/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.util.Collection;
import jcmdline.AbstractHandlerDecorator;
import jcmdline.BooleanParam;
import jcmdline.CmdLineHandler;
import jcmdline.CmdLineParser;
import jcmdline.DefaultCmdLineHandler;
import jcmdline.Parameter;
import jcmdline.Strings;

public class VersionCmdLineHandler
extends AbstractHandlerDecorator {
    private BooleanParam versionOpt;
    private String version;

    public VersionCmdLineHandler(String version, CmdLineHandler handler) {
        super(handler);
        if (version == null || version.length() == 0) {
            throw new IllegalArgumentException(Strings.get("VersionCmdLineHandler.versionEmptyError"));
        }
        this.version = version;
        this.versionOpt = new BooleanParam(Strings.get("VersionCmdLineHandler.version.tag"), Strings.get("VersionCmdLineHandler.version.desc"));
        this.versionOpt.setIgnoreRequired(true);
        this.setCustomOptions(new Parameter[]{this.versionOpt});
    }

    public VersionCmdLineHandler(String version, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args, CmdLineParser parser) {
        this(version, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args, parser));
    }

    public VersionCmdLineHandler(String version, String cmdName, String cmdDesc, Parameter[] options, Parameter[] args) {
        this(version, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    public VersionCmdLineHandler(String version, String cmdName, String cmdDesc, Collection options, Collection args) {
        this(version, new DefaultCmdLineHandler(cmdName, cmdDesc, options, args));
    }

    protected boolean processParsedOptions(boolean parseOk) {
        if (parseOk && this.versionOpt.isTrue()) {
            System.out.println(this.version);
            System.exit(0);
        }
        return parseOk;
    }
}

