/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.MessageBox;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.PageSize;
import it.businesslogic.ireport.util.Unit;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ReportPropertiesFrame
extends JDialog {
    private Unit[] units;
    private int dialogResult;
    private int reportWidth;
    private int reportHeight;
    private int topMargin;
    private int leftMargin;
    private int bottomMargin;
    private int rightMargin;
    private String orientation;
    private String scriptletClass;
    private String reportName;
    private int reportHandling = 0;
    private JButton jButtonCANCEL;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxSummaryOnNewPage;
    private JCheckBox jCheckBoxTitleOnNewPage;
    private JComboBox jComboBoxBottomMarginUnit;
    private JComboBox jComboBoxColumnsSpacingUnit;
    private JComboBox jComboBoxColumnsWidthUnit;
    private JComboBox jComboBoxHUnit;
    private JComboBox jComboBoxLeftMarginUnit;
    private JComboBox jComboBoxOrientation;
    private JComboBox jComboBoxPrintOrder;
    private JComboBox jComboBoxRightMarginUnit;
    private JComboBox jComboBoxScriptletHandling;
    private JComboBox jComboBoxSize;
    private JComboBox jComboBoxTopMarginUnit;
    private JComboBox jComboBoxWUnit;
    private JComboBox jComboBoxWhenNoData;
    private JComboBox jComboBoxXMLEncoding;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JNumberField jNumberFieldBottomMargin;
    private JNumberField jNumberFieldColumns;
    private JNumberField jNumberFieldColumnsSpacing;
    private JNumberField jNumberFieldColumnsWidth;
    private JNumberField jNumberFieldHeight;
    private JNumberField jNumberFieldLeftMargin;
    private JNumberField jNumberFieldRightMargin;
    private JNumberField jNumberFieldTopMargin;
    private JNumberField jNumberFieldWidth;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldName;
    private JTextField jTextFieldScriptletClass;
    private int columns;
    private int columnsWidth;
    private int columnsSpacing;
    private boolean titleOnNewPage;
    private boolean summaryOnNewPage;
    private String printOrder;
    private String whenNoDataType;
    private String xmlEncoding;
    private int globalUnit = 0;
    private String reportFormat;
    private int scriptletHandling;

    public ReportPropertiesFrame(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(435, 385);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point();
        p.x = Math.max(0, (dim.width - this.getWidth()) / 2);
        p.y = Math.max(0, (dim.height - this.getHeight()) / 2);
        this.setLocation(p);
        this.units = Unit.getStandardUnits();
        for (int i = 0; i < this.units.length; ++i) {
            this.jComboBoxWUnit.addItem(this.units[i]);
            this.jComboBoxHUnit.addItem(this.units[i]);
            this.jComboBoxTopMarginUnit.addItem(this.units[i]);
            this.jComboBoxBottomMarginUnit.addItem(this.units[i]);
            this.jComboBoxLeftMarginUnit.addItem(this.units[i]);
            this.jComboBoxRightMarginUnit.addItem(this.units[i]);
            this.jComboBoxColumnsWidthUnit.addItem(this.units[i]);
            this.jComboBoxColumnsSpacingUnit.addItem(this.units[i]);
        }
        this.jComboBoxScriptletHandling.addItem("Don't use scriptlet");
        this.jComboBoxScriptletHandling.addItem("Use iReport internal scriptlet support");
        this.jComboBoxScriptletHandling.addItem("Use this scriptlet class...");
        this.jTabbedPane1.setTitleAt(0, "Page Margin");
        this.jTabbedPane1.setTitleAt(1, "Columns");
        this.jTabbedPane1.setTitleAt(2, "Scriptlet");
        this.jTabbedPane1.setTitleAt(3, "More...");
        this.jComboBoxSize.addItem("Custom");
        this.jComboBoxSize.addItem("LETTER");
        this.jComboBoxSize.addItem("NOTE");
        this.jComboBoxSize.addItem("LEGAL");
        this.jComboBoxSize.addItem("A0");
        this.jComboBoxSize.addItem("A1");
        this.jComboBoxSize.addItem("A2");
        this.jComboBoxSize.addItem("A3");
        this.jComboBoxSize.addItem("A4");
        this.jComboBoxSize.addItem("A5");
        this.jComboBoxSize.addItem("A6");
        this.jComboBoxSize.addItem("A7");
        this.jComboBoxSize.addItem("A8");
        this.jComboBoxSize.addItem("A9");
        this.jComboBoxSize.addItem("A10");
        this.jComboBoxSize.addItem("B0");
        this.jComboBoxSize.addItem("B1");
        this.jComboBoxSize.addItem("B2");
        this.jComboBoxSize.addItem("B3");
        this.jComboBoxSize.addItem("B4");
        this.jComboBoxSize.addItem("B5");
        this.jComboBoxSize.addItem("ARCH_E");
        this.jComboBoxSize.addItem("ARCH_D");
        this.jComboBoxSize.addItem("ARCH_C");
        this.jComboBoxSize.addItem("ARCH_B");
        this.jComboBoxSize.addItem("ARCH_A");
        this.jComboBoxSize.addItem("FLSA");
        this.jComboBoxSize.addItem("FLSE");
        this.jComboBoxSize.addItem("HALFLETTER");
        this.jComboBoxSize.addItem("11x17");
        this.jComboBoxSize.addItem("LEDGER");
        this.jComboBoxOrientation.addItem("Portrait");
        this.jComboBoxOrientation.addItem("Landscape");
        this.jComboBoxPrintOrder.addItem("Vertical");
        this.jComboBoxPrintOrder.addItem("Horizontal");
        this.jComboBoxWhenNoData.addItem("NoPages");
        this.jComboBoxWhenNoData.addItem("BlankPage");
        this.jComboBoxWhenNoData.addItem("AllSectionsNoDetail");
        this.jComboBoxXMLEncoding.addItem("UTF-8");
        this.jComboBoxXMLEncoding.addItem("ISO-8859-1");
        this.jComboBoxPrintOrder.setSelectedItem("Vertical");
        this.jComboBoxWhenNoData.setSelectedItem("NoPages");
        this.jComboBoxXMLEncoding.setSelectedItem("UTF-8");
        this.setReportFormat("A4");
        this.setReportName("Untitled_report_1");
        this.setReportWidth(PageSize.A4.x);
        this.setReportHeight(PageSize.A4.y);
        this.setTopMargin(20);
        this.setBottomMargin(20);
        this.setLeftMargin(30);
        this.setRightMargin(30);
        this.setColumns(1);
        this.setColumnsSpacing(0);
        this.setColumnsWidth(this.getReportWidth() - this.getLeftMargin() - this.getRightMargin());
        this.jComboBoxWUnitActionPerformed(new ActionEvent(this.jComboBoxWUnit, 0, ""));
        this.jComboBoxHUnitActionPerformed(new ActionEvent(this.jComboBoxHUnit, 0, ""));
        this.setGlobalUnit(2);
        this.applyI18n();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxSize = new JComboBox();
        this.jComboBoxWUnit = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxHUnit = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jComboBoxOrientation = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jNumberFieldWidth = new JNumberField();
        this.jNumberFieldHeight = new JNumberField();
        this.jButtonOK = new JButton();
        this.jButtonCANCEL = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jComboBoxTopMarginUnit = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jComboBoxBottomMarginUnit = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jComboBoxLeftMarginUnit = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jComboBoxRightMarginUnit = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jNumberFieldTopMargin = new JNumberField();
        this.jNumberFieldBottomMargin = new JNumberField();
        this.jNumberFieldLeftMargin = new JNumberField();
        this.jNumberFieldRightMargin = new JNumberField();
        this.jPanel3 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jComboBoxColumnsWidthUnit = new JComboBox();
        this.jLabel12 = new JLabel();
        this.jComboBoxColumnsSpacingUnit = new JComboBox();
        this.jLabel13 = new JLabel();
        this.jNumberFieldColumnsWidth = new JNumberField();
        this.jNumberFieldColumnsSpacing = new JNumberField();
        this.jNumberFieldColumns = new JNumberField();
        this.jPanel4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextFieldScriptletClass = new JTextField();
        this.jComboBoxScriptletHandling = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jCheckBoxTitleOnNewPage = new JCheckBox();
        this.jCheckBoxSummaryOnNewPage = new JCheckBox();
        this.jComboBoxPrintOrder = new JComboBox();
        this.jComboBoxXMLEncoding = new JComboBox();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jComboBoxWhenNoData = new JComboBox();
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(2);
        this.setTitle("Report properties");
        this.setName("Report properties");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                ReportPropertiesFrame.this.formWindowOpened(evt);
            }

            public void windowClosing(WindowEvent evt) {
                ReportPropertiesFrame.this.exitForm(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Report name:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(4, 12, 80, 16);
        this.jTextFieldName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jTextFieldNameActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jTextFieldName);
        this.jTextFieldName.setBounds(88, 9, 222, 22);
        this.jPanel1.setLayout(null);
        this.jPanel1.setBorder(new TitledBorder(new EtchedBorder(), "Page size"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Preset sizes:");
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(8, 24, 78, 16);
        this.jComboBoxSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxSizeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jComboBoxSize);
        this.jComboBoxSize.setBounds(90, 20, 200, 22);
        this.jComboBoxWUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxWUnitActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jComboBoxWUnit);
        this.jComboBoxWUnit.setBounds(214, 50, 76, 22);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Width:");
        this.jPanel1.add(this.jLabel3);
        this.jLabel3.setBounds(70, 54, 75, 16);
        this.jComboBoxHUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxHUnitActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jComboBoxHUnit);
        this.jComboBoxHUnit.setBounds(214, 80, 76, 22);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Height:");
        this.jPanel1.add(this.jLabel4);
        this.jLabel4.setBounds(70, 80, 75, 16);
        this.jComboBoxOrientation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxOrientationActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jComboBoxOrientation);
        this.jComboBoxOrientation.setBounds(150, 110, 140, 22);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Orientation:");
        this.jPanel1.add(this.jLabel5);
        this.jLabel5.setBounds(70, 110, 75, 16);
        this.jNumberFieldWidth.setHorizontalAlignment(4);
        this.jNumberFieldWidth.setText("0");
        this.jNumberFieldWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldWidthActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jNumberFieldWidth);
        this.jNumberFieldWidth.setBounds(154, 50, 58, 22);
        this.jNumberFieldHeight.setHorizontalAlignment(4);
        this.jNumberFieldHeight.setText("0");
        this.jNumberFieldHeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldHeightActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jNumberFieldHeight);
        this.jNumberFieldHeight.setBounds(154, 80, 58, 22);
        this.getContentPane().add(this.jPanel1);
        this.jPanel1.setBounds(8, 35, 304, 140);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonOK);
        this.jButtonOK.setBounds(340, 10, 80, 23);
        this.jButtonCANCEL.setText("Cancel");
        this.jButtonCANCEL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jButtonCANCELActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonCANCEL);
        this.jButtonCANCEL.setBounds(340, 40, 80, 23);
        this.jTabbedPane1.setName("");
        this.jPanel2.setLayout(null);
        this.jPanel2.setName("");
        this.jPanel6.setLayout(null);
        this.jPanel6.setBorder(new TitledBorder(new EtchedBorder(), "Page margin"));
        this.jComboBoxTopMarginUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxTopMarginUnitActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jComboBoxTopMarginUnit);
        this.jComboBoxTopMarginUnit.setBounds(170, 30, 75, 22);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Top:");
        this.jPanel6.add(this.jLabel7);
        this.jLabel7.setBounds(36, 30, 75, 16);
        this.jComboBoxBottomMarginUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxBottomMarginUnitActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jComboBoxBottomMarginUnit);
        this.jComboBoxBottomMarginUnit.setBounds(170, 54, 75, 22);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Bottom:");
        this.jPanel6.add(this.jLabel8);
        this.jLabel8.setBounds(36, 54, 75, 16);
        this.jComboBoxLeftMarginUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxLeftMarginUnitActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jComboBoxLeftMarginUnit);
        this.jComboBoxLeftMarginUnit.setBounds(170, 78, 75, 22);
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Left:");
        this.jPanel6.add(this.jLabel9);
        this.jLabel9.setBounds(36, 78, 75, 16);
        this.jComboBoxRightMarginUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxRightMarginUnitActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jComboBoxRightMarginUnit);
        this.jComboBoxRightMarginUnit.setBounds(170, 102, 75, 22);
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("Right:");
        this.jPanel6.add(this.jLabel10);
        this.jLabel10.setBounds(36, 102, 75, 16);
        this.jNumberFieldTopMargin.setHorizontalAlignment(4);
        this.jNumberFieldTopMargin.setText("0");
        this.jNumberFieldTopMargin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldTopMarginActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jNumberFieldTopMargin);
        this.jNumberFieldTopMargin.setBounds(114, 30, 54, 22);
        this.jNumberFieldBottomMargin.setHorizontalAlignment(4);
        this.jNumberFieldBottomMargin.setText("0");
        this.jNumberFieldBottomMargin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldBottomMarginActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jNumberFieldBottomMargin);
        this.jNumberFieldBottomMargin.setBounds(114, 54, 54, 22);
        this.jNumberFieldLeftMargin.setHorizontalAlignment(4);
        this.jNumberFieldLeftMargin.setText("0");
        this.jNumberFieldLeftMargin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldLeftMarginActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jNumberFieldLeftMargin);
        this.jNumberFieldLeftMargin.setBounds(114, 78, 54, 22);
        this.jNumberFieldRightMargin.setHorizontalAlignment(4);
        this.jNumberFieldRightMargin.setText("0");
        this.jNumberFieldRightMargin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldRightMarginActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jNumberFieldRightMargin);
        this.jNumberFieldRightMargin.setBounds(114, 102, 54, 22);
        this.jPanel2.add(this.jPanel6);
        this.jPanel6.setBounds(2, 0, 292, 140);
        this.jTabbedPane1.addTab("tab1", this.jPanel2);
        this.jPanel3.setLayout(null);
        this.jPanel7.setLayout(null);
        this.jPanel7.setBorder(new TitledBorder(new EtchedBorder(), "Report columns"));
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("Columns:");
        this.jPanel7.add(this.jLabel11);
        this.jLabel11.setBounds(36, 30, 75, 16);
        this.jComboBoxColumnsWidthUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxColumnsWidthUnitActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jComboBoxColumnsWidthUnit);
        this.jComboBoxColumnsWidthUnit.setBounds(170, 54, 75, 22);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText("Width:");
        this.jPanel7.add(this.jLabel12);
        this.jLabel12.setBounds(36, 54, 75, 16);
        this.jComboBoxColumnsSpacingUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxColumnsSpacingUnitActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jComboBoxColumnsSpacingUnit);
        this.jComboBoxColumnsSpacingUnit.setBounds(170, 78, 75, 22);
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("Spacing:");
        this.jPanel7.add(this.jLabel13);
        this.jLabel13.setBounds(36, 78, 75, 16);
        this.jNumberFieldColumnsWidth.setHorizontalAlignment(4);
        this.jNumberFieldColumnsWidth.setText("0");
        this.jNumberFieldColumnsWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldColumnsWidthActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jNumberFieldColumnsWidth);
        this.jNumberFieldColumnsWidth.setBounds(114, 54, 54, 22);
        this.jNumberFieldColumnsSpacing.setHorizontalAlignment(4);
        this.jNumberFieldColumnsSpacing.setText("0");
        this.jNumberFieldColumnsSpacing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldColumnsSpacingActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jNumberFieldColumnsSpacing);
        this.jNumberFieldColumnsSpacing.setBounds(114, 78, 54, 22);
        this.jNumberFieldColumns.setHorizontalAlignment(4);
        this.jNumberFieldColumns.setText("0");
        this.jNumberFieldColumns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jNumberFieldColumnsActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jNumberFieldColumns);
        this.jNumberFieldColumns.setBounds(114, 30, 54, 22);
        this.jPanel3.add(this.jPanel7);
        this.jPanel7.setBounds(2, 0, 292, 140);
        this.jTabbedPane1.addTab("tab2", this.jPanel3);
        this.jPanel4.setLayout(null);
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setText("Scriptlet class");
        this.jPanel4.add(this.jLabel6);
        this.jLabel6.setBounds(10, 10, 110, 16);
        this.jTextFieldScriptletClass.setEnabled(false);
        this.jTextFieldScriptletClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jTextFieldScriptletClassActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jTextFieldScriptletClass);
        this.jTextFieldScriptletClass.setBounds(10, 60, 278, 22);
        this.jComboBoxScriptletHandling.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxScriptletHandlingActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jComboBoxScriptletHandling);
        this.jComboBoxScriptletHandling.setBounds(10, 30, 280, 19);
        this.jTabbedPane1.addTab("tab3", this.jPanel4);
        this.jPanel5.setLayout(null);
        this.jCheckBoxTitleOnNewPage.setText("Title on a new page");
        this.jCheckBoxTitleOnNewPage.setHorizontalAlignment(4);
        this.jCheckBoxTitleOnNewPage.setHorizontalTextPosition(2);
        this.jCheckBoxTitleOnNewPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jCheckBoxTitleOnNewPageActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jCheckBoxTitleOnNewPage);
        this.jCheckBoxTitleOnNewPage.setBounds(80, 10, 185, 23);
        this.jCheckBoxSummaryOnNewPage.setText("Summary on a new page");
        this.jCheckBoxSummaryOnNewPage.setHorizontalAlignment(4);
        this.jCheckBoxSummaryOnNewPage.setHorizontalTextPosition(2);
        this.jCheckBoxSummaryOnNewPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jCheckBoxSummaryOnNewPageActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jCheckBoxSummaryOnNewPage);
        this.jCheckBoxSummaryOnNewPage.setBounds(80, 30, 185, 23);
        this.jComboBoxPrintOrder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxPrintOrderActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jComboBoxPrintOrder);
        this.jComboBoxPrintOrder.setBounds(115, 60, 150, 22);
        this.jComboBoxXMLEncoding.setEditable(true);
        this.jComboBoxXMLEncoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxXMLEncodingActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jComboBoxXMLEncoding);
        this.jComboBoxXMLEncoding.setBounds(115, 108, 150, 22);
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText("Print order:");
        this.jPanel5.add(this.jLabel14);
        this.jLabel14.setBounds(10, 60, 100, 16);
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText("When no data:");
        this.jPanel5.add(this.jLabel15);
        this.jLabel15.setBounds(10, 84, 100, 16);
        this.jLabel16.setHorizontalAlignment(4);
        this.jLabel16.setText("XML encoding:");
        this.jPanel5.add(this.jLabel16);
        this.jLabel16.setBounds(10, 108, 100, 16);
        this.jComboBoxWhenNoData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportPropertiesFrame.this.jComboBoxWhenNoDataActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jComboBoxWhenNoData);
        this.jComboBoxWhenNoData.setBounds(115, 84, 150, 22);
        this.jTabbedPane1.addTab("tab4", this.jPanel5);
        this.getContentPane().add(this.jTabbedPane1);
        this.jTabbedPane1.setBounds(10, 180, 300, 170);
        this.pack();
    }

    private void jComboBoxScriptletHandlingActionPerformed(ActionEvent evt) {
        if (this.jComboBoxScriptletHandling.getSelectedIndex() == 0) {
            this.jTextFieldScriptletClass.setText("");
            this.jTextFieldScriptletClass.setEnabled(false);
        } else if (this.jComboBoxScriptletHandling.getSelectedIndex() == 1) {
            this.jTextFieldScriptletClass.setText("");
            this.jTextFieldScriptletClass.setEnabled(false);
        } else if (this.jComboBoxScriptletHandling.getSelectedIndex() == 2) {
            this.jTextFieldScriptletClass.setEnabled(true);
        }
        this.scriptletHandling = this.jComboBoxScriptletHandling.getSelectedIndex();
    }

    private void jCheckBoxSummaryOnNewPageActionPerformed(ActionEvent evt) {
        this.summaryOnNewPage = this.jCheckBoxSummaryOnNewPage.isSelected();
    }

    private void jComboBoxOrientationActionPerformed(ActionEvent evt) {
        this.orientation = (String)this.jComboBoxOrientation.getSelectedItem();
    }

    private void jComboBoxSizeActionPerformed(ActionEvent evt) {
        this.reportFormat = (String)this.jComboBoxSize.getSelectedItem();
        if (this.reportFormat != null && !this.reportFormat.equalsIgnoreCase("CUSTOM")) {
            Point p = PageSize.getFormatSize(this.reportFormat);
            this.setReportWidth(p.x);
            this.setReportHeight(p.y);
        }
    }

    private void jComboBoxXMLEncodingActionPerformed(ActionEvent evt) {
        this.xmlEncoding = this.jComboBoxXMLEncoding.getSelectedItem() + "";
    }

    private void jComboBoxWhenNoDataActionPerformed(ActionEvent evt) {
        this.whenNoDataType = this.jComboBoxWhenNoData.getSelectedItem() + "";
    }

    private void jComboBoxPrintOrderActionPerformed(ActionEvent evt) {
        this.printOrder = this.jComboBoxPrintOrder.getSelectedItem() + "";
    }

    private void jNumberFieldColumnsSpacingActionPerformed(ActionEvent evt) {
        int avail;
        double convert = 1.0;
        convert = this.getConversionUnit(this.jComboBoxColumnsSpacingUnit);
        this.columnsSpacing = (int)Unit.convertToPixels(this.jNumberFieldColumnsSpacing.getValue(), convert);
        int dim = avail = this.getReportWidth() - this.getLeftMargin() - this.getRightMargin();
        if (this.columnsSpacing * (this.getColumns() - 1) > avail) {
            MessageBox.show("WARNING: Column spacing too big!", "Error", 129);
        }
        while (dim > 0 && dim * this.getColumns() + this.getColumnsSpacing() * (this.getColumns() - 1) > avail) {
            --dim;
        }
        this.setColumnsWidth(dim);
    }

    private void jNumberFieldColumnsWidthActionPerformed(ActionEvent evt) {
        this.columnsWidth = (int)Unit.convertToPixels(this.jNumberFieldColumnsWidth.getValue(), this.getConversionUnit(this.jComboBoxColumnsWidthUnit));
    }

    private void jComboBoxColumnsWidthUnitActionPerformed(ActionEvent evt) {
        this.adjustValue(this.jComboBoxColumnsWidthUnit, this.jNumberFieldColumnsWidth, this.getColumnsWidth());
    }

    private void jNumberFieldColumnsActionPerformed(ActionEvent evt) {
        int avail;
        this.columns = (int)this.jNumberFieldColumns.getValue();
        int dim = avail = this.getReportWidth() - this.getLeftMargin() - this.getRightMargin() - (this.getColumns() - 1) * this.getColumnsSpacing();
        dim = (int)((double)dim / (double)this.getColumns());
        while (dim * this.getColumns() > avail) {
            --dim;
        }
        this.setColumnsWidth(dim);
    }

    private void jComboBoxColumnsSpacingUnitActionPerformed(ActionEvent evt) {
        this.adjustValue(this.jComboBoxColumnsSpacingUnit, this.jNumberFieldColumnsSpacing, this.getColumnsSpacing());
    }

    private void jTextFieldNameActionPerformed(ActionEvent evt) {
        this.reportName = this.jTextFieldName.getText().trim();
    }

    private void jTextFieldScriptletClassActionPerformed(ActionEvent evt) {
        this.scriptletClass = this.jTextFieldScriptletClass.getText().trim();
    }

    private void jComboBoxTopMarginUnitActionPerformed(ActionEvent evt) {
        this.adjustValue(this.jComboBoxTopMarginUnit, this.jNumberFieldTopMargin, this.getTopMargin());
    }

    private void jComboBoxBottomMarginUnitActionPerformed(ActionEvent evt) {
        this.adjustValue(this.jComboBoxBottomMarginUnit, this.jNumberFieldBottomMargin, this.getBottomMargin());
    }

    private void jComboBoxLeftMarginUnitActionPerformed(ActionEvent evt) {
        this.adjustValue(this.jComboBoxLeftMarginUnit, this.jNumberFieldLeftMargin, this.getLeftMargin());
    }

    private void jComboBoxRightMarginUnitActionPerformed(ActionEvent evt) {
        this.adjustValue(this.jComboBoxRightMarginUnit, this.jNumberFieldRightMargin, this.getRightMargin());
    }

    private void jNumberFieldRightMarginActionPerformed(ActionEvent evt) {
        this.rightMargin = (int)Unit.convertToPixels(this.jNumberFieldRightMargin.getValue(), this.getConversionUnit(this.jComboBoxRightMarginUnit));
    }

    private void jNumberFieldLeftMarginActionPerformed(ActionEvent evt) {
        this.leftMargin = (int)Unit.convertToPixels(this.jNumberFieldLeftMargin.getValue(), this.getConversionUnit(this.jComboBoxLeftMarginUnit));
    }

    private void jNumberFieldBottomMarginActionPerformed(ActionEvent evt) {
        this.bottomMargin = (int)Unit.convertToPixels(this.jNumberFieldBottomMargin.getValue(), this.getConversionUnit(this.jComboBoxBottomMarginUnit));
    }

    private void jNumberFieldTopMarginActionPerformed(ActionEvent evt) {
        this.topMargin = (int)Unit.convertToPixels(this.jNumberFieldTopMargin.getValue(), this.getConversionUnit(this.jComboBoxTopMarginUnit));
    }

    private void jComboBoxHUnitActionPerformed(ActionEvent evt) {
        this.adjustValue(this.jComboBoxHUnit, this.jNumberFieldHeight, this.getReportHeight());
    }

    private void jNumberFieldHeightActionPerformed(ActionEvent evt) {
        this.jComboBoxSize.setSelectedItem("Custom");
        this.reportHeight = (int)Unit.convertToPixels(this.jNumberFieldHeight.getValue(), this.getConversionUnit(this.jComboBoxHUnit));
    }

    private void jNumberFieldWidthActionPerformed(ActionEvent evt) {
        this.jComboBoxSize.setSelectedItem("Custom");
        this.reportWidth = (int)Unit.convertToPixels(this.jNumberFieldWidth.getValue(), this.getConversionUnit(this.jComboBoxWUnit));
    }

    private void jComboBoxWUnitActionPerformed(ActionEvent evt) {
        this.adjustValue(this.jComboBoxWUnit, this.jNumberFieldWidth, this.getReportWidth());
    }

    private void jCheckBoxTitleOnNewPageActionPerformed(ActionEvent evt) {
        this.titleOnNewPage = this.jCheckBoxTitleOnNewPage.isSelected();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.reportName = this.jTextFieldName.getText();
        this.scriptletClass = this.jTextFieldScriptletClass.getText();
        this.setDialogResult(0);
        this.setVisible(false);
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void jButtonCANCELActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.dispose();
    }

    private void exitForm(WindowEvent evt) {
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new ReportPropertiesFrame(null, true).show();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void adjustValue(JComboBox unitCombo, JNumberField numberField, int store_value) {
        try {
            if (unitCombo.getSelectedIndex() == 0) {
                numberField.setDecimals(0);
                numberField.setInteger(true);
                numberField.setValue(store_value);
            } else if (unitCombo.getSelectedIndex() == 1) {
                numberField.setDecimals(3);
                numberField.setInteger(false);
                numberField.setValue(Unit.convertPixelsToInches(store_value));
            } else if (unitCombo.getSelectedIndex() == 2) {
                numberField.setDecimals(3);
                numberField.setInteger(false);
                numberField.setValue(Unit.convertPixelsToCentimeters(store_value));
            } else if (unitCombo.getSelectedIndex() == 3) {
                numberField.setDecimals(3);
                numberField.setInteger(false);
                numberField.setValue(Unit.convertPixelsToMillimeters(store_value));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private double getConversionUnit(JComboBox comboBox) {
        double convert = 1.0;
        if (comboBox.getSelectedIndex() == 1) {
            convert = 72.0;
        } else if (comboBox.getSelectedIndex() == 2) {
            convert = 28.3464;
        } else if (comboBox.getSelectedIndex() == 3) {
            convert = 2.83464;
        }
        return convert;
    }

    public int getReportHeight() {
        return this.reportHeight;
    }

    public void setReportHeight(int reportHeight) {
        this.reportHeight = reportHeight;
        this.jComboBoxHUnitActionPerformed(new ActionEvent(this.jComboBoxHUnit, 0, ""));
    }

    public int getReportWidth() {
        return this.reportWidth;
    }

    public void setReportWidth(int reportWidth) {
        this.reportWidth = reportWidth;
        this.jComboBoxWUnitActionPerformed(new ActionEvent(this.jComboBoxWUnit, 0, ""));
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
        this.jComboBoxRightMarginUnitActionPerformed(new ActionEvent(this.jComboBoxRightMarginUnit, 0, ""));
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
        this.jComboBoxTopMarginUnitActionPerformed(new ActionEvent(this.jComboBoxTopMarginUnit, 0, ""));
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        this.jComboBoxLeftMarginUnitActionPerformed(new ActionEvent(this.jComboBoxLeftMarginUnit, 0, ""));
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
        this.jComboBoxBottomMarginUnitActionPerformed(new ActionEvent(this.jComboBoxBottomMarginUnit, 0, ""));
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.jComboBoxOrientation.setSelectedItem(orientation);
        this.orientation = orientation;
    }

    public String getScriptletClass() {
        return this.scriptletClass;
    }

    public void setScriptletClass(String scriptletClass) {
        this.jTextFieldScriptletClass.setText(Misc.nvl(scriptletClass, ""));
        this.scriptletClass = scriptletClass;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
        this.jTextFieldName.setText(reportName);
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
        try {
            this.jNumberFieldColumns.setValue(columns);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getColumnsSpacing() {
        return this.columnsSpacing;
    }

    public void setColumnsSpacing(int columnsSpacing) {
        this.columnsSpacing = columnsSpacing;
        this.jComboBoxColumnsSpacingUnitActionPerformed(new ActionEvent(this.jComboBoxColumnsSpacingUnit, 0, ""));
    }

    public int getColumnsWidth() {
        return this.columnsWidth;
    }

    public void setColumnsWidth(int columnsWidth) {
        this.columnsWidth = columnsWidth;
        this.jComboBoxColumnsWidthUnitActionPerformed(new ActionEvent(this.jComboBoxColumnsWidthUnit, 0, ""));
    }

    public boolean isSummaryOnNewPage() {
        return this.summaryOnNewPage;
    }

    public void setSummaryOnNewPage(boolean summaryOnNewPage) {
        this.jCheckBoxSummaryOnNewPage.setSelected(summaryOnNewPage);
        this.summaryOnNewPage = summaryOnNewPage;
    }

    public boolean isTitleOnNewPage() {
        return this.titleOnNewPage;
    }

    public void setTitleOnNewPage(boolean titleOnNewPage) {
        this.jCheckBoxTitleOnNewPage.setSelected(titleOnNewPage);
        this.titleOnNewPage = titleOnNewPage;
    }

    public String getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(String whenNoDataType) {
        this.jComboBoxWhenNoData.setSelectedItem(whenNoDataType);
        this.whenNoDataType = whenNoDataType;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public void setXmlEncoding(String xmlEncoding) {
        this.jComboBoxXMLEncoding.setSelectedItem(xmlEncoding);
        this.xmlEncoding = xmlEncoding;
    }

    public int getGlobalUnit() {
        return this.globalUnit;
    }

    public void setGlobalUnit(int globalUnit) {
        if (this.globalUnit != globalUnit) {
            this.globalUnit = globalUnit;
            this.jComboBoxWUnit.setSelectedIndex(globalUnit);
            this.jComboBoxHUnit.setSelectedIndex(globalUnit);
            this.jComboBoxTopMarginUnit.setSelectedIndex(globalUnit);
            this.jComboBoxBottomMarginUnit.setSelectedIndex(globalUnit);
            this.jComboBoxLeftMarginUnit.setSelectedIndex(globalUnit);
            this.jComboBoxRightMarginUnit.setSelectedIndex(globalUnit);
            this.jComboBoxColumnsSpacingUnit.setSelectedIndex(globalUnit);
            this.jComboBoxColumnsWidthUnit.setSelectedIndex(globalUnit);
        }
    }

    public String getPrintOrder() {
        return this.printOrder;
    }

    public void setPrintOrder(String printOrder) {
        this.jComboBoxPrintOrder.setSelectedItem(printOrder);
        this.printOrder = printOrder;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
        this.jComboBoxSize.setSelectedItem(reportFormat);
    }

    public int getScriptletHandling() {
        return this.scriptletHandling;
    }

    public void setScriptletHandling(int scriptletHandling) {
        this.scriptletHandling = scriptletHandling;
        this.jComboBoxScriptletHandling.setSelectedIndex(scriptletHandling);
    }

    public void applyI18n() {
        this.jLabel1.setText(I18n.getString("reportName", "Report name:") + ":");
        this.jLabel2.setText(I18n.getString("presetSizes", "Preset sizes:") + ":");
        this.jLabel3.setText(I18n.getString("width", "Width:") + ":");
        this.jLabel4.setText(I18n.getString("height", "Height:") + ":");
        this.jLabel5.setText(I18n.getString("orientation", "Orientation:") + ":");
        this.jButtonCANCEL.setText(I18n.getString("cancel", "Cancel"));
        this.jLabel7.setText(I18n.getString("top", "Top:") + ":");
        this.jLabel8.setText(I18n.getString("bottom", "Bottom:") + ":");
        this.jLabel9.setText(I18n.getString("left", "Left:") + ":");
        this.jLabel10.setText(I18n.getString("right", "Right:") + ":");
        this.jLabel11.setText(I18n.getString("columns", "Columns:") + ":");
        this.jLabel12.setText(I18n.getString("width", "Width:") + ":");
        this.jLabel13.setText(I18n.getString("spacing", "Spacing:") + ":");
        this.jLabel6.setText(I18n.getString("scriptlet", "Scriptlet class"));
        this.jCheckBoxTitleOnNewPage.setText(I18n.getString("titleOnANewPage", "Title on a new page"));
        this.jCheckBoxSummaryOnNewPage.setText(I18n.getString("summaryInANewPage", "Summary on a new page"));
        this.jLabel14.setText(I18n.getString("printOrder", "Print order:") + ":");
        this.jLabel15.setText(I18n.getString("whenNoData", "When no data:") + ":");
        this.jLabel16.setText(I18n.getString("xmlEncoding", "XML encoding:") + ":");
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }
}

