/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.gui.JReportFrame;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JPanel;

public class JReportPanel
extends JPanel
implements DropTargetListener {
    private JReportFrame jrf = null;

    public JReportPanel() {
        this.setBackground(new Color(128, 128, 128));
        new DropTarget(this, 3, this);
        this.setIgnoreRepaint(true);
    }

    public void paint(Graphics g) {
        if (this.jrf != null) {
            this.jrf.paintReportPanel(g);
        } else {
            super.paint(g);
        }
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            DropTargetContext context = dtde.getDropTargetContext();
            Transferable tr = dtde.getTransferable();
            DataFlavor[] df = tr.getTransferDataFlavors();
            if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRField")) {
                DataFlavor myFlavor = new DataFlavor(JRField.class, JRField.class.getName());
                JRField field = (JRField)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$F{" + field.getName() + "}", field.getClassType());
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRVariable")) {
                DataFlavor myFlavor = new DataFlavor(JRVariable.class, JRVariable.class.getName());
                JRVariable var = (JRVariable)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$V{" + var.getName() + "}", var.getClassType());
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.JRParameter")) {
                DataFlavor myFlavor = new DataFlavor(JRParameter.class, JRParameter.class.getName());
                JRParameter par = (JRParameter)tr.getTransferData(myFlavor);
                this.jrf.dropNewTextField(dtde.getLocation(), "$P{" + par.getName() + "}", par.getClassType());
            }
            context.dropComplete(true);
        }
        catch (Exception ex) {
            System.out.println("Errore in drop!");
            ex.printStackTrace();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

