/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.DocumentExpressionEditorTreeCellRenderer;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;

public class ExpressionEditor
extends JDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JEditTextArea jEditTextArea1;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTree jTree1;
    private JReportFrame jrf;
    private String Expression;
    private int dialogResult;

    public ExpressionEditor() {
        this.initComponents();
        this.setSize(600, 450);
        this.setModal(true);
        SyntaxDocument sd = new SyntaxDocument();
        sd.setTokenMarker(new JavaTokenMarker());
        this.jEditTextArea1.setDocument(sd);
        this.jEditTextArea1.getPainter().setEOLMarkersPainted(false);
        this.jEditTextArea1.getPainter().setInvalidLinesPainted(false);
        this.jEditTextArea1.getPainter().setLineHighlightEnabled(false);
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode("root");
        dmtn.add(new DefaultMutableTreeNode("Fields"));
        dmtn.add(new DefaultMutableTreeNode("Variables"));
        dmtn.add(new DefaultMutableTreeNode("Parameters"));
        dmtn.add(new DefaultMutableTreeNode("Formulas"));
        this.jTree1.setCellRenderer(new DocumentExpressionEditorTreeCellRenderer());
        this.jTree1.setModel(new DefaultTreeModel(dmtn));
        Misc.centerFrame(this);
        this.jList1.setModel(new DefaultListModel());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jEditTextArea1 = new JEditTextArea();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jScrollPane3 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setTitle("Expression editor...");
        this.setModal(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ExpressionEditor.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ExpressionEditor.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerSize(4);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jEditTextArea1.setMinimumSize(new Dimension(20, 20));
        this.jEditTextArea1.setPreferredSize(new Dimension(150, 150));
        this.jEditTextArea1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ExpressionEditor.this.jEditTextArea1ComponentResized(evt);
            }
        });
        this.jSplitPane1.setLeftComponent(this.jEditTextArea1);
        this.jSplitPane2.setDividerSize(4);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setPreferredSize(new Dimension(361, 160));
        this.jSplitPane2.setAutoscrolls(true);
        this.jPanel3.setLayout(new BorderLayout());
        this.jScrollPane2.setPreferredSize(new Dimension(100, 100));
        this.jTree1.setRootVisible(false);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ExpressionEditor.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTree1);
        this.jPanel3.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane2.setLeftComponent(this.jPanel3);
        this.jScrollPane3.setPreferredSize(new Dimension(259, 60));
        this.jList1.setFont(new Font("Dialog", 0, 11));
        this.jList1.setPreferredSize(new Dimension(80, 80));
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ExpressionEditor.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jList1);
        this.jSplitPane2.setRightComponent(this.jScrollPane3);
        this.jSplitPane1.setBottomComponent(this.jSplitPane2);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setMinimumSize(new Dimension(10, 30));
        this.jPanel2.setPreferredSize(new Dimension(10, 30));
        this.jPanel4.setLayout(null);
        this.jPanel4.setMinimumSize(new Dimension(300, 10));
        this.jPanel4.setPreferredSize(new Dimension(300, 10));
        this.jButton1.setFont(new Font("Dialog", 0, 11));
        this.jButton1.setMnemonic('c');
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jButton1.setBounds(210, 4, 88, 25);
        this.jButton2.setFont(new Font("Dialog", 0, 11));
        this.jButton2.setMnemonic('a');
        this.jButton2.setText("Apply");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton2);
        this.jButton2.setBounds(118, 4, 90, 25);
        this.jPanel2.add((Component)this.jPanel4, "East");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1 && this.jList1.getSelectedIndex() >= 0) {
            String s = "" + this.jList1.getSelectedValue();
            try {
                this.jEditTextArea1.getDocument().insertString(this.jEditTextArea1.getCaretPosition(), s, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        block5: {
            DefaultMutableTreeNode dmtn;
            block6: {
                block4: {
                    ((DefaultListModel)this.jList1.getModel()).removeAllElements();
                    if (this.jrf == null) {
                        return;
                    }
                    dmtn = (DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent();
                    if (!("" + dmtn.getUserObject()).equalsIgnoreCase("Fields")) break block4;
                    Enumeration e = this.jrf.getReport().getFields().elements();
                    while (e.hasMoreElements()) {
                        ((DefaultListModel)this.jList1.getModel()).addElement("$F{" + e.nextElement() + "}");
                    }
                    break block5;
                }
                if (!("" + dmtn.getUserObject()).equalsIgnoreCase("Parameters")) break block6;
                Enumeration e = this.jrf.getReport().getParameters().elements();
                while (e.hasMoreElements()) {
                    ((DefaultListModel)this.jList1.getModel()).addElement("$P{" + e.nextElement() + "}");
                }
                break block5;
            }
            if (!("" + dmtn.getUserObject()).equalsIgnoreCase("Variables")) break block5;
            Enumeration e = this.jrf.getReport().getVariables().elements();
            while (e.hasMoreElements()) {
                ((DefaultListModel)this.jList1.getModel()).addElement("$V{" + e.nextElement() + "}");
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setDialogResult(1);
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setExpression(this.jEditTextArea1.getText());
        this.setDialogResult(0);
        this.dispose();
    }

    private void jEditTextArea1ComponentResized(ComponentEvent evt) {
    }

    private void formComponentResized(ComponentEvent evt) {
        this.jEditTextArea1.updateScrollBars();
    }

    private void exitForm(WindowEvent evt) {
    }

    public static void main(String[] args) {
        new ExpressionEditor().show();
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
        this.jTree1.setSelectionRow(0);
        this.jEditTextArea1.getTokenMarker().setKeywordLookup(jrf.getReport().getKeywordLookup());
    }

    public String getExpression() {
        return this.Expression;
    }

    public void setExpression(String Expression) {
        this.jEditTextArea1.setText(Expression);
        this.Expression = Expression;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

