/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.gui.DocumentExpressionEditorTreeCellRenderer;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;

public class EventsForm
extends JFrame {
    private JButton jButtonSave;
    private JComboBox jComboBoxEvents;
    private JEditTextArea jEditTextArea1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTree jTree1;
    private JReportFrame jrf;

    public EventsForm() {
        this.initComponents();
        this.jComboBoxEvents.addItem("<Imports and global declarations>");
        this.jComboBoxEvents.addItem("afterColumnInit()");
        this.jComboBoxEvents.addItem("afterDetailEval()");
        this.jComboBoxEvents.addItem("afterGroupInit(java.lang.String groupName)");
        this.jComboBoxEvents.addItem("afterPageInit()");
        this.jComboBoxEvents.addItem("afterReportInit()");
        this.jComboBoxEvents.addItem("beforeColumnInit()");
        this.jComboBoxEvents.addItem("beforeDetailEval()");
        this.jComboBoxEvents.addItem("beforeGroupInit(java.lang.String groupName)");
        this.jComboBoxEvents.addItem("beforePageInit()");
        this.jComboBoxEvents.addItem("beforeReportInit()");
        SyntaxDocument sd = new SyntaxDocument();
        sd.setTokenMarker(new JavaTokenMarker());
        this.jEditTextArea1.setDocument(sd);
        this.jTree1.setCellRenderer(new DocumentExpressionEditorTreeCellRenderer());
        this.jTree1.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.setSize((int)(tk.getScreenSize().getWidth() * 0.75), (int)(tk.getScreenSize().getHeight() * 0.75));
        Misc.centerFrame(this);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxEvents = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jEditTextArea1 = new JEditTextArea();
        this.jButtonSave = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTree1 = new JTree();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EventsForm.this.exitForm(evt);
            }
        });
        this.jSplitPane1.setDividerSize(6);
        this.jSplitPane1.setResizeWeight(0.2);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("Events");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 6, 0, 4);
        gridBagConstraints.anchor = 12;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxEvents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EventsForm.this.jComboBoxEventsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 2, 4, 2);
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jComboBoxEvents, gridBagConstraints);
        this.jEditTextArea1.setMinimumSize(new Dimension(20, 20));
        this.jEditTextArea1.setPreferredSize(new Dimension(150, 150));
        this.jScrollPane1.setViewportView(this.jEditTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonSave.setFont(new Font("Dialog", 0, 11));
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EventsForm.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 0, 2, 4);
        gridBagConstraints.anchor = 12;
        this.jPanel1.add((Component)this.jButtonSave, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setText("Objects");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 4);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jTree1.setRootVisible(false);
        this.jTree1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EventsForm.this.jTree1MouseClicked(evt);
            }
        });
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                EventsForm.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTree1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        int portion = this.getSelectedPortion();
        this.jrf.getReport().getScripletCode().setPortionCode(portion, this.jEditTextArea1.getText());
        this.jComboBoxEventsActionPerformed(new ActionEvent(this.jButtonSave, 0, ""));
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1) {
            TreePath path = this.jTree1.getSelectionPath();
            if (path == null) {
                return;
            }
            TreeNode node = (TreeNode)path.getLastPathComponent();
            if (node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode nodem = (DefaultMutableTreeNode)node;
                Object obj = nodem.getUserObject();
                if (obj != null && obj instanceof JRVariable) {
                    String s = "variablesMap.get(\"" + obj + "\")";
                    if (((JRVariable)obj).getClassType() != null && ((JRVariable)obj).getClassType().length() > 0) {
                        s = "(" + ((JRVariable)obj).getClassType() + ")" + s;
                    }
                    try {
                        this.jEditTextArea1.getDocument().insertString(this.jEditTextArea1.getCaretPosition(), s + "", null);
                    }
                    catch (Exception ex) {}
                } else if (obj != null && obj instanceof JRParameter) {
                    String s = "parametersMap.get(\"" + obj + "\")";
                    try {
                        this.jEditTextArea1.getDocument().insertString(this.jEditTextArea1.getCaretPosition(), s + "", null);
                    }
                    catch (Exception ex) {}
                } else if (obj != null && obj instanceof JRField) {
                    String s = "(" + ((JRField)obj).getClassType() + ")fieldsMap.get(\"" + obj + "\")";
                    try {
                        this.jEditTextArea1.getDocument().insertString(this.jEditTextArea1.getCaretPosition(), s + "", null);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
    }

    private void jComboBoxEventsActionPerformed(ActionEvent evt) {
        if (this.jrf == null) {
            return;
        }
        int portion = this.getSelectedPortion();
        this.jEditTextArea1.setText(this.jrf.getReport().getScripletCode().getPortion(portion));
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        new EventsForm().show();
    }

    public int getSelectedPortion() {
        return Math.max(0, this.jComboBoxEvents.getSelectedIndex());
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJReportFrame(JReportFrame jrf) {
        this.jrf = jrf;
        if (jrf == null) {
            this.setVisible(false);
            return;
        }
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.jTree1.getModel().getRoot();
        dmtn.removeAllChildren();
        DefaultMutableTreeNode dmtnFields = new DefaultMutableTreeNode("Fields");
        Enumeration enumFields = jrf.getReport().getFields().elements();
        while (enumFields.hasMoreElements()) {
            dmtnFields.add(new DefaultMutableTreeNode(enumFields.nextElement()));
        }
        dmtn.add(dmtnFields);
        DefaultMutableTreeNode dmtnVariables = new DefaultMutableTreeNode("Variables");
        Enumeration enumVariables = jrf.getReport().getVariables().elements();
        while (enumVariables.hasMoreElements()) {
            dmtnVariables.add(new DefaultMutableTreeNode(enumVariables.nextElement()));
        }
        dmtn.add(dmtnVariables);
        DefaultMutableTreeNode dmtnParameters = new DefaultMutableTreeNode("Parameters");
        Enumeration enumParameters = jrf.getReport().getParameters().elements();
        while (enumParameters.hasMoreElements()) {
            dmtnParameters.add(new DefaultMutableTreeNode(enumParameters.nextElement()));
        }
        dmtn.add(dmtnParameters);
        this.jTree1.updateUI();
        int portion = this.getSelectedPortion();
        this.jEditTextArea1.setText(jrf.getReport().getScripletCode().getPortion(portion));
        this.jEditTextArea1.setCaretPosition(0);
        this.jEditTextArea1.updateUI();
        this.jEditTextArea1.updateScrollBars();
    }
}

