/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public final class DriverPool {
    private static final ArrayList driverSet = new ArrayList();

    private DriverPool() {
    }

    private static boolean isDriverAllReadyRegistered(Driver jdbcDriver) {
        int verCheckSum = jdbcDriver.getMajorVersion() * 10 + jdbcDriver.getMinorVersion();
        Iterator drivers = driverSet.iterator();
        while (drivers.hasNext()) {
            Driver driver = (Driver)drivers.next();
            int checkSum = driver.getMajorVersion() * 10 + driver.getMinorVersion();
            if (checkSum != verCheckSum || !driver.getClass().getName().equals(jdbcDriver.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerDriver(String driverClass, ClassLoader cl) throws ClassNotFoundException {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (driverClass == null) {
            return;
        }
        try {
            Driver jdbcDriver = (Driver)Class.forName(driverClass, false, cl).newInstance();
            if (DriverPool.isDriverAllReadyRegistered(jdbcDriver)) return;
            String[] stringArray = driverSet;
            synchronized (driverSet) {
                driverSet.add(jdbcDriver);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                stringArray = new String[]{driverClass, jdbcDriver.toString()};
                return;
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(driverClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterDriver(Driver jdbcDriver) {
        if (jdbcDriver == null) {
            return;
        }
        try {
            String[] p = new String[]{jdbcDriver.getClass().getName(), jdbcDriver.toString()};
            ArrayList arrayList = driverSet;
            synchronized (arrayList) {
                Driver di;
                int i = 0;
                for (i = 0; i < driverSet.size() && (di = (Driver)driverSet.get(i)) != jdbcDriver; ++i) {
                }
                if (i >= driverSet.size()) {
                    return;
                }
                driverSet.remove(i);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static Driver getDriver(String jdbcURL) throws SQLException {
        Iterator drivers = driverSet.iterator();
        while (drivers.hasNext()) {
            Driver jdbcDriver = (Driver)drivers.next();
            try {
                if (!jdbcDriver.acceptsURL(jdbcURL)) continue;
                return jdbcDriver;
            }
            catch (Throwable throwable) {
            }
        }
        return DriverPool.getDriver(jdbcURL);
    }
}

