/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JREmptyDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JasperCompileManager;
import dori.jasper.engine.JasperFillManager;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.design.JRJdk13Compiler;
import dori.jasper.engine.export.JRCsvExporter;
import dori.jasper.engine.export.JRExportProgressMonitor;
import dori.jasper.engine.export.JRGraphics2DExporter;
import dori.jasper.engine.export.JRHtmlExporter;
import dori.jasper.engine.export.JRPdfExporter;
import dori.jasper.engine.export.JRXlsExporter;
import dori.jasper.view.JasperViewer;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.ReportClassLoader;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.connection.JRCustomDataSourceConnection;
import it.businesslogic.ireport.export.JRTxtExporter;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;

public class IReportCompiler
implements Runnable,
JRExportProgressMonitor {
    public static final int CMD_COMPILE = 1;
    public static final int CMD_EXPORT = 2;
    public static final int CMD_COMPILE_SCRIPTLET = 4;
    public static final String OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String OUTPUT_FORMAT = "OUTPUT_FORMAT";
    public static final String USE_EMPTY_DATASOURCE = "USE_EMPTY_DATASOURCE";
    public static final String USE_CONNECTION = "USE_CONNECTION";
    public static final String CONNECTION = "CONNECTION";
    public static final String SCRIPTLET_OUTPUT_DIRECTORY = "SCRIPTLET_OUTPUT_DIRECTORY";
    static PrintStream myPrintStream = null;
    int filledpage = 0;
    private String status = "";
    private IReportConnection iReportConnection;
    private JReportFrame jrf;
    private MainFrame mainFrame;
    private int command = 0;
    private HashMap properties = new HashMap();
    private Thread thread;
    private String javaFile = "";
    private static String outputBuffer = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StringWriter sw;
        File tempDirFile;
        String oldCompileTemp;
        String tempDirStr;
        long start = System.currentTimeMillis();
        PrintStream out = System.out;
        PrintStream err = System.err;
        if (myPrintStream == null) {
            myPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
        }
        if (out != myPrintStream) {
            System.setOut(myPrintStream);
        }
        if (err != myPrintStream) {
            System.setErr(myPrintStream);
        }
        outputBuffer = "";
        String fileName = this.jrf.getReport().getFilename();
        String srcFileName = this.jrf.getReport().getFilename();
        fileName = Misc.changeFileExtension(fileName, "jasper");
        File f = new File(fileName);
        if (this.properties.get(OUTPUT_DIRECTORY) != null) {
            fileName = (String)this.properties.get(OUTPUT_DIRECTORY) + File.separatorChar + f.getName();
        }
        String scriptletFileName = this.jrf.getReport().getFilename();
        String srcScriptletFileName = this.jrf.getReport().getFilename();
        fileName = Misc.changeFileExtension(fileName, "");
        srcScriptletFileName = scriptletFileName = srcScriptletFileName.substring(0, scriptletFileName.length() - 1) + "Scriptlet.java";
        File f2 = new File(scriptletFileName);
        if (this.properties.get(SCRIPTLET_OUTPUT_DIRECTORY) != null) {
            scriptletFileName = (String)this.properties.get(SCRIPTLET_OUTPUT_DIRECTORY) + File.separatorChar + f2.getName();
        }
        String reportDirectory = new File(this.jrf.getReport().getFilename()).getParent();
        String classpath = System.getProperty("jasper.reports.compile.class.path");
        if (classpath != null) {
            classpath = classpath + File.pathSeparator + reportDirectory;
            System.setProperty("jasper.reports.compile.class.path", classpath);
        } else if (System.getProperty("java.class.path") != null) {
            classpath = System.getProperty("java.class.path");
            classpath = classpath + File.pathSeparator + reportDirectory;
            System.setProperty("java.class.path", classpath);
        }
        reportDirectory = reportDirectory.replace('\\', '/');
        if (!reportDirectory.endsWith("/")) {
            reportDirectory = reportDirectory + "/";
        }
        if (!reportDirectory.startsWith("/")) {
            reportDirectory = "/" + reportDirectory;
        }
        ReportClassLoader reportClassLoader = new ReportClassLoader();
        reportClassLoader.setRelodablePaths(reportDirectory);
        reportClassLoader.rescanLibDirectory();
        try {
            Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + reportDirectory)}, (ClassLoader)reportClassLoader));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        if ((this.command & 4) != 0) {
            start = System.currentTimeMillis();
            oldCompileTemp = tempDirStr = System.getProperty("jasper.reports.compile.temp");
            if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
            }
            tempDirFile = new File(tempDirStr);
            this.javaFile = srcScriptletFileName;
            this.javaFile = new File(tempDirFile, this.javaFile).getPath();
            this.javaFile = this.jrf.getReport().getScriptletFileName();
            this.status = "Compiling scriptlet";
            this.mainFrame.logOnConsole("</font><font face=\"SansSerif\" size=\"3\" color=\"#000000\">Compiling file... " + scriptletFileName + " -> " + this.javaFile + "</font><br><font face=\"Courier New\" size=\"3\">", true);
            try {
                JRJdk13Compiler compiler = new JRJdk13Compiler();
                compiler.compileClass(new File(this.javaFile), Misc.getClassPath());
            }
            catch (Exception ex) {
                this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the Scriptlet java source!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                sw = new StringWriter(0);
                ex.printStackTrace(new PrintWriter(sw));
                myPrintStream.flush();
                this.parseException(outputBuffer + sw.getBuffer() + "", null);
            }
            finally {
                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                    // empty if block
                }
            }
            this.mainFrame.logOnConsole(outputBuffer);
            outputBuffer = "";
            this.mainFrame.logOnConsole("</font><hr><font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Compilation running time : " + (System.currentTimeMillis() - start) + "</b></font><br><hr><font face=\"Courier New\" size=\"3\">", true);
        }
        if ((this.command & 1) != 0) {
            System.setProperty("jasper.reports.compile.keep.java.file", "true");
            this.javaFile = this.jrf.getReport().getName() + ".java";
            oldCompileTemp = tempDirStr = System.getProperty("jasper.reports.compile.temp");
            if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
            }
            tempDirFile = new File(tempDirStr);
            this.javaFile = new File(tempDirFile, this.javaFile).getPath();
            this.status = "Compiling";
            this.mainFrame.logOnConsole("</font><font face=\"SansSerif\" size=\"3\" color=\"#000000\">Compiling to file... " + fileName + " -> " + this.javaFile + "</font><br><font face=\"Courier New\" size=\"3\">", true);
            try {
                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                    System.setProperty("jasper.reports.compile.temp", tempDirStr);
                }
                String old_jr_classpath = Misc.nvl(System.getProperty("jasper.reports.compile.class.path"), "");
                System.setProperty("jasper.reports.compile.class.path", Misc.nvl(new File(fileName).getParent(), ".") + File.pathSeparator + System.getProperty("java.class.path") + File.pathSeparator + System.getProperty("java.class.path"));
                JasperCompileManager.compileReportToFile((String)srcFileName, (String)fileName);
                System.setProperty("jasper.reports.compile.class.path", old_jr_classpath);
            }
            catch (JRException jrex) {
                this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Errors compiling " + fileName + "!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                Vector<String> source = new Vector<String>();
                try {
                    String line;
                    BufferedReader is = new BufferedReader(new FileReader(this.javaFile));
                    while ((line = is.readLine()) != null) {
                        source.addElement(line);
                    }
                    is.close();
                }
                catch (Exception ioex) {
                    // empty catch block
                }
                StringWriter sw2 = new StringWriter(0);
                jrex.printStackTrace(new PrintWriter(sw2));
                System.out.println("\n\n\n");
                myPrintStream.flush();
                this.parseException(outputBuffer + sw2.getBuffer() + "", source);
            }
            catch (Exception ex) {
                this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the report java source!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                sw = new StringWriter(0);
                ex.printStackTrace(new PrintWriter(sw));
                myPrintStream.flush();
                this.parseException(outputBuffer + sw.getBuffer() + "", null);
            }
            finally {
                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                    if (oldCompileTemp != null) {
                        System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                    } else {
                        System.setProperty("jasper.reports.compile.temp", "");
                    }
                }
            }
            this.mainFrame.logOnConsole(outputBuffer);
            outputBuffer = "";
            this.mainFrame.logOnConsole("</font><hr><font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Compilation running time : " + (System.currentTimeMillis() - start) + "</b></font><br><hr><font face=\"Courier New\" size=\"3\">", true);
        }
        if ((this.command & 2) != 0) {
            JasperPrint print = null;
            this.mainFrame.logOnConsole("</font><font face=\"SansSerif\" size=\"3\" color=\"#000000\">Filling report... </font><br><font face=\"Courier New\" size=\"3\">", true);
            if (this.properties.get(USE_EMPTY_DATASOURCE) != null && this.properties.get(USE_EMPTY_DATASOURCE).equals("true")) {
                try {
                    print = JasperFillManager.fillReport((String)fileName, new HashMap(), (JRDataSource)new JREmptyDataSource());
                }
                catch (Exception ex) {
                    this.mainFrame.logOnConsole("Error filling print...\n");
                    ex.printStackTrace();
                    this.mainFrame.logOnConsole(outputBuffer);
                    outputBuffer = "";
                }
            } else if (this.properties.get(USE_CONNECTION) != null && this.properties.get(USE_CONNECTION).equals("true")) {
                try {
                    IReportConnection connection = (IReportConnection)this.properties.get(CONNECTION);
                    HashMap hm = new HashMap();
                    if (connection instanceof JDBCConnection) {
                        print = JasperFillManager.fillReport((String)fileName, hm, (Connection)connection.getConnection());
                    } else if (connection instanceof JRCustomDataSourceConnection) {
                        JRCustomDataSourceConnection cds = (JRCustomDataSourceConnection)connection;
                        Object obj = Class.forName(cds.getFactoryClass()).newInstance();
                        Method m = obj.getClass().getMethod(cds.getMethodToCall(), new Class[0]);
                        JRDataSource ds = (JRDataSource)m.invoke(obj, (Object[])new Class[0]);
                        print = JasperFillManager.fillReport((String)fileName, hm, (JRDataSource)ds);
                    }
                }
                catch (Exception ex) {
                    this.mainFrame.logOnConsole("Error filling print...\n");
                    ex.printStackTrace();
                    this.mainFrame.logOnConsole(outputBuffer);
                    outputBuffer = "";
                }
            }
            Object jrv = null;
            Object exporter = null;
            if (print != null) {
                String format = Misc.nvl(this.properties.get(OUTPUT_FORMAT), "pdf");
                String viewer_program = "";
                this.mainFrame.logOnConsole(this.properties.get(OUTPUT_FORMAT) + "Exporting\n");
                try {
                    if (format.equalsIgnoreCase("pdf")) {
                        exporter = new JRPdfExporter();
                        fileName = Misc.changeFileExtension(fileName, "pdf");
                        this.mainFrame.logOnConsole("Exporting pdf to file... \"" + fileName + "\"\n");
                        viewer_program = this.mainFrame.getProperties().getProperty("ExternalPDFViewer");
                    } else if (format.equalsIgnoreCase("csv")) {
                        exporter = new JRCsvExporter();
                        fileName = Misc.changeFileExtension(fileName, "cvs");
                        this.mainFrame.logOnConsole("Exporting CSV to file... " + fileName + "\n");
                        viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalCSVViewer"), "");
                    } else if (format.equalsIgnoreCase("html")) {
                        exporter = new JRHtmlExporter();
                        fileName = Misc.changeFileExtension(fileName, "html");
                        this.mainFrame.logOnConsole("Exporting HTML to file... " + fileName + "\n");
                        viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalHTMLViewer"), "");
                    } else if (format.equalsIgnoreCase("xls")) {
                        exporter = new JRXlsExporter();
                        fileName = Misc.changeFileExtension(fileName, "xls");
                        this.mainFrame.logOnConsole("Exporting xls to file... " + fileName + "\n");
                        viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalXLSViewer"), "");
                    } else if (format.equalsIgnoreCase("java2D")) {
                        exporter = new JRGraphics2DExporter();
                        this.mainFrame.logOnConsole("Exporting to Java2D \n");
                        viewer_program = null;
                    } else if (format.equalsIgnoreCase("jrviewer")) {
                        this.mainFrame.logOnConsole("Viewing with JasperReports Viewer\n");
                        exporter = null;
                        viewer_program = null;
                    } else if (format.equalsIgnoreCase("txt")) {
                        exporter = new JRTxtExporter();
                        fileName = Misc.changeFileExtension(fileName, "txt");
                        this.mainFrame.logOnConsole("Exporting txt (experimental) to file... " + fileName + "\n");
                        viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalEditor"), "");
                    }
                    if (exporter != null) {
                        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
                        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                        exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)this);
                        exporter.exportReport();
                    } else if (format.equalsIgnoreCase("jrviewer")) {
                        JasperViewer jasperViewer = new JasperViewer(print, false);
                        jasperViewer.setTitle("iReport JasperViewer");
                        jasperViewer.show();
                    }
                }
                catch (Exception ex2) {
                    this.mainFrame.logOnConsole("Error exporting print...\n");
                    ex2.printStackTrace();
                    this.mainFrame.logOnConsole(outputBuffer);
                    outputBuffer = "";
                }
                this.mainFrame.logOnConsole("Running time : " + (System.currentTimeMillis() - start) + "\n");
                Runtime rt = Runtime.getRuntime();
                if (viewer_program == null || viewer_program.equals("")) {
                    if (!format.equalsIgnoreCase("jrviewer")) {
                        this.mainFrame.logOnConsole("No external viewer specified for this type of print. Set it in the options frame!\n");
                    }
                } else {
                    try {
                        String execute_string = viewer_program + " " + fileName + "";
                        this.mainFrame.logOnConsole("Executing: " + execute_string + "\n");
                        rt.exec(execute_string);
                    }
                    catch (Exception ex) {
                        this.mainFrame.logOnConsole("Error viewing report...\n");
                        ex.printStackTrace();
                        this.mainFrame.logOnConsole(outputBuffer + "\n");
                        outputBuffer = "";
                    }
                    this.mainFrame.logOnConsole("Finished...\n");
                }
            } else {
                this.mainFrame.logOnConsole("Print not filled. Try to use an EmptyDataSource...!\n");
            }
        }
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public IReportConnection getIReportConnection() {
        return this.iReportConnection;
    }

    public void setIReportConnection(IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.status;
    }

    public void start() {
        this.thread = new Thread(this);
        try {
            String reportDirectory = new File(this.jrf.getReport().getFilename()).getParent();
            String classpath = System.getProperty("jasper.reports.compile.class.path");
            if (classpath != null) {
                classpath = classpath + File.pathSeparator + reportDirectory;
                System.setProperty("jasper.reports.compile.class.path", classpath);
            } else if (System.getProperty("java.class.path") != null) {
                classpath = System.getProperty("java.class.path");
                classpath = classpath + File.pathSeparator + reportDirectory;
                System.setProperty("java.class.path", classpath);
            }
            reportDirectory = reportDirectory.replace('\\', '/');
            if (!reportDirectory.endsWith("/")) {
                reportDirectory = reportDirectory + "/";
            }
            if (!reportDirectory.startsWith("/")) {
                reportDirectory = "/" + reportDirectory;
            }
            this.thread.setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + reportDirectory)}));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        this.thread.start();
    }

    public void parseException(String exception, Vector sourceLines) {
        String outString = "";
        StringTokenizer st = new StringTokenizer(exception, "\n");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            if (line.startsWith(this.javaFile)) {
                String lineCode;
                outString = outString + Misc.toHTML(line + "\n");
                String lineNumber = line.substring(this.javaFile.length() + 1);
                int ln = Integer.parseInt(lineNumber = lineNumber.substring(0, lineNumber.indexOf(58)));
                if (ln >= 3) {
                    ln -= 3;
                }
                String reference = "";
                if (sourceLines.size() >= ln && (lineCode = (String)sourceLines.elementAt(ln)).indexOf("            case") == 0 && lineCode.indexOf(" : // ") > 0) {
                    reference = lineCode.substring(lineCode.indexOf(" : // ") + 6).trim();
                }
                if (!st.hasMoreElements()) continue;
                try {
                    String error_line = st.nextToken();
                    if (error_line.startsWith("found")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("required")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("symbol")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("location")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    String html = "";
                    for (int i = 0; i < error_line.length() && error_line.charAt(i) == ' '; ++i) {
                        html = html + "&nbsp;";
                    }
                    error_line = error_line.trim();
                    html = html + "<a href=\"http://error:" + this.jrf.getWindowID() + "/" + reference + "\">" + Misc.toHTML(error_line) + "</a><br>";
                    outString = outString + html;
                }
                catch (Exception ex) {
                    outString = outString + Misc.toHTML("Error parsing\n!");
                }
                continue;
            }
            if (line.startsWith("Warning :") && line.indexOf("y=") > 0 && line.indexOf("height=") > 0 && line.indexOf("band-height=") > 0) {
                outString = outString + "<a href=\"http://warning:" + this.jrf.getWindowID() + "\">" + Misc.toHTML(line) + "</a><br>";
                continue;
            }
            outString = outString + Misc.toHTML(line + "\n");
        }
        this.mainFrame.logOnConsole(outString, true);
        outputBuffer = "";
    }

    public JComponent searchButton(JComponent root, String text) {
        if (root instanceof JButton && ((JButton)root).getText() != null && ((JButton)root).getText().equals(text)) {
            return root;
        }
        for (int i = 0; i < root.getComponentCount(); ++i) {
            if (!(root.getComponent(i) instanceof JComponent)) continue;
            this.mainFrame.logOnConsole("" + (JComponent)root.getComponent(i) + "\n");
            JComponent res = this.searchButton((JComponent)root.getComponent(i), text);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void afterPageExport() {
        ++this.filledpage;
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            outputBuffer = outputBuffer + aString;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            outputBuffer = outputBuffer + aString;
        }
    }
}

