/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.barcode.BcImage;

public class BarcodeReportElement
extends ImageReportElement {
    private String title = "Sample barcode";
    private boolean legend = false;
    private boolean showText = false;
    private String text = "0815";
    private int type = 13;
    private boolean checkSum = false;
    private String lastError = null;

    public BarcodeReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setGraphicElementPen("Thin");
        this.setBarCodeImg(this.type, this.text, this.showText, this.checkSum);
        this.setImageClass("java.awt.Image");
        this.setScaleImage("RetainShape");
        this.setGraphicElementPen("None");
        this.setHyperlinkType("None");
        this.setAnchorNameExpression("");
        BarcodeReportElement.setImgDef(null);
    }

    public void setBarCodeImg(int type, String text, boolean showText, boolean checkSum) {
        StringBuffer bcCall = new StringBuffer("it.businesslogic.ireport.barcode.BcImage.getBarcodeImage(");
        boolean isFormula = text.trim().startsWith("$");
        bcCall.append(type);
        if (isFormula) {
            bcCall.append(",");
            bcCall.append(text);
            bcCall.append(",");
        } else {
            bcCall.append(",\"");
            bcCall.append(text);
            bcCall.append("\",");
        }
        bcCall.append(showText);
        bcCall.append(",");
        bcCall.append(checkSum);
        bcCall.append(")");
        super.setImageExpression(bcCall.toString());
        try {
            this.setImg(BcImage.getBarcodeImage(type, text, showText, checkSum));
            this.lastError = null;
        }
        catch (RuntimeException e) {
            this.setImg(null);
            this.lastError = e.getMessage();
        }
    }

    public void setImageExpression(String imageExpression) {
        super.setImageExpression(imageExpression);
        String iE = imageExpression.substring(imageExpression.indexOf("(") + 1, imageExpression.indexOf(")"));
        String[] params = iE.split(",");
        this.type = new Integer(params[0]);
        this.text = params[1].startsWith("$") ? params[1] : params[1].substring(1, params[1].length() - 1);
        this.showText = new Boolean(params[2]);
        this.checkSum = new Boolean(params[3]);
        this.update();
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
        this.update();
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void update() {
        this.setBarCodeImg(this.type, this.text, this.showText, this.checkSum);
        boolean isFormula = this.text.trim().startsWith("$");
        if (!isFormula) {
            this.width = BcImage.getBarcode().getMinimumSize().width;
            this.height = BcImage.getBarcode().getMinimumSize().height;
        }
        this.updateBounds();
    }

    public ReportElement cloneMe() {
        BarcodeReportElement newReportElement = new BarcodeReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setImg(null);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.update();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(boolean checkSum) {
        this.checkSum = checkSum;
        this.update();
    }

    public String getLastError() {
        return this.lastError;
    }
}

