/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class SharedFormulaRecord
extends Record {
    public static final short sid = 1212;
    private short size = 0;
    private byte[] thedata = null;
    int offset = 0;

    public SharedFormulaRecord() {
    }

    public SharedFormulaRecord(short id, short size, byte[] data) {
        super(id, size, data);
        this.fillFields(data, size, 0);
    }

    public int serialize(int offset, byte[] data) {
        if (this.thedata == null) {
            this.thedata = new byte[0];
        }
        LittleEndian.putShort(data, 0 + offset, (short)1212);
        LittleEndian.putShort(data, 2 + offset, (short)this.thedata.length);
        if (this.thedata.length > 0) {
            System.arraycopy(this.thedata, 0, data, 4 + offset, this.thedata.length);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.thedata != null) {
            retval += this.thedata.length;
        }
        return retval;
    }

    protected void validateSid(short id) {
        if (id != 1212) {
            throw new RecordFormatException("Not a valid SharedFormula");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SHARED FORMULA RECORD:" + Integer.toHexString(1212) + "]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(1212)).append("\n");
        buffer.append("[/SHARED FORMULA RECORD]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 1212;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.thedata = new byte[size];
        System.arraycopy(data, 0, this.thedata, 0, size);
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object clone() {
        SharedFormulaRecord rec = new SharedFormulaRecord();
        rec.offset = this.offset;
        rec.size = this.size;
        rec.thedata = this.thedata;
        return rec;
    }
}

