/*
 * GroupsDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 10 maggio 2003, 9.51
 */

package it.businesslogic.ireport.gui;

import javax.swing.table.*;
import javax.swing.*;
import javax.swing.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;

import java.util.*;
/**
 *
 * @author  Administrator
 */
public class GroupsDialog extends javax.swing.JDialog {
    
    
    private JReportFrame jReportFrame=null;
    
    /** Creates new form GroupsDialog */
    public GroupsDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
         this.setSize(420, 250);
         Misc.centerFrame(this);
        
        DefaultListSelectionModel dlsm =  (DefaultListSelectionModel)this.jTableGroups.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)  {
                jTableGroupsListSelectionValueChanged(e);
            }
        });
    }
    
    public void jTableGroupsListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {
         if (this.jTableGroups.getSelectedRowCount() > 0) {
            this.jButtonModifyGroup.setEnabled(true);
            this.jButtonDeleteGroup.setEnabled(true);
        }
        else {
            this.jButtonModifyGroup.setEnabled(false);
            this.jButtonDeleteGroup.setEnabled(false);
        }
    }
    
     public void updateGroups() {
    
         
        DefaultTableModel dtm = (DefaultTableModel)jTableGroups.getModel();
        dtm.setRowCount(0);
    
        if (jReportFrame == null) return;
        Enumeration e = jReportFrame.getReport().getGroups().elements();
        while (e.hasMoreElements())
        {
            it.businesslogic.ireport.Group group = (it.businesslogic.ireport.Group)e.nextElement();
            Vector row = new Vector();
            row.addElement( group );
            
            dtm.addRow(row);           
        }    
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanelFields = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTableGroups = new javax.swing.JTable();
        jPanelButtons = new javax.swing.JPanel();
        jButtonNewGroup = new javax.swing.JButton();
        jButtonModifyGroup = new javax.swing.JButton();
        jButtonDeleteGroup = new javax.swing.JButton();
        jButtonDeleteGroup1 = new javax.swing.JButton();
        jButtonDeleteGroup2 = new javax.swing.JButton();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanelFields.setLayout(new java.awt.BorderLayout());

        jScrollPane3.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane3.setFont(new java.awt.Font("Dialog", 0, 11));
        jTableGroups.setFont(new java.awt.Font("Dialog", 0, 11));
        jTableGroups.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Group name"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane3.setViewportView(jTableGroups);

        jPanelFields.add(jScrollPane3, java.awt.BorderLayout.CENTER);

        jPanelButtons.setLayout(null);

        jPanelButtons.setMinimumSize(new java.awt.Dimension(100, 10));
        jPanelButtons.setPreferredSize(new java.awt.Dimension(100, 10));
        jButtonNewGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonNewGroup.setText("New");
        jButtonNewGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewGroupActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonNewGroup);
        jButtonNewGroup.setBounds(4, 5, 92, 22);

        jButtonModifyGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonModifyGroup.setText("Modify");
        jButtonModifyGroup.setEnabled(false);
        jButtonModifyGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyGroupActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonModifyGroup);
        jButtonModifyGroup.setBounds(4, 30, 92, 22);

        jButtonDeleteGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonDeleteGroup.setText("Delete");
        jButtonDeleteGroup.setEnabled(false);
        jButtonDeleteGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteGroupActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonDeleteGroup);
        jButtonDeleteGroup.setBounds(4, 108, 92, 22);

        jButtonDeleteGroup1.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonDeleteGroup1.setText("Move Up");
        jButtonDeleteGroup1.setEnabled(false);
        jPanelButtons.add(jButtonDeleteGroup1);
        jButtonDeleteGroup1.setBounds(4, 56, 92, 22);

        jButtonDeleteGroup2.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonDeleteGroup2.setText("Move Down");
        jButtonDeleteGroup2.setEnabled(false);
        jPanelButtons.add(jButtonDeleteGroup2);
        jButtonDeleteGroup2.setBounds(4, 82, 92, 22);

        jPanelFields.add(jPanelButtons, java.awt.BorderLayout.EAST);

        getContentPane().add(jPanelFields, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void jButtonDeleteGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteGroupActionPerformed
        jTableGroups.getSelectedRows();
        int[]  rows= jTableGroups.getSelectedRows();
        for (int i=rows.length-1; i>=0; --i)
        {
            // Adjust elements
            Enumeration e = this.getJReportFrame().getReport().getElements().elements();
            while (e.hasMoreElements())
            {
                ReportElement re = (ReportElement)e.nextElement();
                if (re.printWhenGroupChanges.equals(""+(it.businesslogic.ireport.Group)jTableGroups.getValueAt( rows[i], 0)) )
                    re.printWhenGroupChanges = "";
            }
            
            // Adjust variables...
            e = this.getJReportFrame().getReport().getVariables().elements();
            while (e.hasMoreElements())
            {
                JRVariable var = (JRVariable)e.nextElement();
                if (var.getResetType().equals("Group") && var.getResetGroup().equals(""+(it.businesslogic.ireport.Group)jTableGroups.getValueAt( rows[i], 0)) )
                {
                    var.setResetType("Report");
                    var.setResetGroup("");
                }
            }
            
            this.getJReportFrame().getReport().delGroup((it.businesslogic.ireport.Group)jTableGroups.getValueAt( rows[i], 0));
            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
        updateGroups();

        this.getJReportFrame().checkSelection(false);
        ((MainFrame)this.getParent()).getBandsDialog().updateBands();
        ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
        this.getJReportFrame().setIsDocDirty(true);
        this.getJReportFrame().repaint();
    }//GEN-LAST:event_jButtonDeleteGroupActionPerformed

    private void jButtonModifyGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyGroupActionPerformed
        it.businesslogic.ireport.Group group = (it.businesslogic.ireport.Group)jTableGroups.getValueAt( jTableGroups.getSelectedRow(), 0);
        
        JRGroupDialog jrpd = new JRGroupDialog(getJReportFrame(), true);
        jrpd.setGroup( group );
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            String oldName = group.getName();

            group.setName( jrpd.getGroupName() );
            group.setGroupExpression( jrpd.getExpression());
            group.setIsReprintHeaderOnEachPage(jrpd.isPrintHeaderEachPage() );
            group.setIsResetPageNumber( jrpd.isResetPageNumber()  );
            group.setIsStartNewColumn( jrpd.isStartNewColumn());
            group.setIsStartNewPage( jrpd.isStartNewPage());
            group.setMinHeightToStartNewPage( jrpd.getMinHeightStartNewPage() );
            
            group.getGroupHeader().setName( group.getName()+"Header");
            group.getGroupFooter().setName( group.getName()+"Footer");
            group.getGroupHeader().setHeight(  jrpd.getHeaderBandHeight());
            group.getGroupFooter().setHeight(  jrpd.getFooterBandHeight());
            
            // Update All variables...
            Enumeration e = getJReportFrame().getReport().getVariables().elements();
            while (e.hasMoreElements())
            {
                JRVariable var = (JRVariable)e.nextElement();
                if (var.getResetGroup() != null &&
                    var.getResetGroup().equals(oldName))
                {
                    var.setResetGroup( group.getName() );
                }
            }
            
            // Adjust elements
            e = this.getJReportFrame().getReport().getElements().elements();
            while (e.hasMoreElements())
            {
                ReportElement re = (ReportElement)e.nextElement();
                if (re.printWhenGroupChanges.equals(oldName) )
                    re.printWhenGroupChanges = group.getName();
                
                if (re instanceof TextFieldReportElement &&
                    ((TextFieldReportElement)re).getGroup().equals(oldName))
                    ((TextFieldReportElement)re).setGroup(group.getName());
            }
            
            // refersh bands frame....
            ((MainFrame)this.getParent()).getBandsDialog().updateBands();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().repaint();
            this.updateGroups();
        }
        
    }//GEN-LAST:event_jButtonModifyGroupActionPerformed

    private void jButtonNewGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewGroupActionPerformed
        JRGroupDialog jrpd = new JRGroupDialog(this.getJReportFrame(), true);
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            Group g = new it.businesslogic.ireport.Group(this.getJReportFrame().getReport(), jrpd.getGroupName());
            g.setGroupExpression( jrpd.getExpression());
            g.setIsReprintHeaderOnEachPage(jrpd.isPrintHeaderEachPage() );
            g.setIsResetPageNumber( jrpd.isResetPageNumber()  );
            g.setIsStartNewColumn( jrpd.isStartNewColumn());
            g.setIsStartNewPage( jrpd.isStartNewPage());
            g.setMinHeightToStartNewPage( jrpd.getMinHeightStartNewPage() );
            
            g.getGroupHeader().setHeight(  jrpd.getHeaderBandHeight());
            g.getGroupFooter().setHeight(  jrpd.getFooterBandHeight());

            this.getJReportFrame().getReport().addGroup(g);
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().repaint();
            this.updateGroups();
            
            // refersh bands frame....
            ((MainFrame)this.getParent()).getBandsDialog().updateBands();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateBands();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateGroups();
        }
    }//GEN-LAST:event_jButtonNewGroupActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new GroupsDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property jReportFrame.
     * @return Value of property jReportFrame.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJReportFrame() {
        return jReportFrame;
    }    
    
    /** Setter for property jReportFrame.
     * @param jReportFrame New value of property jReportFrame.
     *
     */
    public void setJReportFrame(it.businesslogic.ireport.gui.JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        
        // Update all...
        if (jReportFrame == null) 
        {
            setVisible(false);
            return;
        }
        this.setTitle(jReportFrame.getReport().getName()+" groups...");
        if (isVisible())
        {
            updateGroups();
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonDeleteGroup;
    private javax.swing.JButton jButtonNewGroup;
    private javax.swing.JButton jButtonDeleteGroup1;
    private javax.swing.JTable jTableGroups;
    private javax.swing.JPanel jPanelButtons;
    private javax.swing.JPanel jPanelFields;
    private javax.swing.JButton jButtonDeleteGroup2;
    private javax.swing.JButton jButtonModifyGroup;
    private javax.swing.JScrollPane jScrollPane3;
    // End of variables declaration//GEN-END:variables
    
    public void setVisible(boolean visible)
    {
        if (visible == isVisible()) return;
        super.setVisible(visible);
        if (visible == true) 
        {
            this.setJReportFrame(jReportFrame);
        }
    }
}
