/*
 * Created on 09/05/2004
 *
 */
package it.businesslogic.ireport.chart;

import java.awt.Color;
import java.awt.Image;
import java.util.Hashtable;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.PieDataset;

import dori.jasper.engine.JRDataSource;

/**
 * @author Egon
 *
 */
public final class IReportJFreeChartFactory extends IReportAbstractChartFactory implements IReportChartTypeDescription {

	public static final int CHART_TYPE_PIE 				= 1;
	public static final int CHART_TYPE_BAR				= 2;
	public static final int CHART_TYPE_PIE_3D			= 3;
	public static final int CHART_TYPE_BAR_3D			= 4;
	public static final int CHART_TYPE_LINE				= 5;

/*
	public static final int CHART_TYPE_STACKED_BAR		= 6;
	public static final int CHART_TYPE_STACKED_BAR_3D	= 7;
	public static final int CHART_TYPE_AREA				= 8;
	public static final int CHART_TYPE_STACKED_AREA		= 9;
	public static final int CHART_TYPE_MULTIPLE_PIE_3D	= 10;
	public static final int CHART_TYPE_MULTIPLE_PIE 	= 11;
	public static final int CHART_TYPE_GANTT			= 12;
	public static final int CHART_TYPE_WATERFALL		= 13;
	public static final int CHART_TYPE_POLAR			= 14;
	public static final int CHART_TYPE_SCATTER_PLOT		= 15;
	public static final int CHART_TYPE_XY_BAR			= 16;
	public static final int CHART_TYPE_XY_AREA			= 17;
	public static final int CHART_TYPE_STACKED_XY_AREA	= 18;
	public static final int CHART_TYPE_XY_LINE			= 19;
	public static final int CHART_TYPE_XY_STEP			= 20;
	public static final int CHART_TYPE_XY_STEP_AREA		= 21;
	public static final int CHART_TYPE_TIMESERIES		= 22;
	public static final int CHART_TYPE_CANDLESTICK		= 23;
	public static final int CHART_TYPE_HIGHLOW			= 24;
	public static final int CHART_TYPE_SIGNAL			= 25;
	public static final int CHART_TYPE_BUBBLE			= 26;
	public static final int CHART_TYPE_HISTOGRAM		= 27;
	public static final int CHART_TYPE_BOXANDWHISKER	= 28;
	public static final int CHART_TYPE_WINDPLOT			= 29;
	public static final int CHART_TYPE_WAFERMAP			= 30;
*/

	private static Number[][] generateDataset(IReportChartProperties chartProperties, Hashtable dataSources, int index) throws Exception {
		return null;
	}


	private Plot generatePlot(
		Plot plot,
		IReportChartProperties chartProperties,
		Hashtable dataSources, int index)
		throws Exception {
			
		JFreeChart chart = null;
		int tipo = chartProperties.getType(index);
		PlotOrientation plotOrientation = IReportChartProperties.CHART_TYPE_ORIENTATION_HORIZONTAL.equals(chartProperties.getChartTypeOrientation(index)) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
		String title = chartProperties.getTitle(index);
		boolean legend = chartProperties.isLegendVisible(index);
		
		String categoryAxisLabel = null;
		String valueAxisLabel = null;
		CategoryDataset categoryDataset = null;
		PieDataset pieDataset = null;
		Number[][] values = generateDataset(chartProperties, dataSources, index);
		
		categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Category ", values);
		
		if(!hasYAxis(index) && !hasZAxis(index)){
			//use the first column
			pieDataset = DatasetUtilities.createPieDatasetForColumn(categoryDataset,0);
		}
		
		
		switch(tipo){
			case CHART_TYPE_BAR :
			chart = ChartFactory.createBarChart( title, categoryAxisLabel, valueAxisLabel, categoryDataset, plotOrientation, legend, false, false);  
			break;
			case CHART_TYPE_BAR_3D :
			chart = ChartFactory.createBarChart3D(title, categoryAxisLabel, valueAxisLabel, categoryDataset, plotOrientation, legend, false, false);  
			break;
			case CHART_TYPE_PIE :
			chart = ChartFactory.createPieChart(title, pieDataset, legend, false, false);  
			break;
			case CHART_TYPE_PIE_3D :
			chart = ChartFactory.createPieChart3D(title, pieDataset, legend, false, false);  
			break;
			case CHART_TYPE_LINE :
			chart = ChartFactory.createLineChart(title, categoryAxisLabel, valueAxisLabel, categoryDataset, plotOrientation, legend, false, false);  
			break;

/*			case CHART_TYPE_AREA :
			break;
			case CHART_TYPE_STACKED_AREA :
			break;
			case CHART_TYPE_STACKED_BAR :
			break;
			case CHART_TYPE_STACKED_BAR_3D :
			break;*/
		} 
		
		if(chart != null){
			plot = chart.getPlot();
		}
		
		return plot;			
	}


	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportAbstractChartFactory#engineGenerateChartImage(it.businesslogic.ireport.chart.IReportChartProperties, java.util.Hashtable)
	 */
	protected Image engineGenerateChartImage(
		IReportChartProperties chartProperties,
		Hashtable datasources)
		throws Exception 
	{

		int chartCount = chartProperties.getCount();
	
		Plot plot = null;
		for(int i = 1; i <= chartCount; i++){
		
			plot = generatePlot(plot, chartProperties, datasources, i);
		
		}

		JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
		chart.setBackgroundPaint(Color.WHITE);

		int chartWidth  = chartProperties.getWidth();
		int chartHeight = chartProperties.getHeight();

		return chart.createBufferedImage(chartWidth, chartHeight);
	}



	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportChartTypeDescription#getDataSetType(int)
	 */
	public int getDataSetType(int chartType) {
		int dsType = 0;
		
		switch(chartType){
			case CHART_TYPE_BAR :
			dsType = XY_AXIS_CHART_DATASET_TYPE;
			break;
			case CHART_TYPE_BAR_3D :
			dsType = XY_AXIS_CHART_DATASET_TYPE;
			break;
			case CHART_TYPE_PIE :
			dsType = X_AXIS_CHART_DATASET_TYPE;
			break;
			case CHART_TYPE_PIE_3D :
			dsType = X_AXIS_CHART_DATASET_TYPE;
			break;
			case CHART_TYPE_LINE :
			dsType = XY_AXIS_CHART_DATASET_TYPE;
			break;
		}
		return dsType;
	}

	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportChartTypeDescription#getDescription(int)
	 */
	public String getDescription(int chartType) {
		return getName(chartType);
	}

	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportChartTypeDescription#getName(int)
	 */
	public String getName(int chartType) {
		String text= "";
			
		switch(chartType){
			case CHART_TYPE_BAR :
			text = "Bar Chart";
			break;
			case CHART_TYPE_BAR_3D :
			text = "Bar Chart 3D";
			break;
			case CHART_TYPE_PIE :
			text = "Pie Chart";
			break;
			case CHART_TYPE_PIE_3D :
			text = "Pie Chart 3D";
			break;
			case CHART_TYPE_LINE :
			text = "Line Chart";
			break;
		}
		return text;
	}

	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportChartTypeDescription#getThumbImage(int)
	 */
	public Image getThumbImage(int chartType) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportChartTypeDescription#hasXAxis(int)
	 */
	public boolean hasXAxis(int chartType) {
		return true;
	}

	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportChartTypeDescription#hasYAxis(int)
	 */
	public boolean hasYAxis(int chartType) {
		switch(chartType){
			case CHART_TYPE_BAR :
			case CHART_TYPE_BAR_3D :
			case CHART_TYPE_LINE :
			return true;
			case CHART_TYPE_PIE :
			case CHART_TYPE_PIE_3D :
			default:
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportChartTypeDescription#hasZAxis(int)
	 */
	public boolean hasZAxis(int chartType) {
		return false;
	}

	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportAbstractChartFactory#engineGetChartTypeCount()
	 */
	protected int engineGetChartTypeCount() {
		return 5;
	}

	/* (non-Javadoc)
	 * @see it.businesslogic.ireport.chart.IReportAbstractChartFactory#allowMultipleChart()
	 */
	protected boolean allowMultipleChart() {
		return true;
	}

}
