/*
 * IReportChartWizard.java
 *
 * Created on 15 de Maio de 2004, 18:49
 */

package it.businesslogic.ireport.chart;

import java.awt.Frame;
import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JOptionPane;

import it.businesslogic.ireport.ChartReportElement;
import it.businesslogic.ireport.chart.gui.IReportChartWizardDialog;
import it.businesslogic.ireport.util.I18nOptionPane;
import it.businesslogic.ireport.util.Misc;

/**
 *
 * @author  Egon
 */
public class IReportChartWizard {
	
	private IReportChartWizardDialog wizardDialog = null;
	private Frame parent = null;
	private IReportChartProperties chartProperties = null;
	private ChartReportElement chartReportElement = null;
	
	private static IReportChartWizard CHART_WIZARD = null;
    
    /** Creates a new instance of IReportChartWizard */
    public IReportChartWizard(Frame parent) {
    	super();
    	
    	this.parent = parent;
    }

    /**
     * Show wizard dialog.
     * 
	 * @param parent
	 * @param chartReportElement
	 */
	public void showWizard(ChartReportElement chartReportElement){
		
		//test if chart factory is set
		if(chartReportElement.getChartProperties().getFactory() == null || 
		chartReportElement.getChartProperties().getFactory().trim().length() == 0){
			
			I18nOptionPane.showMessageDialog(parent, "chartFactoryRequired", "error", JOptionPane.ERROR_MESSAGE);
			return;
		}
    	
    	//make a instance of dialog
    	if(wizardDialog == null){
    		wizardDialog = new IReportChartWizardDialog(parent, true);
    	}
    	
    	this.chartReportElement = chartReportElement;
    	
    	//load chart properties
    	setChartProperties(chartReportElement.getChartProperties());

		//under construction
		JOptionPane.showMessageDialog(parent, "Under construction...\nWait for next release, ok? :)", "Error", JOptionPane.ERROR_MESSAGE);
    	
		/*wizardDialog.setSize(400, 400);
		Misc.centerFrame(wizardDialog);
    	wizardDialog.show();*/
    }
    
    
    public static IReportChartWizard getInstance(Frame parent){
    	
    	if(CHART_WIZARD == null){

    		CHART_WIZARD = new IReportChartWizard(parent);

    	}else if(CHART_WIZARD.wizardDialog == null || (parent != null && CHART_WIZARD.wizardDialog.getParent() != parent) ) {
    		
    		//reset 
			CHART_WIZARD.wizardDialog = null;
			CHART_WIZARD.parent = parent;
    	}
    	
    	return CHART_WIZARD;
    }

	public void setChartProperties(IReportChartProperties chartProperties){
		this.chartProperties = chartProperties;
	}
    
}
