/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class OptionsDialog
extends JDialog {
    MainFrame mf = null;
    Unit[] units;
    List listOfLanguages;
    List listOfPLAF;
    private ButtonGroup buttonGroup1;
    private JButton jButtonApply;
    private JButton jButtonBackupDirectory;
    private JButton jButtonBorderTextColor;
    private JButton jButtonBrowseEditor;
    private JButton jButtonBrowseEditor1;
    private JButton jButtonBrowseEditor2;
    private JButton jButtonBrowseEditor3;
    private JButton jButtonBrowseEditor4;
    private JButton jButtonCancel;
    private JButton jButtonCompilationDir;
    private JButton jButtonOK;
    private JButton jButtonTemplate;
    private JCheckBox jCheckBoxAutosave;
    private JCheckBox jCheckBoxUseCurrentFilesDirectoryForCompiles;
    private JCheckBox jCheckBoxUseMultiLineScripts;
    private JCheckBox jCheckBoxViewBorderText;
    private JCheckBox jCheckBoxViewGrid;
    private JCheckBox jCheckBoxViewRules;
    private JComboBox jComboBoxDefaultRulesUnit;
    private JComboBox jComboBoxLanguage;
    private JComboBox jComboBoxLookAndFeel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JNumberField jNumberFieldGridSize;
    private JNumberField jNumberFieldRecentFilesListLenght;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanelBackup;
    private JPanel jPanelComper;
    private JPanel jPanelExternalPrograms;
    private JPanel jPanelGeneral;
    private JRadioButton jRadioButton1_NoBackup;
    private JRadioButton jRadioButton2_ReplaceExtension;
    private JRadioButton jRadioButton3_AppendExtension;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldBackupDirectory;
    private JTextField jTextFieldCSVViewer;
    private JTextField jTextFieldCompilationDir;
    private JTextField jTextFieldEditor;
    private JTextField jTextFieldHTMLViewer;
    private JTextField jTextFieldPDFViewer;
    private JTextField jTextFieldTemplate;
    private JTextField jTextFieldXLSViewer;

    public OptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mf = (MainFrame)parent;
        this.initComponents();
        DocumentListener listener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }

            public void insertUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }

            public void removeUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }
        };
        this.jTextFieldBackupDirectory.getDocument().addDocumentListener(listener);
        this.jTextFieldCSVViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldCompilationDir.getDocument().addDocumentListener(listener);
        this.jTextFieldEditor.getDocument().addDocumentListener(listener);
        this.jTextFieldHTMLViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldPDFViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldTemplate.getDocument().addDocumentListener(listener);
        this.jTextFieldXLSViewer.getDocument().addDocumentListener(listener);
        this.units = Unit.getStandardUnits();
        for (int i = 0; i < this.units.length; ++i) {
            this.jComboBoxDefaultRulesUnit.addItem(this.units[i] + "");
        }
        this.listOfLanguages = I18n.getListOfAvailLanguages();
        Object languageModel = null;
        String selectedLanguage = this.mf.getProperties().getProperty("Language");
        String selectedCountry = this.mf.getProperties().getProperty("Country");
        for (int i = 0; i < this.listOfLanguages.size(); ++i) {
            Locale lang = (Locale)this.listOfLanguages.get(i);
            LocaleAdapter adapeter = new LocaleAdapter(lang);
            this.jComboBoxLanguage.addItem(adapeter);
            if (!lang.getCountry().equals(selectedCountry) || !lang.getLanguage().equals(selectedLanguage)) continue;
            this.jComboBoxLanguage.setSelectedItem(adapeter);
        }
        this.listOfPLAF = Misc.getAvailablePLAF();
        String selectedPAF = this.mf.getProperties().getProperty("LookAndFeel");
        for (int i = 0; i < this.listOfPLAF.size(); ++i) {
            String pnf = (String)this.listOfPLAF.get(i);
            this.jComboBoxLookAndFeel.addItem(pnf);
            if (!pnf.equals(selectedPAF)) continue;
            this.jComboBoxLookAndFeel.setSelectedItem(pnf);
        }
    }

    public void loadConfiguration() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        try {
            this.jNumberFieldRecentFilesListLenght.setValue(Integer.parseInt(Misc.nvl(this.mf.getProperties().getProperty("RecentFilesLength"), "10")));
            this.jNumberFieldGridSize.setValue(Integer.parseInt(Misc.nvl(this.mf.getProperties().getProperty("GridSize"), "10")));
            this.jTextFieldBackupDirectory.setText(Misc.nvl(this.mf.getProperties().getProperty("DefaultBackupDirectory"), ""));
            this.jTextFieldCSVViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalCSVViewer"), ""));
            this.jTextFieldPDFViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalPDFViewer"), ""));
            this.jTextFieldXLSViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalXLSViewer"), ""));
            this.jTextFieldHTMLViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalHTMLViewer"), ""));
            this.jTextFieldEditor.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalEditor"), ""));
            this.jCheckBoxViewRules.setSelected(Misc.nvl(this.mf.getProperties().getProperty("ViewRules"), "true").equals("true"));
            this.jCheckBoxViewGrid.setSelected(Misc.nvl(this.mf.getProperties().getProperty("ViewGrid"), "false").equals("true"));
            this.jCheckBoxViewBorderText.setSelected(Misc.nvl(this.mf.getProperties().getProperty("ViewBorderForTextElements"), "true").equals("true"));
            this.jTextFieldCompilationDir.setText(this.mf.getDefaultCompilationDirectory());
            this.jRadioButton1_NoBackup.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("1"));
            this.jRadioButton2_ReplaceExtension.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("2"));
            this.jRadioButton3_AppendExtension.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("3"));
            this.jButtonBorderTextColor.setBackground(new Color(Integer.parseInt(Misc.nvl(this.mf.getProperties().getProperty("ViewBorderColor"), "1"))));
            this.jTextFieldTemplate.setText(Misc.nvl(this.mf.getProperties().getProperty("DefaultTemplate"), ""));
            this.jCheckBoxAutosave.setSelected(Misc.nvl(this.mf.getProperties().getProperty("SaveBeforeCompiling"), "true").equals("true"));
            this.jCheckBoxUseMultiLineScripts.setSelected(this.mf.isUsingMultiLineExpressions());
            this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setSelected(this.mf.isUsingCurrentFilesDirectoryForCompiles());
            if (this.mf.isUsingCurrentFilesDirectoryForCompiles()) {
                this.disableCompileDirectoryBrowse();
            }
            for (int i = 0; i < this.jComboBoxDefaultRulesUnit.getItemCount(); ++i) {
                if (!(this.jComboBoxDefaultRulesUnit.getItemAt(i) + "").equals(Misc.nvl(this.mf.getProperties().getProperty("DefaultUnit"), "cm"))) continue;
                this.jComboBoxDefaultRulesUnit.setSelectedIndex(i);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.disableApplyAndOk();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelGeneral = new JPanel();
        this.jPanel8 = new JPanel();
        this.jNumberFieldRecentFilesListLenght = new JNumberField();
        this.jLabel6 = new JLabel();
        this.jCheckBoxViewRules = new JCheckBox();
        this.jCheckBoxViewGrid = new JCheckBox();
        this.jNumberFieldGridSize = new JNumberField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jComboBoxDefaultRulesUnit = new JComboBox();
        this.jCheckBoxViewBorderText = new JCheckBox();
        this.jCheckBoxUseMultiLineScripts = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.jButtonBorderTextColor = new JButton();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jComboBoxLookAndFeel = new JComboBox();
        this.jComboBoxLanguage = new JComboBox();
        this.jTextFieldTemplate = new JTextField();
        this.jButtonTemplate = new JButton();
        this.jLabel9 = new JLabel();
        this.jPanelComper = new JPanel();
        this.jPanel7 = new JPanel();
        this.jTextFieldCompilationDir = new JTextField();
        this.jButtonCompilationDir = new JButton();
        this.jCheckBoxAutosave = new JCheckBox();
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles = new JCheckBox();
        this.jPanelBackup = new JPanel();
        this.jPanel6 = new JPanel();
        this.jTextFieldBackupDirectory = new JTextField();
        this.jButtonBackupDirectory = new JButton();
        this.jRadioButton1_NoBackup = new JRadioButton();
        this.jRadioButton2_ReplaceExtension = new JRadioButton();
        this.jRadioButton3_AppendExtension = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jPanelExternalPrograms = new JPanel();
        this.jPanel4 = new JPanel();
        this.jTextFieldEditor = new JTextField();
        this.jButtonBrowseEditor = new JButton();
        this.jPanel5 = new JPanel();
        this.jTextFieldPDFViewer = new JTextField();
        this.jButtonBrowseEditor1 = new JButton();
        this.jTextFieldHTMLViewer = new JTextField();
        this.jButtonBrowseEditor2 = new JButton();
        this.jTextFieldXLSViewer = new JTextField();
        this.jButtonBrowseEditor3 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldCSVViewer = new JTextField();
        this.jButtonBrowseEditor4 = new JButton();
        this.jPanel1 = new JPanel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonApply = new JButton();
        this.setTitle("iReport Options");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OptionsDialog.this.closeDialog(evt);
            }
        });
        this.jTabbedPane1.setFont(new Font("Dialog", 0, 11));
        this.jPanelGeneral.setLayout(null);
        this.jPanel8.setLayout(null);
        this.jPanel8.setBorder(new TitledBorder(new EtchedBorder(), "General", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel8.setFont(new Font("Dialog", 0, 11));
        this.jNumberFieldRecentFilesListLenght.setHorizontalAlignment(4);
        try {
            this.jNumberFieldRecentFilesListLenght.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            this.jNumberFieldRecentFilesListLenght.setValue(10.0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldRecentFilesListLenght.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jNumberFieldRecentFilesListLenghtActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jNumberFieldRecentFilesListLenght);
        this.jNumberFieldRecentFilesListLenght.setBounds(180, 26, 52, 20);
        this.jLabel6.setFont(new Font("Dialog", 0, 11));
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setText("Num of recent files in file menu");
        this.jPanel8.add(this.jLabel6);
        this.jLabel6.setBounds(24, 28, 156, 15);
        this.jCheckBoxViewRules.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxViewRules.setSelected(true);
        this.jCheckBoxViewRules.setText("View rules");
        this.jCheckBoxViewRules.setHorizontalAlignment(4);
        this.jCheckBoxViewRules.setHorizontalTextPosition(2);
        this.jCheckBoxViewRules.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jCheckBoxViewRulesItemStateChanged(evt);
            }
        });
        this.jPanel8.add(this.jCheckBoxViewRules);
        this.jCheckBoxViewRules.setBounds(58, 70, 134, 18);
        this.jCheckBoxViewGrid.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxViewGrid.setText("View grid");
        this.jCheckBoxViewGrid.setHorizontalAlignment(4);
        this.jCheckBoxViewGrid.setHorizontalTextPosition(2);
        this.jCheckBoxViewGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxViewGridActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jCheckBoxViewGrid);
        this.jCheckBoxViewGrid.setBounds(26, 86, 166, 24);
        this.jNumberFieldGridSize.setHorizontalAlignment(4);
        try {
            this.jNumberFieldGridSize.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            this.jNumberFieldGridSize.setValue(10.0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldGridSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jNumberFieldGridSizeActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jNumberFieldGridSize);
        this.jNumberFieldGridSize.setBounds(180, 110, 52, 20);
        this.jLabel7.setFont(new Font("Dialog", 0, 11));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Grid size");
        this.jPanel8.add(this.jLabel7);
        this.jLabel7.setBounds(58, 112, 118, 16);
        this.jLabel8.setFont(new Font("Dialog", 0, 11));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Default unit");
        this.jPanel8.add(this.jLabel8);
        this.jLabel8.setBounds(20, 50, 154, 16);
        this.jComboBoxDefaultRulesUnit.setFont(new Font("Dialog", 0, 11));
        this.jComboBoxDefaultRulesUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jComboBoxDefaultRulesUnitActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jComboBoxDefaultRulesUnit);
        this.jComboBoxDefaultRulesUnit.setBounds(180, 48, 76, 20);
        this.jCheckBoxViewBorderText.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxViewBorderText.setText("View border for text elements");
        this.jCheckBoxViewBorderText.setHorizontalAlignment(4);
        this.jCheckBoxViewBorderText.setHorizontalTextPosition(2);
        this.jCheckBoxViewBorderText.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jCheckBoxViewBorderTextItemStateChanged(evt);
            }
        });
        this.jPanel8.add(this.jCheckBoxViewBorderText);
        this.jCheckBoxViewBorderText.setBounds(9, 132, 185, 24);
        this.jCheckBoxUseMultiLineScripts.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxUseMultiLineScripts.setText("Using multi line expressions");
        this.jCheckBoxUseMultiLineScripts.setHorizontalAlignment(4);
        this.jCheckBoxUseMultiLineScripts.setHorizontalTextPosition(2);
        this.jCheckBoxUseMultiLineScripts.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jCheckBoxUseMultiLineScriptsItemStateChanged(evt);
            }
        });
        this.jPanel8.add(this.jCheckBoxUseMultiLineScripts);
        this.jCheckBoxUseMultiLineScripts.setBounds(10, 155, 185, 24);
        this.jLabel10.setFont(new Font("Dialog", 0, 11));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("Text border color");
        this.jPanel8.add(this.jLabel10);
        this.jLabel10.setBounds(60, 180, 114, 16);
        this.jButtonBorderTextColor.setBackground(new Color(128, 128, 128));
        this.jButtonBorderTextColor.setFont(new Font("Dialog", 0, 11));
        this.jButtonBorderTextColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBorderTextColorActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jButtonBorderTextColor);
        this.jButtonBorderTextColor.setBounds(180, 180, 54, 20);
        this.jLabel11.setFont(new Font("Dialog", 0, 11));
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("Look&Feel");
        this.jPanel8.add(this.jLabel11);
        this.jLabel11.setBounds(60, 202, 114, 16);
        this.jLabel12.setFont(new Font("Dialog", 0, 11));
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText("Language");
        this.jPanel8.add(this.jLabel12);
        this.jLabel12.setBounds(60, 223, 114, 16);
        this.jComboBoxLookAndFeel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jComboBoxLookAndFeelItemStateChanged(evt);
            }
        });
        this.jPanel8.add(this.jComboBoxLookAndFeel);
        this.jComboBoxLookAndFeel.setBounds(180, 202, 110, 20);
        this.jComboBoxLanguage.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OptionsDialog.this.jComboBoxLanguageItemStateChanged(evt);
            }
        });
        this.jPanel8.add(this.jComboBoxLanguage);
        this.jComboBoxLanguage.setBounds(180, 223, 110, 20);
        this.jPanelGeneral.add(this.jPanel8);
        this.jPanel8.setBounds(8, 8, 374, 250);
        this.jTextFieldTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jTextFieldTemplateActionPerformed(evt);
            }
        });
        this.jTextFieldTemplate.addInputMethodListener(new InputMethodListener(){

            public void caretPositionChanged(InputMethodEvent evt) {
            }

            public void inputMethodTextChanged(InputMethodEvent evt) {
                OptionsDialog.this.jTextFieldTemplateInputMethodTextChanged(evt);
            }
        });
        this.jPanelGeneral.add(this.jTextFieldTemplate);
        this.jTextFieldTemplate.setBounds(10, 280, 282, 20);
        this.jButtonTemplate.setFont(new Font("Dialog", 0, 11));
        this.jButtonTemplate.setText("Browse");
        this.jButtonTemplate.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonTemplateActionPerformed(evt);
            }
        });
        this.jPanelGeneral.add(this.jButtonTemplate);
        this.jButtonTemplate.setBounds(300, 280, 72, 20);
        this.jLabel9.setFont(new Font("Dialog", 0, 11));
        this.jLabel9.setHorizontalAlignment(2);
        this.jLabel9.setText("Use this file as template for new documents");
        this.jPanelGeneral.add(this.jLabel9);
        this.jLabel9.setBounds(10, 260, 282, 16);
        this.jTabbedPane1.addTab("General", this.jPanelGeneral);
        this.jPanelComper.setLayout(null);
        this.jPanel7.setLayout(null);
        this.jPanel7.setBorder(new TitledBorder(new EtchedBorder(), "Default compilation directory", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel7.setFont(new Font("Dialog", 0, 11));
        this.jPanel7.add(this.jTextFieldCompilationDir);
        this.jTextFieldCompilationDir.setBounds(10, 24, 282, 20);
        this.jButtonCompilationDir.setFont(new Font("Dialog", 0, 11));
        this.jButtonCompilationDir.setText("Browse");
        this.jButtonCompilationDir.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonCompilationDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonCompilationDirActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButtonCompilationDir);
        this.jButtonCompilationDir.setBounds(293, 24, 72, 20);
        this.jPanelComper.add(this.jPanel7);
        this.jPanel7.setBounds(8, 12, 374, 56);
        this.jCheckBoxAutosave.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxAutosave.setText("Autosave before compiling");
        this.jCheckBoxAutosave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxAutosaveActionPerformed(evt);
            }
        });
        this.jPanelComper.add(this.jCheckBoxAutosave);
        this.jCheckBoxAutosave.setBounds(10, 90, 372, 24);
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setText("Use the reports directory for compiles");
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(evt);
            }
        });
        this.jPanelComper.add(this.jCheckBoxUseCurrentFilesDirectoryForCompiles);
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setBounds(10, 70, 372, 24);
        this.jTabbedPane1.addTab("Compiler", this.jPanelComper);
        this.jPanelBackup.setLayout(null);
        this.jPanel6.setLayout(null);
        this.jPanel6.setBorder(new TitledBorder(new EtchedBorder(), "Backup files on save", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel6.setFont(new Font("Dialog", 0, 11));
        this.jPanel6.add(this.jTextFieldBackupDirectory);
        this.jTextFieldBackupDirectory.setBounds(10, 108, 282, 20);
        this.jButtonBackupDirectory.setFont(new Font("Dialog", 0, 11));
        this.jButtonBackupDirectory.setText("Browse");
        this.jButtonBackupDirectory.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBackupDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBackupDirectoryActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButtonBackupDirectory);
        this.jButtonBackupDirectory.setBounds(292, 108, 72, 20);
        this.jRadioButton1_NoBackup.setFont(new Font("Dialog", 0, 11));
        this.jRadioButton1_NoBackup.setText("No backup");
        this.buttonGroup1.add(this.jRadioButton1_NoBackup);
        this.jRadioButton1_NoBackup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton1_NoBackupActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jRadioButton1_NoBackup);
        this.jRadioButton1_NoBackup.setBounds(16, 24, 338, 23);
        this.jRadioButton2_ReplaceExtension.setFont(new Font("Dialog", 0, 11));
        this.jRadioButton2_ReplaceExtension.setText("Replace extension with .bak");
        this.buttonGroup1.add(this.jRadioButton2_ReplaceExtension);
        this.jRadioButton2_ReplaceExtension.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton2_ReplaceExtensionActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jRadioButton2_ReplaceExtension);
        this.jRadioButton2_ReplaceExtension.setBounds(16, 44, 338, 23);
        this.jRadioButton3_AppendExtension.setFont(new Font("Dialog", 0, 11));
        this.jRadioButton3_AppendExtension.setSelected(true);
        this.jRadioButton3_AppendExtension.setText("Append .bak to existing extension");
        this.buttonGroup1.add(this.jRadioButton3_AppendExtension);
        this.jRadioButton3_AppendExtension.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton3_AppendExtensionActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jRadioButton3_AppendExtension);
        this.jRadioButton3_AppendExtension.setBounds(16, 64, 338, 23);
        this.jLabel5.setFont(new Font("Dialog", 0, 11));
        this.jLabel5.setText("Default backup directory");
        this.jPanel6.add(this.jLabel5);
        this.jLabel5.setBounds(12, 92, 146, 15);
        this.jPanelBackup.add(this.jPanel6);
        this.jPanel6.setBounds(8, 12, 374, 142);
        this.jTabbedPane1.addTab("Backup", this.jPanelBackup);
        this.jPanelExternalPrograms.setLayout(null);
        this.jPanel4.setLayout(null);
        this.jPanel4.setBorder(new TitledBorder(new EtchedBorder(), "External editor", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel4.setFont(new Font("Dialog", 0, 11));
        this.jPanel4.add(this.jTextFieldEditor);
        this.jTextFieldEditor.setBounds(10, 24, 282, 20);
        this.jButtonBrowseEditor.setFont(new Font("Dialog", 0, 11));
        this.jButtonBrowseEditor.setText("Browse");
        this.jButtonBrowseEditor.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditorActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButtonBrowseEditor);
        this.jButtonBrowseEditor.setBounds(292, 24, 72, 20);
        this.jPanelExternalPrograms.add(this.jPanel4);
        this.jPanel4.setBounds(8, 12, 374, 56);
        this.jPanel5.setLayout(null);
        this.jPanel5.setBorder(new TitledBorder(new EtchedBorder(), "Viewers", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel5.setFont(new Font("Dialog", 0, 11));
        this.jPanel5.add(this.jTextFieldPDFViewer);
        this.jTextFieldPDFViewer.setBounds(10, 32, 282, 20);
        this.jButtonBrowseEditor1.setFont(new Font("Dialog", 0, 11));
        this.jButtonBrowseEditor1.setText("Browse");
        this.jButtonBrowseEditor1.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor1ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButtonBrowseEditor1);
        this.jButtonBrowseEditor1.setBounds(292, 32, 72, 20);
        this.jPanel5.add(this.jTextFieldHTMLViewer);
        this.jTextFieldHTMLViewer.setBounds(10, 68, 282, 20);
        this.jButtonBrowseEditor2.setFont(new Font("Dialog", 0, 11));
        this.jButtonBrowseEditor2.setText("Browse");
        this.jButtonBrowseEditor2.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor2ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButtonBrowseEditor2);
        this.jButtonBrowseEditor2.setBounds(292, 68, 72, 20);
        this.jPanel5.add(this.jTextFieldXLSViewer);
        this.jTextFieldXLSViewer.setBounds(10, 104, 282, 20);
        this.jButtonBrowseEditor3.setFont(new Font("Dialog", 0, 11));
        this.jButtonBrowseEditor3.setText("Browse");
        this.jButtonBrowseEditor3.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor3ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButtonBrowseEditor3);
        this.jButtonBrowseEditor3.setBounds(292, 104, 72, 20);
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("PDF viewer");
        this.jPanel5.add(this.jLabel1);
        this.jLabel1.setBounds(12, 16, 146, 15);
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setText("HTML viewer");
        this.jPanel5.add(this.jLabel2);
        this.jLabel2.setBounds(12, 52, 146, 15);
        this.jLabel3.setFont(new Font("Dialog", 0, 11));
        this.jLabel3.setText("XLS viewer");
        this.jPanel5.add(this.jLabel3);
        this.jLabel3.setBounds(12, 88, 146, 15);
        this.jLabel4.setFont(new Font("Dialog", 0, 11));
        this.jLabel4.setText("CSV viewer");
        this.jPanel5.add(this.jLabel4);
        this.jLabel4.setBounds(12, 126, 146, 15);
        this.jPanel5.add(this.jTextFieldCSVViewer);
        this.jTextFieldCSVViewer.setBounds(10, 142, 282, 20);
        this.jButtonBrowseEditor4.setFont(new Font("Dialog", 0, 11));
        this.jButtonBrowseEditor4.setText("Browse");
        this.jButtonBrowseEditor4.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor4ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButtonBrowseEditor4);
        this.jButtonBrowseEditor4.setBounds(292, 142, 72, 20);
        this.jPanelExternalPrograms.add(this.jPanel5);
        this.jPanel5.setBounds(8, 72, 374, 180);
        this.jTabbedPane1.addTab("External programs", this.jPanelExternalPrograms);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jPanel1.setLayout(null);
        this.jPanel1.setMinimumSize(new Dimension(10, 30));
        this.jPanel1.setPreferredSize(new Dimension(10, 30));
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.jButtonCancel.setBounds(322, 4, 65, 23);
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('s');
        this.jButtonOK.setText("Save");
        this.jButtonOK.setEnabled(false);
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonOK.setBounds(162, 4, 76, 23);
        this.jButtonApply.setFont(new Font("Dialog", 0, 11));
        this.jButtonApply.setMnemonic('a');
        this.jButtonApply.setText("Apply");
        this.jButtonApply.setEnabled(false);
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonApplyActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonApply);
        this.jButtonApply.setBounds(241, 4, 80, 23);
        this.getContentPane().add((Component)this.jPanel1, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 413) / 2, (screenSize.height - 412) / 2, 413, 412);
    }

    private void jComboBoxLookAndFeelItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jComboBoxLanguageItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected()) {
            this.disableCompileDirectoryBrowse();
        } else {
            this.enableCompileDirectoryBrowse();
        }
        this.enableApplyAndOk();
    }

    private void jCheckBoxUseMultiLineScriptsItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jButtonApply.isEnabled()) {
            this.jButtonApplyActionPerformed(evt);
        }
        if (this.mf != null) {
            this.mf.saveiReportConfiguration();
        }
        this.jButtonOK.setEnabled(false);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.applyConfiguration();
        this.jButtonApply.setEnabled(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonBrowseEditor4ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an CSV viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldCSVViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor3ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an XLS viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldXLSViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor2ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an HTML viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldHTMLViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor1ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an PDF viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldPDFViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditorActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an editor...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldEditor.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBackupDirectoryActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldBackupDirectory.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonCompilationDirActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldCompilationDir.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonTemplateActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.endsWith(".xml") || file.isDirectory();
            }

            public String getDescription() {
                return "JasperReports XML *.xml";
            }
        });
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldTemplate.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jRadioButton3_AppendExtensionActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jRadioButton2_ReplaceExtensionActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jRadioButton1_NoBackupActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxAutosaveActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jTextFieldTemplateInputMethodTextChanged(InputMethodEvent evt) {
        this.enableApplyAndOk();
    }

    private void jTextFieldTemplateActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jButtonBorderTextColorActionPerformed(ActionEvent evt) {
        JColorChooser jcc = new JColorChooser();
        Color c = JColorChooser.showDialog(null, "Select a color...", this.jButtonBorderTextColor.getBackground());
        if (c != null) {
            this.enableApplyAndOk();
            this.jButtonBorderTextColor.setBackground(c);
            this.jButtonBorderTextColor.updateUI();
        }
    }

    private void jCheckBoxViewBorderTextItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jNumberFieldGridSizeActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxViewRulesItemStateChanged(ItemEvent evt) {
        this.enableApplyAndOk();
    }

    private void jComboBoxDefaultRulesUnitActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jNumberFieldRecentFilesListLenghtActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxViewGridActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new OptionsDialog((Frame)new JFrame(), true).show();
    }

    public void applyConfiguration() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        Properties prop = this.mf.getProperties();
        try {
            prop.put("RecentFilesLength", "" + (int)this.jNumberFieldRecentFilesListLenght.getValue());
            prop.put("GridSize", "" + (int)this.jNumberFieldGridSize.getValue());
            prop.put("DefaultBackupDirectory", "" + this.jTextFieldBackupDirectory.getText());
            prop.put("ExternalCSVViewer", "" + this.jTextFieldCSVViewer.getText());
            prop.put("ExternalPDFViewer", "" + this.jTextFieldPDFViewer.getText());
            prop.put("ExternalXLSViewer", "" + this.jTextFieldXLSViewer.getText());
            prop.put("ExternalHTMLViewer", "" + this.jTextFieldHTMLViewer.getText());
            prop.put("ExternalEditor", "" + this.jTextFieldEditor.getText());
            prop.put("ViewRules", "" + this.jCheckBoxViewRules.isSelected());
            prop.put("ViewGrid", "" + this.jCheckBoxViewGrid.isSelected());
            prop.put("ViewBorderForTextElements", "" + this.jCheckBoxViewBorderText.isSelected());
            prop.put("ViewRules", "" + this.jCheckBoxViewRules.isSelected());
            prop.put("DefaultTemplate", "" + this.jTextFieldTemplate.getText());
            prop.put("SaveBeforeCompiling", "" + this.jCheckBoxAutosave.isSelected());
            prop.put("DefaultUnit", "" + this.jComboBoxDefaultRulesUnit.getSelectedItem() + "");
            prop.put("LookAndFeel", (String)this.jComboBoxLookAndFeel.getSelectedItem());
            this.mf.setUsingMultiLineExpressions(this.jCheckBoxUseMultiLineScripts.isSelected());
            this.mf.setUsingCurrentFilesDirectoryForCompiles(this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected());
            this.mf.setDefaultCompilationDirectory(this.jTextFieldCompilationDir.getText());
            String policy = "3";
            if (this.jRadioButton1_NoBackup.isSelected()) {
                policy = "1";
            }
            if (this.jRadioButton2_ReplaceExtension.isSelected()) {
                policy = "2";
            }
            if (this.jRadioButton3_AppendExtension.isSelected()) {
                policy = "3";
            }
            prop.put("BackupPolicy", policy);
            prop.put("ViewBorderColor", "" + this.jButtonBorderTextColor.getBackground().getRGB());
            LocaleAdapter adapter = (LocaleAdapter)this.jComboBoxLanguage.getSelectedItem();
            Locale selectedLang = adapter.getLocale();
            prop.put("Language", selectedLang.getLanguage());
            prop.put("Country", selectedLang.getCountry());
            I18n.setCurrentLocale(selectedLang);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jButtonApply.setEnabled(false);
    }

    protected void enableCompileDirectoryBrowse() {
        this.jTextFieldCompilationDir.setEnabled(true);
        this.jButtonCompilationDir.setEnabled(true);
    }

    protected void disableCompileDirectoryBrowse() {
        this.jTextFieldCompilationDir.setEnabled(false);
        this.jButtonCompilationDir.setEnabled(false);
    }

    protected void disableApplyAndOk() {
        this.jButtonApply.setEnabled(false);
        this.jButtonOK.setEnabled(false);
    }

    protected void disableApply() {
        this.jButtonOK.setEnabled(false);
    }

    protected void enableApplyAndOk() {
        this.jButtonApply.setEnabled(true);
        this.jButtonOK.setEnabled(true);
    }

    protected void enableApply() {
        this.jButtonOK.setEnabled(true);
    }

    class LocaleAdapter {
        Locale l;

        public LocaleAdapter(Locale locale) {
            this.l = locale;
        }

        public Locale getLocale() {
            return this.l;
        }

        public String toString() {
            if (this.l.getCountry() == null || this.l.getCountry().length() == 0) {
                return this.l.getDisplayLanguage();
            }
            return this.l.getDisplayLanguage() + " - " + this.l.getDisplayCountry();
        }
    }
}

