/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.barcode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;

public class Bc
extends JPanel {
    private final TBcData[] BcData = new TBcData[]{new TBcData("2_5_interleaved", true), new TBcData("2_5_industrial", true), new TBcData("2_5_matrix", true), new TBcData("Code39", false), new TBcData("Code39 Extended", false), new TBcData("Code128A", false), new TBcData("Code128B", false), new TBcData("Code128C", true), new TBcData("Code93", false), new TBcData("Code93 Extended", false), new TBcData("MSI", true), new TBcData("PostNet", true), new TBcData("Codebar", false), new TBcData("EAN8", true), new TBcData("EAN13", true), new TBcData("UPC_A", true), new TBcData("UPC_E0", true), new TBcData("UPC_E1", true), new TBcData("UPC Supp2", true), new TBcData("UPC Supp5", true), new TBcData("EAN128A", false), new TBcData("EAN128B", false), new TBcData("EAN128C", true)};
    private final String[] tabelle_EAN_A = new String[]{"2605", "1615", "1516", "0805", "0526", "0625", "0508", "0706", "0607", "2506"};
    private final String[] tabelle_EAN_C = new String[]{"7150", "6160", "6061", "5350", "5071", "5170", "5053", "5251", "5152", "7051"};
    private int FHeight = 50;
    private String FText = "12345678";
    private int FTop;
    private int FLeft;
    private int FModul = 2;
    private double FRatio = 2.0;
    private int FType = 13;
    private boolean FCheckSum = false;
    private int FShowText = 0;
    private double FAngle = 0.0;
    private Color FColor = Color.white;
    private Color FColorBar = Color.black;
    private int FCheckSumMethod = 1;
    private int[] modules = new int[4];
    private Font FShowTextFont = new Font("SansSerif", 0, 10);
    private TShowTextPosition FShowTextPosition;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JPanel jPanel1;

    public Bc() {
        this.initComponents();
    }

    private void oneBarProps(char code, int[] width, int[] lt) {
        try {
            switch (code) {
                case '0': {
                    width[0] = this.modules[0];
                    lt[0] = 0;
                    break;
                }
                case '1': {
                    width[0] = this.modules[1];
                    lt[0] = 0;
                    break;
                }
                case '2': {
                    width[0] = this.modules[2];
                    lt[0] = 0;
                    break;
                }
                case '3': {
                    width[0] = this.modules[3];
                    lt[0] = 0;
                    break;
                }
                case '5': {
                    width[0] = this.modules[0];
                    lt[0] = 1;
                    break;
                }
                case '6': {
                    width[0] = this.modules[1];
                    lt[0] = 1;
                    break;
                }
                case '7': {
                    width[0] = this.modules[2];
                    lt[0] = 1;
                    break;
                }
                case '8': {
                    width[0] = this.modules[3];
                    lt[0] = 1;
                    break;
                }
                case 'A': {
                    width[0] = this.modules[0];
                    lt[0] = 2;
                    break;
                }
                case 'B': {
                    width[0] = this.modules[1];
                    lt[0] = 2;
                    break;
                }
                case 'C': {
                    width[0] = this.modules[2];
                    lt[0] = 2;
                    break;
                }
                case 'D': {
                    width[0] = this.modules[3];
                    lt[0] = 2;
                    break;
                }
                default: {
                    throw new Exception("Internal error method Bc.oneBarProps");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Dimension getBarExtents() {
        bcUtil bcU = new bcUtil();
        double alpha = this.FAngle / 180.0 * Math.PI;
        Point orgin = bcU.translateQuad2D(alpha, new Point(this.FLeft, this.FTop), new Point(this.getWidth(), this.FHeight));
        Point a = new Point(0, 0);
        Point b = new Point(0, this.FHeight);
        Point c = new Point(this.getWidth() - 1, this.FHeight);
        Point d = new Point(this.getWidth() - 1, 0);
        a = bcU.translate2D(bcU.rotate2D(a, alpha), orgin);
        b = bcU.translate2D(bcU.rotate2D(b, alpha), orgin);
        c = bcU.translate2D(bcU.rotate2D(c, alpha), orgin);
        d = bcU.translate2D(bcU.rotate2D(d, alpha), orgin);
        int exX = 0;
        int exY = 0;
        if (a.x > exX) {
            exX = a.x;
        }
        if (b.x > exX) {
            exX = b.x;
        }
        if (c.x > exX) {
            exX = c.x;
        }
        if (d.x > exX) {
            exX = d.x;
        }
        if (a.y > exY) {
            exY = a.y;
        }
        if (b.y > exY) {
            exY = b.y;
        }
        if (c.y > exY) {
            exY = c.y;
        }
        if (d.y > exY) {
            exY = d.y;
        }
        return new Dimension(exX, exY);
    }

    private void doLines(String data, Graphics canvas) {
        bcUtil bcU = new bcUtil();
        int[] w = new int[1];
        int[] lt = new int[1];
        int xadd = 0;
        double alpha = this.FAngle / 180.0 * Math.PI;
        Point orgin = bcU.translateQuad2D(alpha, new Point(this.FLeft, this.FTop), new Point(this.getWidth(), this.FHeight));
        for (int i = 0; i < data.length(); ++i) {
            this.oneBarProps(data.charAt(i), w, lt);
            int width = w[0];
            if (lt[0] == 1 || lt[0] == 2) {
                canvas.setColor(this.FColorBar);
            } else {
                canvas.setColor(this.FColor);
            }
            int height = lt[0] == 2 ? this.FHeight * 2 / 5 : this.FHeight;
            Point a = new Point(xadd, 0);
            Point b = new Point(xadd, height);
            Point c = new Point(xadd + width - 1, height);
            Point d = new Point(xadd + width - 1, 0);
            a = bcU.translate2D(bcU.rotate2D(a, alpha), orgin);
            b = bcU.translate2D(bcU.rotate2D(b, alpha), orgin);
            c = bcU.translate2D(bcU.rotate2D(c, alpha), orgin);
            d = bcU.translate2D(bcU.rotate2D(d, alpha), orgin);
            Polygon p = new Polygon();
            p.addPoint(a.x, a.y);
            p.addPoint(b.x, b.y);
            p.addPoint(c.x, c.y);
            p.addPoint(d.x, d.y);
            canvas.drawPolygon(p);
            canvas.fillPolygon(p);
            xadd += width;
        }
    }

    private String setLen(int pI) {
        int l = pI - this.FText.length();
        StringBuffer s = new StringBuffer();
        while (s.length() < l) {
            s.append('0');
        }
        s.append(this.FText);
        return s.toString();
    }

    private String code_2_5_interleaved() {
        return null;
    }

    private String code_2_5_industrial() {
        return null;
    }

    private String code_2_5_matrix() {
        return null;
    }

    private String code_39() {
        return null;
    }

    private String code_39Extended() {
        return null;
    }

    private String code_128() {
        return null;
    }

    private String code_93() {
        return null;
    }

    private String code_93Extended() {
        return null;
    }

    private String code_MSI() {
        return null;
    }

    private String code_PostNet() {
        return null;
    }

    private String code_Codabar() {
        return null;
    }

    private String code_EAN8() throws Exception {
        int i;
        String tmp = this.FCheckSum ? this.doCheckSumming(this.setLen(7)) : this.setLen(8);
        if (tmp.length() != 8) {
            throw new Exception("Invalid Text len (EAN8)");
        }
        StringBuffer result = new StringBuffer("505");
        for (i = 0; i < 4; ++i) {
            result.append(this.tabelle_EAN_A[Integer.valueOf(tmp.substring(i, i + 1))]);
        }
        result.append("05050");
        for (i = 4; i < 8; ++i) {
            result.append(this.tabelle_EAN_C[Integer.valueOf(tmp.substring(i, i + 1))]);
        }
        result.append("505");
        return result.toString();
    }

    private String code_EAN13() {
        return null;
    }

    private String code_UPC_A() {
        return null;
    }

    private String code_UPC_E0() {
        return null;
    }

    private String code_UPC_E1() {
        return null;
    }

    private String code_Supp5() {
        return null;
    }

    private String code_Supp2() {
        return null;
    }

    public String getTypeText() {
        return this.BcData[this.FType].getName();
    }

    private void makeModules() {
        switch (this.FType) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (this.FRatio < 2.0) {
                    this.FRatio = 2.0;
                }
                if (!(this.FRatio > 3.0)) break;
                this.FRatio = 3.0;
                break;
            }
            case 2: {
                if (this.FRatio < 2.25) {
                    this.FRatio = 2.25;
                }
                if (!(this.FRatio > 3.0)) break;
                this.FRatio = 3.0;
            }
        }
        this.modules[0] = this.FModul;
        this.modules[1] = this.FModul * new Double(this.FRatio).intValue();
        this.modules[2] = this.modules[1] * 3 / 2;
        this.modules[3] = this.modules[1] * 2;
    }

    public int getWidth() {
        int res = 0;
        int[] w = new int[]{0};
        int[] lt = new int[1];
        try {
            String data = this.makeData();
            for (int i = 0; i < data.length(); ++i) {
                this.oneBarProps(data.charAt(i), w, lt);
                res += w[0];
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setWidth(int Value) {
        int wtotal = 0;
        int[] w = new int[]{0};
        int[] lt = new int[1];
        try {
            String data = this.makeData();
            for (int i = 1; i < data.length(); ++i) {
                this.oneBarProps(data.charAt(i), w, lt);
                wtotal += w[0];
            }
            if (wtotal > 0) {
                this.setModul(this.FModul * Value / wtotal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String doCheckSumming(String data) {
        switch (this.FCheckSumMethod) {
            case 0: {
                return data;
            }
            case 1: {
                return this.checkSumModulo10(data);
            }
        }
        return null;
    }

    private String checkSumModulo10(String data) {
        int sum = 0;
        int fak = data.length();
        byte[] bData = data.getBytes();
        for (int i = 0; i < data.length(); ++i) {
            sum = fak % 2 == 0 ? (sum += bData[i] * 1) : (sum += bData[i] * 3);
            --fak;
        }
        if (sum % 10 == 0) {
            return data + "0";
        }
        return data + (10 - sum % 10);
    }

    public void setType(int Value) {
        if (Value != this.FType) {
            int oldTyp = Value;
            this.FType = Value;
            this.propertyChangeSupport.firePropertyChange("setTyp", new Integer(oldTyp), new Integer(this.FType));
        }
    }

    public void setAngle(double Value) {
        if (Value != this.FAngle) {
            double oldAngle = Value;
            this.FAngle = Value;
            this.propertyChangeSupport.firePropertyChange("setAngle", new Double(oldAngle), new Double(this.FAngle));
        }
    }

    public void setText(String Value) {
        if (Value != this.FText) {
            String oldText = Value;
            this.FText = Value;
            this.propertyChangeSupport.firePropertyChange("setText", new String(oldText), new String(this.FText));
        }
    }

    private void setShowText(TBarcodeOption Value) {
    }

    private void setTop(int Value) {
    }

    private void setLeft(int Value) {
    }

    public void setCheckSum(boolean Value) {
        if (Value != this.FCheckSum) {
            boolean oldCheckSum = Value;
            this.FCheckSum = Value;
            this.propertyChangeSupport.firePropertyChange("setCheckSum", new Boolean(oldCheckSum), new Boolean(this.FCheckSum));
        }
    }

    private void setShowTextFont(Font Value) {
    }

    public void paint(Graphics g) {
        try {
            Dimension s = this.getSize();
            Dimension p = this.getBarExtents();
            if (p.height != s.height || p.width != s.width) {
                this.setSize(p.width, p.height);
            }
            this.drawBarcode(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setShowTextPosition(TShowTextPosition Value) {
    }

    protected String makeData() throws Exception {
        this.makeModules();
        if (this.BcData[this.FType].num) {
            this.FText = this.FText.trim();
            for (int i = 0; i < this.FText.length(); ++i) {
                if (this.FText.charAt(i) <= '9' && this.FText.charAt(i) >= '0') continue;
                throw new Exception("Barcode have to be numeric");
            }
        }
        switch (this.FType) {
            case 0: {
                return this.code_2_5_interleaved();
            }
            case 1: {
                return this.code_2_5_industrial();
            }
            case 2: {
                return this.code_2_5_matrix();
            }
            case 3: {
                return this.code_39();
            }
            case 4: {
                return this.code_39Extended();
            }
            case 5: {
                return this.code_128();
            }
            case 6: {
                return this.code_128();
            }
            case 7: {
                return this.code_128();
            }
            case 20: {
                return this.code_128();
            }
            case 21: {
                return this.code_128();
            }
            case 22: {
                return this.code_128();
            }
            case 8: {
                return this.code_93();
            }
            case 9: {
                return this.code_93Extended();
            }
            case 10: {
                return this.code_MSI();
            }
            case 11: {
                return this.code_PostNet();
            }
            case 12: {
                return this.code_Codabar();
            }
            case 13: {
                return this.code_EAN8();
            }
            case 14: {
                return this.code_EAN13();
            }
            case 15: {
                return this.code_UPC_A();
            }
            case 16: {
                return this.code_UPC_E0();
            }
            case 17: {
                return this.code_UPC_E1();
            }
            case 18: {
                return this.code_Supp2();
            }
            case 19: {
                return this.code_Supp5();
            }
        }
        throw new Exception("Wrong Barcode type");
    }

    public void drawBarcode(Graphics canvas) throws Exception {
        String data = this.makeData();
        Font saveFon = canvas.getFont();
        Color saveColor = canvas.getColor();
        this.doLines(data, canvas);
        if (this.FShowText != 0) {
            this.drawText(canvas);
        }
        canvas.setColor(saveColor);
        canvas.setFont(saveFon);
    }

    public void drawText(Graphics canvas) {
    }

    public String getText() {
        return this.FText;
    }

    public int getTop() {
        return this.FTop;
    }

    public int getLeft() {
        return this.FLeft;
    }

    public double getRatio() {
        return this.FRatio;
    }

    public int getType() {
        return this.FType;
    }

    public boolean isCheckSum() {
        return this.FCheckSum;
    }

    public int getCheckSumMethod() {
        return this.FCheckSumMethod;
    }

    public void setCheckSumMethod(int Value) {
        if (this.FCheckSumMethod != Value) {
            int oldCheckSumMethod = this.FCheckSumMethod;
            this.FCheckSumMethod = Value;
            this.propertyChangeSupport.firePropertyChange("FCheckSumMethod", new Integer(oldCheckSumMethod), new Integer(this.FCheckSumMethod));
        }
    }

    public double getAngle() {
        return this.FAngle;
    }

    public int getShowText() {
        return this.FShowText;
    }

    public Font getShowTextFont() {
        return this.FShowTextFont;
    }

    public TShowTextPosition getShowTextPosition() {
        return this.FShowTextPosition;
    }

    public Color getColor() {
        return this.FColor;
    }

    public void setColor(Color color) throws PropertyVetoException {
        this.FColor = color;
    }

    public Color getColorBar() {
        return this.FColorBar;
    }

    public void setColorBar(Color colorBar) {
        this.FColorBar = colorBar;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setModul(int v) {
        if (v >= 1 && v < 50) {
            int oldModul = this.FModul;
            this.FModul = v;
            this.propertyChangeSupport.firePropertyChange("FModul", new Integer(oldModul), new Integer(this.FModul));
        }
    }

    public void setRatio(double Value) {
        if (this.FRatio != Value) {
            double oldRatio = this.FRatio;
            this.FRatio = Value;
            this.propertyChangeSupport.firePropertyChange("FRatio", new Double(oldRatio), new Double(this.FRatio));
        }
    }

    public void setHeightBar(int Value) {
        if (this.FHeight != Value) {
            int oldHeight = this.FHeight;
            this.FHeight = Value;
            this.propertyChangeSupport.firePropertyChange("FHeight", new Integer(oldHeight), new Integer(this.FHeight));
        }
    }

    public int getModul() {
        return this.FModul;
    }

    public int getHeightBar() {
        return this.FHeight;
    }

    public void setShowText(int Value) {
        if (this.FShowText != Value) {
            int oldShowText = this.FShowText;
            this.FShowText = Value;
            this.propertyChangeSupport.firePropertyChange("FShowText", new Integer(oldShowText), new Integer(this.FShowText));
        }
    }

    public Dimension getMinimumSize() {
        return this.getBarExtents();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public String getName() {
        return "Barcode";
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(null);
        this.add((Component)this.jPanel1, "Center");
    }

    public class bcUtil {
        public String convert(String s) {
            byte[] b = s.getBytes();
            for (int i = 0; i < s.length(); ++i) {
                int v = b[i] - 1;
                if (i % 2 == 0) {
                    v += 5;
                }
                b[i] = new Integer(v).byteValue();
            }
            return new String(b);
        }

        public int quersumme(int x) {
            int sum = 0;
            while (x > 0) {
                sum += x % 10;
                x /= 10;
            }
            return sum;
        }

        public Point rotate2D(Point p, double alpha) {
            double sinus = Math.sin(alpha);
            double cosinus = Math.cos(alpha);
            int x = new Long(Math.round((double)p.x * cosinus + (double)p.y * sinus)).intValue();
            int y = new Long(Math.round((double)p.y * cosinus - (double)p.x * sinus)).intValue();
            return new Point(x, y);
        }

        public Point translate2D(Point a, Point b) {
            return new Point(a.x + b.x, a.y + b.y);
        }

        public Point translateQuad2D(double alpha, Point orgin, Point point) {
            Point moveby = new Point();
            double alphasin = Math.sin(alpha);
            double alphacos = Math.cos(alpha);
            if (alphasin >= 0.0) {
                if (alphacos >= 0.0) {
                    moveby.x = 0;
                    moveby.y = new Double(alphasin * (double)point.x).intValue();
                } else {
                    moveby.x = -new Double(alphacos * (double)point.x).intValue();
                    moveby.y = new Double(alphasin * (double)point.x - alphacos * (double)point.y).intValue();
                }
            } else if (alphacos >= 0.0) {
                moveby.x = -new Double(alphasin * (double)point.y).intValue();
                moveby.y = 0;
            } else {
                moveby.x = -new Double(alphacos * (double)point.x - alphasin * (double)point.y).intValue();
                moveby.y = -new Double(alphacos * (double)point.y).intValue();
            }
            return this.translate2D(orgin, moveby);
        }
    }

    private class TBcData {
        private String name;
        private boolean num;

        public TBcData(String name, boolean num) {
            this.name = name;
            this.num = num;
        }

        public String getName() {
            return this.name;
        }

        public boolean getNum() {
            return this.num;
        }
    }

    public class TCheckSumMethod {
        public static final int csmNone = 0;
        public static final int csmModulo10 = 1;
    }

    public class TShowTextPosition {
        public static final int stpTopLeft = 0;
        public static final int stpTopRight = 1;
        public static final int stpTopCenter = 2;
        public static final int stpBottomLeft = 3;
        public static final int stpBottomRight = 4;
        public static final int stpBottomCenter = 5;
    }

    public class TBarcodeOption {
        public static final int bcoNone = 0;
        public static final int bcoCode = 1;
        public static final int bcoTyp = 2;
        public static final int bcoBoth = 3;
    }

    public class TBarLineType {
        public static final int white = 0;
        public static final int black = 1;
        public static final int black_half = 2;
    }

    public class TBarcodeType {
        public static final int bcCode_2_5_interleaved = 0;
        public static final int bcCode_2_5_industrial = 1;
        public static final int bcCode_2_5_matrix = 2;
        public static final int bcCode39 = 3;
        public static final int bcCode39Extended = 4;
        public static final int bcCode128A = 5;
        public static final int bcCode128B = 6;
        public static final int bcCode128C = 7;
        public static final int bcCode93 = 8;
        public static final int bcCode93Extended = 9;
        public static final int bcCodeMSI = 10;
        public static final int bcCodePostNet = 11;
        public static final int bcCodeCodabar = 12;
        public static final int bcCodeEAN8 = 13;
        public static final int bcCodeEAN13 = 14;
        public static final int bcCodeUPC_A = 15;
        public static final int bcCodeUPC_E0 = 16;
        public static final int bcCodeUPC_E1 = 17;
        public static final int bcCodeUPC_Supp2 = 18;
        public static final int bcCodeUPC_Supp5 = 19;
        public static final int bcCodeEAN128A = 20;
        public static final int bcCodeEAN128B = 21;
        public static final int bcCodeEAN128C = 22;
    }
}

