/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.util.Java2DUtil;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class TextReportElement
extends ReportElement {
    private String text = "";
    private String reportFont = "";
    private String fontName = "";
    private String PDFFontName = "";
    private int fontSize = 10;
    private String TTFFont = "";
    private boolean bold = false;
    private boolean underline = false;
    private boolean italic = false;
    private boolean strikeTrought = false;
    private String lineSpacing = "";
    private String align = "";
    private String verticalAlign = "";
    private boolean pdfEmbedded = false;
    private String pdfEncoding = "";
    private Font font = null;

    public TextReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.bgcolor = Color.WHITE;
        this.fgcolor = Color.BLACK;
        this.font = new Font("Arial", 0, 12);
        this.text = "Staic text\nsecond line";
        this.verticalAlign = "Top";
        this.align = "Left";
        this.fontSize = 12;
        this.fontName = "SansSerif";
        this.PDFFontName = "Helvetica";
        this.pdfEncoding = "Cp1252";
        this.pdfEmbedded = false;
        this.lineSpacing = "Single";
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        this.zoom_factor = zoom_factor;
        g.setColor(this.bgcolor);
        if (!this.getTransparent().equalsIgnoreCase("Transparent")) {
            g.fillRect(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        }
        g.setColor(this.fgcolor);
        if (this.font == null) {
            int style = 0;
            if (this.isBold()) {
                style |= 1;
            }
            if (this.isItalic()) {
                style |= 2;
            }
            if (style == 0) {
                style = 0;
            }
            this.font = new Font(this.getFontName(), style, this.getZoomedDim(this.getFontSize()));
        }
        Java2DUtil.setClip(g, this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        if (this.getText() != null && this.getText().length() > 0) {
            int zoomedFieldHeight = this.getZoomedDim(this.height);
            String allText = Misc.treatNewLineChars(this.getText());
            float formatWidth = this.getZoomedDim(this.width);
            float verticalOffset = 0.0f;
            FontRenderContext fontRenderContext = g.getFontRenderContext();
            Map<TextAttribute, ?> fontAttributes = this.font.getAttributes();
            fontAttributes.put(TextAttribute.SIZE, new Float(this.getZoomedDim(this.getFontSize())));
            fontAttributes.put(TextAttribute.FAMILY, this.getFontName());
            if (this.isBold()) {
                fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (this.isItalic()) {
                fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (this.isUnderline()) {
                fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.isStrikeTrought()) {
                fontAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            float lineSpacing = 1.0f;
            if (this.getLineSpacing().equals("Single")) {
                lineSpacing = 1.0f;
            } else if (this.getLineSpacing().equals("1_1_2")) {
                lineSpacing = 1.5f;
            } else if (this.getLineSpacing().equals("Double")) {
                lineSpacing = 2.0f;
            }
            TextLayout layout = null;
            String paragr_text = "";
            boolean isMaxHeightReached = false;
            StringTokenizer tkzer = new StringTokenizer(allText, "\n");
            float drawPosY = 0.0f;
            float drawPosX = 0.0f;
            paragr_text = "";
            isMaxHeightReached = false;
            tkzer = new StringTokenizer(allText, "\n");
            ArrayList<TextReportElementLayout> textLayouts = new ArrayList<TextReportElementLayout>();
            while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
                paragr_text = tkzer.nextToken();
                AttributedString atext = new AttributedString(paragr_text, fontAttributes);
                AttributedCharacterIterator paragraph = atext.getIterator();
                int paragraphStart = paragraph.getBeginIndex();
                int paragraphEnd = paragraph.getEndIndex();
                LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
                lineMeasurer.setPosition(paragraphStart);
                layout = null;
                while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                    layout = lineMeasurer.nextLayout(formatWidth);
                    if ((drawPosY += layout.getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)(zoomedFieldHeight + 1)) {
                        if (this.getAlign().equals("Justify")) {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                            if (lineMeasurer.getPosition() < paragraphEnd) {
                                layout = layout.getJustifiedLayout(formatWidth);
                            }
                        } else {
                            drawPosX = this.getAlign().equals("Right") ? (layout.isLeftToRight() ? formatWidth - layout.getAdvance() : formatWidth) : (this.getAlign().equals("Center") ? (formatWidth - layout.getAdvance()) / 2.0f : (layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance()));
                        }
                        float x = drawPosX + (float)this.getZoomedDim(this.position.x) - (float)x_shift_origin;
                        float y = drawPosY + (float)this.getZoomedDim(this.position.y) - (float)y_shift_origin;
                        TextReportElementLayout textReportElementLayout = new TextReportElementLayout(layout, x, y);
                        textLayouts.add(textReportElementLayout);
                        drawPosY += layout.getDescent();
                        continue;
                    }
                    drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                    isMaxHeightReached = true;
                }
            }
            float textHeight = drawPosY;
            if (this.getVerticalAlign().equals("Top")) {
                verticalOffset = 0.0f;
            } else if (this.getVerticalAlign().equals("Middle")) {
                verticalOffset = ((float)zoomedFieldHeight - textHeight) / 2.0f;
            } else if (this.getVerticalAlign().equals("Bottom")) {
                verticalOffset = (float)zoomedFieldHeight - textHeight;
            }
            Iterator i = textLayouts.iterator();
            while (i.hasNext()) {
                ((TextReportElementLayout)i.next()).drawWithOffset(g, verticalOffset);
            }
        }
        Java2DUtil.resetClip(g);
        this.position.x += 10;
        this.position.y += 10;
        this.drawBorder(g, zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public String getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(String lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public boolean isPdfEmbedded() {
        return this.pdfEmbedded;
    }

    public void setPdfEmbedded(boolean pdfEmbedded) {
        this.pdfEmbedded = pdfEmbedded;
    }

    public String getPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    public String getPDFFontName() {
        return this.PDFFontName;
    }

    public void setPDFFontName(String PDFFontName) {
        this.PDFFontName = PDFFontName;
    }

    public String getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(String reportFont) {
        this.reportFont = reportFont;
    }

    public boolean isStrikeTrought() {
        return this.strikeTrought;
    }

    public void setStrikeTrought(boolean strikeTrought) {
        this.strikeTrought = strikeTrought;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTTFFont() {
        return this.TTFFont;
    }

    public void setTTFFont(String TTFFont) {
        this.TTFFont = TTFFont;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public String getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(String verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public int getTextHeight(FontMetrics fm) {
        return fm.getAscent() + (this.getLineCount() - 1) * fm.getHeight();
    }

    public int getLineCount() {
        String text = this.getText();
        text = text.replace('\r', ' ');
        int line = 1;
        while (text.indexOf(10) > 0) {
            ++line;
            text = text.substring(text.indexOf(10) + 1);
        }
        return line;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof TextReportElement && source instanceof TextReportElement) {
            ((TextReportElement)destination).setAlign(new String(((TextReportElement)source).getAlign()));
            ((TextReportElement)destination).setReportFont(((TextReportElement)source).getReportFont());
            ((TextReportElement)destination).setFontName(new String(((TextReportElement)source).getFontName()));
            ((TextReportElement)destination).setPDFFontName(new String(((TextReportElement)source).getPDFFontName()));
            ((TextReportElement)destination).setFontSize(((TextReportElement)source).getFontSize());
            ((TextReportElement)destination).setTTFFont(new String(((TextReportElement)source).getTTFFont()));
            ((TextReportElement)destination).setBold(((TextReportElement)source).isBold());
            ((TextReportElement)destination).setItalic(((TextReportElement)source).isItalic());
            ((TextReportElement)destination).setUnderline(((TextReportElement)source).isUnderline());
            ((TextReportElement)destination).setStrikeTrought(((TextReportElement)source).isStrikeTrought());
            ((TextReportElement)destination).setLineSpacing(new String(((TextReportElement)source).getLineSpacing()));
            ((TextReportElement)destination).setVerticalAlign(new String(((TextReportElement)source).getVerticalAlign()));
            ((TextReportElement)destination).setPdfEmbedded(((TextReportElement)source).isPdfEmbedded());
            ((TextReportElement)destination).setPdfEncoding(new String(((TextReportElement)source).getPdfEncoding()));
            ((TextReportElement)destination).setText(new String(((TextReportElement)source).getText()));
        }
    }

    private class TextReportElementLayout {
        private TextLayout layout;
        private float x;
        private float y;

        private TextReportElementLayout(TextLayout layout, float x, float y) {
            this.layout = layout;
            this.x = x;
            this.y = y;
        }

        void drawWithOffset(Graphics2D g2, float yOffset) {
            this.layout.draw(g2, this.x, this.y + yOffset);
        }
    }
}

