/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser.coretypes;

import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.parser.AbstractXmlReadHandler;
import org.jfree.xml.parser.RootXmlReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.jfree.xml.parser.coretypes.ObjectRefHandler;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.PropertyDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GenericReadHandler
extends AbstractXmlReadHandler {
    private Object object;
    private GenericObjectFactory objectFactory;
    private ArrayList objectRefHandlers;
    private HashMap createdHandler = new HashMap();

    public GenericReadHandler(GenericObjectFactory factory) {
        this.objectRefHandlers = new ArrayList();
        this.objectFactory = factory;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        try {
            AttributeDefinition[] attribs = this.objectFactory.getAttributeDefinitions();
            for (int i = 0; i < attribs.length; ++i) {
                AttributeDefinition attrDef = attribs[i];
                String value = attrs.getValue(attrDef.getAttributeName());
                if (value == null) continue;
                Object o = attrDef.getHandler().toPropertyValue(value);
                this.objectFactory.setProperty(attrDef.getPropertyName(), o);
            }
        }
        catch (ObjectDescriptionException ode) {
            throw new SAXException(ode);
        }
    }

    protected XmlReadHandler getHandlerForChild(String tagName, Attributes atts) throws SAXException {
        try {
            if (tagName.equals("objectRef")) {
                ObjectRefHandler handler = new ObjectRefHandler();
                this.objectRefHandlers.add(handler);
                return handler;
            }
            XmlReadHandler handler = this.rootHandler.createHandler(this.objectFactory.getTypeForTagName(tagName), tagName, atts);
            if (handler != null) {
                this.createdHandler.put(tagName, handler);
            }
            return handler;
        }
        catch (ObjectDescriptionException ode) {
            Log.debug("Failed to get handler for child: ", ode);
            throw new SAXException(ode);
        }
    }

    public Object getObject() throws XmlReaderException {
        if (this.object != null) {
            return this.object;
        }
        RootXmlReadHandler rootHandler = this.getRootHandler();
        try {
            for (int i = 0; i < this.objectRefHandlers.size(); ++i) {
                ObjectRefHandler handler = (ObjectRefHandler)this.objectRefHandlers.get(i);
                this.objectFactory.setProperty(handler.getPropertyName(), handler.getObject());
            }
            ArrayList<String> lookups = new ArrayList<String>();
            LookupDefinition[] lookupDefs = this.objectFactory.getLookupDefinitions();
            for (int i = 0; i < lookupDefs.length; ++i) {
                LookupDefinition ldef = lookupDefs[i];
                lookups.add(ldef.getPropertyName());
                Log.debug("lookup object: " + ldef.getPropertyName());
                Object value = rootHandler.getObject(ldef.getRegistryKey());
                if (value == null) {
                    Log.warn("Failed to lookup object: " + value);
                    continue;
                }
                this.objectFactory.setProperty(ldef.getPropertyName(), value);
            }
            ConstructorDefinition[] conDefs = this.objectFactory.getConstructorDefinitions();
            for (int i = 0; i < conDefs.length; ++i) {
                PropertyDefinition pd;
                XmlReadHandler handler;
                ConstructorDefinition cDef = conDefs[i];
                if (lookups.contains(cDef.getPropertyName()) || !this.objectFactory.isPropertyDefinition(cDef.getPropertyName()) || (handler = (XmlReadHandler)this.createdHandler.get((pd = this.objectFactory.getPropertyDefinitionByPropertyName(cDef.getPropertyName())).getElementName())) == null) continue;
                this.objectFactory.setProperty(pd.getPropertyName(), handler.getObject());
            }
            this.object = this.objectFactory.createObject();
            Object oldValue = null;
            if (this.objectFactory.getRegisterName() != null) {
                oldValue = rootHandler.getObject(this.objectFactory.getRegisterName());
                rootHandler.putObject(this.objectFactory.getRegisterName(), this.object);
            }
            PropertyDefinition[] propertyDefs = this.objectFactory.getPropertyDefinitions();
            for (int i = 0; i < propertyDefs.length; ++i) {
                PropertyDefinition pdef = propertyDefs[i];
                XmlReadHandler handler = (XmlReadHandler)this.createdHandler.get(pdef.getElementName());
                if (handler == null) continue;
                this.objectFactory.setProperty(pdef.getPropertyName(), handler.getObject());
            }
            this.objectFactory.writeObjectProperties(this.object);
            if (this.objectFactory.getRegisterName() != null) {
                rootHandler.putObject(this.objectFactory.getRegisterName(), oldValue);
            }
        }
        catch (ObjectDescriptionException ode) {
            Log.error("Unable to create object.", ode);
            throw new XmlReaderException("Unable to create object.", ode);
        }
        return this.object;
    }
}

