/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.threads;

import java.util.Enumeration;
import java.util.Vector;
import org.jfree.threads.ReaderWriterNode;

public class ReaderWriterLock {
    private Vector waiters = new Vector();

    public synchronized void lockRead() {
        ReaderWriterNode node;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            node = new ReaderWriterNode(me, 0);
            this.waiters.addElement(node);
        } else {
            node = (ReaderWriterNode)this.waiters.elementAt(index);
        }
        while (this.getIndex(me) > this.firstWriter()) {
            try {
                this.wait();
            }
            catch (Exception e) {
                System.err.println("ReaderWriterLock.lockRead(): exception.");
                System.err.print(e.getMessage());
            }
        }
        ++node.nAcquires;
    }

    public synchronized void lockWrite() {
        ReaderWriterNode node;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            node = new ReaderWriterNode(me, 1);
            this.waiters.addElement(node);
        } else {
            node = (ReaderWriterNode)this.waiters.elementAt(index);
            if (node.state == 0) {
                throw new IllegalArgumentException("Upgrade lock");
            }
            node.state = 1;
        }
        while (this.getIndex(me) != 0) {
            try {
                this.wait();
            }
            catch (Exception e) {
                System.err.println("ReaderWriterLock.lockWrite(): exception.");
                System.err.print(e.getMessage());
            }
        }
        ++node.nAcquires;
    }

    public synchronized void unlock() {
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index > this.firstWriter()) {
            throw new IllegalArgumentException("Lock not held");
        }
        ReaderWriterNode node = (ReaderWriterNode)this.waiters.elementAt(index);
        --node.nAcquires;
        if (node.nAcquires == 0) {
            this.waiters.removeElementAt(index);
        }
        this.notifyAll();
    }

    private int firstWriter() {
        int index = 0;
        Enumeration e = this.waiters.elements();
        while (e.hasMoreElements()) {
            ReaderWriterNode node = (ReaderWriterNode)e.nextElement();
            if (node.state == 1) {
                return index;
            }
            ++index;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread t) {
        int index = 0;
        Enumeration e = this.waiters.elements();
        while (e.hasMoreElements()) {
            ReaderWriterNode node = (ReaderWriterNode)e.nextElement();
            if (node.t == t) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

