/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Arrays;
import java.util.Date;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.HighLowDataset;
import org.jfree.data.OHLCDataItem;

public class OHLCDataset
extends AbstractSeriesDataset
implements HighLowDataset {
    private String name;
    private OHLCDataItem[] data;

    public OHLCDataset(String name, OHLCDataItem[] data) {
        this.name = name;
        this.data = data;
    }

    public String getSeriesName(int series) {
        return this.name;
    }

    public Number getXValue(int series, int item) {
        return new Long(this.data[item].getDate().getTime());
    }

    public Date getXDate(int series, int item) {
        return this.data[item].getDate();
    }

    public Number getYValue(int series, int item) {
        return this.getCloseValue(series, item);
    }

    public Number getHighValue(int series, int item) {
        return this.data[item].getHigh();
    }

    public Number getLowValue(int series, int item) {
        return this.data[item].getLow();
    }

    public Number getOpenValue(int series, int item) {
        return this.data[item].getOpen();
    }

    public Number getCloseValue(int series, int item) {
        return this.data[item].getClose();
    }

    public Number getVolumeValue(int series, int item) {
        return this.data[item].getVolume();
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int series) {
        return this.data.length;
    }

    public void sortDataByDate() {
        Arrays.sort(this.data);
    }
}

