/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Spacer;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public class CategoryPlot
extends Plot
implements ValueAxisPlot,
RendererChangeListener,
Cloneable,
PublicCloneable,
Serializable {
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private Spacer axisOffset;
    private CategoryAxis domainAxis;
    private AxisLocation domainAxisLocation;
    private ObjectList secondaryDomainAxes;
    private ObjectList secondaryDomainAxisLocations;
    private boolean drawSharedDomainAxis;
    private ValueAxis rangeAxis;
    private AxisLocation rangeAxisLocation;
    private ObjectList secondaryRangeAxes;
    private ObjectList secondaryRangeAxisLocations;
    private CategoryDataset dataset;
    private ObjectList secondaryDatasets;
    private ObjectList secondaryDatasetDomainAxisMap;
    private ObjectList secondaryDatasetRangeAxisMap;
    private CategoryItemRenderer renderer;
    private ObjectList secondaryRenderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.STANDARD;
    private SortOrder columnRenderingOrder = SortOrder.ASCENDING;
    private SortOrder rowRenderingOrder = SortOrder.ASCENDING;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private double anchorValue;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private transient List foregroundRangeMarkers;
    private transient List backgroundRangeMarkers;
    private transient Map secondaryForegroundRangeMarkers;
    private transient Map secondaryBackgroundRangeMarkers;
    private transient List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset dataset, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.secondaryDomainAxes = new ObjectList();
        this.secondaryDomainAxisLocations = new ObjectList();
        this.secondaryRangeAxes = new ObjectList();
        this.secondaryRangeAxisLocations = new ObjectList();
        this.secondaryDatasets = new ObjectList();
        this.secondaryDatasetDomainAxisMap = new ObjectList();
        this.secondaryDatasetRangeAxisMap = new ObjectList();
        this.secondaryRenderers = new ObjectList();
        this.dataset = dataset;
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        this.axisOffset = new Spacer(1, 0.0, 0.0, 0.0, 0.0);
        this.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT, false);
        this.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        this.renderer = renderer;
        if (renderer != null) {
            renderer.setPlot(this);
        }
        this.domainAxis = domainAxis;
        if (domainAxis != null) {
            domainAxis.setPlot(this);
            domainAxis.addChangeListener(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxis = rangeAxis;
        if (rangeAxis != null) {
            rangeAxis.setPlot(this);
            rangeAxis.addChangeListener(this);
        }
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.foregroundRangeMarkers = new ArrayList();
        this.backgroundRangeMarkers = new ArrayList();
        this.secondaryForegroundRangeMarkers = new HashMap();
        this.secondaryBackgroundRangeMarkers = new HashMap();
        ValueMarker baseline = new ValueMarker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), new BasicStroke(1.0f), 0.6f);
        this.addRangeMarker(baseline, Layer.BACKGROUND);
        this.anchorValue = 0.0;
    }

    public String getPlotType() {
        return localizationResources.getString("Category_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        this.orientation = orientation;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Spacer getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(Spacer offset) {
        this.axisOffset = offset;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryAxis getDomainAxis() {
        Plot parent;
        CategoryAxis result = this.domainAxis;
        if (result == null && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot p = (CategoryPlot)parent;
            result = p.getDomainAxis();
        }
        return result;
    }

    public void setDomainAxis(CategoryAxis axis) {
        if (axis != null) {
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        if (this.domainAxis != null) {
            this.domainAxis.removeChangeListener(this);
        }
        this.domainAxis = axis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getDomainAxisLocation() {
        return this.domainAxisLocation;
    }

    public void setDomainAxisLocation(AxisLocation location) {
        this.setDomainAxisLocation(location, true);
    }

    public void setDomainAxisLocation(AxisLocation location, boolean notify) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (location != this.domainAxisLocation) {
            this.domainAxisLocation = location;
            if (notify) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.domainAxisLocation, this.orientation);
    }

    public CategoryAxis getSecondaryDomainAxis(int index) {
        Plot parent;
        CategoryAxis result = null;
        if (index < this.secondaryDomainAxes.size()) {
            result = (CategoryAxis)this.secondaryDomainAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot cp = (CategoryPlot)parent;
            result = cp.getSecondaryDomainAxis(index);
        }
        return result;
    }

    public void setSecondaryDomainAxis(int index, CategoryAxis axis) {
        CategoryAxis existing = this.getSecondaryDomainAxis(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        if (axis != null) {
            axis.setPlot(this);
        }
        this.secondaryDomainAxes.set(index, (Object)axis);
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryDomainAxes() {
        for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            CategoryAxis axis = (CategoryAxis)this.secondaryDomainAxes.get(i);
            if (axis == null) continue;
            axis.removeChangeListener(this);
        }
        this.secondaryDomainAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryDomainAxes() {
        for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            CategoryAxis axis = (CategoryAxis)this.secondaryDomainAxes.get(i);
            if (axis == null) continue;
            axis.configure();
        }
    }

    public AxisLocation getSecondaryDomainAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.secondaryDomainAxisLocations.size()) {
            result = (AxisLocation)this.secondaryDomainAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.domainAxisLocation);
        }
        return result;
    }

    public void setSecondaryDomainAxisLocation(int index, AxisLocation location) {
        this.secondaryDomainAxisLocations.set(index, (Object)location);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryDomainAxisEdge(int index) {
        AxisLocation location = this.getSecondaryDomainAxisLocation(index);
        RectangleEdge result = Plot.resolveDomainAxisLocation(location, this.orientation);
        if (result == null) {
            result = RectangleEdge.opposite((RectangleEdge)this.getDomainAxisEdge());
        }
        return result;
    }

    public ValueAxis getRangeAxis() {
        Plot parent;
        ValueAxis result = this.rangeAxis;
        if (result == null && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot cp = (CategoryPlot)parent;
            result = cp.getRangeAxis();
        }
        return result;
    }

    public void setRangeAxis(ValueAxis axis) {
        if (axis != null) {
            axis.setPlot(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.removeChangeListener(this);
        }
        this.rangeAxis = axis;
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getRangeAxisLocation() {
        return this.rangeAxisLocation;
    }

    public void setRangeAxisLocation(AxisLocation location) {
        this.setRangeAxisLocation(location, true);
    }

    public void setRangeAxisLocation(AxisLocation location, boolean notify) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (location != this.rangeAxisLocation) {
            this.rangeAxisLocation = location;
            if (notify) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.rangeAxisLocation, this.orientation);
    }

    public ValueAxis getSecondaryRangeAxis(int index) {
        Plot parent;
        ValueAxis result = null;
        if (index < this.secondaryRangeAxes.size()) {
            result = (ValueAxis)this.secondaryRangeAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot cp = (CategoryPlot)parent;
            result = cp.getSecondaryRangeAxis(index);
        }
        return result;
    }

    public void setSecondaryRangeAxis(int index, ValueAxis axis) {
        ValueAxis existing = this.getSecondaryRangeAxis(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        if (axis != null) {
            axis.setPlot(this);
        }
        this.secondaryRangeAxes.set(index, (Object)axis);
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeAxes() {
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            ValueAxis axis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (axis == null) continue;
            axis.removeChangeListener(this);
        }
        this.secondaryRangeAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryRangeAxes() {
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            ValueAxis axis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (axis == null) continue;
            axis.configure();
        }
    }

    public AxisLocation getSecondaryRangeAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.secondaryRangeAxisLocations.size()) {
            result = (AxisLocation)this.secondaryRangeAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.rangeAxisLocation);
        }
        return result;
    }

    public void setSecondaryRangeAxisLocation(int index, AxisLocation location) {
        this.secondaryRangeAxisLocations.set(index, (Object)location);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryRangeAxisEdge(int index) {
        AxisLocation location = this.getSecondaryRangeAxisLocation(index);
        RectangleEdge result = Plot.resolveRangeAxisLocation(location, this.orientation);
        if (result == null) {
            result = RectangleEdge.opposite((RectangleEdge)this.getRangeAxisEdge());
        }
        return result;
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset dataset) {
        CategoryDataset existing = this.dataset;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public CategoryDataset getSecondaryDataset(int index) {
        CategoryDataset result = null;
        if (this.secondaryDatasets.size() > index) {
            result = (CategoryDataset)this.secondaryDatasets.get(index);
        }
        return result;
    }

    public void setSecondaryDataset(int index, CategoryDataset dataset) {
        CategoryDataset existing = (CategoryDataset)this.secondaryDatasets.get(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.secondaryDatasets.set(index, (Object)dataset);
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public void mapSecondaryDatasetToDomainAxis(int index, Integer key) {
        this.secondaryDatasetDomainAxisMap.set(index, (Object)key);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public void mapSecondaryDatasetToRangeAxis(int index, Integer key) {
        this.secondaryDatasetRangeAxisMap.set(index, (Object)key);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public ValueAxis getRangeAxisForSecondaryDataset(int index) {
        ValueAxis result = this.getRangeAxis();
        Integer secondaryAxisIndex = (Integer)this.secondaryDatasetRangeAxisMap.get(index);
        if (secondaryAxisIndex != null) {
            result = this.getSecondaryRangeAxis(secondaryAxisIndex);
        }
        return result;
    }

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer renderer) {
        this.setRenderer(renderer, true);
    }

    public void setRenderer(CategoryItemRenderer renderer, boolean notify) {
        if (this.renderer != null) {
            this.renderer.removeChangeListener(this);
        }
        this.renderer = renderer;
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        if (notify) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryItemRenderer getSecondaryRenderer(int index) {
        CategoryItemRenderer result = null;
        if (this.secondaryRenderers.size() > index) {
            result = (CategoryItemRenderer)this.secondaryRenderers.get(index);
        }
        return result;
    }

    public CategoryItemRenderer getRendererForDataset(CategoryDataset d) {
        CategoryItemRenderer result = null;
        if (this.dataset == d) {
            result = this.renderer;
        } else {
            for (int i = 0; i < this.secondaryDatasets.size(); ++i) {
                if (this.secondaryDatasets.get(i) != d) continue;
                result = (CategoryItemRenderer)this.secondaryRenderers.get(i);
                break;
            }
        }
        return result;
    }

    public void setSecondaryRenderer(int index, CategoryItemRenderer renderer) {
        CategoryItemRenderer existing = this.getSecondaryRenderer(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.secondaryRenderers.set(index, (Object)renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = order;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public SortOrder getColumnRenderingOrder() {
        return this.columnRenderingOrder;
    }

    public void setColumnRenderingOrder(SortOrder order) {
        this.columnRenderingOrder = order;
    }

    public SortOrder getRowRenderingOrder() {
        return this.rowRenderingOrder;
    }

    public void setRowRenderingOrder(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.rowRenderingOrder = order;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean visible) {
        if (this.domainGridlinesVisible != visible) {
            this.domainGridlinesVisible = visible;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor position) {
        this.domainGridlinePosition = position;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean visible) {
        if (this.rangeGridlinesVisible != visible) {
            this.rangeGridlinesVisible = visible;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        CategoryDataset data = this.getDataset();
        if (data != null) {
            int seriesCount = data.getRowCount();
            for (int i = 0; i < seriesCount; ++i) {
                CategoryItemRenderer r = this.getRenderer();
                if (r == null) continue;
                LegendItem item = r.getLegendItem(0, i);
                result.add(item);
            }
        }
        int count = this.secondaryDatasets.size();
        for (int datasetIndex = 0; datasetIndex < count; ++datasetIndex) {
            CategoryItemRenderer renderer2;
            CategoryDataset dataset2 = this.getSecondaryDataset(datasetIndex);
            if (dataset2 == null || (renderer2 = this.getSecondaryRenderer(datasetIndex)) == null) continue;
            int seriesCount = dataset2.getRowCount();
            for (int i = 0; i < seriesCount; ++i) {
                LegendItem item = renderer2.getLegendItem(datasetIndex + 1, i);
                result.add(item);
            }
        }
        return result;
    }

    public void handleClick(int x, int y, PlotRenderingInfo info) {
        Rectangle2D dataArea = info.getDataArea();
        if (dataArea.contains(x, y)) {
            double java2D = 0.0;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                java2D = x;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                java2D = y;
            }
            RectangleEdge edge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double value = this.rangeAxis.java2DToValue(java2D, info.getDataArea(), edge);
            this.setAnchorValue(value);
            this.setRangeCrosshairValue(value);
        }
    }

    public void zoom(double percent) {
        if (percent > 0.0) {
            double range = this.rangeAxis.getRange().getLength();
            double scaledRange = range * percent;
            this.rangeAxis.setRange(this.anchorValue - scaledRange / 2.0, this.anchorValue + scaledRange / 2.0);
        } else {
            this.rangeAxis.setAutoRange(true);
        }
    }

    public void datasetChanged(DatasetChangeEvent event) {
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        int count = this.secondaryRangeAxes.size();
        for (int axisIndex = 0; axisIndex < count; ++axisIndex) {
            ValueAxis secondaryRangeAxis = this.getSecondaryRangeAxis(axisIndex);
            if (secondaryRangeAxis == null) continue;
            secondaryRangeAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(event);
        } else {
            PlotChangeEvent e = new PlotChangeEvent(this);
            this.notifyListeners(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rendererChanged(RendererChangeEvent event) {
        Plot parent = this.getParent();
        if (parent != null) {
            if (!(parent instanceof RendererChangeListener)) throw new RuntimeException("The renderer has changed and I don't know what to do!");
            RendererChangeListener rcl = (RendererChangeListener)((Object)parent);
            rcl.rendererChanged(event);
            return;
        } else {
            PlotChangeEvent e = new PlotChangeEvent(this);
            this.notifyListeners(e);
        }
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' is not permitted.");
        }
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' is not permitted.");
        }
        if (layer == Layer.FOREGROUND) {
            if (this.foregroundRangeMarkers == null) {
                this.foregroundRangeMarkers = new ArrayList();
            }
            this.foregroundRangeMarkers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            if (this.backgroundRangeMarkers == null) {
                this.backgroundRangeMarkers = new ArrayList();
            }
            this.backgroundRangeMarkers.add(marker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.backgroundRangeMarkers != null) {
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            this.foregroundRangeMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getRangeMarkers(Layer layer) {
        if (layer == Layer.FOREGROUND) {
            return Collections.unmodifiableList(this.foregroundRangeMarkers);
        }
        if (layer == Layer.BACKGROUND) {
            return Collections.unmodifiableList(this.backgroundRangeMarkers);
        }
        throw new IllegalStateException("CategoryPlot.getRangeMarkers(..): layer?");
    }

    public void addSecondaryRangeMarker(int index, Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.secondaryForegroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.secondaryForegroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.secondaryForegroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.secondaryBackgroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeMarkers(int index) {
        Integer key = new Integer(index);
        Collection markers = (Collection)this.secondaryBackgroundRangeMarkers.get(key);
        if (markers != null) {
            markers.clear();
        }
        if ((markers = (Collection)this.secondaryForegroundRangeMarkers.get(key)) != null) {
            markers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Collection getSecondaryRangeMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.secondaryForegroundRangeMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.secondaryBackgroundRangeMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean flag) {
        if (this.rangeCrosshairVisible != flag) {
            this.rangeCrosshairVisible = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean flag) {
        if (this.rangeCrosshairLockedOnData != flag) {
            this.rangeCrosshairLockedOnData = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double value) {
        this.setRangeCrosshairValue(value, true);
    }

    public void setRangeCrosshairValue(double value, boolean notify) {
        this.rangeCrosshairValue = value;
        if (this.isRangeCrosshairVisible() && notify) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(annotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D g2, Rectangle2D plotArea, AxisSpace space) {
        block7: {
            block5: {
                block6: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block5;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block6;
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block7;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block7;
                space.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                space.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block7;
            }
            RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.domainAxis != null) {
                space = this.domainAxis.reserveSpace(g2, this, plotArea, domainEdge, space);
            } else if (this.drawSharedDomainAxis) {
                space = this.getDomainAxis().reserveSpace(g2, this, plotArea, domainEdge, space);
            }
            for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                CategoryAxis secondaryDomainAxis = this.getSecondaryDomainAxis(i);
                if (secondaryDomainAxis == null) continue;
                RectangleEdge edge = this.getSecondaryDomainAxisEdge(i);
                space = ((Axis)secondaryDomainAxis).reserveSpace(g2, this, plotArea, edge, space);
            }
        }
        return space;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D g2, Rectangle2D plotArea, AxisSpace space) {
        block5: {
            block3: {
                block4: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                space.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                space.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            ValueAxis rangeAxis1 = this.rangeAxis;
            if (rangeAxis1 != null) {
                space = ((Axis)rangeAxis1).reserveSpace(g2, this, plotArea, this.getRangeAxisEdge(), space);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis secondaryRangeAxis = this.getSecondaryRangeAxis(i);
                if (secondaryRangeAxis == null) continue;
                RectangleEdge edge = this.getSecondaryRangeAxisEdge(i);
                space = ((Axis)secondaryRangeAxis).reserveSpace(g2, this, plotArea, edge, space);
            }
        }
        return space;
    }

    protected AxisSpace calculateAxisSpace(Graphics2D g2, Rectangle2D plotArea) {
        AxisSpace space = new AxisSpace();
        space = this.calculateRangeAxisSpace(g2, plotArea, space);
        space = this.calculateDomainAxisSpace(g2, plotArea, space);
        return space;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, PlotState parentState, PlotRenderingInfo state) {
        Insets insets;
        boolean b2;
        boolean b1 = plotArea.getWidth() <= 10.0;
        boolean bl = b2 = plotArea.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        if (state != null) {
            state.setPlotArea(plotArea);
        }
        if ((insets = this.getInsets()) != null) {
            plotArea.setRect(plotArea.getX() + (double)insets.left, plotArea.getY() + (double)insets.top, plotArea.getWidth() - (double)insets.left - (double)insets.right, plotArea.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace space = this.calculateAxisSpace(g2, plotArea);
        Rectangle2D dataArea = space.shrink(plotArea, null);
        this.axisOffset.trim(dataArea);
        if (state != null) {
            state.setDataArea(dataArea);
        }
        if (this.renderer != null) {
            this.renderer.drawBackground(g2, this, dataArea);
        } else {
            this.drawBackground(g2, dataArea);
        }
        Map axisStateMap = this.drawAxes(g2, plotArea, dataArea, state);
        this.drawDomainGridlines(g2, dataArea);
        AxisState rangeAxisState = (AxisState)axisStateMap.get(this.getRangeAxis());
        if (rangeAxisState == null && parentState != null) {
            rangeAxisState = (AxisState)parentState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (rangeAxisState != null) {
            this.drawRangeGridlines(g2, dataArea, rangeAxisState.getTicks());
        }
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            this.drawSecondaryRangeMarkers(g2, dataArea, i, Layer.BACKGROUND);
        }
        this.drawRangeMarkers(g2, dataArea, Layer.BACKGROUND);
        DatasetRenderingOrder order = this.getDatasetRenderingOrder();
        if (order == DatasetRenderingOrder.STANDARD) {
            this.render2(g2, dataArea, state);
            this.render(g2, dataArea, state);
        } else if (order == DatasetRenderingOrder.REVERSE) {
            this.render(g2, dataArea, state);
            this.render2(g2, dataArea, state);
        }
        if (this.isRangeCrosshairVisible()) {
            this.drawRangeLine(g2, dataArea, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
        }
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            this.drawSecondaryRangeMarkers(g2, dataArea, i, Layer.FOREGROUND);
        }
        this.drawRangeMarkers(g2, dataArea, Layer.FOREGROUND);
        this.drawAnnotations(g2, dataArea);
        if (this.renderer != null) {
            this.renderer.drawOutline(g2, this, dataArea);
        } else {
            this.drawOutline(g2, dataArea);
        }
    }

    protected Map drawAxes(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, PlotRenderingInfo plotState) {
        AxisState axisState;
        Axis axis;
        Axis secondaryAxis;
        int index;
        AxisCollection axisCollection = new AxisCollection();
        if (this.domainAxis != null) {
            axisCollection.add(this.domainAxis, this.getDomainAxisEdge());
        }
        if (this.rangeAxis != null) {
            axisCollection.add(this.rangeAxis, this.getRangeAxisEdge());
        }
        for (index = 0; index < this.secondaryDomainAxes.size(); ++index) {
            secondaryAxis = (CategoryAxis)this.secondaryDomainAxes.get(index);
            if (secondaryAxis == null) continue;
            axisCollection.add(secondaryAxis, this.getSecondaryDomainAxisEdge(index));
        }
        for (index = 0; index < this.secondaryRangeAxes.size(); ++index) {
            secondaryAxis = (ValueAxis)this.secondaryRangeAxes.get(index);
            if (secondaryAxis == null) continue;
            axisCollection.add(secondaryAxis, this.getSecondaryRangeAxisEdge(index));
        }
        HashMap<Axis, AxisState> axisStateMap = new HashMap<Axis, AxisState>();
        double cursor = dataArea.getMinY() - this.axisOffset.getTopSpace(dataArea.getHeight());
        Iterator iterator = axisCollection.getAxesAtTop().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.TOP, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = dataArea.getMaxY() + this.axisOffset.getBottomSpace(dataArea.getHeight());
        iterator = axisCollection.getAxesAtBottom().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.BOTTOM, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = dataArea.getMinX() - this.axisOffset.getLeftSpace(dataArea.getWidth());
        iterator = axisCollection.getAxesAtLeft().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.LEFT, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        cursor = dataArea.getMaxX() + this.axisOffset.getRightSpace(dataArea.getWidth());
        iterator = axisCollection.getAxesAtRight().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.RIGHT, plotState);
            cursor = axisState.getCursor();
            axisStateMap.put(axis, axisState);
        }
        return axisStateMap;
    }

    public void render(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info) {
        if (this.renderer == null) {
            return;
        }
        CategoryDataset data = this.getDataset();
        if (!DatasetUtilities.isEmptyOrNull(data)) {
            Shape savedClip = g2.getClip();
            g2.clip(dataArea);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            CategoryItemRendererState state = this.renderer.initialise(g2, dataArea, this, null, info);
            int columnCount = data.getColumnCount();
            int rowCount = data.getRowCount();
            if (this.columnRenderingOrder == SortOrder.ASCENDING) {
                for (int column = 0; column < columnCount; ++column) {
                    int row;
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        for (row = 0; row < rowCount; ++row) {
                            this.renderer.drawItem(g2, state, dataArea, this, this.getDomainAxis(), this.getRangeAxis(), data, row, column);
                        }
                        continue;
                    }
                    for (row = rowCount - 1; row >= 0; --row) {
                        this.renderer.drawItem(g2, state, dataArea, this, this.getDomainAxis(), this.getRangeAxis(), data, row, column);
                    }
                }
            } else {
                for (int column = columnCount - 1; column >= 0; --column) {
                    int row;
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        for (row = 0; row < rowCount; ++row) {
                            this.renderer.drawItem(g2, state, dataArea, this, this.getDomainAxis(), this.getRangeAxis(), data, row, column);
                        }
                        continue;
                    }
                    for (row = rowCount - 1; row >= 0; --row) {
                        this.renderer.drawItem(g2, state, dataArea, this, this.getDomainAxis(), this.getRangeAxis(), data, row, column);
                    }
                }
            }
            g2.setClip(savedClip);
            g2.setComposite(originalComposite);
        } else {
            this.drawNoDataMessage(g2, dataArea);
        }
    }

    public void render2(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info) {
        Shape savedClip = g2.getClip();
        g2.clip(dataArea);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        for (int i = 0; i < this.secondaryDatasets.size(); ++i) {
            CategoryItemRenderer renderer2;
            CategoryDataset data2 = this.getSecondaryDataset(i);
            if (DatasetUtilities.isEmptyOrNull(data2)) continue;
            ValueAxis rangeAxis2 = this.getRangeAxisForSecondaryDataset(i);
            if (rangeAxis2 == null) {
                rangeAxis2 = this.getRangeAxis();
            }
            if ((renderer2 = this.getSecondaryRenderer(i)) == null) continue;
            CategoryItemRendererState state = renderer2.initialise(g2, dataArea, this, new Integer(i), info);
            int columnCount = data2.getColumnCount();
            int rowCount = data2.getRowCount();
            for (int column = 0; column < columnCount; ++column) {
                for (int row = 0; row < rowCount; ++row) {
                    renderer2.drawItem(g2, state, dataArea, this, this.getDomainAxis(), rangeAxis2, data2, row, column);
                }
            }
        }
        g2.setClip(savedClip);
        g2.setComposite(originalComposite);
    }

    protected void drawDomainGridlines(Graphics2D g2, Rectangle2D dataArea) {
        if (this.isDomainGridlinesVisible()) {
            CategoryAxis axis;
            CategoryDataset data;
            CategoryAnchor anchor = this.getDomainGridlinePosition();
            RectangleEdge domainAxisEdge = this.getDomainAxisEdge();
            Stroke gridStroke = this.getDomainGridlineStroke();
            Paint gridPaint = this.getDomainGridlinePaint();
            if (gridStroke != null && gridPaint != null && (data = this.getDataset()) != null && (axis = this.getDomainAxis()) != null) {
                int columnCount = data.getColumnCount();
                for (int c = 0; c < columnCount; ++c) {
                    double xx = axis.getCategoryJava2DCoordinate(anchor, c, columnCount, dataArea, domainAxisEdge);
                    CategoryItemRenderer renderer1 = this.getRenderer();
                    if (renderer1 == null) continue;
                    renderer1.drawDomainGridline(g2, this, dataArea, xx);
                }
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D g2, Rectangle2D dataArea, List ticks) {
        if (this.isRangeGridlinesVisible()) {
            ValueAxis axis;
            Stroke gridStroke = this.getRangeGridlineStroke();
            Paint gridPaint = this.getRangeGridlinePaint();
            if (gridStroke != null && gridPaint != null && (axis = this.getRangeAxis()) != null) {
                Iterator iterator = ticks.iterator();
                while (iterator.hasNext()) {
                    ValueTick tick = (ValueTick)iterator.next();
                    CategoryItemRenderer renderer1 = this.getRenderer();
                    if (renderer1 == null) continue;
                    renderer1.drawRangeGridline(g2, this, this.getRangeAxis(), dataArea, tick.getValue());
                }
            }
        }
    }

    protected void drawAnnotations(Graphics2D g2, Rectangle2D dataArea) {
        if (this.getAnnotations() != null) {
            Iterator iterator = this.getAnnotations().iterator();
            while (iterator.hasNext()) {
                CategoryAnnotation annotation = (CategoryAnnotation)iterator.next();
                annotation.draw(g2, this, dataArea, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D g2, Rectangle2D dataArea, Layer layer) {
        CategoryItemRenderer r = this.getRenderer();
        List markers = this.getRangeMarkers(layer);
        if (markers != null && r != null) {
            Iterator iterator = markers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                r.drawRangeMarker(g2, this, this.getRangeAxis(), marker, dataArea);
            }
        }
    }

    protected void drawSecondaryRangeMarkers(Graphics2D g2, Rectangle2D dataArea, int index, Layer layer) {
        CategoryItemRenderer r = this.getSecondaryRenderer(index);
        if (r == null) {
            return;
        }
        Collection markers = this.getSecondaryRangeMarkers(index, layer);
        ValueAxis axis = this.getSecondaryRangeAxis(index);
        if (markers != null && axis != null) {
            Iterator iterator = markers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawRangeMarker(g2, this, axis, marker, dataArea);
            }
        }
    }

    protected void drawRangeLine(Graphics2D g2, Rectangle2D dataArea, double value, Stroke stroke, Paint paint) {
        double java2D = this.getRangeAxis().valueToJava2D(value, dataArea, this.getRangeAxisEdge());
        Line2D.Double line = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            line = new Line2D.Double(java2D, dataArea.getMinY(), java2D, dataArea.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            line = new Line2D.Double(dataArea.getMinX(), java2D, dataArea.getMaxX(), java2D);
        }
        g2.setStroke(stroke);
        g2.setPaint(paint);
        g2.draw(line);
    }

    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        ArrayList<CategoryDataset> mappedDatasets = new ArrayList<CategoryDataset>();
        if (axis == this.getRangeAxis()) {
            mappedDatasets.add(this.dataset);
            mappedDatasets.addAll(this.getSecondaryDatasetsMappedToRangeAxis(null));
        } else {
            int rangeIndex = this.secondaryRangeAxes.indexOf((Object)axis);
            if (rangeIndex >= 0) {
                mappedDatasets.addAll(this.getSecondaryDatasetsMappedToRangeAxis(new Integer(rangeIndex)));
            }
        }
        Iterator iterator = mappedDatasets.iterator();
        while (iterator.hasNext()) {
            CategoryDataset d = (CategoryDataset)iterator.next();
            CategoryItemRenderer r = this.getRendererForDataset(d);
            RangeType rangeType = RangeType.STANDARD;
            if (r != null) {
                rangeType = r.getRangeType();
            }
            if (rangeType == RangeType.STACKED) {
                result = Range.combine(result, DatasetUtilities.getStackedRangeExtent(d));
                continue;
            }
            if (rangeType == RangeType.SERIES_CUMULATIVE) {
                result = Range.combine(result, DatasetUtilities.getCumulativeRangeExtent(d));
                continue;
            }
            result = Range.combine(result, DatasetUtilities.getRangeExtent(d));
        }
        return result;
    }

    private List getSecondaryDatasetsMappedToRangeAxis(Integer index) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.secondaryDatasetRangeAxisMap.size(); ++i) {
            Integer m = (Integer)this.secondaryDatasetRangeAxisMap.get(i);
            if (m == null) {
                if (index != null) continue;
                result.add(this.secondaryDatasets.get(i));
                continue;
            }
            if (!m.equals(index)) continue;
            result.add(this.secondaryDatasets.get(i));
        }
        return result;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace space) {
        this.fixedDomainAxisSpace = space;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace space) {
        this.fixedRangeAxisSpace = space;
    }

    public List getCategories() {
        List result = null;
        if (this.dataset != null) {
            result = Collections.unmodifiableList(this.dataset.getColumnKeys());
        }
        return result;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void zoomHorizontalAxes(double factor) {
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.resizeRange(factor);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis rangeAxis2 = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (rangeAxis2 == null) continue;
                rangeAxis2.resizeRange(factor);
            }
        }
    }

    public void zoomHorizontalAxes(double lowerPercent, double upperPercent) {
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.zoomRange(lowerPercent, upperPercent);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis rangeAxis2 = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (rangeAxis2 == null) continue;
                rangeAxis2.zoomRange(lowerPercent, upperPercent);
            }
        }
    }

    public void zoomVerticalAxes(double factor) {
        if (this.orientation == PlotOrientation.VERTICAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.resizeRange(factor);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis rangeAxis2 = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (rangeAxis2 == null) continue;
                rangeAxis2.resizeRange(factor);
            }
        }
    }

    public void zoomVerticalAxes(double lowerPercent, double upperPercent) {
        if (this.orientation == PlotOrientation.VERTICAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.zoomRange(lowerPercent, upperPercent);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis rangeAxis2 = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (rangeAxis2 == null) continue;
                rangeAxis2.zoomRange(lowerPercent, upperPercent);
            }
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double value) {
        this.setAnchorValue(value, true);
    }

    public void setAnchorValue(double value, boolean notify) {
        this.anchorValue = value;
        if (notify) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof CategoryPlot) {
            CategoryPlot p = (CategoryPlot)object;
            boolean b0 = this.orientation == p.orientation;
            boolean b1 = ObjectUtils.equal((Object)this.axisOffset, (Object)p.axisOffset);
            boolean b2 = ObjectUtils.equal((Object)this.domainAxis, (Object)p.domainAxis);
            boolean b3 = this.domainAxisLocation == p.domainAxisLocation;
            boolean b4 = this.secondaryDomainAxes.equals((Object)p.secondaryDomainAxes);
            boolean b5 = this.secondaryDomainAxisLocations.equals((Object)p.secondaryDomainAxisLocations);
            boolean b6 = ObjectUtils.equal((Object)this.rangeAxis, (Object)p.rangeAxis);
            boolean b7 = this.rangeAxisLocation == p.rangeAxisLocation;
            boolean b8 = this.secondaryRangeAxes.equals((Object)p.secondaryRangeAxes);
            boolean b9 = this.secondaryRangeAxisLocations.equals((Object)p.secondaryRangeAxisLocations);
            boolean b10 = ObjectUtils.equal((Object)this.secondaryDatasetDomainAxisMap, (Object)p.secondaryDatasetDomainAxisMap);
            boolean b11 = ObjectUtils.equal((Object)this.secondaryDatasetRangeAxisMap, (Object)p.secondaryDatasetRangeAxisMap);
            boolean b12 = ObjectUtils.equal((Object)this.renderer, (Object)p.renderer);
            boolean b13 = ObjectUtils.equal((Object)this.secondaryRenderers, (Object)p.secondaryRenderers);
            boolean b14 = this.renderingOrder == p.renderingOrder;
            boolean b15 = this.domainGridlinesVisible == p.domainGridlinesVisible;
            boolean b16 = this.domainGridlinePosition == p.domainGridlinePosition;
            boolean b17 = ObjectUtils.equal((Object)this.domainGridlineStroke, (Object)p.domainGridlineStroke);
            boolean b18 = ObjectUtils.equal((Object)this.domainGridlinePaint, (Object)p.domainGridlinePaint);
            boolean b19 = this.anchorValue == p.anchorValue;
            boolean b20 = this.rangeGridlinesVisible == p.rangeGridlinesVisible;
            boolean b21 = ObjectUtils.equal((Object)this.rangeGridlineStroke, (Object)p.rangeGridlineStroke);
            boolean b22 = ObjectUtils.equal((Object)this.rangeGridlinePaint, (Object)p.rangeGridlinePaint);
            boolean b23 = this.rangeCrosshairVisible == p.rangeCrosshairVisible;
            boolean b24 = this.rangeCrosshairValue == p.rangeCrosshairValue;
            boolean b25 = ObjectUtils.equal((Object)this.rangeCrosshairStroke, (Object)p.rangeCrosshairStroke);
            boolean b26 = ObjectUtils.equal((Object)this.rangeCrosshairPaint, (Object)p.rangeCrosshairPaint);
            boolean b27 = this.rangeCrosshairLockedOnData == p.rangeCrosshairLockedOnData;
            boolean b28 = ObjectUtils.equal((Object)this.foregroundRangeMarkers, (Object)p.foregroundRangeMarkers);
            boolean b29 = ObjectUtils.equal((Object)this.backgroundRangeMarkers, (Object)p.backgroundRangeMarkers);
            boolean b30 = ObjectUtils.equal((Object)this.secondaryForegroundRangeMarkers, (Object)p.secondaryForegroundRangeMarkers);
            boolean b31 = ObjectUtils.equal((Object)this.secondaryBackgroundRangeMarkers, (Object)p.secondaryBackgroundRangeMarkers);
            boolean b32 = ObjectUtils.equal((Object)this.annotations, (Object)p.annotations);
            boolean b33 = this.weight == p.weight;
            return b0 && b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8 && b9 && b10 && b11 && b12 && b13 && b14 && b15 && b16 && b17 && b18 && b19 && b20 && b21 && b22 && b23 && b24 && b25 && b26 && b27 && b28 && b29 && b30 && b31 && b32 && b33;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        int i;
        CategoryPlot clone = (CategoryPlot)super.clone();
        if (this.domainAxis != null) {
            clone.domainAxis = (CategoryAxis)this.domainAxis.clone();
            clone.domainAxis.setPlot(clone);
            clone.domainAxis.addChangeListener(clone);
        }
        clone.secondaryDomainAxes = (ObjectList)this.secondaryDomainAxes.clone();
        for (i = 0; i < clone.secondaryDomainAxes.size(); ++i) {
            ((CategoryAxis)clone.secondaryDomainAxes.get(i)).setPlot(clone);
            ((CategoryAxis)clone.secondaryDomainAxes.get(i)).addChangeListener(clone);
        }
        clone.secondaryDomainAxisLocations = (ObjectList)this.secondaryDomainAxisLocations.clone();
        if (this.rangeAxis != null) {
            clone.rangeAxis = (ValueAxis)this.rangeAxis.clone();
            clone.rangeAxis.setPlot(clone);
            clone.rangeAxis.addChangeListener(clone);
        }
        clone.secondaryRangeAxes = (ObjectList)this.secondaryRangeAxes.clone();
        for (i = 0; i < clone.secondaryRangeAxes.size(); ++i) {
            ((CategoryAxis)clone.secondaryRangeAxes.get(i)).setPlot(clone);
            ((CategoryAxis)clone.secondaryRangeAxes.get(i)).addChangeListener(clone);
        }
        clone.secondaryRangeAxisLocations = (ObjectList)this.secondaryRangeAxisLocations.clone();
        if (clone.dataset != null) {
            clone.dataset.addChangeListener(clone);
        }
        clone.secondaryDatasets = (ObjectList)this.secondaryDatasets.clone();
        for (i = 0; i < clone.secondaryDatasets.size(); ++i) {
            ((CategoryDataset)clone.secondaryDatasets.get(i)).addChangeListener(clone);
        }
        clone.secondaryDatasetDomainAxisMap = (ObjectList)this.secondaryDatasetDomainAxisMap.clone();
        clone.secondaryDatasetRangeAxisMap = (ObjectList)this.secondaryDatasetRangeAxisMap.clone();
        if (this.renderer != null) {
            if (this.renderer instanceof PublicCloneable) {
                PublicCloneable pc = (PublicCloneable)this.renderer;
                clone.renderer = (CategoryItemRenderer)pc.clone();
            } else {
                throw new CloneNotSupportedException("CategoryPlot: renderer doesn't implement PublicCloneable.");
            }
        }
        clone.secondaryRenderers = (ObjectList)this.secondaryRenderers.clone();
        clone.fixedDomainAxisSpace = (AxisSpace)ObjectUtils.clone((Object)this.fixedDomainAxisSpace);
        clone.fixedRangeAxisSpace = (AxisSpace)ObjectUtils.clone((Object)this.fixedRangeAxisSpace);
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.domainGridlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.domainGridlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.rangeGridlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.rangeGridlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.rangeCrosshairStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.rangeCrosshairPaint, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.domainGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.rangeGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.rangeGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        if (this.domainAxis != null) {
            this.domainAxis.setPlot(this);
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.setPlot(this);
            this.rangeAxis.addChangeListener(this);
        }
        this.foregroundRangeMarkers = new ArrayList();
        this.backgroundRangeMarkers = new ArrayList();
        this.secondaryForegroundRangeMarkers = new HashMap();
        this.secondaryBackgroundRangeMarkers = new HashMap();
        ValueMarker baseline = new ValueMarker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), new BasicStroke(1.0f), 0.6f);
        this.addRangeMarker(baseline, Layer.BACKGROUND);
    }

    public List getRangeMarkers() {
        return this.getRangeMarkers(Layer.FOREGROUND);
    }

    public void addSecondaryRangeMarker(Marker marker) {
        this.addSecondaryRangeMarker(0, marker, Layer.FOREGROUND);
    }

    public void clearSecondaryRangeMarkers() {
        this.clearSecondaryRangeMarkers(0);
    }

    public List getSecondaryRangeMarkers() {
        ArrayList result = null;
        Collection markers = this.getSecondaryRangeMarkers(0, Layer.FOREGROUND);
        if (markers != null) {
            result = new ArrayList(result);
        }
        return result;
    }

    protected void drawSecondaryRangeMarkers(Graphics2D g2, Rectangle2D dataArea) {
        CategoryItemRenderer r = this.getSecondaryRenderer(0);
        if (r == null) {
            return;
        }
        if (this.getSecondaryRangeMarkers() != null) {
            Iterator iterator = this.getSecondaryRangeMarkers().iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawRangeMarker(g2, this, this.getSecondaryRangeAxis(0), marker, dataArea);
            }
        }
    }
}

