/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.RowData;
import java.sql.SQLException;

public class RowDataDynamic
implements RowData {
    private MysqlIO io;
    private byte[][] nextRow;
    private boolean isAfterEnd = false;
    private boolean isAtEnd = false;
    private boolean streamerClosed = false;
    private int columnCount;
    private int index = -1;

    public RowDataDynamic(MysqlIO io, int colCount) throws SQLException {
        this.io = io;
        this.columnCount = colCount;
        this.nextRecord();
    }

    public boolean isAfterLast() throws SQLException {
        return this.isAfterEnd;
    }

    public byte[][] getAt(int index) throws SQLException {
        this.notSupported();
        return null;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.index < 0;
    }

    public void setCurrentRow(int rowNumber) throws SQLException {
        this.notSupported();
    }

    public int getCurrentRowNumber() throws SQLException {
        this.notSupported();
        return -1;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isEmpty() throws SQLException {
        this.notSupported();
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.notSupported();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.notSupported();
        return false;
    }

    public void addRow(byte[][] row) throws SQLException {
        this.notSupported();
    }

    public void afterLast() throws SQLException {
        this.notSupported();
    }

    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    public void beforeLast() throws SQLException {
        this.notSupported();
    }

    public void close() throws SQLException {
        while (this.hasNext()) {
            this.next();
        }
    }

    public boolean hasNext() throws SQLException {
        boolean hasNext;
        boolean bl = hasNext = this.nextRow != null;
        if (!hasNext && !this.streamerClosed) {
            this.io.closeStreamer(this);
            this.streamerClosed = true;
        }
        return hasNext;
    }

    public void moveRowRelative(int rows) throws SQLException {
        this.notSupported();
    }

    public byte[][] next() throws SQLException {
        ++this.index;
        byte[][] ret = this.nextRow;
        this.nextRecord();
        return ret;
    }

    public void removeRow(int index) throws SQLException {
        this.notSupported();
    }

    public int size() {
        return -1;
    }

    private void nextRecord() throws SQLException {
        try {
            if (!this.isAtEnd) {
                this.nextRow = this.io.nextRow(this.columnCount);
                if (this.nextRow == null) {
                    this.isAtEnd = true;
                }
            } else {
                this.isAfterEnd = true;
            }
        }
        catch (Exception e) {
            throw new SQLException("Error trying to fetch row:" + e.getMessage(), "S1000");
        }
    }

    private void notSupported() throws SQLException {
        throw new OperationNotSupportedException();
    }

    class OperationNotSupportedException
    extends SQLException {
        OperationNotSupportedException() {
            super("Operation not supported for streaming result sets", "S1009");
        }
    }
}

