/*
 * BarcodeReportElement.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 15. April 2004, 13:21 by Heiko Wenzel
 */
package it.businesslogic.ireport;
import java.awt.*;
import it.businesslogic.ireport.util.*;

import java.util.*;

/**
 *
 * @author  Administrator
 */
public class BarcodeReportElement extends it.businesslogic.ireport.ImageReportElement {
	private String title = "Sample barcode";
	private boolean legend = false;
	private double angle = 0;
	private String bcText = "0815";
	private int type = 13;
	private boolean checkSum = false;
	
	public BarcodeReportElement(int x, int y, int width, int height)  {
		super(x, y, width, height);
		setGraphicElementPen("Thin");
		setImg(it.businesslogic.ireport.barcode.BcImage.getBarcodeImage(type, bcText, angle, checkSum));
		this.width = it.businesslogic.ireport.barcode.BcImage.getBarcode().getWidth();
		this.height = it.businesslogic.ireport.barcode.BcImage.getBarcode().getHeightBar();		
		
		setImageClass("java.awt.Image");
		setScaleImage("FillFrame");
		setGraphicElementPen("None");
		setHyperlinkType("None");
		setAnchorNameExpression("");
	}
	
	public void setAngle(double angle) {
		this.angle = angle;		
		update();
	}
	
	public double getAngle() {
		return this.angle;
	}
	
	public void update() {
		StringBuffer bcCall = new StringBuffer("/*barcode*/it.businesslogic.ireport.barcode.BcImage.getBarcodeImage(");
		bcCall.append(getType());
		bcCall.append(",\"");
		bcCall.append(getBcText());
		bcCall.append("\",");
		bcCall.append(getAngle());
		bcCall.append(",");
		bcCall.append(isCheckSum());
		bcCall.append(")");
		
		setImageExpression(bcCall.toString());		
		setImg(it.businesslogic.ireport.barcode.BcImage.getBarcodeImage(type, bcText, angle, checkSum));
		
		this.width = it.businesslogic.ireport.barcode.BcImage.getBarcode().getMinimumSize().width;
		this.height = it.businesslogic.ireport.barcode.BcImage.getBarcode().getMinimumSize().height;
		this.updateBounds();
	}
	
	public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
		super.drawObject(g, zoom_factor, x_shift_origin, y_shift_origin);
	}
	
	
	public java.lang.String getTitle() {
		return title;
	}
	
	public void setTitle(java.lang.String title) {
		this.title = title;
		this.setImg(null);
	}
	
	public String getBcText() {
		return this.bcText;
	}
	
	public void setBcText(String bcText) {
		this.bcText = bcText;
	}
	
	public int getType() {
		return this.type;
	}
	
	public void setType(int type) {
		this.type = type;
	}
	
	public boolean isCheckSum() {
		return this.checkSum;
	}
	
	public void setCheckSum(boolean checkSum) {
		this.checkSum = checkSum;
	}
	
}