/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

public class SymbolTable {
    protected static final int TABLE_SIZE = 101;
    protected Entry[] fBuckets = null;
    protected int fTableSize;

    public SymbolTable() {
        this(101);
    }

    public SymbolTable(int n) {
        this.fTableSize = n;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public String addSymbol(String string) {
        Entry entry;
        int n = this.hash(string) % this.fTableSize;
        int n2 = string.length();
        Entry entry2 = this.fBuckets[n];
        while (entry2 != null) {
            block4: {
                if (n2 == entry2.characters.length) {
                    int n3 = 0;
                    while (n3 < n2) {
                        if (string.charAt(n3) == entry2.characters[n3]) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    return entry2.symbol;
                }
            }
            entry2 = entry2.next;
        }
        this.fBuckets[n] = entry = new Entry(string, this.fBuckets[n]);
        return entry.symbol;
    }

    public String addSymbol(char[] cArray, int n, int n2) {
        Entry entry;
        int n3 = this.hash(cArray, n, n2) % this.fTableSize;
        Entry entry2 = this.fBuckets[n3];
        while (entry2 != null) {
            block4: {
                if (n2 == entry2.characters.length) {
                    int n4 = 0;
                    while (n4 < n2) {
                        if (cArray[n + n4] == entry2.characters[n4]) {
                            ++n4;
                            continue;
                        }
                        break block4;
                    }
                    return entry2.symbol;
                }
            }
            entry2 = entry2.next;
        }
        this.fBuckets[n3] = entry = new Entry(cArray, n, n2, this.fBuckets[n3]);
        return entry.symbol;
    }

    public int hash(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = n * 37 + string.charAt(n3);
            ++n3;
        }
        return n & 0x7FFFFFF;
    }

    public int hash(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 * 37 + cArray[n + n4];
            ++n4;
        }
        return n3 & 0x7FFFFFF;
    }

    public boolean containsSymbol(String string) {
        int n = this.hash(string) % this.fTableSize;
        int n2 = string.length();
        Entry entry = this.fBuckets[n];
        while (entry != null) {
            block4: {
                if (n2 == entry.characters.length) {
                    int n3 = 0;
                    while (n3 < n2) {
                        if (string.charAt(n3) == entry.characters[n3]) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n, int n2) {
        int n3 = this.hash(cArray, n, n2) % this.fTableSize;
        Entry entry = this.fBuckets[n3];
        while (entry != null) {
            block4: {
                if (n2 == entry.characters.length) {
                    int n4 = 0;
                    while (n4 < n2) {
                        if (cArray[n + n4] == entry.characters[n4]) {
                            ++n4;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    protected static final class Entry {
        public String symbol;
        public char[] characters;
        public Entry next;

        public Entry(String string, Entry entry) {
            this.symbol = string.intern();
            this.characters = new char[string.length()];
            string.getChars(0, this.characters.length, this.characters, 0);
            this.next = entry;
        }

        public Entry(char[] cArray, int n, int n2, Entry entry) {
            this.characters = new char[n2];
            System.arraycopy(cArray, n, this.characters, 0, n2);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }
    }
}

