/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class StandardCategoryItemLabelGenerator
implements CategoryItemLabelGenerator,
CategoryToolTipGenerator,
PublicCloneable,
Cloneable,
Serializable {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private boolean showSeriesNameInToolTips;

    public StandardCategoryItemLabelGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardCategoryItemLabelGenerator(NumberFormat formatter) {
        this(formatter, true);
    }

    public StandardCategoryItemLabelGenerator(NumberFormat formatter, boolean showSeriesNameInToolTips) {
        if (formatter == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.numberFormat = formatter;
        this.dateFormat = null;
        this.showSeriesNameInToolTips = showSeriesNameInToolTips;
    }

    public StandardCategoryItemLabelGenerator(DateFormat formatter) {
        this(formatter, true);
    }

    public StandardCategoryItemLabelGenerator(DateFormat formatter, boolean showSeriesNameInToolTips) {
        if (formatter == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.numberFormat = null;
        this.dateFormat = formatter;
        this.showSeriesNameInToolTips = showSeriesNameInToolTips;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset dataset, int series, int category) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String result = null;
        Number value = dataset.getValue(series, category);
        if (value != null) {
            Comparable seriesName;
            if (this.showSeriesNameInToolTips && (seriesName = dataset.getRowKey(series)) != null) {
                result = seriesName.toString() + ", ";
            }
            Comparable categoryKey = dataset.getColumnKey(category);
            String categoryName = categoryKey.toString();
            String valueString = null;
            if (this.numberFormat != null) {
                valueString = this.numberFormat.format(value);
            } else if (this.dateFormat != null) {
                valueString = this.dateFormat.format(value);
            }
            result = result != null ? result + categoryName + " = " + valueString : categoryName + " = " + valueString;
        }
        return result;
    }

    public String generateItemLabel(CategoryDataset dataset, int series, int category) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String result = null;
        Number value = dataset.getValue(series, category);
        if (value != null) {
            if (this.numberFormat != null) {
                result = this.numberFormat.format(value);
            } else if (this.dateFormat != null) {
                result = this.dateFormat.format(value);
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof StandardCategoryItemLabelGenerator) {
            StandardCategoryItemLabelGenerator generator = (StandardCategoryItemLabelGenerator)o;
            boolean b0 = ObjectUtils.equal((Object)this.dateFormat, (Object)generator.dateFormat);
            boolean b1 = ObjectUtils.equal((Object)this.numberFormat, (Object)generator.numberFormat);
            return b0 && b1;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardCategoryItemLabelGenerator clone = (StandardCategoryItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            clone.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.dateFormat != null) {
            clone.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        return clone;
    }
}

