/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.design;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JasperReport;
import dori.jasper.engine.design.JRBshGenerator;
import dori.jasper.engine.design.JRCompiler;
import dori.jasper.engine.design.JRVerifier;
import dori.jasper.engine.design.JasperDesign;
import dori.jasper.engine.fill.JRBshCalculator;
import dori.jasper.engine.fill.JRCalculator;
import java.util.Collection;
import java.util.Iterator;

public class JRBshCompiler
implements JRCompiler {
    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JasperReport jasperReport = null;
        Collection brokenRules = JRVerifier.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report design not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
        String bshScript = JRBshGenerator.generateScript(jasperDesign);
        jasperReport = new JasperReport(jasperDesign, this.getClass().getName(), bshScript);
        JRBshCalculator bshCalculator = new JRBshCalculator(bshScript);
        bshCalculator.verify(jasperDesign.getExpressions());
        return jasperReport;
    }

    public JRCalculator loadCalculator(JasperReport jasperReport) throws JRException {
        return new JRBshCalculator((String)jasperReport.getCompileData());
    }
}

