/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;
/**
 *
 * @author  Administrator
 */
public class JRVariableDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    JRVariable tmpVariable = null;
    
    Report report = null;
    
    public JRVariableDialog(Report report, java.awt.Frame parent, boolean modal) {
        
        super(parent, modal);
        initComponents();
        
        this.report = report;
        updateGroups();
        
        this.setSize(360, 364);
        this.jRTextExpressionAreaExpression.setText("");
        this.jRTextExpressionAreaInitialExpression.setText("");
        setTypes();               
        this.jComboBoxClassType.setSelectedItem("java.lang.String");
        this.jComboBoxCalculationType.setSelectedItem("Nothing");
        this.jComboBoxResetType.setSelectedItem("Report");
        
        updateGroups();
        Misc.centerFrame(this);
    }
    
    public void setTypes()
    {
        this.jComboBoxClassType.addItem("java.lang.String");
        this.jComboBoxClassType.addItem("java.lang.Object");
        this.jComboBoxClassType.addItem("java.lang.Boolean");
        this.jComboBoxClassType.addItem("java.lang.Byte");
        this.jComboBoxClassType.addItem("java.util.Date");
        this.jComboBoxClassType.addItem("java.sql.Timestamp");
        this.jComboBoxClassType.addItem("java.lang.Double");
        this.jComboBoxClassType.addItem("java.lang.Float");
        this.jComboBoxClassType.addItem("java.lang.Integer");
        this.jComboBoxClassType.addItem("java.io.InputStream");
        this.jComboBoxClassType.addItem("java.lang.Long");
        this.jComboBoxClassType.addItem("java.lang.Short");
        this.jComboBoxClassType.addItem("java.math.BigDecimal");
        this.jComboBoxClassType.addItem("dori.jasper.engine.JREmptyDataSource");
        
        this.jComboBoxCalculationType.addItem("Nothing");
        this.jComboBoxCalculationType.addItem("Count");
        this.jComboBoxCalculationType.addItem("Sum");
        this.jComboBoxCalculationType.addItem("Average");
        this.jComboBoxCalculationType.addItem("Lowest");
        this.jComboBoxCalculationType.addItem("Highest");
        this.jComboBoxCalculationType.addItem("StandardDeviation");
        this.jComboBoxCalculationType.addItem("Variance");
        this.jComboBoxCalculationType.addItem("System");
        
        this.jComboBoxResetType.addItem("None");
        this.jComboBoxResetType.addItem("Report");
        this.jComboBoxResetType.addItem("Page");
        this.jComboBoxResetType.addItem("Column");
        this.jComboBoxResetType.addItem("Group");
    }
    
    public void updateGroups()
    {
        if (getReport() != null)
        {
            Misc.updateStringComboBox( jComboBoxResetGroup , getReport().getGroups(), true );
        }
        else
        {
            jComboBoxResetGroup.removeAllItems();
            jComboBoxResetGroup.addItem("");
        }
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxResetGroup = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jButtonCancel = new javax.swing.JButton();
        jButtonOK = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        jComboBoxResetType = new javax.swing.JComboBox();
        jComboBoxCalculationType = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jComboBoxClassType = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();
        jRTextExpressionAreaInitialExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionAreaExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();

        getContentPane().setLayout(null);

        setTitle("Add/modify variable");
        setModal(true);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setText("Variable name");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(4, 4, 250, 15);

        jTextFieldName.setFont(new java.awt.Font("Dialog", 0, 11));
        getContentPane().add(jTextFieldName);
        jTextFieldName.setBounds(4, 20, 340, 22);

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.setText("Calculation type");
        getContentPane().add(jLabel2);
        jLabel2.setBounds(194, 46, 150, 15);

        jComboBoxResetGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        getContentPane().add(jComboBoxResetGroup);
        jComboBoxResetGroup.setBounds(160, 104, 184, 22);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.setText("Variable expression");
        getContentPane().add(jLabel3);
        jLabel3.setBounds(4, 130, 250, 15);

        jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel4.setText("Initial value expression");
        getContentPane().add(jLabel4);
        jLabel4.setBounds(4, 214, 250, 15);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        getContentPane().add(jButtonCancel);
        jButtonCancel.setBounds(274, 310, 70, 25);

        jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        getContentPane().add(jButtonOK);
        jButtonOK.setBounds(198, 310, 70, 25);

        jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel5.setText("Variable class type");
        getContentPane().add(jLabel5);
        jLabel5.setBounds(4, 46, 170, 15);

        jComboBoxResetType.setFont(new java.awt.Font("Dialog", 0, 11));
        getContentPane().add(jComboBoxResetType);
        jComboBoxResetType.setBounds(4, 104, 150, 22);

        jComboBoxCalculationType.setFont(new java.awt.Font("Dialog", 0, 11));
        getContentPane().add(jComboBoxCalculationType);
        jComboBoxCalculationType.setBounds(194, 62, 150, 22);

        jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel6.setText("Reset group");
        getContentPane().add(jLabel6);
        jLabel6.setBounds(160, 88, 190, 15);

        jComboBoxClassType.setEditable(true);
        jComboBoxClassType.setFont(new java.awt.Font("Dialog", 0, 11));
        getContentPane().add(jComboBoxClassType);
        jComboBoxClassType.setBounds(4, 62, 184, 22);

        jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel7.setText("Reset type");
        getContentPane().add(jLabel7);
        jLabel7.setBounds(4, 88, 130, 15);

        jRTextExpressionAreaInitialExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaInitialExpression.setElectricScroll(0);
        jRTextExpressionAreaInitialExpression.setMinimumSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaInitialExpression.setPreferredSize(new java.awt.Dimension(0, 0));
        getContentPane().add(jRTextExpressionAreaInitialExpression);
        jRTextExpressionAreaInitialExpression.setBounds(6, 234, 338, 64);

        jRTextExpressionAreaExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaExpression.setElectricScroll(0);
        jRTextExpressionAreaExpression.setMinimumSize(new java.awt.Dimension(0, 0));
        jRTextExpressionAreaExpression.setPreferredSize(new java.awt.Dimension(0, 0));
        getContentPane().add(jRTextExpressionAreaExpression);
        jRTextExpressionAreaExpression.setBounds(4, 148, 338, 64);

        pack();
    }//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        
        if (this.jTextFieldName.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid variable name!","Invalid variable!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        tmpVariable = new JRVariable( this.jTextFieldName.getText(), false);
        tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem() +"");
        tmpVariable.setCalculation(this.jComboBoxCalculationType.getSelectedItem() +"");
        tmpVariable.setResetType( this.jComboBoxResetType.getSelectedItem()+"" );
        
        if (this.jComboBoxClassType.getSelectedItem().toString().trim().length() != 0)
        {
            tmpVariable.setClassType( this.jComboBoxClassType.getSelectedItem().toString().trim() );
        }
        else
            tmpVariable.setClassType( "java.lang.String");
        
        if ( tmpVariable.getResetType().equals("Group"))
        {
            if ( this.jComboBoxResetGroup.getSelectedItem() == null ||
                 this.jComboBoxResetGroup.getSelectedItem().equals("")) 
            {
                javax.swing.JOptionPane.showMessageDialog(this,"Please choose a valid group for the reset type selected!","Invalid group!",javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
            }
            tmpVariable.setResetGroup(  this.jComboBoxResetGroup.getSelectedItem()+"" );
        }

        tmpVariable.setExpression( jRTextExpressionAreaExpression.getText());
        
        tmpVariable.setInitialValueExpression( jRTextExpressionAreaInitialExpression.getText());

        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new JRParameterDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property tmpParameter.
     * @return Value of property tmpParameter.
     *
     */
    public it.businesslogic.ireport.JRVariable getVariable() {
        return tmpVariable;
    }    
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setVariable(it.businesslogic.ireport.JRVariable tmpVariable) {
        this.jTextFieldName.setText( new String(tmpVariable.getName()));

        this.jComboBoxClassType.setSelectedItem( new String(tmpVariable.getClassType()));
        this.jComboBoxResetType.setSelectedItem( new String(tmpVariable.getResetType()));
        this.jComboBoxCalculationType.setSelectedItem( new String(tmpVariable.getCalculation() ));
        this.jComboBoxResetGroup.setSelectedItem( tmpVariable.getResetGroup());
        
        this.jRTextExpressionAreaExpression.setText( new String(tmpVariable.getExpression()));                      
        this.jRTextExpressionAreaInitialExpression.setText( new String(tmpVariable.getInitialValueExpression())); 
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property report.
     * @return Value of property report.
     *
     */
    public it.businesslogic.ireport.Report getReport() {
        return report;
    }
    
    /** Setter for property report.
     * @param report New value of property report.
     *
     */
    public void setReport(it.businesslogic.ireport.Report report) {
        this.report = report;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JComboBox jComboBoxCalculationType;
    private javax.swing.JComboBox jComboBoxClassType;
    private javax.swing.JComboBox jComboBoxResetGroup;
    private javax.swing.JComboBox jComboBoxResetType;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaInitialExpression;
    private javax.swing.JTextField jTextFieldName;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
}
