/*
 * ValuesDialog.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 7 maggio 2003, 23.43
 */

package it.businesslogic.ireport.gui;

import javax.swing.table.*;
import javax.swing.*;
import javax.swing.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.Misc;

import java.util.*;

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

/**
 *
 * @author  Administrator
 */
public class ConnectionsDialog extends javax.swing.JDialog {
    
    /** Creates new form ValuesDialog */
    public ConnectionsDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.setSize(490, 250);
        //DefaultTableColumnModel dtcm = (DefaultTableColumnModel)jTableParameters.getColumnModel();
        //DefaultTableCellRenderer tcr = (DefaultTableCellRenderer)dtcm.getColumn(0).getHeaderRenderer();
        
        //new DefaultTableCellRenderer();
        //tcr.setFont(jTableParameters.getFont());
        //tcr.setBackground(this.getBackground());
        //tcr.setBorder( new javax.swing.border.BevelBorder( javax.swing.border.BevelBorder.RAISED));
        //dtcm.getColumn(0).setHeaderRenderer(tcr);
 
        DefaultListSelectionModel dlsm =  (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)  {
                jTableParametersListSelectionValueChanged(e);
            }
        });
                      
        // Open in center...
        it.businesslogic.ireport.util.Misc.centerFrame(this);
        
        DefaultTableModel dtm = (DefaultTableModel)jTableParameters.getModel();
            
        Enumeration enum = ((MainFrame)parent).getConnections().elements();
        while (enum.hasMoreElements())
        {
            IReportConnection con = (IReportConnection)enum.nextElement();
            dtm.addRow( new Object[]{con, con.getDescription() });
        }
    }
    
    
    public void jTableParametersListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {
         if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
        }
        else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
        }
    }
    
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanelParameters = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableParameters = new javax.swing.JTable();
        jPanelButtons = new javax.swing.JPanel();
        jButtonNewParameter = new javax.swing.JButton();
        jButtonModifyParameter = new javax.swing.JButton();
        jButtonDeleteParameter = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Connections / Datasources");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanelParameters.setLayout(new java.awt.BorderLayout(2, 2));

        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setFont(new java.awt.Font("Dialog", 0, 11));
        jTableParameters.setFont(new java.awt.Font("Dialog", 0, 11));
        jTableParameters.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Name", "Datasource type"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(jTableParameters);

        jPanelParameters.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanelButtons.setLayout(null);

        jPanelButtons.setMinimumSize(new java.awt.Dimension(100, 10));
        jPanelButtons.setPreferredSize(new java.awt.Dimension(100, 10));
        jButtonNewParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonNewParameter.setText("New");
        jButtonNewParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewParameterActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonNewParameter);
        jButtonNewParameter.setBounds(4, 5, 92, 22);

        jButtonModifyParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonModifyParameter.setText("Modify");
        jButtonModifyParameter.setEnabled(false);
        jButtonModifyParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyParameterActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonModifyParameter);
        jButtonModifyParameter.setBounds(4, 30, 92, 22);

        jButtonDeleteParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonDeleteParameter.setText("Delete");
        jButtonDeleteParameter.setEnabled(false);
        jButtonDeleteParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteParameterActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonDeleteParameter);
        jButtonDeleteParameter.setBounds(4, 56, 92, 22);

        jPanelParameters.add(jPanelButtons, java.awt.BorderLayout.EAST);

        getContentPane().add(jPanelParameters, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void jButtonDeleteParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteParameterActionPerformed
        // Get the selected connection...
        if (jTableParameters.getSelectedRowCount() > 0)
        {
            IReportConnection irc = null;
            try {
                irc = (IReportConnection)jTableParameters.getModel().getValueAt(jTableParameters.getSelectedRow(), 0);
            } catch (Exception ex) { return; }
            
            
            if ( ((MainFrame)this.getParent()).getProperties().get( "DefaultConnection") == irc)
            {
                ((MainFrame)this.getParent()).getProperties().remove("DefaultConnection");
            }
            
            ((MainFrame)this.getParent()).getConnections().removeElement(irc);
            ((MainFrame)this.getParent()).saveiReportConfiguration();
            ((DefaultTableModel)jTableParameters.getModel()).removeRow(jTableParameters.getSelectedRow());
            jTableParameters.updateUI();
        }
        
    }//GEN-LAST:event_jButtonDeleteParameterActionPerformed

    private void jButtonModifyParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyParameterActionPerformed
        java.awt.Frame parent = Misc.frameFromComponent(this);     
        ConnectionDialog cd = new ConnectionDialog(parent,false);
        
        // Take the selected connection from the table...
        if (jTableParameters.getSelectedRow() < 0) return;
        IReportConnection irc = null;
        try {
            irc = (IReportConnection)jTableParameters.getModel().getValueAt(jTableParameters.getSelectedRow(), 0);
        } catch (Exception ex) { return; }

        if (irc == null) return;
        
        cd.setIReportConnection(irc); 
        
        cd.show();
        
        if (cd.getDialogResult() == JOptionPane.OK_OPTION)
        {
            IReportConnection con = cd.getIReportConnection();
            // Now we have an old and a new object.
            // 1. Adjust table...
            try {
                jTableParameters.getModel().setValueAt(con ,jTableParameters.getSelectedRow(), 0);
                jTableParameters.getModel().setValueAt(con.getDescription() ,jTableParameters.getSelectedRow(), 1);      
            } catch (Exception ex) { return; }
            
            if ( ((MainFrame)this.getParent()).getProperties().get( "DefaultConnection") == irc)
            {
                ((MainFrame)this.getParent()).getProperties().put( "DefaultConnection", con);
            }
            
            ((MainFrame)this.getParent()).getConnections().setElementAt(con, 
                       ((MainFrame)this.getParent()).getConnections().indexOf(irc));
            ((MainFrame)this.getParent()).saveiReportConfiguration();
        }
    }//GEN-LAST:event_jButtonModifyParameterActionPerformed

    private void jButtonNewParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewParameterActionPerformed
        java.awt.Frame parent = Misc.frameFromComponent(this);     
        ConnectionDialog cd = new ConnectionDialog(parent,false);
        cd.show();
        
        if (cd.getDialogResult() == JOptionPane.OK_OPTION)
        {
            IReportConnection con = cd.getIReportConnection();
            DefaultTableModel dtm = (DefaultTableModel)jTableParameters.getModel();
            dtm.addRow( new Object[]{con, con.getDescription() });
            // 
            ((MainFrame)this.getParent()).getConnections().addElement(con);
            ((MainFrame)this.getParent()).saveiReportConfiguration();
        }
    }//GEN-LAST:event_jButtonNewParameterActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ValuesDialog(new javax.swing.JFrame(), true).show();
    }
    
        
    public void updateConnections() {
       /*
        DefaultTableModel dtm = (DefaultTableModel)jTableParameters.getModel();
        dtm.setRowCount(0);
    
        Enumeration enum = jReportFrame.getReport().getParameters().elements();
        while (enum.hasMoreElements())
        {
            it.businesslogic.ireport.JRParameter parameter = (it.businesslogic.ireport.JRParameter)enum.nextElement();
            Vector row = new Vector();
            row.addElement( parameter);
            row.addElement( parameter.getClassType());
            row.addElement( parameter.isIsForPrompting()+"");
            
            dtm.addRow(row);           
        }
        */    
    }  
       
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonDeleteParameter;
    private javax.swing.JButton jButtonModifyParameter;
    private javax.swing.JButton jButtonNewParameter;
    private javax.swing.JPanel jPanelButtons;
    private javax.swing.JPanel jPanelParameters;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTableParameters;
    // End of variables declaration//GEN-END:variables

       public void setVisible(boolean visible)
    {
       updateConnections();
    }
}
