/*
 * ReportUtilitiesOptionsDialog.java
 *
 * Created on February 17, 2004, 9:40 PM
 */

package dori.jasper.util.gui;

import dori.jasper.util.*;


/**
 * Class used to manage the Options for ReportUtilities
 * @author  Wade Chandler
 * @version 1.0
 */
public class ReportUtilitiesOptionsDialog extends javax.swing.JDialog
{
   
   /** used to designate an OK button press */
   public static final int OK_OPTION = 1;
   
   /** used to designate a CANCEL button press */
   public static final int CANCEL_OPTION = 2;
   
   /** used to hold the users choice */
   public int userOption = CANCEL_OPTION;
   
   /** Creates new form ReportUtilitiesOptionsDialog */
   public ReportUtilitiesOptionsDialog(java.awt.Frame parent, boolean modal)
   {
      super(parent, modal);
      initComponents();
      userOption = CANCEL_OPTION;
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   private void initComponents()//GEN-BEGIN:initComponents
   {
      buttonsPanel = new javax.swing.JPanel();
      optionsButtonsPanel = new javax.swing.JPanel();
      okButton = new javax.swing.JButton();
      cancelButton = new javax.swing.JButton();
      optionsPanel = new javax.swing.JPanel();
      jTabbedPane1 = new javax.swing.JTabbedPane();
      knownPanel = new javax.swing.JPanel();
      knownPanelScrollPane = new javax.swing.JScrollPane();
      knownOptionsPanel = new javax.swing.JPanel();
      compileDirCheckBox = new javax.swing.JCheckBox();
      keepJavaFilesCheckBox = new javax.swing.JCheckBox();
      xmlSaxParserText = new javax.swing.JTextField();
      jLabel1 = new javax.swing.JLabel();
      jLabel2 = new javax.swing.JLabel();
      compileDirText = new javax.swing.JTextField();
      jLabel3 = new javax.swing.JLabel();
      overriddenClasspathText = new javax.swing.JTextField();
      genericPanel = new javax.swing.JPanel();
      genericScrollPane = new javax.swing.JScrollPane();
      genericTable = new javax.swing.JTable();
      
      FormListener formListener = new FormListener();
      
      addWindowListener(formListener);
      
      buttonsPanel.setLayout(new java.awt.CardLayout());
      
      buttonsPanel.setPreferredSize(new java.awt.Dimension(10, 40));
      okButton.setText("OK");
      okButton.setPreferredSize(new java.awt.Dimension(75, 25));
      okButton.addActionListener(formListener);
      
      optionsButtonsPanel.add(okButton);
      
      cancelButton.setText("CANCEL");
      cancelButton.addActionListener(formListener);
      
      optionsButtonsPanel.add(cancelButton);
      
      buttonsPanel.add(optionsButtonsPanel, "card2");
      
      getContentPane().add(buttonsPanel, java.awt.BorderLayout.SOUTH);
      
      optionsPanel.setLayout(new java.awt.CardLayout());
      
      jTabbedPane1.setDoubleBuffered(true);
      knownPanel.setLayout(new java.awt.CardLayout());
      
      knownOptionsPanel.setLayout(null);
      
      compileDirCheckBox.setText("Use the open files directory for the compilation and temp directory.");
      compileDirCheckBox.addActionListener(formListener);
      compileDirCheckBox.addPropertyChangeListener(formListener);
      
      knownOptionsPanel.add(compileDirCheckBox);
      compileDirCheckBox.setBounds(7, 5, 428, 23);
      
      keepJavaFilesCheckBox.setText("Keep temp java files");
      knownOptionsPanel.add(keepJavaFilesCheckBox);
      keepJavaFilesCheckBox.setBounds(8, 32, 424, 23);
      
      knownOptionsPanel.add(xmlSaxParserText);
      xmlSaxParserText.setBounds(12, 80, 424, 21);
      
      jLabel1.setText("XLM Parser Class( property org.xml.sax.driver)");
      knownOptionsPanel.add(jLabel1);
      jLabel1.setBounds(12, 64, 420, 15);
      
      jLabel2.setText("Jasper Compiile Directory( property jasper.reports.compile.temp )");
      knownOptionsPanel.add(jLabel2);
      jLabel2.setBounds(12, 108, 416, 15);
      
      knownOptionsPanel.add(compileDirText);
      compileDirText.setBounds(12, 124, 424, 21);
      
      jLabel3.setText("Overridden Classpath (property jasper.reports.compile.class.path )");
      knownOptionsPanel.add(jLabel3);
      jLabel3.setBounds(12, 156, 420, 15);
      
      knownOptionsPanel.add(overriddenClasspathText);
      overriddenClasspathText.setBounds(12, 172, 424, 21);
      
      knownPanelScrollPane.setViewportView(knownOptionsPanel);
      
      knownPanel.add(knownPanelScrollPane, "card2");
      
      jTabbedPane1.addTab("Options", knownPanel);
      
      genericPanel.setLayout(new java.awt.CardLayout());
      
      genericTable.setModel(new javax.swing.table.DefaultTableModel(
      new Object [][]
      {
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null},
         {null, null}
      },
      new String []
      {
         "Option/Property Name", "Value"
      }
      )
      {
         Class[] types = new Class []
         {
            java.lang.String.class, java.lang.String.class
         };
         
         public Class getColumnClass(int columnIndex)
         {
            return types [columnIndex];
         }
      });
      genericTable.setDoubleBuffered(true);
      genericScrollPane.setViewportView(genericTable);
      
      genericPanel.add(genericScrollPane, "card2");
      
      jTabbedPane1.addTab("System Properties", genericPanel);
      
      optionsPanel.add(jTabbedPane1, "Options");
      
      getContentPane().add(optionsPanel, java.awt.BorderLayout.CENTER);
      
      pack();
   }
   
   // Code for dispatching events from components to event handlers.
   
   private class FormListener implements java.awt.event.ActionListener, java.awt.event.WindowListener, java.beans.PropertyChangeListener
   {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
         if (evt.getSource() == compileDirCheckBox)
         {
            ReportUtilitiesOptionsDialog.this.compileDirCheckBoxActionPerformed(evt);
         }
         else if (evt.getSource() == okButton)
         {
            ReportUtilitiesOptionsDialog.this.okButtonActionPerformed(evt);
         }
         else if (evt.getSource() == cancelButton)
         {
            ReportUtilitiesOptionsDialog.this.cancelButtonActionPerformed(evt);
         }
      }
      
      public void windowActivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosed(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosing(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == ReportUtilitiesOptionsDialog.this)
         {
            ReportUtilitiesOptionsDialog.this.closeDialog(evt);
         }
      }
      
      public void windowDeactivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowDeiconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowIconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowOpened(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == ReportUtilitiesOptionsDialog.this)
         {
            ReportUtilitiesOptionsDialog.this.formWindowOpened(evt);
         }
      }
      
      public void propertyChange(java.beans.PropertyChangeEvent evt)
      {
         if (evt.getSource() == compileDirCheckBox)
         {
            ReportUtilitiesOptionsDialog.this.compileDirCheckBoxPropertyChange(evt);
         }
      }
   }//GEN-END:initComponents

   private void formWindowOpened(java.awt.event.WindowEvent evt)//GEN-FIRST:event_formWindowOpened
   {//GEN-HEADEREND:event_formWindowOpened
      //ok, so now we need to populate this Dialog.
      //first we'll populate the table.
      
      javax.swing.table.DefaultTableModel m = (javax.swing.table.DefaultTableModel)this.genericTable.getModel();
      
      //we need the System properties
      Object[] keys = System.getProperties().keySet().toArray();
      
      //now loop the keys.
      String key = null;
      String val = null;
      for( int i = 0; i < keys.length; i++ )
      {
         key = (String)keys[i];
         val = System.getProperty(key);
         val = val == null ? "" : val;
         if( i+1 > m.getRowCount())
         {
            Object[] os = new Object[2];
            os[1] = "";
            os[2] = "";
            m.addRow(os);
         }
         m.setValueAt(key, i, 0);
         m.setValueAt(val, i, 1);
      }
      
      //ok, now we need to set the static fields.
      String parserClass = System.getProperty("org.xml.sax.driver");
      if( parserClass != null && parserClass.length() > 0 )
      {
         this.xmlSaxParserText.setText( parserClass );
      }
      String compileTemp = System.getProperty("jasper.reports.compile.temp");
      if( compileTemp != null && compileTemp.length() > 0 )
      {
         this.compileDirText.setText( compileTemp );
      }
      String classpath = System.getProperty("jasper.reports.compile.class.path");
      if( classpath != null && classpath.length() > 0 )
      {
         this.overriddenClasspathText.setText( classpath );
      }
      String useFileDir = System.getProperty(ReportUtilities.PROPERTY_FILE_DIR_IS_COMPILE_DIR);
      if( useFileDir != null && useFileDir.trim().toLowerCase().equals("true"))
      {
         this.compileDirCheckBox.setSelected(true);
      }
      else
      {
         this.compileDirCheckBox.setSelected(false);
      }
      String keepJava = System.getProperty("jasper.reports.compile.keep.java.file");
      if( keepJava != null && keepJava.trim().toLowerCase().equals("true"))
      {
         this.keepJavaFilesCheckBox.setSelected(true);
      }
      else
      {
         this.keepJavaFilesCheckBox.setSelected(false);
      }      
   }//GEN-LAST:event_formWindowOpened

   private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
   {//GEN-HEADEREND:event_cancelButtonActionPerformed
      this.userCloseDialog();
   }//GEN-LAST:event_cancelButtonActionPerformed

   private void okButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_okButtonActionPerformed
   {//GEN-HEADEREND:event_okButtonActionPerformed
      //this means that we need to take the values from this window and set them back into
      //system properties.
      
      //the first thing for the correct order is to take the values from the generic table.
      //this is because the other tabs components will override any settings in these.
      javax.swing.table.DefaultTableModel m = (javax.swing.table.DefaultTableModel)this.genericTable.getModel();
      for( int i = 0; i < m.getRowCount(); i++)
      {
         String pname = (String)m.getValueAt(i, 0);
         String pval = (String)m.getValueAt(i, 1);
         pval = pval == null ? "" : pval;
         if( pname != null && pname.length() > 0 )
         {
            System.setProperty(pname, pval);
         }
      }
      
      //now we need to set the values from the text fields.
      String saxDriver = this.xmlSaxParserText.getText().trim();
      if( saxDriver.length() > 0 )
      {
         System.setProperty("org.xml.sax.driver", saxDriver);
      }
      String compileDirectory = this.compileDirText.getText().trim();
      if( compileDirectory.length() > 0 )
      {
         System.setProperty("jasper.reports.compile.temp", compileDirectory);
      }
      String classpath = this.overriddenClasspathText.getText().trim();
      if( classpath.length() > 0 )
      {
         System.setProperty("jasper.reports.compile.class.path", classpath);
      }
      boolean useFileDirectory = this.compileDirCheckBox.isSelected();
      if( useFileDirectory )
      {
         System.setProperty(ReportUtilities.PROPERTY_FILE_DIR_IS_COMPILE_DIR, "true");
      }
      boolean keepJava = this.keepJavaFilesCheckBox.isSelected();
      if( keepJava )
      {
         System.setProperty("jasper.reports.compile.keep.java.file", "true");
      }
      this.userOption = OK_OPTION;
      this.hide();
      
      
   }//GEN-LAST:event_okButtonActionPerformed

   private void compileDirCheckBoxActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_compileDirCheckBoxActionPerformed
   {//GEN-HEADEREND:event_compileDirCheckBoxActionPerformed
      if( this.compileDirCheckBox.isSelected() )
      {
         ReportUtilities p = null;
         p = this.getParent() instanceof ReportUtilities ? (ReportUtilities)this.getParent() : null;
         if(p!=null)
         {
            p.writeErrorToConsole("The box is checked.");
         }
      }
      else
      {
         
      }
   }//GEN-LAST:event_compileDirCheckBoxActionPerformed

   private void compileDirCheckBoxPropertyChange(java.beans.PropertyChangeEvent evt)//GEN-FIRST:event_compileDirCheckBoxPropertyChange
   {//GEN-HEADEREND:event_compileDirCheckBoxPropertyChange
      
   }//GEN-LAST:event_compileDirCheckBoxPropertyChange
   
   /** Closes the dialog */
   private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
   {
      this.userCloseDialog();
   }//GEN-LAST:event_closeDialog
   
   /**
    * @param args the command line arguments
    */
   public static void main(String args[])
   {
      new ReportUtilitiesOptionsDialog(new javax.swing.JFrame(), true).show();
   }
   
   public void userCloseDialog()
   {
      this.userOption = CANCEL_OPTION;
      hide();
   }
   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   protected javax.swing.JPanel buttonsPanel;
   protected javax.swing.JButton cancelButton;
   protected javax.swing.JCheckBox compileDirCheckBox;
   protected javax.swing.JTextField compileDirText;
   protected javax.swing.JPanel genericPanel;
   protected javax.swing.JScrollPane genericScrollPane;
   protected javax.swing.JTable genericTable;
   protected javax.swing.JLabel jLabel1;
   protected javax.swing.JLabel jLabel2;
   protected javax.swing.JLabel jLabel3;
   protected javax.swing.JTabbedPane jTabbedPane1;
   protected javax.swing.JCheckBox keepJavaFilesCheckBox;
   protected javax.swing.JPanel knownOptionsPanel;
   protected javax.swing.JPanel knownPanel;
   protected javax.swing.JScrollPane knownPanelScrollPane;
   protected javax.swing.JButton okButton;
   protected javax.swing.JPanel optionsButtonsPanel;
   protected javax.swing.JPanel optionsPanel;
   protected javax.swing.JTextField overriddenClasspathText;
   protected javax.swing.JTextField xmlSaxParserText;
   // End of variables declaration//GEN-END:variables
   
   /**
    *Method for showing a Dialog to allow the user to set the properties.
    *@param parent the parent for the window.
    *@param options a map which is used to display the options.
    */
   public static int showOptionsDialog(java.awt.Component parent)
   {
      java.awt.Frame p = DialogUtilities.frameFromComponent(parent);
      ReportUtilitiesOptionsDialog d = new ReportUtilitiesOptionsDialog(p, true);
      d.show();
      d.dispose();
      return d.userOption;
   }//end showOptionsDialog
   
}
