/*
 * DialogException.java
 *
 * Created on February 15, 2004, 11:18 PM
 */

package dori.jasper.util.gui;

/**
 * Class used for specialized exceptions.  Good for dialogs.
 * @author  Wade Chandler
 * @version 1.0
 */
public class DialogException 
extends java.lang.Exception
{
   
   /** used for titles */
   protected String title = null;
   
   /**
    * Creates a new instance of <code>DialogException</code> without detail message.
    */
   public DialogException()
   {
      super();
      this.title = "";
   }
   
   
   /**
    * Constructs an instance of <code>DialogException</code> with the specified detail message.
    * @param msg the detail message.
    */
   public DialogException(String msg)
   {
      super(msg);
      this.title = "";
   }
   
   /**
    * Constructs an instance of <code>DialogException</code> with the specified detail message.
    * @param msg the detail message.
    * @param title the title for the exception
    */
   public DialogException(String msg, String title)
   {
      super(msg);
      this.title = title;
   }   
   
   /**
    * Getter for property title.
    * @return Value of property title.
    */
   public java.lang.String getTitle()
   {
      return title;
   }
   
   /**
    * Setter for property title.
    * @param title New value of property title.
    */
   public void setTitle(java.lang.String title)
   {
      this.title = title;
   }
   
}//end class DialogException
