/*
 * DatabaseConnectionManager.java
 *
 * Created on February 12, 2004, 10:32 PM
 */

package dori.jasper.util.gui;

import dori.jasper.util.*;

/**
 * Class used to manage the database connections.
 * @author  Wade Chandler
 * @version 1.0
 */
public class DatabaseConnectionManagerDialog 
extends javax.swing.JDialog
implements java.io.Serializable
{
   
   /** used to show and manage the database connections. */
   protected DatabaseConnectionInfoManager dbInfo = null;
   
   /** used to display the connection info */
   protected DatabaseConnectionEditorDialog editor = null;
   
   /** Creates new form DatabaseConnectionManager */
   public DatabaseConnectionManagerDialog(java.awt.Frame parent, boolean modal)
   {
      super(parent, modal);
      initComponents();
      this.dbInfo = new DatabaseConnectionInfoManager(100);
      this.editor = null;
   }//end DatabaseConnectionManagerDialog
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   private void initComponents()//GEN-BEGIN:initComponents
   {
      connectionsPanel = new javax.swing.JPanel();
      connectionsScrollPane = new javax.swing.JScrollPane();
      connectionsTable = new javax.swing.JTable();
      buttonsPanel = new javax.swing.JPanel();
      newButton = new javax.swing.JButton();
      modifyButton = new javax.swing.JButton();
      deleteButton = new javax.swing.JButton();
      closeButton = new javax.swing.JButton();
      
      FormListener formListener = new FormListener();
      
      setTitle("Database Connections");
      addWindowListener(formListener);
      
      connectionsPanel.setLayout(new java.awt.CardLayout());
      
      connectionsScrollPane.setDoubleBuffered(true);
      connectionsScrollPane.setAutoscrolls(true);
      connectionsTable.setModel(new javax.swing.table.DefaultTableModel(
      new Object [][]
      {
         
      },
      new String []
      {
         "Connection Name", "JDBC Driver"
      }
      )
      {
         Class[] types = new Class []
         {
            java.lang.String.class, java.lang.String.class
         };
         boolean[] canEdit = new boolean []
         {
            false, false
         };
         
         public Class getColumnClass(int columnIndex)
         {
            return types [columnIndex];
         }
         
         public boolean isCellEditable(int rowIndex, int columnIndex)
         {
            return canEdit [columnIndex];
         }
      });
      connectionsTable.setDoubleBuffered(true);
      connectionsScrollPane.setViewportView(connectionsTable);
      
      connectionsPanel.add(connectionsScrollPane, "card2");
      
      getContentPane().add(connectionsPanel, java.awt.BorderLayout.CENTER);
      
      buttonsPanel.setPreferredSize(new java.awt.Dimension(10, 30));
      newButton.setText("New");
      newButton.setPreferredSize(new java.awt.Dimension(75, 26));
      newButton.addActionListener(formListener);
      
      buttonsPanel.add(newButton);
      
      modifyButton.setText("Modify");
      modifyButton.setPreferredSize(new java.awt.Dimension(75, 26));
      modifyButton.addActionListener(formListener);
      
      buttonsPanel.add(modifyButton);
      
      deleteButton.setText("Delete");
      deleteButton.setPreferredSize(new java.awt.Dimension(75, 26));
      deleteButton.addActionListener(formListener);
      
      buttonsPanel.add(deleteButton);
      
      closeButton.setText("Close");
      closeButton.setPreferredSize(new java.awt.Dimension(75, 26));
      closeButton.addActionListener(formListener);
      
      buttonsPanel.add(closeButton);
      
      getContentPane().add(buttonsPanel, java.awt.BorderLayout.SOUTH);
      
      pack();
   }
   
   // Code for dispatching events from components to event handlers.
   
   private class FormListener implements java.awt.event.ActionListener, java.awt.event.WindowListener
   {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
         if (evt.getSource() == newButton)
         {
            DatabaseConnectionManagerDialog.this.newButtonActionPerformed(evt);
         }
         else if (evt.getSource() == modifyButton)
         {
            DatabaseConnectionManagerDialog.this.modifyButtonActionPerformed(evt);
         }
         else if (evt.getSource() == deleteButton)
         {
            DatabaseConnectionManagerDialog.this.deleteButtonActionPerformed(evt);
         }
         else if (evt.getSource() == closeButton)
         {
            DatabaseConnectionManagerDialog.this.closeButtonActionPerformed(evt);
         }
      }
      
      public void windowActivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosed(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosing(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == DatabaseConnectionManagerDialog.this)
         {
            DatabaseConnectionManagerDialog.this.closeDialog(evt);
         }
      }
      
      public void windowDeactivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowDeiconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowIconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowOpened(java.awt.event.WindowEvent evt)
      {
      }
   }//GEN-END:initComponents

   private void closeButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_closeButtonActionPerformed
   {//GEN-HEADEREND:event_closeButtonActionPerformed
      // TODO add your handling code here:
      this.closeDialog();
   }//GEN-LAST:event_closeButtonActionPerformed

   private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_deleteButtonActionPerformed
   {//GEN-HEADEREND:event_deleteButtonActionPerformed
      // TODO add your handling code here:
      try
      {
         this.deleteDatabaseConnectionInfo();
      }
      catch(Throwable e)
      {
         //TODO popup
      }
   }//GEN-LAST:event_deleteButtonActionPerformed
   
   private void modifyButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_modifyButtonActionPerformed
   {//GEN-HEADEREND:event_modifyButtonActionPerformed
      // TODO add your handling code here:
      try
      {
         this.modifyDatabaseConnectionInfo();
      }
      catch(Throwable e)
      {
         //TODO popup
      }      
   }//GEN-LAST:event_modifyButtonActionPerformed
   
   private void newButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_newButtonActionPerformed
   {//GEN-HEADEREND:event_newButtonActionPerformed
      // TODO add your handling code here:
      try
      {
         this.newDatabaseConnectionInfo();
      }
      catch(Throwable e)
      {
         //TODO popup
      }
   }//GEN-LAST:event_newButtonActionPerformed
   
   /** Closes the dialog */
   private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
   {
      this.closeDialog();
   }//GEN-LAST:event_closeDialog
   
   /**
    * @param args the command line arguments
    */
   public static void main(String args[])
   {
      new DatabaseConnectionManagerDialog(new javax.swing.JFrame(), true).show();
   }
   
   /**
    *Used to access the DatabaseConnectionInfo manager class.
    *@return the DatabaseConnectionInfoManager for this Dialog.
    */
   public DatabaseConnectionInfoManager getDatabaseConnectionInfoManager()
   {
      return this.dbInfo;
   }//end getDatabaseConnectionInfoManager
   
   public void setDatabaseConnectionInfoManager(DatabaseConnectionInfoManager dbInfoManager)
   {
      this.dbInfo = dbInfoManager;
      java.util.Vector data = dbInfoManager.getDatabaseConnectionInfoKeysAndDrivers();
      javax.swing.table.DefaultTableModel m = (javax.swing.table.DefaultTableModel)this.connectionsTable.getModel();
      int colCount = m.getColumnCount();
      java.util.Vector cols = new java.util.Vector(colCount);
      for(int i = 0; i<colCount;i++)
      {
         cols.addElement( m.getColumnName(i) );
      }
      m.setDataVector(data, cols);
   }//end setDatabaseConnectionInfoManager
   
   public void newDatabaseConnectionInfo()
   {
      this.editor = new DatabaseConnectionEditorDialog(DialogUtilities.frameFromComponent(this), true);
      try
      {
         DatabaseConnectionInfo info = null;
         if( this.editor.showCreateDatabaseConnectionInfoDialog() == this.editor.OK_OPTION )
         {
            info = this.editor.getDatabaseConnectionInfo();
            if(info != null)
            {
               String name = info.getInfoName();
               this.dbInfo.setDatabaseConnectionInfo( name, info );
               //now we need to update the table.
               javax.swing.table.DefaultTableModel m = (javax.swing.table.DefaultTableModel)this.connectionsTable.getModel();
               Object[] row = new Object[2];
               row[0] = name;
               row[1] = info.getDriver();
               m.addRow(row);
            }//end if info is not null
         }//end if OK_OPTION
      }
      catch(Throwable e)
      {
         //may put a popup here.
      }
      finally
      {
         this.editor = null;
      }
   }//end newDatabaseConnectionInfo
   
   public void modifyDatabaseConnectionInfo()
   {
      int selectedRow = this.connectionsTable.getSelectedRow();
      if( selectedRow != -1)
      {
         
         this.editor = new DatabaseConnectionEditorDialog(DialogUtilities.frameFromComponent(this), true);
         try
         {
            javax.swing.table.DefaultTableModel m = (javax.swing.table.DefaultTableModel)this.connectionsTable.getModel();
            String name = (String)m.getValueAt(selectedRow, 0);
            DatabaseConnectionInfo info = this.dbInfo.getDatabaseConnectionInfo(name);
            if( info != null )
            {
               if( this.editor.showModifyDatabaseConnectionInfoDialog( info ) == this.editor.OK_OPTION )
               {
                  info = this.editor.getDatabaseConnectionInfo();
                  if( info != null )
                  {
                     //ok, so we know we edited this info correctly.  Now we need to reset the row
                     //just in case the driver has changed.  currently the name could not have
                     //changed.
                     m.setValueAt( info.getDriver(), selectedRow, 1 );
                     this.dbInfo.setDatabaseConnectionInfo( name, info );
                  }//end if info is not null ...after modify/edit
               }//end if OK_OPTION
            }//end if info is not null
         }
         catch(Throwable e)
         {
            //may put a popup here.
         }
         finally
         {
            this.editor = null;
         }
      }//end if row selected
   }//end modifyDatabaseConnectionInfo
   
   public void deleteDatabaseConnectionInfo()
   {
      javax.swing.table.DefaultTableModel m = (javax.swing.table.DefaultTableModel)this.connectionsTable.getModel();
      int selectedIndex = this.connectionsTable.getSelectedRow();
      if( selectedIndex != -1 )
      {
         String name = (String)m.getValueAt(selectedIndex, 0);
         m.removeRow(selectedIndex);
         this.dbInfo.removeDatabaseConnectionInfo( name );
      }//end if there is a selected row
   }//end deleteDatabaseConnectionInfo
   
   public void closeDialog()
   {
      this.hide();
      this.setVisible(false);
   }//end closeDialog
   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   protected javax.swing.JPanel buttonsPanel;
   protected javax.swing.JButton closeButton;
   protected javax.swing.JPanel connectionsPanel;
   protected javax.swing.JScrollPane connectionsScrollPane;
   protected javax.swing.JTable connectionsTable;
   protected javax.swing.JButton deleteButton;
   protected javax.swing.JButton modifyButton;
   protected javax.swing.JButton newButton;
   // End of variables declaration//GEN-END:variables
   
}
