/*
 * DatabaseConnectionEditorDialog.java
 *
 * Created on February 12, 2004, 10:48 PM
 */

package dori.jasper.util.gui;

import dori.jasper.util.*;

/**
 * Class used to edit or create a DatabaseConnectionInfo object as a Dialog.
 * @author  Wade Chandler
 * @version 1.0
 */
public class DatabaseConnectionEditorDialog extends javax.swing.JDialog
implements java.io.Serializable
{

   /** used to hold the DatabaseConnectionInfo data. */
   protected DatabaseConnectionInfo connectionInfo = null;
   
   /** this is the OK_OPTION for the return from a Dialog showing. */
   public static final int OK_OPTION = 1;
   
   /** this is the CANCEL_OPTION for the return from a Dialog showing. */
   public static final int CANCEL_OPTION = 2;
   
   /** this is used to keep track of the selected option */
   protected int userChoice = CANCEL_OPTION;
   
   /** Creates new form DatabaseConnectionEditorDialog */
   public DatabaseConnectionEditorDialog(java.awt.Frame parent, boolean modal)
   {
      super(parent, modal);
      initComponents();
      connectionInfo = null;
      try
      {
         //we need to use teh database driver names and url examples here.
         Object[] names = DatabaseDriverNameAndURLExamples.getDriverNames();
         if( names != null )
         {
            for(int i = 0; i < names.length; i++)
            {
               this.driverClassComboBox.addItem( names[i] );
            }
         }
      }
      catch(Throwable t)
      {
         //don't do anything.
      }
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   private void initComponents()//GEN-BEGIN:initComponents
   {
      connectionInfoPanel = new javax.swing.JPanel();
      jLabel2 = new javax.swing.JLabel();
      jLabel1 = new javax.swing.JLabel();
      jLabel3 = new javax.swing.JLabel();
      jLabel4 = new javax.swing.JLabel();
      jLabel5 = new javax.swing.JLabel();
      jLabel6 = new javax.swing.JLabel();
      connectionNameText = new javax.swing.JTextField();
      driverClassComboBox = new javax.swing.JComboBox();
      driverUrlText = new javax.swing.JTextField();
      driverUrlExampleButton = new javax.swing.JButton();
      databaseNameText = new javax.swing.JTextField();
      userIdText = new javax.swing.JTextField();
      passwordText = new javax.swing.JTextField();
      buttonPanel = new javax.swing.JPanel();
      okButton = new javax.swing.JButton();
      cancelButton = new javax.swing.JButton();
      testButton = new javax.swing.JButton();
      
      FormListener formListener = new FormListener();
      
      getContentPane().setLayout(new java.awt.BorderLayout(5, 5));
      
      setTitle("Edit Database Connection");
      addWindowListener(formListener);
      
      connectionInfoPanel.setLayout(null);
      
      connectionInfoPanel.setPreferredSize(new java.awt.Dimension(416, 170));
      jLabel2.setText("Connection Name:");
      connectionInfoPanel.add(jLabel2);
      jLabel2.setBounds(4, 4, 104, 15);
      
      jLabel1.setText("Driver Class:");
      connectionInfoPanel.add(jLabel1);
      jLabel1.setBounds(4, 28, 78, 15);
      
      jLabel3.setText("Driver URL:");
      connectionInfoPanel.add(jLabel3);
      jLabel3.setBounds(4, 52, 78, 15);
      
      jLabel4.setText("Database Name:");
      connectionInfoPanel.add(jLabel4);
      jLabel4.setBounds(4, 76, 100, 15);
      
      jLabel5.setText("User ID:");
      connectionInfoPanel.add(jLabel5);
      jLabel5.setBounds(4, 100, 78, 15);
      
      jLabel6.setText("Password:");
      connectionInfoPanel.add(jLabel6);
      jLabel6.setBounds(4, 124, 78, 15);
      
      connectionInfoPanel.add(connectionNameText);
      connectionNameText.setBounds(108, 4, 308, 21);
      
      connectionInfoPanel.add(driverClassComboBox);
      driverClassComboBox.setBounds(108, 28, 308, 20);
      
      connectionInfoPanel.add(driverUrlText);
      driverUrlText.setBounds(108, 52, 216, 21);
      
      driverUrlExampleButton.setText("Example");
      driverUrlExampleButton.addActionListener(formListener);
      
      connectionInfoPanel.add(driverUrlExampleButton);
      driverUrlExampleButton.setBounds(328, 52, 88, 20);
      
      connectionInfoPanel.add(databaseNameText);
      databaseNameText.setBounds(108, 76, 308, 21);
      
      connectionInfoPanel.add(userIdText);
      userIdText.setBounds(108, 100, 308, 21);
      
      connectionInfoPanel.add(passwordText);
      passwordText.setBounds(108, 124, 308, 21);
      
      getContentPane().add(connectionInfoPanel, java.awt.BorderLayout.CENTER);
      
      buttonPanel.setPreferredSize(new java.awt.Dimension(10, 30));
      okButton.setText("OK");
      okButton.setPreferredSize(new java.awt.Dimension(80, 26));
      okButton.addActionListener(formListener);
      
      buttonPanel.add(okButton);
      
      cancelButton.setText("CANCEL");
      cancelButton.addActionListener(formListener);
      
      buttonPanel.add(cancelButton);
      
      testButton.setText("TEST");
      testButton.setPreferredSize(new java.awt.Dimension(75, 25));
      buttonPanel.add(testButton);
      
      getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
      
      pack();
   }
   
   // Code for dispatching events from components to event handlers.
   
   private class FormListener implements java.awt.event.ActionListener, java.awt.event.WindowListener
   {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
         if (evt.getSource() == okButton)
         {
            DatabaseConnectionEditorDialog.this.okButtonActionPerformed(evt);
         }
         else if (evt.getSource() == cancelButton)
         {
            DatabaseConnectionEditorDialog.this.cancelButtonActionPerformed(evt);
         }
         else if (evt.getSource() == driverUrlExampleButton)
         {
            DatabaseConnectionEditorDialog.this.driverUrlExampleButtonActionPerformed(evt);
         }
      }
      
      public void windowActivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosed(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosing(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == DatabaseConnectionEditorDialog.this)
         {
            DatabaseConnectionEditorDialog.this.closeDialog(evt);
         }
      }
      
      public void windowDeactivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowDeiconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowIconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowOpened(java.awt.event.WindowEvent evt)
      {
      }
   }//GEN-END:initComponents

   private void driverUrlExampleButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_driverUrlExampleButtonActionPerformed
   {//GEN-HEADEREND:event_driverUrlExampleButtonActionPerformed
      // TODO add your handling code here:
      if( this.driverClassComboBox.getSelectedIndex() != -1 )
      {
         String key = (String)this.driverClassComboBox.getSelectedItem();
         String example = DatabaseDriverNameAndURLExamples.getExampleJdbcURL( key );
         if( example != null && example.trim().length() > 0 )
         {
            this.driverUrlText.setText( example );
         }
      }
      else
      {
         javax.swing.JOptionPane.showMessageDialog(this, "The driver must be selected first.", "Select driver", javax.swing.JOptionPane.INFORMATION_MESSAGE);
         
      }
   }//GEN-LAST:event_driverUrlExampleButtonActionPerformed

   private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
   {//GEN-HEADEREND:event_cancelButtonActionPerformed
      // TODO add your handling code here:
      this.connectionInfo = null;
      this.setVisible(false);
   }//GEN-LAST:event_cancelButtonActionPerformed

   private void okButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_okButtonActionPerformed
   {//GEN-HEADEREND:event_okButtonActionPerformed
      // Add your handling code here:
      try
      {
         this.checkFormInfo();
      }
      catch(DialogException de)
      {
         javax.swing.JOptionPane.showMessageDialog(this, de.toString(), de.getTitle(), javax.swing.JOptionPane.ERROR_MESSAGE);
         return;
      }
      this.userChoice = OK_OPTION;
      this.dispose();
      this.setVisible(false);
   }//GEN-LAST:event_okButtonActionPerformed
   
   /** Closes the dialog */
   private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
   {
      this.userChoice = CANCEL_OPTION;
      this.dispose();
      setVisible(false);
   }//GEN-LAST:event_closeDialog
   
   /**
    * @param args the command line arguments
    */
   public static void main(String args[])
   {
      javax.swing.JFrame frame = new javax.swing.JFrame();
      DatabaseConnectionEditorDialog d = new DatabaseConnectionEditorDialog(frame, true);
      d.show();
      frame.dispose();
      System.exit(0);
   }
   
   /**
    *Gets the DatabaseConnectionInfo from this Dialog.  This should not be read if a
    *showing of the dialog returns CANCEL_OPTION.
    *@return the DatabaseConnectionInfo which is set from showing the dialog.
    */
   public DatabaseConnectionInfo getDatabaseConnectionInfo()
   {
      return this.connectionInfo;
   }//end getDatabaseConnectionInfo
   
   /**
    *Method used to show the create dialog.
    *@return OK_OPTION or CANCEL_OPTION depending on user choice.
    */
   public int showCreateDatabaseConnectionInfoDialog()
   {
      boolean oldModal = this.isModal();
      try
      {
         this.setModal(true);
         this.show();
      }
      catch(Throwable e)
      {
         throw new RuntimeException(e);
      }
      finally
      {
         this.setModal(oldModal);
      }
      this.testAndCreateNewDatabaseConnectionInfo();
      return this.userChoice;
   }//end showCreateDatabaseConnectionInfoDialog
   
   /**
    *Method used to show the modify dialog.
    *@param info the info to modify
    *@return OK_OPTION or CANCEL_OPTION depending on user choice.
    */
   public int showModifyDatabaseConnectionInfoDialog(DatabaseConnectionInfo info)
   {
      this.connectionNameText.setEnabled(false);
      this.copyDatabaseConnectionInfoToGui(info);
      boolean oldModal = this.isModal();
      try
      {
         this.setModal(true);
         this.show();
      }
      finally
      {
         this.connectionNameText.setEnabled(true);
         this.setModal(oldModal);
      }
      this.testAndCreateNewDatabaseConnectionInfo();
      return this.userChoice;
   }//end showModifyDatabaseConnectionInfoDialog
   
   protected void copyDatabaseConnectionInfoToGui(DatabaseConnectionInfo info)
   {
      this.connectionNameText.setText( info.getInfoName() );
      this.driverUrlText.setText( info.getJdbcUrl() );
      this.driverClassComboBox.setSelectedItem( info.getDriver() );
      this.userIdText.setText( info.getDbUserName() );
      this.passwordText.setText( info.getDbPassword() );
      this.databaseNameText.setText( info.getDatabaseName() );
   }//end copyDatabaseConnectionInfoToGui
   
   protected void testAndCreateNewDatabaseConnectionInfo()
   {
      if( this.userChoice == this.OK_OPTION )
      {
         this.connectionInfo = this.createNewDatabaseConnectionInfo();
      }
      else
      {
         this.connectionInfo = null;
      }
   }//end testAndCreateNewDatabaseConnectionInfo
   
   protected DatabaseConnectionInfo createNewDatabaseConnectionInfo()
   {
      DatabaseConnectionInfo d = new DatabaseConnectionInfo();
      d.setDatabaseName( this.databaseNameText.getText() );
      d.setDbPassword( this.passwordText.getText() );
      d.setDbUserName( this.userIdText.getText() );
      d.setDriver( (String)this.driverClassComboBox.getSelectedItem() );
      d.setJdbcUrl( this.driverUrlText.getText() );
      d.setInfoName( this.connectionNameText.getText() );
      return d;
   }//end createNewDatabaseConnectionInfo
   
   protected void checkFormInfo()
   throws DialogException
   {
      if( this.connectionNameText.getText().trim().length() == 0 )
      {
         DialogException de = new DialogException("The connection name can not be empty or only white space.", "Connection name empty");
         throw de;
      }
      if( this.driverUrlText.getText().trim().length() == 0 )
      {
         DialogException de = new DialogException("The driver url can not be empty or contain only white space.", "Driver url empty");
         throw de;
      }
      if( this.driverClassComboBox.getSelectedIndex() == -1 )
      {
         DialogException de = new DialogException("The driver must be selected", "Driver not selected");
         throw de;         
      }
   }//end checkFormInfo
   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   protected javax.swing.JPanel buttonPanel;
   protected javax.swing.JButton cancelButton;
   protected javax.swing.JPanel connectionInfoPanel;
   protected javax.swing.JTextField connectionNameText;
   protected javax.swing.JTextField databaseNameText;
   protected javax.swing.JComboBox driverClassComboBox;
   protected javax.swing.JButton driverUrlExampleButton;
   protected javax.swing.JTextField driverUrlText;
   protected javax.swing.JLabel jLabel1;
   protected javax.swing.JLabel jLabel2;
   protected javax.swing.JLabel jLabel3;
   protected javax.swing.JLabel jLabel4;
   protected javax.swing.JLabel jLabel5;
   protected javax.swing.JLabel jLabel6;
   protected javax.swing.JButton okButton;
   protected javax.swing.JTextField passwordText;
   protected javax.swing.JButton testButton;
   protected javax.swing.JTextField userIdText;
   // End of variables declaration//GEN-END:variables
   
}
