/*
 * ReportUtilities.java
 *
 * Created on February 12, 2004, 2:12 PM
 */

package dori.jasper.util;

import dori.jasper.util.gui.*;
import dori.jasper.engine.*;
import dori.jasper.view.*;

/**
 * Class used for testing reports.  This is also good for adding new features
 * to Jasper reports.
 * @author  Wade Chandler
 * @version 1.0
 */
public class ReportUtilities extends javax.swing.JFrame
{
   
   /**  used to manage the Database Connections */
   protected DatabaseConnectionManagerDialog connectionManager = null;
   
   /** used to manage the Database Connections info */
   protected DatabaseConnectionInfoManager dbInfo = null;
   
   /** used to denote an XML file type */
   public static final String XML_FILE_TYPE = ".xml";
   
   /** used to denote a JASPER file type */
   public static final String JASPER_FILE_TYPE = ".jasper";
   
   /** used to denote a CLASS file type */
   public static final String CLASS_FILE_TYPE = ".class";
   
   /** used to denote a JRPRINT file type */
   public static final String JRPRINT_FILE_TYPE = ".jrprint";
   
   /** used to store a reference to a JRDesignViewer object */
   protected dori.jasper.view.JRDesignViewer designView = null;
   
   /** used to store a reference to a JRViewer object */
   protected dori.jasper.view.JRViewer reportView = null;
   
   /** used to tell what the current opened file type is.  Needed for different
    * operations. */
   protected String currentFileType = XML_FILE_TYPE;
   
   /** used to keep track of the file name.  This is used for Save, Save AS, and things like that. */
   protected String currentFileName = null;
   
   /** used to keep up with the document name number */
   protected int currentFileNameHelper = 0;
   
   /** used to represent a property name that tells the program to use the current file directory for compiling. */
   public static final String PROPERTY_FILE_DIR_IS_COMPILE_DIR = "jasper.util.report.utilities.fileDirIsCompileDir";
   
   /** Creates new form ReportUtilities */
   public ReportUtilities()
   {
      initComponents();
      dbInfo = null;
      connectionManager = new DatabaseConnectionManagerDialog(this, true);
      this.currentFileType = XML_FILE_TYPE;
      this.currentFileNameHelper = 0;
      java.util.HashMap map = new java.util.HashMap();
      try
      {
         map = (java.util.HashMap)Resource.loadObjectFromFile(Resource.REPORT_UTILS_APP_SETTINGS);
         String fileName = (String)map.get("selectedFile");
         String useFileDir = (String)map.get(PROPERTY_FILE_DIR_IS_COMPILE_DIR);
         if(useFileDir != null && useFileDir.toLowerCase().equals("true"))
         {
            System.setProperty(PROPERTY_FILE_DIR_IS_COMPILE_DIR, "true");
         }
         else
         {
            System.setProperty(PROPERTY_FILE_DIR_IS_COMPILE_DIR, "false");
         }
         String keepJava = (String)map.get("jasper.reports.compile.keep.java.file");
         if(useFileDir != null && useFileDir.toLowerCase().equals("true"))
         {
            System.setProperty("jasper.reports.compile.keep.java.file", "true");
         }
         else
         {
            System.setProperty("jasper.reports.compile.keep.java.file", "false");
         }         
         String compileDir = (String)map.get("jasper.reports.compile.temp");
         if(compileDir != null)
         {
            System.setProperty("jasper.reports.compile.temp", compileDir);
         }
         String classpath = (String)map.get("jasper.reports.compile.class.path");
         if(classpath != null)
         {
            System.setProperty("jasper.reports.compile.class.path", classpath);
         }
         java.io.File sf = new java.io.File( fileName );
         if( sf.exists() )
         {
            this.currentFileName = fileName;
            this.fileChooser.setSelectedFile( sf );
            this.setTitleToCurrentFileName();
            this.openXmlFile();
         }
         else
         {
            //the method sets current file and selected file
            String newFileName = this.getUniqueCurrentFileName();
         }
      }
      catch(Throwable t)
      {
         String newFileName = this.getUniqueCurrentFileName();
         this.writeErrorToConsole(t);
      }
      try
      {
         String fileName = Resource.DCM_CONFIG_FILE;
         //we'll try to load our saved file.  we'll save this file
         //everytime we close the application.  We'll provide a menu item
         //to save the system settings.  This will be part of the overall
         //settings.
         this.dbInfo = (DatabaseConnectionInfoManager)Resource.loadObjectFromFile(Resource.DCM_CONFIG_FILE);
      }
      catch(Throwable e)
      {
         this.writeErrorToConsole(e);
         this.dbInfo = new DatabaseConnectionInfoManager();
      }
      try
      {
         //we have to push this info into it's tabel.
         this.connectionManager.setDatabaseConnectionInfoManager( this.dbInfo );
      }
      catch(Throwable e)
      {
         this.writeErrorToConsole(e);
      }
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   private void initComponents()//GEN-BEGIN:initComponents
   {
      fileChooser = new javax.swing.JFileChooser();
      mainSplitPane = new javax.swing.JSplitPane();
      tabs = new javax.swing.JTabbedPane();
      xmlPanel = new javax.swing.JPanel();
      xmlScrollPane = new javax.swing.JScrollPane();
      xmlEditor = new javax.swing.JEditorPane();
      previewPanel = new javax.swing.JPanel();
      viewPanel = new javax.swing.JPanel();
      outputPanel = new javax.swing.JPanel();
      outputScrollPane = new javax.swing.JScrollPane();
      outputText = new javax.swing.JTextArea();
      mainMenu = new javax.swing.JMenuBar();
      applicationMenu = new javax.swing.JMenu();
      miApplicationOptions = new javax.swing.JMenuItem();
      miApplicationExit = new javax.swing.JMenuItem();
      fileMenu = new javax.swing.JMenu();
      miFileOpen = new javax.swing.JMenuItem();
      miFileNew = new javax.swing.JMenuItem();
      miFileSave = new javax.swing.JMenuItem();
      miFileSaveAs = new javax.swing.JMenuItem();
      miFileCompile = new javax.swing.JMenuItem();
      databaseMenu = new javax.swing.JMenu();
      miDatabaseConnections = new javax.swing.JMenuItem();
      miDatabaseSetActiveConnection = new javax.swing.JMenuItem();
      
      FormListener formListener = new FormListener();
      
      fileChooser.setAcceptAllFileFilterUsed(false);
      
      getContentPane().setLayout(new java.awt.CardLayout());
      
      setTitle(this.getDefaultTitle());
      addWindowListener(formListener);
      
      mainSplitPane.setDividerLocation(300);
      mainSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
      mainSplitPane.setAutoscrolls(true);
      tabs.addChangeListener(formListener);
      tabs.addComponentListener(formListener);
      tabs.addHierarchyListener(formListener);
      tabs.addPropertyChangeListener(formListener);
      
      xmlPanel.setLayout(new java.awt.CardLayout());
      
      xmlPanel.addComponentListener(formListener);
      
      xmlEditor.setDoubleBuffered(true);
      xmlScrollPane.setViewportView(xmlEditor);
      
      xmlPanel.add(xmlScrollPane, "card2");
      
      tabs.addTab("XML", xmlPanel);
      
      previewPanel.setLayout(new java.awt.CardLayout());
      
      previewPanel.addComponentListener(formListener);
      
      tabs.addTab("Preview", previewPanel);
      
      viewPanel.setLayout(new java.awt.CardLayout());
      
      tabs.addTab("View", viewPanel);
      
      mainSplitPane.setLeftComponent(tabs);
      
      outputPanel.setLayout(new java.awt.CardLayout());
      
      outputScrollPane.setViewportView(outputText);
      
      outputPanel.add(outputScrollPane, "card2");
      
      mainSplitPane.setRightComponent(outputPanel);
      
      getContentPane().add(mainSplitPane, "card3");
      
      applicationMenu.setText("Application");
      miApplicationOptions.setText("Options");
      miApplicationOptions.addActionListener(formListener);
      
      applicationMenu.add(miApplicationOptions);
      
      miApplicationExit.setText("Exit");
      miApplicationExit.addActionListener(formListener);
      
      applicationMenu.add(miApplicationExit);
      
      mainMenu.add(applicationMenu);
      
      fileMenu.setText("File");
      miFileOpen.setText("Open");
      miFileOpen.addActionListener(formListener);
      
      fileMenu.add(miFileOpen);
      
      miFileNew.setText("New");
      miFileNew.addActionListener(formListener);
      
      fileMenu.add(miFileNew);
      
      miFileSave.setText("Save");
      miFileSave.addActionListener(formListener);
      
      fileMenu.add(miFileSave);
      
      miFileSaveAs.setText("Save As");
      miFileSaveAs.addActionListener(formListener);
      
      fileMenu.add(miFileSaveAs);
      
      miFileCompile.setText("Compile");
      miFileCompile.addActionListener(formListener);
      
      fileMenu.add(miFileCompile);
      
      mainMenu.add(fileMenu);
      
      databaseMenu.setText("Database");
      miDatabaseConnections.setText("Connections");
      miDatabaseConnections.addActionListener(formListener);
      
      databaseMenu.add(miDatabaseConnections);
      
      miDatabaseSetActiveConnection.setText("Set Active Connection");
      miDatabaseSetActiveConnection.addActionListener(formListener);
      
      databaseMenu.add(miDatabaseSetActiveConnection);
      
      mainMenu.add(databaseMenu);
      
      setJMenuBar(mainMenu);
      
      pack();
   }
   
   // Code for dispatching events from components to event handlers.
   
   private class FormListener implements java.awt.event.ActionListener, java.awt.event.ComponentListener, java.awt.event.HierarchyListener, java.awt.event.WindowListener, java.beans.PropertyChangeListener, javax.swing.event.ChangeListener
   {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
         if (evt.getSource() == miApplicationExit)
         {
            ReportUtilities.this.miApplicationExitActionPerformed(evt);
         }
         else if (evt.getSource() == miFileOpen)
         {
            ReportUtilities.this.miFileOpenActionPerformed(evt);
         }
         else if (evt.getSource() == miFileNew)
         {
            ReportUtilities.this.miFileNewActionPerformed(evt);
         }
         else if (evt.getSource() == miFileSave)
         {
            ReportUtilities.this.miFileSaveActionPerformed(evt);
         }
         else if (evt.getSource() == miFileSaveAs)
         {
            ReportUtilities.this.miFileSaveAsActionPerformed(evt);
         }
         else if (evt.getSource() == miDatabaseConnections)
         {
            ReportUtilities.this.miDatabaseConnectionsActionPerformed(evt);
         }
         else if (evt.getSource() == miDatabaseSetActiveConnection)
         {
            ReportUtilities.this.miDatabaseSetActiveConnectionActionPerformed(evt);
         }
         else if (evt.getSource() == miApplicationOptions)
         {
            ReportUtilities.this.miApplicationOptionsActionPerformed(evt);
         }
         else if (evt.getSource() == miFileCompile)
         {
            ReportUtilities.this.miFileCompileActionPerformed(evt);
         }
      }
      
      public void componentHidden(java.awt.event.ComponentEvent evt)
      {
      }
      
      public void componentMoved(java.awt.event.ComponentEvent evt)
      {
      }
      
      public void componentResized(java.awt.event.ComponentEvent evt)
      {
      }
      
      public void componentShown(java.awt.event.ComponentEvent evt)
      {
         if (evt.getSource() == tabs)
         {
            ReportUtilities.this.tabsComponentShown(evt);
         }
         else if (evt.getSource() == xmlPanel)
         {
            ReportUtilities.this.xmlPanelComponentShown(evt);
         }
         else if (evt.getSource() == previewPanel)
         {
            ReportUtilities.this.previewPanelComponentShown(evt);
         }
      }
      
      public void hierarchyChanged(java.awt.event.HierarchyEvent evt)
      {
         if (evt.getSource() == tabs)
         {
            ReportUtilities.this.tabsHierarchyChanged(evt);
         }
      }
      
      public void windowActivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosed(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowClosing(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == ReportUtilities.this)
         {
            ReportUtilities.this.exitForm(evt);
         }
      }
      
      public void windowDeactivated(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowDeiconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowIconified(java.awt.event.WindowEvent evt)
      {
      }
      
      public void windowOpened(java.awt.event.WindowEvent evt)
      {
      }
      
      public void propertyChange(java.beans.PropertyChangeEvent evt)
      {
         if (evt.getSource() == tabs)
         {
            ReportUtilities.this.tabsPropertyChange(evt);
         }
      }
      
      public void stateChanged(javax.swing.event.ChangeEvent evt)
      {
         if (evt.getSource() == tabs)
         {
            ReportUtilities.this.tabsStateChanged(evt);
         }
      }
   }//GEN-END:initComponents

   private void miFileCompileActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miFileCompileActionPerformed
   {//GEN-HEADEREND:event_miFileCompileActionPerformed
      try
      {
         this.compileXmlFile();
      }
      catch(Throwable e)
      {
         this.writeErrorToConsole(e);
         this.showErrorMessage(e);
      }
   }//GEN-LAST:event_miFileCompileActionPerformed
   
   private void miApplicationOptionsActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miApplicationOptionsActionPerformed
   {//GEN-HEADEREND:event_miApplicationOptionsActionPerformed
      try
      {
         ReportUtilitiesOptionsDialog.showOptionsDialog(this);
      }
      catch(Throwable e)
      {
         this.showErrorMessage(e);
         this.writeErrorToConsole(e);
      }
   }//GEN-LAST:event_miApplicationOptionsActionPerformed
   
   private void miFileNewActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miFileNewActionPerformed
   {//GEN-HEADEREND:event_miFileNewActionPerformed
      try
      {
         this.getUniqueCurrentFileName();
         this.xmlEditor.setText("");
      }
      catch(Throwable e)
      {
         this.showErrorMessage(e);
         this.writeErrorToConsole(e);
      }
   }//GEN-LAST:event_miFileNewActionPerformed
   
   private void miFileSaveAsActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miFileSaveAsActionPerformed
   {//GEN-HEADEREND:event_miFileSaveAsActionPerformed
      this.saveFileAsSomethingElse();
   }//GEN-LAST:event_miFileSaveAsActionPerformed
   
   private void miFileSaveActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miFileSaveActionPerformed
   {//GEN-HEADEREND:event_miFileSaveActionPerformed
      if( this.isCurrentFileNameTheSelectedFile() )
      {
         this.saveFile();
      }
      else
      {
         this.saveFileAsSomethingElse();
      }
   }//GEN-LAST:event_miFileSaveActionPerformed
   
   private void xmlPanelComponentShown(java.awt.event.ComponentEvent evt)//GEN-FIRST:event_xmlPanelComponentShown
   {//GEN-HEADEREND:event_xmlPanelComponentShown
      try
      {
         
         if( this.designView != null )
         {
            this.previewPanel.remove(this.designView);
            this.designView = null;
         }
         if( this.reportView != null )
         {
            this.viewPanel.remove( this.reportView );
            this.reportView = null;
         }
      }
      catch(Throwable t)
      {
         this.showErrorMessage(t);
      }
      
   }//GEN-LAST:event_xmlPanelComponentShown
   
   private void previewPanelComponentShown(java.awt.event.ComponentEvent evt)//GEN-FIRST:event_previewPanelComponentShown
   {//GEN-HEADEREND:event_previewPanelComponentShown
      try
      {
         java.io.File f = this.fileChooser.getSelectedFile();
         if( !this.isSelectedFileReal() )
         {
            throw new DialogException("A file must first be loaded or saved for previewing and viewing.", "Load or save the file");
         }
         if( this.designView == null )
         {
            this.designView = new dori.jasper.view.JRDesignViewer(this.fileChooser.getSelectedFile().getAbsolutePath(), true);
            this.previewPanel.add(this.designView, "mainCard");
         }
         this.designView.setVisible(true);
         this.designView.repaint();
         this.previewPanel.revalidate();
         
      }
      catch(Throwable t)
      {
         this.showErrorMessage(t);
         return;
      }
   }//GEN-LAST:event_previewPanelComponentShown
   
   private void tabsHierarchyChanged(java.awt.event.HierarchyEvent evt)//GEN-FIRST:event_tabsHierarchyChanged
   {//GEN-HEADEREND:event_tabsHierarchyChanged
      
   }//GEN-LAST:event_tabsHierarchyChanged
   
   private void tabsPropertyChange(java.beans.PropertyChangeEvent evt)//GEN-FIRST:event_tabsPropertyChange
   {//GEN-HEADEREND:event_tabsPropertyChange
      
   }//GEN-LAST:event_tabsPropertyChange
   
   private void tabsStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_tabsStateChanged
   {//GEN-HEADEREND:event_tabsStateChanged
      
   }//GEN-LAST:event_tabsStateChanged
   
   private void tabsComponentShown(java.awt.event.ComponentEvent evt)//GEN-FIRST:event_tabsComponentShown
   {//GEN-HEADEREND:event_tabsComponentShown
      
   }//GEN-LAST:event_tabsComponentShown
   
   private void miFileOpenActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miFileOpenActionPerformed
   {//GEN-HEADEREND:event_miFileOpenActionPerformed
      try
      {
         this.openFile();
      }
      catch(Throwable e)
      {
         this.showErrorMessage(e);
      }
   }//GEN-LAST:event_miFileOpenActionPerformed
   
   private void miDatabaseSetActiveConnectionActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miDatabaseSetActiveConnectionActionPerformed
   {//GEN-HEADEREND:event_miDatabaseSetActiveConnectionActionPerformed
      //we only need to set the active connection.
      //there is nothing special we really have to do here.
      try
      {
         ActiveDatabaseConnectionDialog.showActiveDatabaseConnectionDialog(this, this.dbInfo);
      }
      catch(Throwable e)
      {
         //todo popup here
      }
   }//GEN-LAST:event_miDatabaseSetActiveConnectionActionPerformed
   
   private void miDatabaseConnectionsActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miDatabaseConnectionsActionPerformed
   {//GEN-HEADEREND:event_miDatabaseConnectionsActionPerformed
      try
      {
         this.connectionManager.setModal(true);
         this.connectionManager.show();
      }
      catch(Throwable e)
      {
         javax.swing.JOptionPane.showMessageDialog(this, e.toString(), "Error in application", javax.swing.JOptionPane.ERROR_MESSAGE);
      }
   }//GEN-LAST:event_miDatabaseConnectionsActionPerformed
   
   private void miApplicationExitActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_miApplicationExitActionPerformed
   {//GEN-HEADEREND:event_miApplicationExitActionPerformed
      this.exitApplication();
   }//GEN-LAST:event_miApplicationExitActionPerformed
   
   /** Exit the Application */
   private void exitForm(java.awt.event.WindowEvent evt)//GEN-FIRST:event_exitForm
   {
      this.exitApplication();
   }//GEN-LAST:event_exitForm
   
   /**
    * @param args the command line arguments
    */
   public static void main(String args[])
   {
      ReportUtilities r = new ReportUtilities();
      r.show();
      try
      {
         java.util.HashMap map = (java.util.HashMap)Resource.loadObjectFromFile(Resource.REPORT_UTILS_APP_SETTINGS);
         String selectedFile = (String)map.get("selectedFile");
         if(selectedFile != null && selectedFile.length() > 0)
         {
            r.fileChooser.setSelectedFile(new java.io.File(selectedFile));
         }
      }
      catch(Throwable t)
      {
         t.printStackTrace();
      }
      
   }//end main
   
   
   /**
    *Used to exit the application.
    *currently there are no checks.  It just exits the application.
    */
   public void exitApplication()
   {
      //we need to try to save the settings
      try
      {
         try
         {
            java.util.HashMap map = new java.util.HashMap(10);
            map.put("selectedFile", this.fileChooser.getSelectedFile().getAbsolutePath());
            String useFileDir = System.getProperty(PROPERTY_FILE_DIR_IS_COMPILE_DIR);
            if( useFileDir != null )
            {
               map.put(PROPERTY_FILE_DIR_IS_COMPILE_DIR, useFileDir );
            }
            String compileDir = System.getProperty("jasper.reports.compile.temp");
            if(compileDir != null)
            {
               map.put("jasper.reports.compile.temp", compileDir);
            }
            String classpath = System.getProperty("jasper.reports.compile.class.path");
            if(classpath != null)
            {
               System.setProperty("jasper.reports.compile.class.path", classpath);
            }
            String keepJava = System.getProperty("jasper.reports.compile.keep.java.file");
            if(keepJava != null)
            {
               if( keepJava.trim().toLowerCase().equals("true") )
               {
                  System.setProperty("jasper.reports.compile.keep.java.file", "true");
               }
               else
               {
                  System.setProperty("jasper.reports.compile.keep.java.file", "false");
               }
            }
            Resource.saveObjectToFile( map, Resource.REPORT_UTILS_APP_SETTINGS );
            Resource.saveObjectToFile( this.dbInfo, Resource.DCM_CONFIG_FILE );
         }
         catch(Throwable e)
         {
            DialogException de = new DialogException(e.toString(), "Error saving application settings.");
            throw de;
         }
      }
      catch(Throwable e)
      {
         this.showErrorMessage(e);
      }
      System.exit(0);
   }//end exitApplication
   
   /**
    *Method used to open a file.
    */
   public void openFile()
   throws DialogException
   {
      this.fileChooser.setFileFilter( this.getOpenFileFilter() );
      if( this.fileChooser.showOpenDialog(this) == this.fileChooser.APPROVE_OPTION )
      {
         String fileName = this.fileChooser.getSelectedFile().getAbsolutePath().toLowerCase();
         if( fileName.endsWith(this.XML_FILE_TYPE))
         {
            this.openXmlFile();
         }
         else if( fileName.endsWith(this.JRPRINT_FILE_TYPE))
         {
            
         }
         else if( fileName.endsWith(this.JASPER_FILE_TYPE) )
         {
            
         }
         else if( fileName.endsWith(this.CLASS_FILE_TYPE) )
         {
            
         }
      }
   }//end openFile
   
   /**
    *Method used to open an xml file.
    */
   public void openXmlFile()
   throws DialogException
   {
      String fileName = this.fileChooser.getSelectedFile().getAbsolutePath();
      try
      {
         java.io.FileInputStream fin = new java.io.FileInputStream(fileName);
         java.io.BufferedInputStream bin = new java.io.BufferedInputStream(fin);
         this.xmlEditor.read(bin, "plain/text");
         this.currentFileName = fileName;
         this.setTitleToCurrentFileName();
      }
      catch(Throwable e)
      {
         throw new DialogException(e.toString(), "Error opening XML file.");
      }
   }//end openXmlFile
   
   /**
    *Method used to save a file
    */
   public void saveFile()
   {
      try
      {
         this.fileChooser.setFileFilter( this.getSaveFileFilter() );
         java.io.File f = this.fileChooser.getSelectedFile();
         String fileName = f.getAbsolutePath();
         this.saveXmlBufferToFile(fileName);
      }//end try main method try
      catch(Throwable e)
      {
         this.writeErrorToConsole(e);
         this.showErrorMessage(e);
      }
   }//end saveFile
   
   public void saveFileAsSomethingElse()
   {
      this.fileChooser.setFileFilter(this.getSaveFileFilter());
      try
      {
         if(this.fileChooser.showSaveDialog(this) == this.fileChooser.APPROVE_OPTION)
         {
            java.io.File f = this.fileChooser.getSelectedFile();
            String fileName = f.getAbsolutePath();
            if( f.exists() )
            {
               int userOption = this.showFileOverwriteConfirmationDialog(fileName);
               if( userOption == javax.swing.JOptionPane.YES_OPTION || userOption == javax.swing.JOptionPane.OK_OPTION )
               {
                  this.saveXmlBufferToFile(fileName);
               }
               else
               {
                  //recursively recall this method until the user hits cancel
                  //on the selection window.
                  this.saveFileAsSomethingElse();
                  return;
               }
            }
            else
            {
               this.saveXmlBufferToFile(fileName);
            }
         }//end if user approved save of given file name
      }
      catch(Throwable e)
      {
         this.writeErrorToConsole(e);
         this.showErrorMessage(e);
      }
   }//end saveFileAsSomethingElse()
   
   /**
    *Method used to save the xml/text area data to file.
    *@param fileName the file to dump the text to.
    */
   public void saveXmlBufferToFile(String fileName)
   throws java.io.IOException
   {
      java.io.FileOutputStream fout = new java.io.FileOutputStream(fileName, false);
      java.io.OutputStreamWriter wout = new java.io.OutputStreamWriter(fout);
      this.xmlEditor.write(wout);
   }
   
   /**
    *Method used to show a confirm message about a file overwrite
    *@param fileName the file name to use in message.
    */
   public int showFileOverwriteConfirmationDialog(String fileName)
   {
      int ret = javax.swing.JOptionPane.showConfirmDialog(this, "The file \"" + fileName + "\" exists.  Do you wish to overwrite this file?");
      return ret;
   }
   
   /**
    *Method used to generate the file filter for the application.
    *@return the file filter for the application
    */
   public javax.swing.filechooser.FileFilter getOpenFileFilter()
   {
      javax.swing.filechooser.FileFilter filter = new javax.swing.filechooser.FileFilter()
      {
         public boolean accept(java.io.File f)
         {
            boolean ret = false;
            if(f.isDirectory() )
            {
               ret = true;
            }
            else
            {
               if( xmlPanel.isShowing() )
               {
                  if( f.getAbsolutePath().endsWith(".xml") || f.getAbsolutePath().endsWith(".XML"))
                  {
                     ret = true;
                  }
               }
               else if( previewPanel.isShowing() )
               {
                  
               }
            }
            return ret;
         }//end accept
         
         public String getDescription()
         {
            return "Jasper Files";
         }
      };
      return filter;
   }
   
   /**
    *Method used to generate the file filter for the application at save time
    *@return the file filter for the app at save time.
    */
   public javax.swing.filechooser.FileFilter getSaveFileFilter()
   {
      javax.swing.filechooser.FileFilter filter = new javax.swing.filechooser.FileFilter()
      {
         public boolean accept(java.io.File f)
         {
            boolean ret = false;
            if(f.isDirectory() )
            {
               ret = true;
            }
            else
            {
               if( f.getAbsolutePath().endsWith(".xml") || f.getAbsolutePath().endsWith(".XML"))
               {
                  ret = true;
               }
            }
            return ret;
         }//end accept
         
         public String getDescription()
         {
            return "Jasper Files";
         }
      };
      return filter;
   }
   
   /**
    *Method used to get a database connection from the current
    *DatabaseConnectionInfo.  Connections created with this method must
    *be freed because they are not bound to a connection manager of any kind.
    *@return a jdbc connection from the current DatabaseConnectionInfo selection.
    */
   public java.sql.Connection getJdbcConnection()
   throws dori.jasper.util.gui.DialogException
   {
      DatabaseConnectionInfo info = this.dbInfo.getActiveDatabaseConnectionInfo();
      java.sql.Connection ret = null;
      if( info != null )
      {
         try
         {
            ret = info.getConnection();
         }
         catch(Throwable e)
         {
            DialogException de = new DialogException(e.toString(), "An SQLException has occurred");
            throw de;
         }
      }
      else
      {
         throw new DialogException("There is not current active connection.  Set this from the database menu.", "No active database connection");
      }
      return ret;
   }
   
   /**
    *Method used to display an error
    *@param t the throwable objec to create the message for.
    */
   public void showErrorMessage(Throwable t)
   {
      this.showErrorMessage(t, this);
   }//end showErrorMessage
   
   public void showErrorMessage(Throwable t, java.awt.Component parent)
   {
      String title = null;
      String message = null;
      if( t instanceof DialogException )
      {
         title = ((DialogException)t).getTitle();
         message = t.getMessage();
      }
      else
      {
         title = "Error in application";
         message = t.toString();
      }
      javax.swing.JOptionPane.showMessageDialog(this, message, title, javax.swing.JOptionPane.ERROR_MESSAGE);
   }//end showErrorMessage
   
   /**
    *Method for writing a line to the console output window.
    *@param s the info for the console.  a newline will also be written.
    */
   public void writeLineToConsole(String s)
   {
      this.writeToConsole(s);
      this.writeToConsole("\n");
   }
   
   /**
    *Method for writing to the console output window.
    *@param s the info for the console.
    */
   public void writeToConsole(String s)
   {
      this.outputText.append(s);
   }
   
   /**
    *Method for an error message line to the console output window.
    *@param s the info for the console.
    */
   public void writeErrorToConsole(String s)
   {
      this.writeLineToConsole("##########################");
      this.writeLineToConsole("!!!!!!!BEGIN ERROR!!!!!!!!");
      this.writeLineToConsole("##########################");
      this.writeLineToConsole(s);
      this.writeToConsole("\n");
      this.writeLineToConsole("##########################");
      this.writeLineToConsole("!!!!!!!END ERROR!!!!!!!!!");
      this.writeLineToConsole("##########################");
   }
   
   /**
    *Method for an error message line to the console output window.
    *This method also dumps the stack trace.
    *@param e The error/exception/throwable to create info for output.
    */
   public void writeErrorToConsole(java.lang.Throwable e)
   {
      java.io.StringWriter sw = new java.io.StringWriter(1000);
      java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      e.printStackTrace(pw);
      String s = sw.getBuffer().toString();
      this.writeLineToConsole("##########################");
      this.writeLineToConsole("!!!!!!!BEGIN ERROR!!!!!!!!");
      this.writeLineToConsole("##########################");
      this.writeLineToConsole(s);
      this.writeToConsole("\n");
      this.writeLineToConsole("##########################");
      this.writeLineToConsole("!!!!!!!END ERROR!!!!!!!!!");
      this.writeLineToConsole("##########################");
   }
   
   protected void setTitleToCurrentFileName()
   {
      String title = this.getDefaultTitle() + ": " + this.currentFileName;
      this.setTitle( title );
   }//end setTitleToCurrentFileName
   
   public String getDefaultTitle()
   {
      return "Jasper Report Utilities";
   }
   
   protected boolean isCurrentFileNameTheSelectedFile()
   {
      boolean ret = false;
      java.io.File f = this.fileChooser.getSelectedFile();
      if( f != null && !f.isDirectory() && f.exists() )
      {
         String fileName = f.getAbsolutePath();
         ret = fileName.equals(this.currentFileName );
      }
      else
      {
         ret = false;
      }
      return ret;
   }//end isCurrentFileNameTheSelectedFile
   
   /**
    *Method used to create a new unique file name for this run.
    *@return the unique file name of the form Untitled#.xml.  # = digit
    */
   public String getUniqueCurrentFileName()
   {
      this.currentFileNameHelper++;
      java.io.File f = this.fileChooser.getSelectedFile();
      String fileName = null;
      String baseFileName = "Untitled" + this.currentFileNameHelper + ".xml";
      if( f != null && f.exists() )
      {
         if( f.isDirectory() )
         {
            fileName = f.getAbsolutePath();
         }
         else
         {
            fileName = f.getParent();
         }
      }
      else
      {
         fileName = this.getUserHome();
      }
      fileName = fileName + f.separator + baseFileName;
      java.io.File fset = new java.io.File( fileName );
      this.fileChooser.setSelectedFile( fset );
      this.currentFileName = fileName;
      this.setTitleToCurrentFileName();
      return fileName;
   }
   
   public String getUserHome()
   {
      String userHome = System.getProperty("user.home");
      return userHome;
   }
   
   public boolean isSelectedFileReal()
   {
      boolean ret = false;
      java.io.File f = this.fileChooser.getSelectedFile();
      if( f != null )
      {
         if( f.exists() && !f.isDirectory() && f.canRead() )
         {
            ret = true;
         }
         else
         {
            ret = false;
         }
      }
      else
      {
         ret = false;
      }
      return ret;
   }
   
   /**
    *Method used to compile the xml report file.
    */
   public void compileXmlFile()
   {
      if( !this.isCurrentFileNameTheSelectedFile() )
      {
         RuntimeException re = new RuntimeException("The file must be saved or a file must be opened before it can be compiled.");
         re.fillInStackTrace();
         throw re;
      }
      else
      {
         try
         {
            String useFileDir = System.getProperty(PROPERTY_FILE_DIR_IS_COMPILE_DIR);
            useFileDir = useFileDir != null ? useFileDir.trim().toLowerCase() : "false";
            String oldCompileDir = System.getProperty("jasper.reports.compile.temp");
            if( useFileDir.equals("true") )
            {
               
               try
               {
                  java.io.File f = new java.io.File( this.currentFileName );
                  String newCompileDir = f.getParent();
                  System.setProperty("jasper.reports.compile.temp", newCompileDir);
                  JasperManager.compileReportToFile(this.currentFileName);
               }
               catch(Throwable t)
               {
                  throw t;
               }
               finally
               {
                  if( oldCompileDir != null )
                  {
                     System.setProperty("jasper.reports.compile.temp", oldCompileDir);
                  }
               }
            }
            else
            {
               JasperManager.compileReportToFile(this.currentFileName);
            }
         }
         catch(Throwable e)
         {
            this.writeErrorToConsole(e);
            RuntimeException re = new RuntimeException(e);
            re.fillInStackTrace();
            throw re;
         }
      }
   }//end compileXmlFile
   
   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   protected javax.swing.JMenu applicationMenu;
   protected javax.swing.JMenu databaseMenu;
   protected javax.swing.JFileChooser fileChooser;
   protected javax.swing.JMenu fileMenu;
   protected javax.swing.JMenuBar mainMenu;
   protected javax.swing.JSplitPane mainSplitPane;
   protected javax.swing.JMenuItem miApplicationExit;
   protected javax.swing.JMenuItem miApplicationOptions;
   protected javax.swing.JMenuItem miDatabaseConnections;
   protected javax.swing.JMenuItem miDatabaseSetActiveConnection;
   protected javax.swing.JMenuItem miFileCompile;
   protected javax.swing.JMenuItem miFileNew;
   protected javax.swing.JMenuItem miFileOpen;
   protected javax.swing.JMenuItem miFileSave;
   protected javax.swing.JMenuItem miFileSaveAs;
   protected javax.swing.JPanel outputPanel;
   protected javax.swing.JScrollPane outputScrollPane;
   protected javax.swing.JTextArea outputText;
   protected javax.swing.JPanel previewPanel;
   protected javax.swing.JTabbedPane tabs;
   protected javax.swing.JPanel viewPanel;
   protected javax.swing.JEditorPane xmlEditor;
   protected javax.swing.JPanel xmlPanel;
   protected javax.swing.JScrollPane xmlScrollPane;
   // End of variables declaration//GEN-END:variables
   
}
