/*
 * DatabaseDriverNameAndURLExamples.java
 *
 * Created on February 12, 2004, 4:50 PM
 */

package dori.jasper.util;

/**
 * Simple class used to house JDBC Driver names and JDBC Driver URL examples.
 * This can be used by Dialogs and things of that nature.
 * @author  Wade Chandler
 * @version 1.0
 */
public class DatabaseDriverNameAndURLExamples
{
   
   
   /** used to hold the names and URL examples for the drivers */
   protected static final java.util.Properties data;
   
   static
   {
      data = new java.util.Properties();
      try
      {
         //we'll load a properties resource file.  then we'll look in the users home
         //.jasperutils directory to see if they have another file we can load and
         //read more drivers and examples from.  we'll do that in another try statement.
         java.io.InputStream in = Resource.class.getResourceAsStream("resources/DatabaseDriverNameAndURLExamples.properties");
         appendNamesAndURLExamples( in );
      }
      catch(Throwable e)
      {
         //we're just going to swallow this.  we'll output the error to the
         //standard error, but that is all we will do.  We will not fail the application.
         e.printStackTrace(System.err);
      }
      try
      {
         //we'll load the users file here.
         appendNamesAndURLExamples( Resource.DATABASE_DRIVER_NAME_AND_URL_EXAMPLES_USER_FILE );
      }
      catch(Throwable e)
      {
         boolean fileExists = false;
         try
         {
            //we're only going to log this if the user file actually exists.
            java.io.File f = new java.io.File( Resource.DATABASE_DRIVER_NAME_AND_URL_EXAMPLES_USER_FILE );
            if( f.exists() && f.isFile() )
            {
               fileExists = true;
            }
         }
         catch(Throwable ignore)
         {
            fileExists = false;
         }
         if( fileExists )
         {
            e.printStackTrace( System.err );
         }
      }
   }//end static init
   
   /** Creates a new instance of DatabaseDriverNameAndURLExamples */
   public DatabaseDriverNameAndURLExamples()
   {
      super();
   }//end DatabaseDriverNameAndURLExamples
   
   /**
    *Method used to add driver names and examples from a properties InputStream.  @see java.util.Properties
    *@param in the InputStream to read the properties from.  DriverName=Example
    *@throws java.io.IOException thrown on file errors.
    */
   public static void appendNamesAndURLExamples(java.io.InputStream in)
   throws java.io.IOException
   {
      java.io.BufferedInputStream bin = new java.io.BufferedInputStream( in );
      java.util.Properties p = new java.util.Properties();
      p.load( bin );
      data.putAll( p );
   }//end appendNamesAndURLExamples
   
   /**
    *Method used to add driver names and examples from a properties InputStream.  @see java.util.Properties
    *@param fileName the file to read the properties from.  DriverName=Example
    *@throws java.io.IOException thrown on file errors.
    */
   public static void appendNamesAndURLExamples(String fileName)
   throws java.io.IOException
   {
      //a file to load from
      java.io.FileInputStream fin = new java.io.FileInputStream( fileName );
      appendNamesAndURLExamples( fin );
   }//end appendNamesAndURLExamples
   
   /**
    *Method used to get the driver key/names.  These can be used to get the example URL.
    *@return the keys/names of the drivers.  These are the JDBC Driver Classnames.
    **/
   public static Object[] getDriverNames()
   {
      Object[] ret = data.keySet().toArray();
      return ret;
   }//end getDriverNames
   
   /**
    *Method used to get a single example URL by driver name/key.
    *@param key the class name of the JDBC driver.
    *@return the example URL for the driver
    */
   public static String getExampleJdbcURL(String key)
   {
      String ret = data.getProperty( key );
      return ret;
   }//end getExampleJdbcURL
   
   /**
    *Method used to get the example URLs.
    *@return the example URLs (all of them)
    */
   public static Object[] getExampleJdbcURLs()
   {
      Object[] ret = data.entrySet().toArray();
      return ret;
   }//end getExampleJdbcURL   
   
   /**
    *Used to test the class and nothing more.
    *@param args
    */
   public static void main(String args[])
   {
      try
      {
         Object[] keys = getDriverNames();
         for(int i = 0; i < keys.length; i++)
         {
            String key = (String)keys[i];
            String value = getExampleJdbcURL( key );
            System.out.println("==========================");
            System.out.println( key );
            System.out.println( value );
            System.out.println("==========================");
            System.out.println("");
         }
                         
      }
      catch(Throwable e)
      {
         e.printStackTrace( System.err );
      }
   }
   
   
}//end class DatabaseDriverNameAndURLExamples
