/*
 * DatabaseConnectionInfo.java
 *
 * Created on February 12, 2004, 2:42 PM
 */

package dori.jasper.util;

/**
 * Used to keep track of database connections.  Stores all relevant info for
 * obtainging a database connection.  This is a simply utility class.
 * @author  Wade Chandler
 * @version 1.0
 */
public class DatabaseConnectionInfo
implements java.io.Serializable
{
   
   /**  used to hold the JDBC driver class name. */
   protected String driver = null;
   
   /** used to hold the drivers JDBC url */
   protected String jdbcUrl = null;
   
   /** used to hold the name of the database for this connection */
   protected String databaseName = null;
   
   /** used to hold the name of the database user */
   protected String dbUserName = null;
   
   /** used to hold the name of the database password  warning this is clear text. */
   protected String dbPassword = null;
   
   /** used to set the connection info name */
   protected String infoName = null;
   
   /** Creates a new instance of DatabaseConnectionInfo */
   public DatabaseConnectionInfo()
   {
      super();
      this.driver = "";
      this.jdbcUrl = "";
      this.databaseName = "";
      this.dbUserName = "";
      this.dbPassword = "";
      this.infoName = "";
   }//end DatabaseConnectionInfo
   
   /**
    * Creates a populated instance of DatabaseConnectionInfo
    * @param driver the database driver class name.
    * @param jdbcUrl the url to use for this database connection.
    * @param databaseName the name of the database for this info.
    * @param dbUserName the user for the db connection.
    * @param dbPassword the password for the db user.
    */
   public DatabaseConnectionInfo( String infoName,
                                  String driver,
                                  String jdbcUrl,
                                  String databaseName,
                                  String dbUserName,
                                  String dbPassword)
   {
      this();
      this.setInfoName( infoName );
      this.setDriver( driver );
      this.setJdbcUrl( jdbcUrl );
      this.setDatabaseName( databaseName );
      this.setDbUserName( dbUserName );
      this.setDbPassword( dbPassword );
   }//end DatabaseConnectionInfo
   
   /** Getter for property databaseName.
    * @return Value of property databaseName.
    *
    */
   public java.lang.String getDatabaseName()
   {
      return databaseName;
   }
   
   /** Setter for property databaseName.
    * @param databaseName New value of property databaseName.
    *
    */
   public void setDatabaseName(java.lang.String databaseName)
   {
      this.databaseName = databaseName;
   }
   
   /** Getter for property dbPassword.
    * @return Value of property dbPassword.
    *
    */
   public java.lang.String getDbPassword()
   {
      return dbPassword;
   }
   
   /** Setter for property dbPassword.
    * @param dbPassword New value of property dbPassword.
    *
    */
   public void setDbPassword(java.lang.String dbPassword)
   {
      this.dbPassword = dbPassword;
   }
   
   /** Getter for property dbUserName.
    * @return Value of property dbUserName.
    *
    */
   public java.lang.String getDbUserName()
   {
      return dbUserName;
   }
   
   /** Setter for property dbUserName.
    * @param dbUserName New value of property dbUserName.
    *
    */
   public void setDbUserName(java.lang.String dbUserName)
   {
      this.dbUserName = dbUserName;
   }
   
   /** Getter for property driver.
    * @return Value of property driver.
    *
    */
   public java.lang.String getDriver()
   {
      return driver;
   }
   
   /** Setter for property driver.
    * @param driver New value of property driver.
    *
    */
   public void setDriver(java.lang.String driver)
   {
      this.driver = driver;
   }
   
   /** Getter for property jdbcUrl.
    * @return Value of property jdbcUrl.
    *
    */
   public java.lang.String getJdbcUrl()
   {
      return jdbcUrl;
   }
   
   /** Setter for property jdbcUrl.
    * @param jdbcUrl New value of property jdbcUrl.
    *
    */
   public void setJdbcUrl(java.lang.String jdbcUrl)
   {
      this.jdbcUrl = jdbcUrl;
   }
   
   /**
    *Method used to create a java.sql.Connection from the given information of
    *the instance.
    *@return a new database connection from the instance data.
    *@throws java.sql.SQLException thrown if there is an issue with creation
    */
   public java.sql.Connection getConnection()
   throws java.sql.SQLException
   {
      java.sql.Connection ret = null;
      ret = java.sql.DriverManager.getConnection(this.getJdbcUrl(), this.getDbUserName(), this.getDbPassword());
      return ret;
   }
   
   /**
    * Getter for property infoName.
    * @return Value of property infoName.
    */
   public java.lang.String getInfoName()
   {
      return infoName;
   }
   
   /**
    * Setter for property infoName.
    * @param infoName New value of property infoName.
    */
   public void setInfoName(java.lang.String infoName)
   {
      if( infoName != null && infoName.trim().length() > 0 )
      {
         this.infoName = infoName;
      }
      else
      {
         throw new java.lang.IllegalArgumentException("infoName can not be null or empty.  All white space doesn't count as not empty.");
      }
   }
   
  
}//end class DatabaseConnectionInfo
