/*
 * ============================================================================
 *                   The JasperReports License, Version 1.0
 * ============================================================================
 * 
 * Copyright (C) 2001-2004 Teodor Danciu (teodord@users.sourceforge.net). All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * 3. The end-user documentation included with the redistribution, if any, must
 *    include the following acknowledgment: "This product includes software
 *    developed by Teodor Danciu (http://jasperreports.sourceforge.net)."
 *    Alternately, this acknowledgment may appear in the software itself, if
 *    and wherever such third-party acknowledgments normally appear.
 * 
 * 4. The name "JasperReports" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For written 
 *    permission, please contact teodord@users.sourceforge.net.
 * 
 * 5. Products derived from this software may not be called "JasperReports", nor 
 *    may "JasperReports" appear in their name, without prior written permission
 *    of Teodor Danciu.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 * APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 * DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 * ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 * (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * ============================================================================
 *                   GNU Lesser General Public License
 * ============================================================================
 *
 * JasperReports - Free Java report-generating library.
 * Copyright (C) 2001-2004 Teodor Danciu teodord@users.sourceforge.net
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Teodor Danciu
 * 173, Calea Calarasilor, Bl. 42, Sc. 1, Ap. 18
 * Postal code 030615, Sector 3
 * Bucharest, ROMANIA
 * Email: teodord@users.sourceforge.net
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRElement;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRGraphicElement;


/**
 *
 */
public abstract class JRFillGraphicElement extends JRFillElement implements JRGraphicElement
{


	/**
	 *
	 */
	private JRElement topElementInGroup = null;
	private JRElement bottomElementInGroup = null;


	/**
	 *
	 */
	protected JRFillGraphicElement(
		JRBaseFiller filler,
		JRGraphicElement graphicElement, 
		JRFillObjectFactory factory
		)
	{
		super(filler, graphicElement, factory);
	}
	

	/**
	 *
	 */
	public byte getStretchType()
	{
		return ((JRGraphicElement)this.parent).getStretchType();
	}

	/**
	 *
	 */
	public void setStretchType(byte stretchType)
	{
	}

	/**
	 *
	 */
	public byte getPen()
	{
		return ((JRGraphicElement)this.parent).getPen();
	}
	
	/**
	 *
	 */
	public void setPen(byte pen)
	{
	}
	
	/**
	 *
	 */
	public byte getFill()
	{
		return ((JRGraphicElement)this.parent).getFill();
	}

	/**
	 *
	 */
	public void setFill(byte fill)
	{
	}
	

	/**
	 *
	 */
	public void rewind() throws JRException
	{
	}


	/**
	 *
	 */
	protected boolean prepare(
		int availableStretchHeight,
		boolean isOverflow
		) throws JRException
	{
		boolean willOverflow = false;

		super.prepare(availableStretchHeight, isOverflow);
		
		if (!this.isToPrint())
		{
			return willOverflow;
		}
		
		boolean isToPrint = true;
		boolean isReprinted = false;

		if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows())
		{
			isToPrint = false;
		}

		if (
			isToPrint && 
			this.isPrintWhenExpressionNull() &&
			!this.isPrintRepeatedValues()
			)
		{
			if (
				( !this.isPrintInFirstWholeBand() || !this.getBand().isNewPageColumn() ) &&
				( this.getPrintWhenGroupChanges() == null || !this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) ) &&
				( !isOverflow || !this.isPrintWhenDetailOverflows() )
				)
			{
				isToPrint = false;
			}
		}

		if (
			isToPrint && 
			availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()
			)
		{
			isToPrint = false;
			willOverflow = true;
		}
		
		if (
			isToPrint && 
			isOverflow && 
			//(this.isAlreadyPrinted() || !this.isPrintRepeatedValues())
			(this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || (!this.isAlreadyPrinted() && !this.isPrintRepeatedValues())))
			)
		{
			isReprinted = true;
		}

		this.setToPrint(isToPrint);
		this.setReprinted(isReprinted);
		
		return willOverflow;
	}
	
	
	/**
	 *
	 */
	protected void stretchElement(int bandStretch) throws JRException
	{
		switch (this.getStretchType())
		{
			case JRGraphicElement.STRETCH_TYPE_RELATIVE_TO_BAND_HEIGHT :
			{
				this.setStretchHeight(this.getHeight() + bandStretch);
				break;
			}
			case JRGraphicElement.STRETCH_TYPE_RELATIVE_TO_TALLEST_OBJECT :
			{
				if (this.elementGroup != null)
				{
					this.setStretchHeight(this.getHeight() + this.getStretchHeightDiff());
				}
				
				break;
			}
			case JRGraphicElement.STRETCH_TYPE_NO_STRETCH :
			default :
			{
				break;
			}
		}
	}
	
	
	/**
	 *
	 */
	private void setTopBottomElements()
	{
		if (this.elementGroup != null)
		{
			JRElement[] elements = this.elementGroup.getElements();
	
			if (elements != null && elements.length > 0)
			{
				for(int i = 0; i < elements.length; i++)
				{
					if (elements[i] != this)
					{
						if (
							this.topElementInGroup == null ||
							(this.topElementInGroup != null &&
							elements[i].getY() + elements[i].getHeight() <
							this.topElementInGroup.getY() + this.topElementInGroup.getHeight())
							)
						{
							this.topElementInGroup = elements[i];
						}
	
						if (
							this.bottomElementInGroup == null ||
							(this.bottomElementInGroup != null &&
							elements[i].getY() + elements[i].getHeight() >
							this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight())
							)
						{
							this.bottomElementInGroup = elements[i];
						}
					}
				}
			}
		}
		
		if (this.topElementInGroup == null)
		{
			this.topElementInGroup = this;
		}

		if (this.bottomElementInGroup == null)
		{
			this.bottomElementInGroup = this;
		}
		
	}


	/**
	 *
	 */
	private int getStretchHeightDiff()
	{
		if (this.topElementInGroup == null)
		{
			this.setTopBottomElements();
		}
		
		JRFillElement topElem = null;
		JRFillElement bottomElem = null;

		if (this.elementGroup != null)
		{
			JRElement[] elements = this.elementGroup.getElements();
	
			if (elements != null && elements.length > 0)
			{
				JRFillElement element = null;
				
				for(int i = 0; i < elements.length; i++)
				{
					element = (JRFillElement)elements[i];
					if (element != this && element.isToPrint())
					{
						if (
							topElem == null ||
							(topElem != null &&
							element.getRelativeY() + element.getStretchHeight() <
							topElem.getRelativeY() + topElem.getStretchHeight())
							)
						{
							topElem = element;
						}
	
						if (
							bottomElem == null ||
							(bottomElem != null &&
							element.getRelativeY() + element.getStretchHeight() >
							bottomElem.getRelativeY() + bottomElem.getStretchHeight())
							)
						{
							bottomElem = element;
						}
					}
				}
			}
		}

		if (topElem == null)
		{
			topElem = this;
		}

		if (bottomElem == null)
		{
			bottomElem = this;
		}

		int diff = 
			bottomElem.getRelativeY() + bottomElem.getStretchHeight() - topElem.getRelativeY() -
			(this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight() - this.topElementInGroup.getY());

		if (diff < 0)
		{
			diff = 0;
		}
		
		return diff;
	}


}
