/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.hsqldb.util.DataAccessPoint;
import org.hsqldb.util.DataAccessPointException;
import org.hsqldb.util.HelperFactory;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferResultSet;
import org.hsqldb.util.TransferTable;

class TransferDb
extends DataAccessPoint {
    Connection conn;
    DatabaseMetaData meta;
    protected Statement srcStatement = null;

    TransferDb(Connection connection, Traceable traceable) throws DataAccessPointException {
        super(traceable);
        this.conn = connection;
        if (connection != null) {
            try {
                this.meta = connection.getMetaData();
                this.databaseToConvert = connection.getCatalog();
                String string = this.meta.getDatabaseProductName();
                string = string == null ? "" : string.toLowerCase();
                this.helper = HelperFactory.getHelper(string);
                this.helper.set(this, traceable, this.meta.getIdentifierQuoteString());
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
        }
    }

    boolean isConnected() {
        return this.conn != null;
    }

    boolean getAutoCommit() throws DataAccessPointException {
        boolean bl = false;
        try {
            bl = this.conn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
        return bl;
    }

    void commit() throws DataAccessPointException {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
    }

    void rollback() throws DataAccessPointException {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
    }

    void setAutoCommit(boolean bl) throws DataAccessPointException {
        try {
            this.conn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean execute(String string) throws DataAccessPointException {
        boolean bl = false;
        Statement statement = null;
        try {
            try {
                statement = this.conn.createStatement();
                bl = statement.execute(string);
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
            Object var6_4 = null;
            if (statement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        statement.close();
        return bl;
    }

    TransferResultSet getData(String string) throws DataAccessPointException {
        ResultSet resultSet = null;
        try {
            if (this.srcStatement != null) {
                this.srcStatement.close();
            }
            this.srcStatement = this.conn.createStatement();
            resultSet = this.srcStatement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            try {
                this.srcStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.srcStatement = null;
            resultSet = null;
            throw new DataAccessPointException(sQLException.getMessage());
        }
        return new TransferResultSet(resultSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void putData(String string, TransferResultSet transferResultSet, int n) throws DataAccessPointException {
        if (string == null) return;
        if (string.equals("")) return;
        if (transferResultSet == null) {
            return;
        }
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = this.conn.prepareStatement(string);
                int n2 = 0;
                while (transferResultSet.next()) {
                    this.transferRow(transferResultSet, preparedStatement);
                    if (n != 0 && n2 == n) break;
                    if (n == 0 && ++n2 % 100 != 0) continue;
                    this.tracer.trace("Transfered " + n2 + " rows");
                }
                Object var7_7 = null;
                if (preparedStatement == null) return;
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (preparedStatement == null) throw throwable;
            try {
                preparedStatement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        preparedStatement.close();
        return;
    }

    private void transferRow(TransferResultSet transferResultSet, PreparedStatement preparedStatement) throws DataAccessPointException, SQLException {
        String string = "";
        if (preparedStatement != null) {
            preparedStatement.clearParameters();
        }
        int n = transferResultSet.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = transferResultSet.getColumnType(i + 1);
            string = "column=" + transferResultSet.getColumnName(i + 1) + " datatype=" + (String)this.helper.getSupportedTypes().get(new Integer(n2));
            Object object = transferResultSet.getObject(i + 1);
            if (object == null) {
                if (preparedStatement != null) {
                    preparedStatement.setNull(i + 1, n2);
                }
                string = string + " value=<null>";
                continue;
            }
            object = this.helper.convertColumnValue(object, i + 1, n2);
            preparedStatement.setObject(i + 1, object);
            string = string + " value='" + object.toString() + "'";
        }
        if (preparedStatement != null) {
            preparedStatement.execute();
        }
        string = "";
    }

    Vector getSchemas() throws DataAccessPointException {
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.meta.getSchemas();
        }
        catch (SQLException sQLException) {
            resultSet = null;
        }
        try {
            if (resultSet != null) {
                while (resultSet.next()) {
                    vector.addElement(resultSet.getString(1));
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
        return vector;
    }

    Vector getCatalog() throws DataAccessPointException {
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = null;
        if (this.databaseToConvert != null && this.databaseToConvert.length() > 0) {
            vector.addElement(this.databaseToConvert);
            return vector;
        }
        try {
            resultSet = this.meta.getCatalogs();
        }
        catch (SQLException sQLException) {
            resultSet = null;
        }
        try {
            if (resultSet != null) {
                while (resultSet.next()) {
                    vector.addElement(resultSet.getString(1));
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
        return vector;
    }

    void setCatalog(String string) throws DataAccessPointException {
        if (string != null && string.length() > 0) {
            try {
                this.conn.setCatalog(string);
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Vector getTables(String string, String[] stringArray) throws DataAccessPointException {
        Vector<TransferTable> vector = new Vector<TransferTable>();
        ResultSet resultSet = null;
        this.tracer.trace("Reading source tables");
        int n = 1;
        if (stringArray != null) {
            n = stringArray.length;
        }
        try {
            try {
                for (int i = 0; i < n; ++i) {
                    if (stringArray != null && stringArray[i] != null) {
                        resultSet = this.meta.getTables(string, stringArray[i], null, null);
                    } else {
                        try {
                            resultSet = this.meta.getTables(string, "", null, null);
                        }
                        catch (SQLException sQLException) {
                            resultSet = this.meta.getTables(string, null, null, null);
                        }
                    }
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(3);
                        String string3 = resultSet.getString(4);
                        String string4 = "";
                        if (stringArray != null && stringArray[i] != null) {
                            string4 = stringArray[i];
                        }
                        if (string3.compareTo("TABLE") == 0 || string3.compareTo("VIEW") == 0) {
                            TransferTable transferTable = new TransferTable(this, string2, string4, string3, this.tracer);
                            vector.addElement(transferTable);
                            continue;
                        }
                        this.tracer.trace("Found table of type :" + string3 + " - this type is ignored");
                    }
                }
                Object var12_13 = null;
                if (resultSet == null) return vector;
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        resultSet.close();
        return vector;
    }

    void getTableStructure(TransferTable transferTable, DataAccessPoint dataAccessPoint) throws DataAccessPointException {
        ResultSetMetaData resultSetMetaData;
        ResultSet resultSet;
        Statement statement;
        int n;
        ResultSet resultSet2;
        Object object;
        String string;
        String string2;
        boolean bl;
        String string3;
        boolean bl2;
        String string4;
        boolean bl3;
        String string5;
        String string6;
        block64: {
            block63: {
                string6 = "CREATE " + transferTable.Stmts.sType + " " + dataAccessPoint.helper.formatName(transferTable.Stmts.sDestTable);
                string5 = "";
                ResultSet resultSet3 = null;
                bl3 = false;
                string4 = new String("");
                String string7 = new String("");
                String string8 = new String("");
                String string9 = new String("");
                String string10 = new String("");
                String string11 = new String("");
                transferTable.Stmts.sDestDrop = "DROP " + transferTable.Stmts.sType + " " + dataAccessPoint.helper.formatName(transferTable.Stmts.sDestTable) + ";";
                if (transferTable.Stmts.sType.compareTo("TABLE") == 0) {
                    transferTable.Stmts.sDestDelete = "DELETE FROM " + dataAccessPoint.helper.formatName(transferTable.Stmts.sDestTable) + ";";
                    string6 = string6 + "(";
                } else if (transferTable.Stmts.sType.compareTo("VIEW") == 0) {
                    transferTable.Stmts.bDelete = false;
                    transferTable.Stmts.sDestDelete = "";
                    string6 = string6 + " AS SELECT ";
                }
                if (transferTable.Stmts.sType.compareTo("TABLE") == 0) {
                    string5 = "INSERT INTO " + dataAccessPoint.helper.formatName(transferTable.Stmts.sDestTable) + " VALUES(";
                } else if (transferTable.Stmts.sType.compareTo("VIEW") == 0) {
                    transferTable.Stmts.bInsert = false;
                    string5 = "";
                }
                if (transferTable.Stmts.sType.compareTo("VIEW") == 0) {
                    transferTable.Stmts.bTransfer = false;
                    transferTable.Stmts.bCreate = true;
                    transferTable.Stmts.bDelete = false;
                    transferTable.Stmts.bDrop = true;
                    transferTable.Stmts.bCreateIndex = false;
                    transferTable.Stmts.bDropIndex = false;
                    transferTable.Stmts.bInsert = false;
                    transferTable.Stmts.bAlter = false;
                    return;
                }
                resultSet3 = null;
                try {
                    resultSet3 = this.meta.getImportedKeys(transferTable.Stmts.sDatabaseToConvert, transferTable.Stmts.sSchema, transferTable.Stmts.sSourceTable);
                }
                catch (SQLException sQLException) {
                    resultSet3 = null;
                }
                try {
                    if (resultSet3 != null) {
                        while (resultSet3.next()) {
                            bl3 = true;
                            if (!resultSet3.getString(12).equals(string8)) {
                                if (!string8.equals("")) {
                                    string4 = string4 + dataAccessPoint.helper.formatIdentifier(string11.substring(0, string11.length() - 1)) + ") REFERENCES " + dataAccessPoint.helper.formatName(string9);
                                    if (string10.length() > 0) {
                                        string4 = string4 + " (" + dataAccessPoint.helper.formatIdentifier(string10.substring(0, string10.length() - 1)) + ")";
                                    }
                                    string4 = string4 + ";";
                                    string7 = string7.substring(0, string7.length() - 1) + ";";
                                    string10 = "";
                                    string11 = "";
                                }
                                string9 = resultSet3.getString(3);
                                string8 = resultSet3.getString(12);
                                string4 = string4 + "ALTER TABLE " + dataAccessPoint.helper.formatName(transferTable.Stmts.sDestTable) + " ADD CONSTRAINT ";
                                string4 = transferTable.Stmts.bFKForced && !string8.startsWith("FK_") ? string4 + dataAccessPoint.helper.formatIdentifier("FK_" + string8) + " " : string4 + dataAccessPoint.helper.formatIdentifier(string8) + " ";
                                string4 = string4 + "FOREIGN KEY (";
                                string7 = string7 + "ALTER TABLE " + dataAccessPoint.helper.formatName(transferTable.Stmts.sDestTable) + " DROP CONSTRAINT ";
                                string7 = transferTable.Stmts.bFKForced && !string8.startsWith("FK_") ? string7 + dataAccessPoint.helper.formatIdentifier("FK_" + string8) + " " : string7 + dataAccessPoint.helper.formatIdentifier(string8) + " ";
                            }
                            string11 = string11 + resultSet3.getString(8) + ",";
                            string10 = string10 + resultSet3.getString(4) + ",";
                        }
                        resultSet3.close();
                    }
                    if (bl3) {
                        string4 = string4 + string11.substring(0, string11.length() - 1) + ") REFERENCES " + dataAccessPoint.helper.formatName(string9);
                        if (string10.length() > 0) {
                            string4 = string4 + " (" + dataAccessPoint.helper.formatIdentifier(string10.substring(0, string10.length() - 1)) + ")";
                        }
                        string4 = string4 + ";";
                        string7 = string7.substring(0, string7.length() - 1) + ";";
                        transferTable.Stmts.sDestDrop = string7 + transferTable.Stmts.sDestDrop;
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataAccessPointException(sQLException.getMessage());
                }
                bl2 = false;
                string3 = new String();
                string3 = "";
                ResultSet resultSet4 = null;
                try {
                    resultSet4 = this.meta.getPrimaryKeys(transferTable.Stmts.sDatabaseToConvert, transferTable.Stmts.sSchema, transferTable.Stmts.sSourceTable);
                }
                catch (SQLException sQLException) {
                    resultSet4 = null;
                }
                try {
                    if (resultSet4 != null) {
                        while (resultSet4.next()) {
                            if (bl2) {
                                string3 = string3 + ", ";
                            } else {
                                if (resultSet4.getString(6) != null) {
                                    string3 = " CONSTRAINT " + dataAccessPoint.helper.formatIdentifier(resultSet4.getString(6));
                                }
                                string3 = string3 + " PRIMARY KEY (";
                            }
                            string3 = string3 + dataAccessPoint.helper.formatIdentifier(resultSet4.getString(4));
                            bl2 = true;
                        }
                        resultSet4.close();
                        if (bl2) {
                            string3 = string3 + ") ";
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataAccessPointException(sQLException.getMessage());
                }
                bl = false;
                ResultSet resultSet5 = null;
                Object object2 = new String("");
                string2 = new String("");
                string = new String("");
                try {
                    resultSet5 = this.meta.getIndexInfo(transferTable.Stmts.sDatabaseToConvert, transferTable.Stmts.sSchema, transferTable.Stmts.sSourceTable, false, false);
                }
                catch (SQLException sQLException) {
                    resultSet5 = null;
                }
                try {
                    if (resultSet5 == null) break block63;
                    while (resultSet5.next()) {
                        object = null;
                        try {
                            object = resultSet5.getString(6);
                        }
                        catch (SQLException sQLException) {
                            object = null;
                        }
                        if (object == null) continue;
                        if (!((String)object).equals(object2)) {
                            if (!((String)object2).equals("")) {
                                string2 = string2.substring(0, string2.length() - 1) + ");";
                                string = string + ";";
                            }
                            object2 = object;
                            string = string + "DROP INDEX ";
                            string = transferTable.Stmts.bIdxForced && !((String)object2).startsWith("Idx_") ? string + dataAccessPoint.helper.formatIdentifier("Idx_" + (String)object2) : string + dataAccessPoint.helper.formatIdentifier((String)object2);
                            string2 = string2 + "CREATE ";
                            if (!resultSet5.getBoolean(4)) {
                                string2 = string2 + "UNIQUE ";
                            }
                            string2 = string2 + "INDEX ";
                            string2 = transferTable.Stmts.bIdxForced && !((String)object2).startsWith("Idx_") ? string2 + dataAccessPoint.helper.formatIdentifier("Idx_" + (String)object2) : string2 + dataAccessPoint.helper.formatIdentifier((String)object2);
                            string2 = string2 + " ON " + dataAccessPoint.helper.formatName(transferTable.Stmts.sDestTable) + "(";
                        }
                        string2 = string2 + dataAccessPoint.helper.formatIdentifier(resultSet5.getString(9)) + ",";
                        bl = true;
                    }
                    resultSet5.close();
                    if (bl) {
                        string2 = string2.substring(0, string2.length() - 1) + ");";
                        string = string + ";";
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataAccessPointException(sQLException.getMessage());
                }
            }
            object = new Vector();
            this.tracer.trace("Reading source columns for table " + transferTable.Stmts.sSourceTable);
            resultSet2 = null;
            n = 1;
            statement = null;
            resultSet = null;
            resultSetMetaData = null;
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(transferTable.Stmts.sSourceSelect);
                resultSetMetaData = resultSet.getMetaData();
                resultSet2 = this.meta.getColumns(transferTable.Stmts.sDatabaseToConvert, transferTable.Stmts.sSchema, transferTable.Stmts.sSourceTable, null);
            }
            catch (SQLException sQLException) {
                if (!transferTable.Stmts.sSchema.equals("")) break block64;
                try {
                    resultSet2 = this.meta.getColumns(transferTable.Stmts.sDatabaseToConvert, null, transferTable.Stmts.sSourceTable, null);
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
        }
        try {
            while (resultSet2.next()) {
                String string12 = dataAccessPoint.helper.formatIdentifier(resultSet2.getString(4));
                int n2 = resultSet2.getShort(5);
                String string13 = resultSet2.getString(6);
                int n3 = resultSet2.getInt(7);
                String string14 = resultSet2.getString(13);
                boolean bl4 = resultSetMetaData.isNullable(n) == 0;
                boolean bl5 = false;
                try {
                    bl5 = resultSetMetaData.isAutoIncrement(n);
                }
                catch (SQLException sQLException) {
                    bl5 = false;
                }
                int n4 = resultSetMetaData.getPrecision(n);
                int n5 = resultSetMetaData.getScale(n);
                n2 = this.helper.convertFromType(n2);
                n2 = dataAccessPoint.helper.convertToType(n2);
                Integer n6 = new Integer(n2);
                String string15 = (String)transferTable.hTypes.get(n6);
                if (string15 == null) {
                    string15 = string13;
                    this.tracer.trace("No mapping for type: " + string12 + " type: " + n2 + " source: " + string13);
                }
                if (n2 == 2) {
                    string15 = string15 + "(" + Integer.toString(n4);
                    if (n5 > 0) {
                        string15 = string15 + "," + Integer.toString(n5);
                    }
                    string15 = string15 + ")";
                } else if (n2 == 1) {
                    string15 = string15 + "(" + Integer.toString(n3) + ")";
                } else if (bl5) {
                    string15 = "SERIAL";
                }
                if (string14 != null) {
                    if (n2 == 1 || n2 == 12 || n2 == -1) {
                        string14 = "'" + string14 + "'";
                    }
                    string15 = string15 + " Default " + string14;
                }
                if (bl4) {
                    string15 = string15 + " NOT NULL ";
                }
                ((Vector)object).addElement(n6);
                string15 = this.helper.fixupColumnDefRead(transferTable, resultSetMetaData, string15, resultSet2, n);
                string15 = dataAccessPoint.helper.fixupColumnDefWrite(transferTable, resultSetMetaData, string15, resultSet2, n);
                string6 = string6 + string12 + " " + string15 + ",";
                string5 = string5 + "?,";
                ++n;
            }
            resultSet.close();
            statement.close();
            resultSet2.close();
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
        if (bl2) {
            string6 = string6 + string3 + ",";
        }
        transferTable.Stmts.sDestCreate = string6.substring(0, string6.length() - 1) + ")";
        transferTable.Stmts.sDestInsert = string5.substring(0, string5.length() - 1) + ")";
        if (bl3) {
            transferTable.Stmts.bAlter = true;
            transferTable.Stmts.sDestAlter = string4;
        } else {
            transferTable.Stmts.bAlter = false;
        }
        if (bl) {
            transferTable.Stmts.bCreateIndex = true;
            transferTable.Stmts.bDropIndex = true;
            transferTable.Stmts.sDestCreateIndex = string2;
            transferTable.Stmts.sDestDropIndex = string;
        } else {
            transferTable.Stmts.bCreateIndex = false;
            transferTable.Stmts.bDropIndex = false;
        }
    }

    void close() throws DataAccessPointException {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.conn = null;
        }
    }
}

