/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.hsqldb.util.SqlToolError;

public class SqlFile {
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private String[] statementHistory = new String[10];
    private boolean htmlMode = false;
    private static final int SEP_LEN = 2;
    private static final String DIVIDER = "-----------------------------------------------------------------";
    private static final String SPACES = "                                                                 ";
    private static final String BANNER = "SqlFile processor.  Enter \"\\q\" to quit,\n    \"\\?\" to list Special Commands, \":?\" to list Buffer/Editing commands\n\nSPECIAL Commands begin with '\\' and execute when you hit ENTER.\nBUFFER Commands begin with ':' and execute when you hit ENTER.\nAn empty line within an SQL Statement moves it into the buffer.\nAll other lines comprise SQL Statements.\nSQL Statement lines ending with ';' cause the current Statement to be executed.\nSQL Statements consisting of only /* SQL comment */ are not executed, therefore\n    you can comment scripts like \"/* This is a comment */;\"\n";
    private static final String BUFFER_HELP_TEXT = "BUFFER Commands (only available for interactive use).\nIn place of \"3\" below, you can use nothing for the previous command, or\nan integer \"X\" to indicate the Xth previous command.\n\n    :?          Help\n    :a          Enter append mode with contents of buffer as current command\n    :l          List current contents of buffer\n    :s/from/to/ Substitute \"to\" for all occurrences of \"from\"\n                ('$'s in \"from\" and \"to\" represent line breaks)\n                (use \":s/from//\" to delete 'from' strings)\n                ('/' can actually be any char which occurs in\n                 neither \"to\" nor \"from\")\n    :;          Execute current buffer as an SQL Statement\n";
    private static final String HELP_TEXT = "SPECIAL Commands.\n* commands only available for interactive use.\nIn place of \"3\" below, you can use nothing for the previous command, or\nan integer \"X\" to indicate the Xth previous command.\n\n    \\?                   Help\n    \\p [line to print]   Print string to stdout\n    \\dt                  List tables\n    \\d TABLENAME         Describe table\n    \\H                   Toggle HTML output mode\n    \\* [true|false]      Continue upon errors (a.o.t. abort upon error)\n    \\s                   * Show previous commands (i.e. command history)\n    \\-[3]                * reload a command to buffer (for / commands)\n    \\q                   Quit (alternatively, end input like Ctrl-Z or Ctrl-D)\n\nEXAMPLE:  To show previous commands then edit and execute the 3rd-to-last:\n    \\s\n    \\-3\n    :;\n";
    private String curCommand = null;
    private int curLinenum = -1;
    private int curHist = -1;
    private PrintStream psStd = null;
    private PrintStream psErr = null;
    StringBuffer stringBuffer = new StringBuffer();
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[][] listMDTableCols = new int[][]{{2, 3}, {3}, {2, 3}};
    private static final String[][][] requireMDTableVals = new String[][][]{{null, null, null, {"TABLE"}}, {null, null, null, {"TABLE"}}, {null, null, null, {"TABLE"}}};
    private static final String[][][] prohibitMDTableVals = new String[][][]{null, null, {null, {"SYS", "SYSTEM"}}};
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR = SqlFile.spaces(4);
    private static final String PRE_TD = SqlFile.spaces(8);

    SqlFile(File file, boolean bl) throws IOException {
        this.file = file;
        this.interactive = bl;
        if (this.file != null && !this.file.canRead()) {
            throw new IOException("Can't read SQL file '" + this.file + "'");
        }
    }

    SqlFile(boolean bl) throws IOException {
        this(null, bl);
    }

    public void execute(Connection connection) throws IOException, SqlToolError, SQLException {
        this.execute(connection, System.out, System.err);
    }

    /*
     * Exception decompiling
     */
    public synchronized void execute(Connection var1_1, PrintStream var2_2, PrintStream var3_3) throws IOException, SqlToolError, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String deTerminated(String string) {
        int n = string.lastIndexOf(59);
        if (n < 0) {
            return null;
        }
        for (int i = n + 1; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return null;
        }
        return string.substring(0, n);
    }

    private void processBuffer(String string) throws BadSpecial, SQLException {
        boolean bl = false;
        int n = 105;
        String string2 = null;
        if (string.length() > 0) {
            n = string.charAt(0);
            string2 = string.substring(1).trim();
            if (string2.length() == 0) {
                string2 = null;
            }
        }
        switch (n) {
            case 59: {
                this.curCommand = this.commandFromHistory(0);
                this.stdprint("Executing command from buffer:\n" + this.curCommand + '\n');
                this.processStatement();
                return;
            }
            case 65: 
            case 97: {
                this.stringBuffer.append(this.commandFromHistory(0));
                return;
            }
            case 76: 
            case 108: {
                this.stdprint("Current Buffer:\n" + this.commandFromHistory(0));
                return;
            }
            case 83: 
            case 115: {
                try {
                    String string3 = this.commandFromHistory(0);
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    if (string2 == null) {
                        throw new BadSwitch(0);
                    }
                    String string4 = string2.substring(0, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, string4, true);
                    if (stringTokenizer.countTokens() < 4 || !stringTokenizer.nextToken().equals(string4)) {
                        throw new BadSwitch(1);
                    }
                    String string5 = stringTokenizer.nextToken().replace('$', '\n');
                    if (!stringTokenizer.nextToken().equals(string4)) {
                        throw new BadSwitch(2);
                    }
                    String string6 = stringTokenizer.nextToken().replace('$', '\n');
                    if (string6.equals(string4)) {
                        string6 = "";
                    } else if (stringTokenizer.countTokens() < 1 || !stringTokenizer.nextToken().equals(string4)) {
                        throw new BadSwitch(3);
                    }
                    if (stringTokenizer.countTokens() > 0) {
                        throw new BadSwitch(4);
                    }
                    int n2 = string3.length();
                    while ((n2 = string3.lastIndexOf(string5, n2 - 1)) > -1) {
                        stringBuffer.replace(n2, n2 + string5.length(), string6);
                    }
                    this.statementHistory[this.curHist] = stringBuffer.toString();
                    this.stdprint("Current Buffer:\n" + this.commandFromHistory(0));
                }
                catch (BadSwitch badSwitch) {
                    throw new BadSpecial("Switch syntax:  \":s/from this/to that/\".  Use '$' for line separations.  [" + badSwitch.getMessage() + ']');
                }
                return;
            }
            case 63: {
                this.stdprint(BUFFER_HELP_TEXT);
                return;
            }
        }
        throw new BadSpecial("Unknown Buffer Command");
    }

    private void processSpecial(String string) throws BadSpecial, QuitNow, SQLException {
        boolean bl = false;
        String string2 = null;
        if (string.length() < 1) {
            throw new BadSpecial("Null special command");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken("").trim();
        }
        switch (string3.charAt(0)) {
            case 'q': {
                throw new QuitNow();
            }
            case 'H': {
                this.htmlMode = !this.htmlMode;
                this.stdprint(this.htmlMode ? "<HTML>" : "</HTML>");
                return;
            }
            case 'd': {
                if (string3.length() > 1 && string3.charAt(1) == 't') {
                    this.listTables();
                    return;
                }
                if (string3.length() != 1 || string2 == null) break;
                this.describe(string2);
                return;
            }
            case 'p': {
                if (string2 == null) {
                    this.stdprint();
                } else {
                    this.stdprint(string2);
                }
                return;
            }
            case '*': {
                if (string2 != null) {
                    this.continueOnError = Boolean.valueOf(string2);
                }
                this.stdprint("Continue-on-error is set to: " + this.continueOnError);
                return;
            }
            case 's': {
                this.showHistory();
                return;
            }
            case '-': {
                String string4;
                int n = 0;
                String string5 = string4 = string3.length() == 1 ? null : string3.substring(1, string3.length());
                if (string4 == null) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BadSpecial("Malformatted command number");
                    }
                }
                this.setBuf(this.commandFromHistory(n));
                this.stdprint("RESTORED following command to buffer.  Enter \":?\" to see buffer commands:\n" + this.commandFromHistory(0));
                return;
            }
            case '?': {
                this.stdprint(HELP_TEXT);
                return;
            }
            case '!': {
                System.err.println("Run '" + (string2 == null ? "SHELL" : string2) + "'");
                return;
            }
        }
        throw new BadSpecial("Unknown Special Command");
    }

    private void stdprint() {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
    }

    private void errprint(String string) {
        this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void stdprint(String string) {
        this.psStd.println(this.htmlMode ? "<P>" + string + "</P>" : string);
    }

    private void listTables() throws SQLException {
        int[] nArray = null;
        String[][] stringArray = null;
        String[][] stringArray2 = null;
        DatabaseMetaData databaseMetaData = this.curConn.getMetaData();
        String string = databaseMetaData.getDatabaseProductName();
        Object var6_6 = null;
        if (string.indexOf("HSQL") > -1) {
            nArray = listMDTableCols[1];
            stringArray = requireMDTableVals[1];
            stringArray2 = prohibitMDTableVals[1];
        } else if (string.indexOf("Oracle") > -1) {
            nArray = listMDTableCols[2];
            stringArray = requireMDTableVals[2];
            stringArray2 = prohibitMDTableVals[2];
        } else {
            nArray = listMDTableCols[0];
            stringArray = requireMDTableVals[0];
            stringArray2 = prohibitMDTableVals[0];
        }
        this.displayResultSet(null, databaseMetaData.getTables(null, null, null, null), nArray, stringArray, stringArray2);
    }

    private void processStatement() throws SQLException {
        Statement statement = this.curConn.createStatement();
        statement.execute(this.curCommand);
        this.displayResultSet(statement, statement.getResultSet(), null, null, null);
    }

    private void displayResultSet(Statement statement, ResultSet resultSet, int[] nArray, String[][] stringArray, String[][] stringArray2) throws SQLException {
        int n = statement == null ? -1 : statement.getUpdateCount();
        switch (n) {
            case -1: {
                String[] stringArray3;
                int n2;
                boolean bl;
                int n3;
                int n4;
                if (resultSet == null) {
                    this.stdprint("No result");
                    break;
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n5 = resultSetMetaData.getColumnCount();
                int n6 = nArray == null ? n5 : nArray.length;
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                String[] stringArray4 = null;
                int[] nArray2 = new int[n6];
                if (!this.htmlMode) {
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = 0;
                    }
                }
                boolean[] blArray = new boolean[n6];
                if (n6 > 1) {
                    n4 = -1;
                    stringArray4 = new String[n6];
                    for (n3 = 1; n3 <= n5; ++n3) {
                        if (nArray != null) {
                            bl = true;
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                if (n3 != nArray[n2]) continue;
                                bl = false;
                            }
                            if (bl) continue;
                        }
                        stringArray4[++n4] = resultSetMetaData.getColumnLabel(n3);
                        String string = resultSetMetaData.getColumnTypeName(n3);
                        boolean bl2 = blArray[n4] = string.equals("INTEGER") || string.equals("NUMBER");
                        if (this.htmlMode || stringArray4[n4].length() <= nArray2[n4]) continue;
                        nArray2[n4] = stringArray4[n4].length();
                    }
                }
                block6: while (resultSet.next()) {
                    stringArray3 = new String[n6];
                    n4 = -1;
                    for (n3 = 1; n3 <= n5; ++n3) {
                        String string = resultSet.getString(n3);
                        if (stringArray != null && stringArray.length >= n3 && stringArray[n3 - 1] != null) {
                            boolean bl3 = false;
                            for (n2 = 0; n2 < stringArray[n3 - 1].length; ++n2) {
                                if (stringArray[n3 - 1][n2] == null || !stringArray[n3 - 1][n2].equals(string)) continue;
                                bl3 = true;
                                break;
                            }
                            if (!bl3) continue block6;
                        }
                        if (stringArray2 != null && stringArray2.length >= n3 && stringArray2[n3 - 1] != null) {
                            for (n2 = 0; n2 < stringArray2[n3 - 1].length; ++n2) {
                                if (stringArray2[n3 - 1][n2] != null && stringArray2[n3 - 1][n2].equals(string)) continue block6;
                            }
                        }
                        if (nArray != null) {
                            bl = true;
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                if (n3 != nArray[n2]) continue;
                                bl = false;
                            }
                            if (bl) continue;
                        }
                        String string2 = resultSet.wasNull() ? (this.htmlMode ? "<I>null</I>" : "null") : (stringArray3[++n4] = string);
                        if (this.htmlMode || stringArray3[n4].length() <= nArray2[n4]) continue;
                        nArray2[n4] = stringArray3[n4].length();
                    }
                    arrayList.add(stringArray3);
                }
                if (this.htmlMode) {
                    this.psStd.println("<TABLE border='1'>");
                }
                if (stringArray4 != null) {
                    if (this.htmlMode) {
                        this.psStd.print(SqlFile.htmlRow(0) + '\n' + PRE_TD);
                    }
                    for (n3 = 0; n3 < stringArray4.length; ++n3) {
                        this.psStd.print(this.htmlMode ? "<TD>" + stringArray4[n3] + "</TD>" : (n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray4[n3], nArray2[n3], blArray[n3]));
                    }
                    this.psStd.println(this.htmlMode ? "\n" + PRE_TR + "</TR>" : "");
                    if (!this.htmlMode) {
                        for (n3 = 0; n3 < stringArray4.length; ++n3) {
                            this.psStd.print((n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray2[n3]));
                        }
                        this.psStd.println();
                    }
                }
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    if (this.htmlMode) {
                        this.psStd.print(SqlFile.htmlRow(n3 % 2 == 0 ? 2 : 1) + '\n' + PRE_TD);
                    }
                    stringArray3 = (String[])arrayList.get(n3);
                    for (n2 = 0; n2 < stringArray3.length; ++n2) {
                        this.psStd.print(this.htmlMode ? "<TD>" + stringArray3[n2] + "</TD>" : (n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray3[n2], nArray2[n2], blArray[n2]));
                    }
                    this.psStd.println(this.htmlMode ? "\n" + PRE_TR + "</TR>" : "");
                }
                if (this.htmlMode) {
                    this.psStd.println("</TABLE>");
                }
                if (arrayList.size() == 1) break;
                this.stdprint("\n" + arrayList.size() + " rows");
                break;
            }
            default: {
                if (n == 0) break;
                this.stdprint(Integer.toString(n) + " row" + (n == 1 ? "" : "s") + " updated");
            }
        }
    }

    private static String htmlRow(int n) {
        switch (n) {
            case 0: {
                return PRE_TR + "<TR style='font-weight: bold;'>";
            }
            case 1: {
                return PRE_TR + "<TR style='background: #94d6ef; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return PRE_TR + "<TR style='background: silver; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int n) {
        return n > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, n);
    }

    private static String spaces(int n) {
        return n > SPACES.length() ? SPACES : SPACES.substring(0, n);
    }

    private static String pad(String string, int n, boolean bl) {
        int n2 = n - string.length();
        if (n2 < 1) {
            return string;
        }
        String string2 = SqlFile.spaces(n2);
        return (bl ? string2 : "") + string + (bl ? "" : string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showHistory() {
        String[] stringArray;
        int n;
        block17: {
            block16: {
                block15: {
                    n = -1;
                    stringArray = new String[this.statementHistory.length];
                    try {
                        String string;
                        int n2;
                        for (n2 = this.curHist; n2 >= 0; --n2) {
                            string = this.statementHistory[n2];
                            if (string == null) {
                                Object var6_5 = null;
                                if (n < 0) {
                                    this.stdprint("<<<    No history yet    >>>");
                                    return;
                                }
                                break block15;
                            }
                            stringArray[++n] = string;
                        }
                        for (n2 = 9; n2 > this.curHist; --n2) {
                            string = this.statementHistory[n2];
                            if (string == null) {
                                break block16;
                            }
                            stringArray[++n] = string;
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        if (n < 0) {
                            this.stdprint("<<<    No history yet    >>>");
                            return;
                        }
                        int n3 = n;
                        while (true) {
                            if (n3 < 0) {
                                this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                                throw throwable;
                            }
                            this.psStd.println((n3 == 0 ? "BUFR" : "-" + n3 + "  ") + " **********************************************\n" + stringArray[n3]);
                            --n3;
                        }
                    }
                }
                for (int i = n; i >= 0; --i) {
                    this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
                }
                this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                return;
            }
            Object var6_6 = null;
            if (n < 0) {
                this.stdprint("<<<    No history yet    >>>");
                return;
            }
            for (int i = n; i >= 0; --i) {
                this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
            }
            this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
            return;
        }
        Object var6_7 = null;
        if (n < 0) {
            this.stdprint("<<<    No history yet    >>>");
            return;
        }
        for (int i = n; i >= 0; --i) {
            this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
        }
        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
    }

    private String commandFromHistory(int n) throws BadSpecial {
        if (n >= this.statementHistory.length) {
            throw new BadSpecial("History can only hold up to " + this.statementHistory.length + " commands");
        }
        String string = this.statementHistory[(this.statementHistory.length + this.curHist - n) % this.statementHistory.length];
        if (string == null) {
            throw new BadSpecial("History doesn't go back that far");
        }
        return string;
    }

    private void setBuf(String string) {
        ++this.curHist;
        if (this.curHist == this.statementHistory.length) {
            this.curHist = 0;
        }
        this.statementHistory[this.curHist] = string;
    }

    private void describe(String string) throws SQLException {
        int n;
        String[] stringArray;
        int n2;
        Statement statement = this.curConn.createStatement();
        statement.execute("SELECT * FROM " + string + " WHERE 1 = 2");
        ResultSet resultSet = statement.getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray2 = new String[]{"name", "datatype", "width", "no-nulls"};
        int[] nArray = new int[]{0, 0, 0, 0};
        boolean[] blArray = new boolean[]{false, false, true, false};
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (this.htmlMode || stringArray2[n2].length() <= nArray[n2]) continue;
            nArray[n2] = stringArray2[n2].length();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray = new String[4];
            stringArray[0] = resultSetMetaData.getColumnName(n2 + 1);
            stringArray[1] = resultSetMetaData.getColumnTypeName(n2 + 1);
            stringArray[2] = Integer.toString(resultSetMetaData.getColumnDisplaySize(n2 + 1));
            stringArray[3] = resultSetMetaData.isNullable(n2 + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : "*";
            arrayList.add(stringArray);
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].length() <= nArray[n]) continue;
                nArray[n] = stringArray[n].length();
            }
        }
        if (this.htmlMode) {
            this.psStd.println("<TABLE border='1'>");
        }
        if (this.htmlMode) {
            this.psStd.print(SqlFile.htmlRow(0) + '\n' + PRE_TD);
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            this.psStd.print(this.htmlMode ? "<TD>" + stringArray2[n2] + "</TD>" : (n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray2[n2], nArray[n2], blArray[n2]));
        }
        this.psStd.println(this.htmlMode ? "\n" + PRE_TR + "</TR>" : "");
        if (!this.htmlMode) {
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                this.psStd.print((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray[n2]));
            }
            this.psStd.println();
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (this.htmlMode) {
                this.psStd.print(SqlFile.htmlRow(n2 % 2 == 0 ? 2 : 1) + '\n' + PRE_TD);
            }
            stringArray = (String[])arrayList.get(n2);
            for (n = 0; n < stringArray.length; ++n) {
                this.psStd.print(this.htmlMode ? "<TD>" + stringArray[n] + "</TD>" : (n > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray[n], nArray[n], blArray[n]));
            }
            this.psStd.println(this.htmlMode ? "\n" + PRE_TR + "</TR>" : "");
        }
        if (this.htmlMode) {
            this.stdprint("\n</TABLE>");
        }
    }

    private class BadSwitch
    extends Exception {
        private BadSwitch(int n) {
            super(Integer.toString(n));
        }
    }

    private class QuitNow
    extends Exception {
        private QuitNow() {
        }
    }

    private class BadSpecial
    extends Exception {
        private BadSpecial(String string) {
            super(string);
        }
    }
}

