/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.IOException;

public class FileUtil {
    public static final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public static final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);

    public static void delete(String string) throws IOException {
        try {
            new File(string).delete();
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    public static boolean exists(String string) throws IOException {
        try {
            return new File(string).exists();
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    public static void renameOverwrite(String string, String string2) throws IOException {
        try {
            if (FileUtil.exists(string)) {
                FileUtil.delete(string2);
                File file = new File(string);
                file.renameTo(new File(string2));
            }
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    static void printSystemOut(String string) {
        System.out.println(string);
    }

    static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable.getMessage());
    }

    public static String absolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public static File absoluteFile(String string) {
        return new File(string).getAbsoluteFile();
    }

    public static File canonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public static File canonicalFile(String string) throws IOException {
        return new File(new File(string).getCanonicalPath());
    }

    public static String canonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public static String canonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public static String canonicalOrAbsolutePath(String string) {
        try {
            return FileUtil.canonicalPath(string);
        }
        catch (Exception exception) {
            return FileUtil.absolutePath(string);
        }
    }
}

