/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.hsqldb.Binary;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.JavaObject;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcParameterMetaData;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.jdbc.jdbcResultSetMetaData;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.jdbc.jdbcUtil;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement {
    protected Object[] parameterValues;
    protected int[] parameterTypes;
    protected int[] parameterModes;
    protected Result rsmdDescriptor;
    protected Result pmdDescriptor;
    protected jdbcResultSetMetaData rsmd;
    protected Object pmd;
    protected String sql;
    protected int statementID;
    protected boolean isRowCount;

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
    }

    public boolean execute() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.resultIn = null;
        try {
            this.resultOut.setMaxRows(this.maxRows);
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw jdbcUtil.sqlException(hsqlException);
        }
        if (this.resultIn.iMode == 2) {
            jdbcUtil.throwError(this.resultIn);
        }
        return this.resultIn.iMode == 3;
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(false);
        this.resultIn = null;
        try {
            this.resultOut.setMaxRows(this.maxRows);
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw jdbcUtil.sqlException(hsqlException);
        }
        if (this.resultIn.iMode == 2) {
            jdbcUtil.throwError(this.resultIn);
        } else if (this.resultIn.iMode != 3) {
            String string = "Expected but did not recieve a result set";
            throw jdbcUtil.sqlException(85, string);
        }
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties);
    }

    public int executeUpdate() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(true);
        this.resultIn = null;
        try {
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw jdbcUtil.sqlException(hsqlException);
        }
        if (this.resultIn.iMode == 2) {
            jdbcUtil.throwError(this.resultIn);
        } else if (this.resultIn.iMode != 1) {
            String string = "Expected but did not recieve a row update count";
            throw jdbcUtil.sqlException(85, string);
        }
        return this.resultIn.getUpdateCount();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setParameter(n, null);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(n, bl2);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setIntParameter(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.setIntParameter(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setIntParameter(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.setLongParameter(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.setParameter(n, d2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setParameter(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.setParameter(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setParameter(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setParameter(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setParameter(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setParameter(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        if (inputStream == null) {
            String string = "input stream is null";
            throw jdbcUtil.sqlException(62, string);
        }
        String string = null;
        try {
            string = StringConverter.inputStreamToString(inputStream);
        }
        catch (IOException iOException) {
            throw jdbcUtil.sqlException(81);
        }
        this.setParameter(n, string);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3;
        this.checkSetParameterIndex(n);
        if (inputStream == null) {
            String string = "input stream is null";
            throw jdbcUtil.sqlException(62, string);
        }
        int n4 = n2 / 2;
        char[] cArray = new char[n4];
        try {
            int n5;
            int n6;
            for (n3 = 0; n3 < n4 && (n6 = inputStream.read()) != -1 && (n5 = inputStream.read()) != -1; ++n3) {
                cArray[n3] = (char)(n6 << 8 | n5);
            }
        }
        catch (IOException iOException) {
            throw jdbcUtil.sqlException(19);
        }
        String string = new String(cArray, 0, n3);
        this.setParameter(n, string);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3;
        this.checkSetParameterIndex(n);
        if (inputStream == null) {
            throw jdbcUtil.sqlException(Trace.error(62, 176));
        }
        byte[] byArray = new byte[n2];
        try {
            n3 = inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw jdbcUtil.sqlException(34, iOException.getMessage());
        }
        if (n3 < n2) {
            byte[] byArray2 = byArray;
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        this.setParameter(n, byArray);
    }

    public void clearParameters() throws SQLException {
        this.checkClosed();
        ArrayUtil.fillArray(this.parameterValues, null);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setParameter(n, object);
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        int n = this.parameterValues.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.parameterValues, 0, objectArray, 0, n);
        this.batchResultOut.add(objectArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        int n3;
        this.checkSetParameterIndex(n);
        if (reader == null) {
            String string = "reader is null";
            throw jdbcUtil.sqlException(62, string);
        }
        char[] cArray = new char[n2];
        try {
            n3 = reader.read(cArray);
            if (n3 == -1) {
                throw new IOException(Trace.getMessage(140));
            }
        }
        catch (IOException iOException) {
            throw jdbcUtil.sqlException(19, iOException.toString());
        }
        this.setParameter(n, new String(cArray, 0, n3));
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkSetParameterIndex(n);
        if (blob == null) {
            this.setParameter(n, null);
            return;
        }
        long l = blob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Blob input octet length exceeded: " + l;
            throw jdbcUtil.sqlException(34, string);
        }
        int n2 = (int)l;
        byte[] byArray = new byte[n2];
        try {
            n2 = blob.getBinaryStream().read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw jdbcUtil.sqlException(34, iOException.getMessage());
        }
        if ((long)n2 < l) {
            byte[] byArray2 = byArray;
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
        }
        this.setParameter(n, byArray);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        int n2;
        this.checkSetParameterIndex(n);
        if (clob == null) {
            this.setParameter(n, null);
            return;
        }
        long l = clob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Clob input character length exceeded: " + l;
            throw jdbcUtil.sqlException(34, string);
        }
        char[] cArray = new char[(int)l];
        try {
            n2 = clob.getCharacterStream().read(cArray);
            if (n2 == -1) {
                throw new IOException(Trace.getMessage(141));
            }
        }
        catch (IOException iOException) {
            throw jdbcUtil.sqlException(19, iOException.toString());
        }
        this.setParameter(n, new String(cArray, 0, n2));
    }

    public void setArray(int n, Array array) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.isRowCount) {
            return null;
        }
        if (this.rsmd == null) {
            this.rsmd = new jdbcResultSetMetaData(this.rsmdDescriptor, this.connection.connProperties);
        }
        return this.rsmd;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        String string;
        try {
            string = HsqlDateTime.getDateString(date, calendar);
        }
        catch (Exception exception) {
            throw jdbcUtil.sqlException(7, exception.getMessage());
        }
        this.setParameter(n, string);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        String string;
        try {
            string = HsqlDateTime.getTimeString(time, calendar);
        }
        catch (Exception exception) {
            throw jdbcUtil.sqlException(7, exception.getMessage());
        }
        this.setParameter(n, string);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        String string;
        this.checkSetParameterIndex(n);
        try {
            string = HsqlDateTime.getTimestampString(timestamp, calendar);
        }
        catch (Exception exception) {
            throw jdbcUtil.sqlException(7, exception.getMessage());
        }
        this.setParameter(n, string);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setParameter(n, null);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new jdbcParameterMetaData(this.pmdDescriptor);
        }
        return (ParameterMetaData)this.pmd;
    }

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string, int n) throws HsqlException, SQLException {
        super(jdbcConnection2, n);
        string = jdbcConnection2.nativeSQL(string);
        this.resultOut.setResultType(65555);
        this.resultOut.setMainString(string);
        Result result = this.connection.sessionProxy.execute(this.resultOut);
        if (result.iMode == 2) {
            jdbcUtil.throwError(result);
        }
        Iterator iterator = result.iterator();
        try {
            Object[] objectArray = (Object[])iterator.next();
            this.statementID = ((Result)objectArray[0]).getStatementID();
            objectArray = (Object[])iterator.next();
            this.rsmdDescriptor = (Result)objectArray[0];
            this.isRowCount = this.rsmdDescriptor.iMode == 1;
            objectArray = (Object[])iterator.next();
            this.pmdDescriptor = (Result)objectArray[0];
            this.parameterTypes = this.pmdDescriptor.metaData.getParameterTypes();
            this.parameterValues = new Object[this.parameterTypes.length];
            this.parameterModes = this.pmdDescriptor.metaData.paramMode;
        }
        catch (Exception exception) {
            throw Trace.error(40, exception.toString());
        }
        this.resultOut = new Result(65548, this.parameterTypes, this.statementID);
        this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
        this.sql = string;
    }

    protected void checkIsRowCount(boolean bl) throws SQLException {
        if (bl != this.isRowCount) {
            int n = bl ? 154 : 155;
            throw jdbcUtil.sqlException(n);
        }
    }

    protected void checkSetParameterIndex(int n) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.parameterValues.length) {
            String string = "parameter index out of range: " + n;
            throw jdbcUtil.sqlException(62, string);
        }
    }

    private void setParameter(int n, Object object) throws SQLException {
        this.checkSetParameterIndex(n);
        --n;
        if (object == null) {
            this.parameterValues[n] = null;
            return;
        }
        int n2 = this.parameterTypes[n];
        try {
            if (n2 == 1111) {
                object = new JavaObject(object, !this.connection.isNetConn);
            } else if (n2 == -2) {
                if (!(object instanceof byte[])) {
                    throw jdbcUtil.sqlException(Trace.error(95));
                }
                object = new Binary((byte[])object, !this.connection.isNetConn);
            } else if (!this.connection.isNetConn) {
                Object object2 = object;
                if ((object = Column.convertObject(object, n2)) == object2) {
                    if (n2 == 91) {
                        object = ((Date)object).clone();
                    } else if (n2 == 92) {
                        object = ((Time)object).clone();
                    } else if (n2 == 93) {
                        object = ((Timestamp)object).clone();
                    }
                }
            } else {
                object = Column.convertObject(object, n2);
            }
        }
        catch (HsqlException hsqlException) {
            jdbcUtil.throwError(hsqlException);
        }
        this.parameterValues[n] = object;
    }

    private void setIntParameter(int n, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        int n3 = this.parameterTypes[n - 1];
        switch (n3) {
            case -6: 
            case 4: 
            case 5: {
                Integer n4 = new Integer(n2);
                this.parameterValues[n - 1] = n4;
                break;
            }
            default: {
                this.setLongParameter(n, n2);
            }
        }
    }

    private void setLongParameter(int n, long l) throws SQLException {
        this.checkSetParameterIndex(n);
        int n2 = this.parameterTypes[n - 1];
        switch (n2) {
            case -5: {
                Long l2 = new Long(l);
                this.parameterValues[n - 1] = l2;
                break;
            }
            case -2: 
            case 1111: {
                throw jdbcUtil.sqlException(Trace.error(95));
            }
            default: {
                this.setParameter(n, new Long(l));
            }
        }
    }

    public void addBatch(String string) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public boolean execute(String string) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public int executeUpdate(String string) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        HsqlException hsqlException = null;
        try {
            if (!this.connection.isClosed) {
                this.connection.sessionProxy.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        this.parameterValues = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.rsmdDescriptor = null;
        this.pmdDescriptor = null;
        this.rsmd = null;
        this.pmd = null;
        super.close();
        if (hsqlException != null) {
            throw jdbcUtil.sqlException(hsqlException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        String string = this.sql;
        Object[] objectArray = this.parameterValues;
        if (string == null || objectArray == null) {
            stringBuffer.append("[closed]");
            return stringBuffer.toString();
        }
        stringBuffer.append("[sql=[").append(string).append("]");
        if (objectArray.length > 0) {
            stringBuffer.append(", parameters=[");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append('[');
                stringBuffer.append(objectArray[i]);
                stringBuffer.append("], ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

