/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcUtil;
import org.hsqldb.lib.AsciiStringInputStream;

public class jdbcClob
implements Clob {
    private String data;

    public jdbcClob(String string) throws SQLException {
        this.data = string;
    }

    public InputStream getAsciiStream() throws SQLException {
        return new AsciiStringInputStream(this.data);
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.data);
    }

    public String getSubString(long l, int n) throws SQLException {
        --l;
        try {
            Trace.check(l >= 0L && l <= (long)this.data.length(), 62, "pos: " + (l + 1L));
            Trace.check(n >= 0 && n <= Integer.MAX_VALUE, 62, "length: " + n);
            int n2 = (int)l + n;
            Trace.check(n2 <= this.data.length(), 62, "length: " + n);
            return this.data.substring((int)l, n2);
        }
        catch (HsqlException hsqlException) {
            throw jdbcUtil.sqlException(hsqlException);
        }
        catch (Throwable throwable) {
            throw jdbcUtil.sqlException(new HsqlException(new Result(throwable, null)));
        }
    }

    public long position(String string, long l) throws SQLException {
        --l;
        try {
            Trace.check(l >= 0L && l <= (long)this.data.length(), 62, "start: " + (l + 1L));
            int n = this.data.indexOf(string, (int)l);
            return n >= 0 ? (long)(n + 1) : -1L;
        }
        catch (HsqlException hsqlException) {
            throw jdbcUtil.sqlException(hsqlException);
        }
        catch (Throwable throwable) {
            throw jdbcUtil.sqlException(new HsqlException(new Result(throwable, null)));
        }
    }

    public long position(Clob clob, long l) throws SQLException {
        --l;
        try {
            Trace.check(l >= 0L && l <= Integer.MAX_VALUE, 62, "start: " + l);
            long l2 = clob.length();
            long l3 = this.data.length();
            if (l + l2 > l3) {
                return -1L;
            }
            Trace.check(l2 <= Integer.MAX_VALUE, 62, "searchstr.length(): " + l2 + " > " + Integer.MAX_VALUE);
            String string = clob.getSubString(1L, (int)l2);
            int n = this.data.indexOf(string, (int)l);
            return n >= 0 ? (long)(n + 1) : -1L;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (HsqlException hsqlException) {
            throw jdbcUtil.sqlException(hsqlException);
        }
        catch (Throwable throwable) {
            throw jdbcUtil.sqlException(new HsqlException(new Result(throwable, null)));
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public Writer setCharacterStream(long l) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public int setString(long l, String string) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public long length() throws SQLException {
        return this.data.length();
    }

    public void truncate(long l) throws SQLException {
        try {
            Trace.check(l >= 0L, 62, "len: " + l);
            Trace.check((l >>= 1) <= (long)this.data.length(), 62, "len: " + l);
            if (l != (long)this.data.length()) {
                this.data = this.data.substring(0, (int)l);
            }
        }
        catch (HsqlException hsqlException) {
            throw jdbcUtil.sqlException(hsqlException);
        }
        catch (Throwable throwable) {
            throw jdbcUtil.sqlException(new HsqlException(new Result(throwable, null)));
        }
    }
}

