/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlArrayList;

class View
extends Table {
    Table workingTable;
    Select viewSelect;
    SubQuery viewSubQuery;
    private String sStatement;
    SubQuery[] viewSubqueries;

    View(Database database, HsqlNameManager.HsqlName hsqlName, String string, HsqlArrayList hsqlArrayList) throws HsqlException {
        super(database, hsqlName, 7, 0);
        this.isReadOnly = true;
        this.setStatement(string, hsqlArrayList);
    }

    void setStatement(String string, HsqlArrayList hsqlArrayList) throws HsqlException {
        int n;
        String string2;
        Tokenizer tokenizer = new Tokenizer(string);
        do {
            n = tokenizer.getPosition();
        } while ((string2 = tokenizer.getString()).length() != 0 || tokenizer.wasValue());
        this.sStatement = string.substring(0, n).trim();
        tokenizer.reset(this.sStatement);
        tokenizer.getThis("SELECT");
        Parser parser = new Parser(this.database, tokenizer, this.database.sessionManager.getSysSession());
        this.viewSubQuery = parser.parseSubquery(null, true, 3);
        parser.setAsView(this);
        this.viewSubqueries = parser.getSortedSubqueries();
        this.workingTable = this.viewSubQuery.table;
        this.viewSelect = this.viewSubQuery.select;
        this.viewSelect.prepareResult();
        Result.ResultMetaData resultMetaData = this.viewSelect.resultMetaData;
        int n2 = this.viewSelect.iResultLen;
        if (hsqlArrayList != null) {
            if (hsqlArrayList.size() != n2) {
                throw Trace.error(5);
            }
            for (int i = 0; i < n2; ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)hsqlArrayList.get(i);
                resultMetaData.sLabel[i] = hsqlName.name;
                resultMetaData.isLabelQuoted[i] = hsqlName.isNameQuoted;
                this.viewSelect.exprColumns[i].setAlias(hsqlName.name, hsqlName.isNameQuoted);
                this.workingTable.renameColumn(this.workingTable.getColumn(i), hsqlName.name, hsqlName.isNameQuoted);
            }
        }
        super.addColumns(resultMetaData, n2);
        this.iVisibleColumns = this.iColumnCount;
    }

    String getStatement() {
        return this.sStatement;
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        throw Trace.error(55);
    }

    boolean hasTable(Table table) {
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            Select select = this.viewSubqueries[i].select;
            while (select != null) {
                TableFilter[] tableFilterArray = select.tFilter;
                for (int j = 0; j < tableFilterArray.length; ++j) {
                    if (table != tableFilterArray[j].filterTable) continue;
                    return true;
                }
                select = select.sUnion;
            }
        }
        return false;
    }
}

