/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;

class TableWorks {
    private Table table;

    TableWorks(Table table) {
        this.table = table;
    }

    Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }

    void createForeignKey(int[] nArray, int[] nArray2, HsqlNameManager.HsqlName hsqlName, Table table, int n, int n2) throws HsqlException {
        if (this.table.database.constraintNameList.containsName(hsqlName.name)) {
            throw Trace.error(60, hsqlName.name);
        }
        if (this.table.getConstraint(hsqlName.name) != null) {
            throw Trace.error(60);
        }
        if (this.table.getConstraintForColumns(table, nArray2, nArray) != null) {
            throw Trace.error(60);
        }
        if (table.isTemp() != this.table.isTemp()) {
            throw Trace.error(47);
        }
        boolean bl = this.table.database.getTableIndex(this.table) < this.table.database.getTableIndex(table);
        Index index = table.getConstraintIndexForColumns(nArray2);
        if (index == null) {
            throw Trace.error(170, table.getName().statementName);
        }
        Constraint.checkReferencedRows(this.table, nArray, index);
        HsqlNameManager.HsqlName hsqlName2 = this.table.database.nameManager.newAutoName("IDX");
        Index index2 = this.createIndex(nArray, hsqlName2, false, true, bl);
        HsqlNameManager.HsqlName hsqlName3 = this.table.database.nameManager.newAutoName("REF", hsqlName.name);
        Constraint constraint = new Constraint(hsqlName3, hsqlName, table, this.table, nArray2, nArray, index, index2, n, n2);
        this.table.addConstraint(constraint);
        table.addConstraint(new Constraint(hsqlName3, constraint));
        this.table.database.constraintNameList.addName(hsqlName.name, this.table.getName());
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        Index index;
        if (this.table.isEmpty() || this.table.isIndexingMutable()) {
            index = this.table.createIndex(nArray, hsqlName, bl, bl2, bl3);
        } else {
            Table table = this.table.moveDefinition(null, null, this.table.getColumnCount(), 0);
            index = table.createIndexStructure(nArray, hsqlName, false, bl, bl2, bl3);
            table.moveData(this.table, this.table.getColumnCount(), 0);
            table.updateConstraints(this.table, this.table.getColumnCount(), 0);
            int n = this.table.database.getTableIndex(this.table);
            this.table.database.getTables().set(n, table);
            this.table = table;
        }
        this.table.database.indexNameList.addName(index.getName().name, this.table.getName());
        return index;
    }

    void createUniqueConstraint(int[] nArray, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Constraint constraint;
        if (this.table.database.constraintNameList.containsName(hsqlName.name)) {
            throw Trace.error(60, hsqlName.name);
        }
        HsqlArrayList hsqlArrayList = this.table.getConstraints();
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            constraint = (Constraint)hsqlArrayList.get(i);
            if (!constraint.isEquivalent(nArray, 2) && !constraint.getName().name.equals(hsqlName.name)) continue;
            throw Trace.error(60);
        }
        HsqlNameManager.HsqlName hsqlName2 = this.table.database.nameManager.newAutoName("IDX", hsqlName.name);
        Index index = this.createIndex(nArray, hsqlName2, true, true, false);
        constraint = new Constraint(hsqlName, this.table, index);
        this.table.addConstraint(constraint);
        this.table.database.constraintNameList.addName(hsqlName.name, this.table.getName());
    }

    void createCheckConstraint(Constraint constraint, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        if (this.table.database.constraintNameList.containsName(hsqlName.name)) {
            throw Trace.error(60, hsqlName.name);
        }
        Expression expression = constraint.core.check;
        expression.setLikeOptimised();
        Select select = Expression.getCheckSelect(this.table, expression);
        Result result = select.getResult(1);
        constraint.core.checkFilter = select.tFilter[0];
        constraint.core.mainTable = this.table;
        if (result.getSize() != 0) {
            throw Trace.error(157);
        }
        expression.getDDL();
        this.table.addConstraint(constraint);
        this.table.database.constraintNameList.addName(hsqlName.name, this.table.getName());
    }

    void resetCheckConstraint(Constraint constraint) throws HsqlException {
    }

    void dropIndex(String string) throws HsqlException {
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(string);
        } else {
            Table table = this.table.moveDefinition(string, null, this.table.getColumnCount(), 0);
            table.moveData(this.table, this.table.getColumnCount(), 0);
            table.updateConstraints(this.table, this.table.getColumnCount(), 0);
            int n = this.table.database.getTableIndex(this.table);
            this.table.database.getTables().set(n, table);
            this.table = table;
        }
        this.table.database.indexNameList.removeName(string);
    }

    void addOrDropColumn(Column column, int n, int n2) throws HsqlException {
        if (this.table.isText()) {
            throw Trace.error(73);
        }
        if (n != this.table.getColumnCount()) {
            this.table.database.checkTableIsInView(this.table);
        }
        Table table = this.table.moveDefinition(null, column, n, n2);
        table.moveData(this.table, n, n2);
        table.updateConstraints(this.table, n, n2);
        int n3 = this.table.database.getTableIndex(this.table);
        this.table.database.getTables().set(n3, table);
        this.table = table;
    }

    void dropConstraint(String string) throws HsqlException {
        int n = this.table.getConstraintIndex(string);
        Constraint constraint = this.table.getConstraint(string);
        if (constraint == null) {
            throw Trace.error(61, 171, new Object[]{string, this.table.getName().name});
        }
        if (constraint.getType() == 1) {
            throw Trace.error(59);
        }
        if (constraint.getType() == 0) {
            Table table = constraint.getMain();
            int n2 = table.getConstraintIndex(constraint.getPkName());
            Index index = constraint.getRefIndex();
            this.dropIndex(index.getName().name);
            table.vConstraint.remove(n2);
            this.table.vConstraint.remove(n);
        } else if (constraint.getType() == 2) {
            HashSet hashSet = new HashSet();
            hashSet.add(constraint);
            this.table.checkDropIndex(constraint.getMainIndex().getName().name, hashSet);
            this.dropIndex(constraint.getMainIndex().getName().name);
            this.table.vConstraint.remove(n);
        } else if (constraint.getType() == 3) {
            this.table.vConstraint.remove(n);
        }
        this.table.database.constraintNameList.removeName(string);
    }
}

