/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.BaseTable;
import org.hsqldb.Cache;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.NumberSequence;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.store.ValuePool;

public class Table
extends BaseTable {
    public static final int SYSTEM_TABLE = 0;
    public static final int SYSTEM_SUBQUERY = 1;
    public static final int TEMP_TABLE = 2;
    public static final int MEMORY_TABLE = 3;
    public static final int CACHED_TABLE = 4;
    public static final int TEMP_TEXT_TABLE = 5;
    public static final int TEXT_TABLE = 6;
    public static final int VIEW = 7;
    static final int SYSTEM_VIEW = 7;
    static final String DEFAULT_PK = "";
    public HashMappedList vColumn;
    private HsqlArrayList vIndex;
    int[] iPrimaryKey;
    int iIndexCount;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    boolean needsRowID;
    int[] nullRowIDCols;
    int identityColumn;
    NumberSequence identitySequence;
    NumberSequence rowIdSequence;
    HsqlArrayList vConstraint;
    HsqlArrayList[] vTrigs;
    private int[] colTypes;
    private int[] colSizes;
    private boolean[] colNullable;
    private String[] colDefaults;
    private int[] defaultColumnMap;
    private boolean hasDefaultValues;
    private boolean isSystem;
    private boolean isText;
    private boolean isView;
    boolean sqlEnforceSize;
    boolean sqlEnforceStrictSize;
    protected int iColumnCount;
    protected int iVisibleColumns;
    protected Database database;
    protected Cache cache;
    protected HsqlNameManager.HsqlName tableName;
    protected int tableType;
    protected int ownerSessionId;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected int indexType;
    HashSet constraintPath = new HashSet();

    Table(Database database, HsqlNameManager.HsqlName hsqlName, int n, int n2) throws HsqlException {
        this.database = database;
        this.sqlEnforceSize = database.sqlEnforceSize;
        this.sqlEnforceStrictSize = database.sqlEnforceStrictSize;
        this.identitySequence = new NumberSequence(null, 0L, 1L, -5);
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        switch (n) {
            case 0: 
            case 1: {
                this.isTemp = true;
                break;
            }
            case 2: {
                this.isTemp = true;
                this.ownerSessionId = n2;
                break;
            }
            case 4: {
                this.cache = database.logger.getCache();
                if (this.cache != null) {
                    this.isCached = true;
                    break;
                }
                n = 3;
                break;
            }
            case 5: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                this.isCached = true;
                this.ownerSessionId = n2;
                break;
            }
            case 6: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isText = true;
                this.isCached = true;
                break;
            }
            case 7: {
                this.isView = true;
            }
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.iPrimaryKey = null;
        this.identityColumn = -1;
        this.vColumn = new HashMappedList();
        this.vIndex = new HsqlArrayList();
        this.vConstraint = new HsqlArrayList();
        this.vTrigs = new HsqlArrayList[12];
        for (int i = 0; i < 12; ++i) {
            this.vTrigs[i] = new HsqlArrayList();
        }
        if (database.filesReadOnly && this.checkTableFileBased()) {
            this.isReadOnly = true;
        }
    }

    boolean equals(String string, Session session) {
        if (this.isTemp && session.getId() != this.ownerSessionId) {
            return false;
        }
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    final boolean isSystem() {
        return this.tableType == 0 || this.tableType == 1;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.filesReadOnly && this.checkTableFileBased()) {
            throw Trace.error(32);
        }
        this.isReadOnly = bl;
    }

    boolean checkTableFileBased() {
        return this.isCached | this.isText;
    }

    int getOwnerSessionId() {
        return this.ownerSessionId;
    }

    protected void setDataSource(String string, boolean bl, Session session, boolean bl2) throws HsqlException {
        throw Trace.error(22);
    }

    protected String getDataSource() {
        return null;
    }

    protected boolean isDescDataSource() {
        return false;
    }

    void addConstraint(Constraint constraint) {
        this.vConstraint.add(constraint);
    }

    HsqlArrayList getConstraints() {
        return this.vConstraint;
    }

    Index getConstraintIndexForColumns(int[] nArray) {
        if (ArrayUtil.areEqual(this.getPrimaryIndex().getColumns(), nArray, nArray.length, true)) {
            return this.getPrimaryIndex();
        }
        int n = this.vConstraint.size();
        for (int i = 0; i < n; ++i) {
            Constraint constraint = (Constraint)this.vConstraint.get(i);
            if (constraint.getType() != 2 || !ArrayUtil.areEqual(constraint.getMainColumns(), nArray, nArray.length, true)) continue;
            return constraint.getMainIndex();
        }
        return null;
    }

    Constraint getConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        int n = this.vConstraint.size();
        for (int i = 0; i < n; ++i) {
            Constraint constraint = (Constraint)this.vConstraint.get(i);
            if (!constraint.isEquivalent(table, nArray, this, nArray2)) continue;
            return constraint;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = this.vConstraint.size();
        for (int i = n; i < n3; ++i) {
            Constraint constraint = (Constraint)this.vConstraint.get(i);
            if (constraint.getType() != n2) continue;
            return i;
        }
        return -1;
    }

    void addColumn(String string, int n) throws HsqlException {
        Column column = new Column(this.database.nameManager.newHsqlName(string, false), true, n, 0, 0, false, 0L, 0L, false, null);
        this.addColumn(column);
    }

    void addColumn(Column column) throws HsqlException {
        if (this.searchColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4 || column.getType() == -5, 16, column.columnName.name);
            Trace.check(this.identityColumn == -1, 24, column.columnName.name);
            this.identityColumn = this.iColumnCount;
        }
        Trace.doAssert(this.iPrimaryKey == null, "Table.addColumn");
        this.vColumn.add(column.columnName.name, column);
        ++this.iColumnCount;
        ++this.iVisibleColumns;
    }

    void addColumns(Result.ResultMetaData resultMetaData, int n) throws HsqlException {
        for (int i = 0; i < n; ++i) {
            Column column = new Column(this.database.nameManager.newHsqlName(resultMetaData.sLabel[i], resultMetaData.isLabelQuoted[i]), true, resultMetaData.colType[i], resultMetaData.colSize[i], resultMetaData.colScale[i], false, 0L, 0L, false, null);
            this.addColumn(column);
        }
    }

    void addColumns(Select select) throws HsqlException {
        int n = select.iResultLen;
        for (int i = 0; i < n; ++i) {
            Expression expression = select.exprColumns[i];
            Column column = new Column(this.database.nameManager.newHsqlName(expression.getAlias(), expression.isAliasQuoted()), true, expression.getDataType(), expression.getColumnSize(), expression.getColumnScale(), false, 0L, 0L, false, null);
            this.addColumn(column);
        }
    }

    public HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    void setName(String string, boolean bl) throws HsqlException {
        this.tableName.rename(string, bl);
        if (HsqlNameManager.HsqlName.isReservedIndexName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    protected Table duplicate() throws HsqlException {
        Table table = new Table(this.database, this.tableName, this.tableType, this.ownerSessionId);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws HsqlException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= this.iColumnCount || nArray2[i] >= table.iColumnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[i]).getType() == table.getColumn(nArray2[i]).getType()) continue;
            throw Trace.error(57);
        }
    }

    Table moveDefinition(String string, Column column, int n, int n2) throws HsqlException {
        int[] nArray;
        Table table = this.duplicate();
        for (int i = 0; i < this.iVisibleColumns + 1; ++i) {
            if (i == n) {
                if (n2 > 0) {
                    table.addColumn(column);
                } else if (n2 < 0) continue;
            }
            if (i == this.iVisibleColumns) break;
            table.addColumn(this.getColumn(i));
        }
        int[] nArray2 = nArray = this.iPrimaryKey[0] == this.iVisibleColumns ? null : this.iPrimaryKey;
        if (nArray != null) {
            int[] nArray3 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
            if (nArray.length != nArray3.length) {
                throw Trace.error(25);
            }
            nArray = nArray3;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray, false);
        table.vConstraint = this.vConstraint;
        for (int i = 1; i < this.getIndexCount(); ++i) {
            Index index;
            Index index2 = this.getIndex(i);
            if (string != null && index2.getName().name.equals(string) || (index = table.createAdjustedIndex(index2, n, n2)) != null) continue;
            throw Trace.error(123);
        }
        table.vTrigs = this.vTrigs;
        return table;
    }

    void updateConstraints(Table table, int n, int n2) throws HsqlException {
        int n3 = this.vConstraint.size();
        for (int i = 0; i < n3; ++i) {
            Constraint constraint = (Constraint)this.vConstraint.get(i);
            constraint.replaceTable(table, this, n, n2);
        }
    }

    public int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.identityColumn;
    }

    int getColumnNr(String string) throws HsqlException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = this.vColumn.getIndex(string);
        return n == this.iVisibleColumns ? -1 : n;
    }

    Index getPrimaryIndex() {
        if (this.iPrimaryKey == null) {
            return null;
        }
        return this.getIndex(0);
    }

    int[] getPrimaryKey() {
        return this.iPrimaryKey[0] == this.iVisibleColumns ? null : this.iPrimaryKey;
    }

    public boolean hasPrimaryKey() {
        return this.iPrimaryKey[0] != this.iVisibleColumns;
    }

    int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    private void setBestRowIdentifiers() {
        int n;
        int[] nArray = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        if (this.colNullable == null) {
            return;
        }
        this.bestIndexForColumn = new int[this.vColumn.size()];
        this.nullRowIDCols = new int[this.vColumn.size()];
        for (n = 0; n < this.bestIndexForColumn.length; ++n) {
            this.bestIndexForColumn[n] = -1;
            this.nullRowIDCols[n] = -1;
        }
        for (n = 0; n < this.vIndex.size(); ++n) {
            Index index = (Index)this.vIndex.get(n);
            int[] nArray2 = index.getColumns();
            int n4 = index.getVisibleColumns();
            if (n == 0 && this.getPrimaryKey() == null) continue;
            if (this.bestIndexForColumn[nArray2[0]] == -1) {
                this.bestIndexForColumn[nArray2[0]] = n;
            }
            if (!index.isUnique()) continue;
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                if (!this.colNullable[nArray2[i]]) {
                    ++n5;
                    continue;
                }
                this.nullRowIDCols[nArray2[i]] = nArray2[i];
            }
            if (n5 == n4) {
                if (nArray != null && n2 == n3 && n4 >= n2) continue;
                nArray = nArray2;
                n2 = n4;
                n3 = n4;
                bl = true;
                continue;
            }
            if (bl || nArray != null && n4 >= n2 && n5 <= n3) continue;
            nArray = nArray2;
            n2 = n4;
            n3 = n5;
        }
        this.bestRowIdentifierCols = nArray == null || n2 == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n2);
        this.bestRowIdentifierStrict = bl;
        ArrayUtil.sortArray(this.nullRowIDCols);
        n = ArrayUtil.findNot(this.nullRowIDCols, -1);
        this.nullRowIDCols = n == -1 ? null : ArrayUtil.arraySlice(this.nullRowIDCols, 0, n);
        this.needsRowID = this.getPrimaryKey() == null;
    }

    void setDefaultString(int n, String string) {
        Column column = this.getColumn(n);
        column.setDefaultString(string);
        this.hasDefaultValues = false;
        for (int i = 0; i < this.iColumnCount; ++i) {
            column = this.getColumn(i);
            if (i >= this.iVisibleColumns) continue;
            this.hasDefaultValues = this.hasDefaultValues || column.getDefaultString() != null;
            this.colDefaults[i] = column.getDefaultString();
        }
    }

    Index getIndexForColumn(int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 == -1 && this.tableType == 1 || this.tableType == 0) {
            try {
                this.createIndex(new int[]{n}, null, false, false, false);
                n2 = this.bestIndexForColumn[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2 == -1 ? null : this.getIndex(n2);
    }

    Index getIndexForColumns(boolean[] blArray) {
        Index index = null;
        int n = 0;
        for (int i = 0; i < this.vIndex.size(); ++i) {
            Index index2 = (Index)this.vIndex.get(i);
            boolean bl = ArrayUtil.containsAllTrueElements(blArray, index2.colCheck);
            if (!bl || index2.getVisibleColumns() <= n) continue;
            n = index2.getVisibleColumns();
            index = index2;
        }
        return index;
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws HsqlException {
        for (int i = 0; i < this.iIndexCount; ++i) {
            Index index = this.getIndex(i);
            int[] nArray2 = index.getColumns();
            if (!ArrayUtil.haveEqualArrays(nArray2, nArray, nArray.length) || bl && !index.isUnique()) continue;
            return index;
        }
        return null;
    }

    int[] getIndexRootsArray() {
        int[] nArray = new int[this.iIndexCount];
        for (int i = 0; i < this.iIndexCount; ++i) {
            Node node = this.getIndex(i).getRoot();
            nArray[i] = node != null ? node.getKey() : -1;
        }
        return nArray;
    }

    String getIndexRoots() {
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", DEFAULT_PK);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.identitySequence.peek());
        return stringBuffer.toString();
    }

    void setIndexRoots(int[] nArray) throws HsqlException {
        Trace.check(this.isCached, 22);
        for (int i = 0; i < this.iIndexCount; ++i) {
            int n = nArray[i];
            CachedRow cachedRow = null;
            if (n != -1) {
                cachedRow = this.cache.getRow(n, this);
            }
            Node node = null;
            if (cachedRow != null) {
                node = cachedRow.getNode(i);
            }
            this.getIndex(i).setRoot(node);
        }
    }

    void setIndexRoots(String string) throws HsqlException {
        Trace.check(this.isCached, 22);
        int[] nArray = new int[this.iIndexCount];
        int n = 0;
        for (int i = 0; i < this.iIndexCount; ++i) {
            int n2;
            int n3 = string.indexOf(32, n);
            nArray[i] = n2 = Integer.parseInt(string.substring(n, n3));
            n = n3 + 1;
        }
        this.setIndexRoots(nArray);
        this.identitySequence.reset(Long.parseLong(string.substring(n)));
    }

    Index getNextIndex(Index index) {
        int n;
        if (index != null) {
            for (n = 0; n < this.iIndexCount && this.getIndex(n) != index; ++n) {
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    void createPrimaryKey(int[] nArray) throws HsqlException {
        this.createPrimaryKey(null, nArray, false);
    }

    void createPrimaryKey() throws HsqlException {
        this.createPrimaryKey(null, null, false);
    }

    void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) throws HsqlException {
        Trace.doAssert(this.iPrimaryKey == null, "Table.createPrimaryKey(column)");
        Column column = new Column(this.database.nameManager.newAutoName(DEFAULT_PK), false, 4, 0, 0, false, 0L, 0L, nArray == null, null);
        this.addColumn(column);
        --this.iVisibleColumns;
        if (nArray == null) {
            nArray = new int[]{this.iVisibleColumns};
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (bl) {
                    this.getColumn(nArray[i]).setNullable(false);
                }
                this.getColumn(nArray[i]).setPrimaryKey(true);
            }
        }
        this.iPrimaryKey = nArray;
        HsqlNameManager.HsqlName hsqlName2 = hsqlName != null ? hsqlName : this.database.nameManager.newHsqlName("SYS_PK", this.tableName.name, this.tableName.isNameQuoted);
        this.createIndexStructure(nArray, hsqlName2, true, true, true, false);
        this.colTypes = new int[this.iColumnCount];
        this.colDefaults = new String[this.iVisibleColumns];
        this.colSizes = new int[this.iVisibleColumns];
        this.colNullable = new boolean[this.iVisibleColumns];
        this.defaultColumnMap = new int[this.iVisibleColumns];
        for (int i = 0; i < this.iColumnCount; ++i) {
            column = this.getColumn(i);
            this.colTypes[i] = column.getType();
            if (i < this.iVisibleColumns) {
                this.hasDefaultValues = this.hasDefaultValues || column.getDefaultString() != null;
                this.colDefaults[i] = column.getDefaultString();
                this.colSizes[i] = column.getSize();
                this.colNullable[i] = column.isNullable() || column.isIdentity();
                this.defaultColumnMap[i] = i;
            }
            if (!column.isIdentity()) continue;
            this.identitySequence.reset(column.identityStart, column.identityIncrement);
        }
        this.setBestRowIdentifiers();
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws HsqlException {
        int[] nArray = (int[])ArrayUtil.resizeArray(index.getColumns(), index.getVisibleColumns());
        int[] nArray2 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
        if (nArray2.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexStructure(nArray2, index.getName(), false, index.isUnique(), index.isConstraint, index.isForward);
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, false, bl, bl2, bl3);
        Index index = (Index)this.vIndex.get(n);
        Index index2 = this.getPrimaryIndex();
        Node node = index2.first();
        int n2 = 0;
        try {
            while (node != null) {
                Row row = node.getRow();
                Node node2 = Node.newNode(row, n, this);
                Node node3 = row.getNode(n - 1);
                node2.nNext = node3.nNext;
                node3.nNext = node2;
                index.insert(node2);
                node = index2.next(node);
            }
            return index;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n2 = 72;
        }
        catch (HsqlException hsqlException) {
            n2 = 9;
        }
        Node node4 = node;
        node = index2.first();
        while (node != node4) {
            int n3 = n;
            Node node5 = node;
            while (--n3 > 0) {
                node5 = node5.nNext;
            }
            node5.nNext = node5.nNext.nNext;
            node = index2.next(node);
        }
        this.vIndex.remove(index);
        this.iIndexCount = this.vIndex.size();
        this.setBestRowIdentifiers();
        throw Trace.error(n2);
    }

    Index createIndexStructure(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws HsqlException {
        return (Index)this.vIndex.get(this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3, bl4));
    }

    int createIndexStructureGetNo(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws HsqlException {
        int n;
        Trace.doAssert(this.iPrimaryKey != null, "createIndex");
        int n2 = nArray.length;
        int n3 = bl ? 0 : this.iPrimaryKey.length;
        int[] nArray2 = new int[n2 + n3];
        int[] nArray3 = new int[n2 + n3];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray[n];
            nArray3[n] = this.getColumn(nArray2[n]).getType();
        }
        if (!bl) {
            for (n = 0; n < n3; ++n) {
                nArray2[n2 + n] = this.iPrimaryKey[n];
                nArray3[n2 + n] = this.getColumn(this.iPrimaryKey[n]).getType();
            }
        }
        if (nArray2[0] == this.iVisibleColumns) {
            n2 = 0;
        }
        Index index = new Index(hsqlName, this, nArray2, nArray3, bl2, bl3, bl4, n2);
        int n4 = this.addIndex(index);
        this.iIndexCount = this.vIndex.size();
        this.setBestRowIdentifiers();
        return n4;
    }

    private int addIndex(Index index) {
        int n;
        for (n = 0; n < this.vIndex.size(); ++n) {
            Index index2 = (Index)this.vIndex.get(n);
            int n2 = index.getIndexOrderValue() - index2.getIndexOrderValue();
            if (n2 < 0) break;
        }
        this.vIndex.add(n, index);
        return n;
    }

    boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    void checkDropIndex(String string, HashSet hashSet) throws HsqlException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n = this.vConstraint.size();
        for (int i = 0; i < n; ++i) {
            Constraint constraint = (Constraint)this.vConstraint.get(i);
            if (hashSet != null && hashSet.contains(constraint)) continue;
            if (constraint.isIndexFK(index)) {
                throw Trace.error(50, string);
            }
            if (!constraint.isIndexUnique(index)) continue;
            throw Trace.error(56, string);
        }
    }

    boolean isEmpty() {
        if (this.iIndexCount == 0) {
            return true;
        }
        return this.getIndex(0).getRoot() == null;
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.iVisibleColumns];
    }

    boolean[] getNewColumnCheckList() {
        return new boolean[this.iVisibleColumns];
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    Object[] getNewRow(boolean[] blArray) throws HsqlException {
        Object[] objectArray = new Object[this.iColumnCount];
        if (blArray != null && this.hasDefaultValues) {
            for (int i = 0; i < this.iVisibleColumns; ++i) {
                String string = this.colDefaults[i];
                if (blArray[i] || string == null) continue;
                objectArray[i] = Column.convertObject(string, this.colTypes[i]);
            }
        }
        return objectArray;
    }

    void dropIndex(String string) throws HsqlException {
        Index index;
        int n;
        for (n = 1; n < this.getIndexCount(); ++n) {
            index = this.getIndex(n);
            if (!index.getName().name.equals(string)) continue;
            this.vIndex.remove(n);
            this.iIndexCount = this.vIndex.size();
            this.setBestRowIdentifiers();
            break;
        }
        index = this.getPrimaryIndex();
        Node node = index.first();
        while (node != null) {
            int n2 = n - 1;
            Node node2 = node;
            while (n2-- > 0) {
                node2 = node2.nNext;
            }
            node2.nNext = node2.nNext.nNext;
            node = index.next(node);
        }
    }

    void moveData(Table table, int n, int n2) throws HsqlException {
        Object object;
        Object object2 = null;
        if (n2 > 0) {
            object = this.getColumn(n);
            object2 = Column.convertObject(((Column)object).getDefaultString(), ((Column)object).getType());
        }
        object = table.getPrimaryIndex();
        Node node = ((Index)object).first();
        while (node != null) {
            Object[] objectArray = node.getData();
            Object[] objectArray2 = this.getNewRow();
            ArrayUtil.copyAdjustArray(objectArray, objectArray2, object2, n, n2);
            this.insertNoCheck(objectArray2, null, false);
            node = ((Index)object).next(node);
        }
        table.drop();
    }

    int insert(Result result, Session session) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            this.enforceCheckConstraints(record.data);
            record = record.next;
        }
        record = result.rRoot;
        this.fireAll(3);
        while (record != null) {
            this.insertRow(record.data, session);
            record = record.next;
            ++n;
        }
        this.fireAll(0);
        return n;
    }

    void insert(Object[] objectArray, Session session) throws HsqlException {
        this.enforceCheckConstraints(objectArray);
        this.fireAll(3);
        this.insertRow(objectArray, session);
        this.fireAll(0);
    }

    private void insertRow(Object[] objectArray, Session session) throws HsqlException {
        this.fireAll(9, null, objectArray);
        if (this.database.isReferentialIntegrity()) {
            int n = this.vConstraint.size();
            for (int i = 0; i < n; ++i) {
                ((Constraint)this.vConstraint.get(i)).checkInsert(objectArray);
            }
        }
        this.insertNoCheck(objectArray, session, true);
        this.fireAll(6, null, objectArray);
    }

    void insertIntoTable(Result result, Session session) throws HsqlException {
        boolean bl;
        Record record = result.rRoot;
        int n = result.getColumnCount();
        boolean bl2 = bl = !this.isTemp && !this.isText && this.database.logger.hasLog();
        while (record != null) {
            Object[] objectArray = this.getNewRow();
            for (int i = 0; i < n; ++i) {
                objectArray[i] = record.data[i];
            }
            try {
                Row row = Row.newRow(this, objectArray);
                this.indexRow(row);
                if (bl) {
                    this.database.logger.writeInsertStatement(session, this, objectArray);
                }
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            record = record.next;
        }
    }

    public void insertNoCheck(Object[] objectArray, Session session, boolean bl) throws HsqlException {
        this.setIdentityColumn(objectArray, session);
        if (session != null) {
            this.enforceFieldValueLimits(objectArray);
        }
        Row row = Row.newRow(this, objectArray);
        this.indexRow(row);
        if (session != null) {
            session.addTransactionInsert(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
    }

    void insertNoCheckRollback(Object[] objectArray, Session session, boolean bl) throws HsqlException {
        Row row = Row.newRow(this, objectArray);
        this.indexRow(row);
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
    }

    protected void insertNoChange(CachedDataRow cachedDataRow) throws HsqlException {
        Object[] objectArray = cachedDataRow.getData();
        this.enforceCheckConstraints(objectArray);
        this.setIdentityColumn(objectArray, null);
        this.indexRow(cachedDataRow);
    }

    protected void enforceCheckConstraints(Object[] objectArray) throws HsqlException {
        for (int i = 0; i < this.iVisibleColumns; ++i) {
            if (objectArray[i] != null || this.colNullable[i]) continue;
            Trace.throwerror(10, "column: " + this.getColumn((int)i).columnName.name + " table: " + this.tableName.name);
        }
    }

    protected void setIdentityColumn(Object[] objectArray, Session session) throws HsqlException {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = this.colTypes[this.identityColumn] == 4 ? (Number)ValuePool.getInt((int)this.identitySequence.getValue()) : (Number)ValuePool.getLong(this.identitySequence.getValue());
                objectArray[this.identityColumn] = number;
            } else {
                this.identitySequence.getValue(number.longValue());
            }
            if (session != null) {
                session.setLastIdentity(number);
            }
        }
    }

    void enforceFieldValueLimits(Object[] objectArray) throws HsqlException {
        if (this.sqlEnforceSize || this.sqlEnforceStrictSize) {
            for (int i = 0; i < this.iVisibleColumns; ++i) {
                if (this.colSizes[i] == 0 || objectArray[i] == null) continue;
                objectArray[i] = Table.enforceSize(objectArray[i], this.colTypes[i], this.colSizes[i], true, this.sqlEnforceStrictSize);
            }
        }
    }

    void enforceFieldValueLimits(Object[] objectArray, int[] nArray) throws HsqlException {
        if (this.sqlEnforceSize) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (this.colSizes[n] == 0 || objectArray[n] == null) continue;
                objectArray[n] = Table.enforceSize(objectArray[n], this.colTypes[n], this.colSizes[n], true, this.sqlEnforceStrictSize);
            }
        }
    }

    static Object enforceSize(Object object, int n, int n2, boolean bl, boolean bl2) throws HsqlException {
        if (n2 == 0) {
            return object;
        }
        switch (n) {
            case 1: {
                return Table.padOrTrunc((String)object, n2, bl, bl2);
            }
            case 12: {
                return Table.padOrTrunc((String)object, n2, false, bl2);
            }
        }
        return object;
    }

    static String padOrTrunc(String string, int n, boolean bl, boolean bl2) throws HsqlException {
        if (bl2 && StringUtil.rTrimSize(string) > n) {
            throw Trace.error(124);
        }
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        if (!bl) {
            return string;
        }
        char[] cArray = new char[n];
        string.getChars(0, n2, cArray, 0);
        for (int i = n2; i < n; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    void fireAll(int n, Object[] objectArray, Object[] objectArray2) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        HsqlArrayList hsqlArrayList = this.vTrigs[n];
        int n2 = hsqlArrayList.size();
        for (int i = 0; i < n2; ++i) {
            TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(i);
            triggerDef.pushPair(objectArray, objectArray2);
        }
    }

    void fireAll(int n) {
        this.fireAll(n, null, null);
    }

    void addTrigger(TriggerDef triggerDef) {
        this.vTrigs[triggerDef.vectorIndx].add(triggerDef);
    }

    void dropTrigger(String string) {
        int n = 12;
        for (int i = 0; i < n; ++i) {
            HsqlArrayList hsqlArrayList = this.vTrigs[i];
            for (int j = hsqlArrayList.size() - 1; j >= 0; --j) {
                TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(j);
                if (!triggerDef.name.name.equals(string)) continue;
                hsqlArrayList.remove(j);
                triggerDef.terminate();
            }
        }
    }

    void checkCascadeDelete(Row row, Session session, boolean bl, HashSet hashSet) throws HsqlException {
        int n = this.vConstraint.size();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            Node node;
            Constraint constraint = (Constraint)this.vConstraint.get(i);
            if (constraint.getType() != 1 || constraint.getRef() == null || (node = constraint.findFkRef(row.getData(), true)) == null) continue;
            Table table = constraint.getRef();
            boolean bl3 = bl2 = table.getNextConstraintIndex(0, 1) != -1;
            if (!bl && !bl2) {
                return;
            }
            Result result = new Result(3);
            Index index = constraint.getRefIndex();
            int[] nArray = constraint.getMainColumns();
            int[] nArray2 = constraint.getRefColumns();
            Object[] objectArray = row.getData();
            Object object = node;
            while (!((Node)object).isDeleted() && index.compareRowNonUnique(objectArray, nArray, ((Node)object).getData()) == 0) {
                object = ((Node)object).getUpdatedNode();
                Node node2 = index.next((Node)object);
                if (constraint.getDeleteAction() == 2 || constraint.getDeleteAction() == 4) {
                    int n2;
                    Object[] objectArray2 = table.getNewRow();
                    System.arraycopy(((Node)object).getData(), 0, objectArray2, 0, objectArray2.length);
                    if (constraint.getDeleteAction() == 2) {
                        for (n2 = 0; n2 < nArray2.length; ++n2) {
                            objectArray2[nArray2[n2]] = null;
                        }
                    } else {
                        for (n2 = 0; n2 < nArray2.length; ++n2) {
                            objectArray2[nArray2[n2]] = Column.convertObject(table.getColumn(nArray2[n2]).getDefaultString(), table.getColumn(nArray2[n2]).getType());
                        }
                    }
                    if (bl2 && hashSet.add(constraint)) {
                        table.checkCascadeUpdate(((Node)object).getRow(), objectArray2, session, nArray2, null, bl, hashSet);
                        hashSet.remove(constraint);
                        object = ((Node)object).getUpdatedNode();
                        Node node3 = node2 = node2 == null ? null : node2.getUpdatedNode();
                    }
                    if (bl && (table != this || ((Node)object).getRow() != row.getUpdatedRow())) {
                        result.add(objectArray2);
                    }
                } else if (bl2) {
                    if (table != this) {
                        if (hashSet.add(constraint)) {
                            table.checkCascadeDelete(((Node)object).getRow(), session, bl, hashSet);
                            hashSet.remove(constraint);
                            object = ((Node)object).getUpdatedNode();
                            node2 = node2 == null ? null : node2.getUpdatedNode();
                        }
                    } else {
                        Row row2 = row = row == null ? null : row.getUpdatedRow();
                        if (((Node)object).getRow() != row) {
                            table.checkCascadeDelete(((Node)object).getRow(), session, bl, hashSet);
                            object = ((Node)object).getUpdatedNode();
                            Node node4 = node2 = node2 == null ? null : node2.getUpdatedNode();
                        }
                    }
                }
                if (bl && !((Node)object).isDeleted()) {
                    table.deleteNoRefCheck(((Node)object).getRow(), session);
                }
                if (node2 == null) break;
                object = node2;
            }
            if (!bl) continue;
            object = result.rRoot;
            while (object != null) {
                table.insertNoCheck(((Record)object).data, session, true);
                object = ((Record)object).next;
            }
        }
    }

    void checkCascadeUpdate(Row row, Object[] objectArray, Session session, int[] nArray, Table table, boolean bl, HashSet hashSet) throws HsqlException {
        for (int i = 0; i < this.vConstraint.size(); ++i) {
            Node node;
            Object object;
            int[] nArray2;
            Constraint constraint = (Constraint)this.vConstraint.get(i);
            if (constraint.getType() == 0 && constraint.getRef() != null) {
                if (table != null && constraint.getMain() == table || (nArray2 = ArrayUtil.commonElements(nArray, constraint.getRefColumns())) == null) continue;
                object = constraint.findMainRef(objectArray);
                continue;
            }
            if (constraint.getType() != 1 || constraint.getRef() == null || (nArray2 = ArrayUtil.commonElements(nArray, constraint.getMainColumns())) == null) continue;
            object = constraint.getMainColumns();
            int[] nArray3 = constraint.getRefColumns();
            boolean bl2 = true;
            for (int j = 0; j < ((Object)object).length; ++j) {
                if (row.getData()[object[j]].equals(objectArray[object[j]])) continue;
                bl2 = false;
                break;
            }
            if (bl2 || (node = constraint.findFkRef(row.getData(), false)) == null) continue;
            Table table2 = constraint.getRef();
            boolean bl3 = table2.getNextConstraintIndex(0, 1) != -1;
            Index index = constraint.getRefIndex();
            Object[] objectArray2 = new Object[nArray3.length];
            ArrayUtil.copyColumnValues(objectArray, nArray3, objectArray2);
            Result result = new Result(3);
            Object object2 = node;
            while (index.compareRowNonUnique(row.getData(), (int[])object, ((Node)object2).getData()) == 0) {
                int n;
                object2 = ((Node)object2).getUpdatedNode();
                Node node2 = index.next((Node)object2);
                Object[] objectArray3 = table2.getNewRow();
                System.arraycopy(((Node)object2).getData(), 0, objectArray3, 0, objectArray3.length);
                if (constraint.getUpdateAction() == 2) {
                    for (n = 0; n < nArray3.length; ++n) {
                        objectArray3[nArray3[n]] = null;
                    }
                } else if (constraint.getUpdateAction() == 4) {
                    for (n = 0; n < nArray3.length; ++n) {
                        objectArray3[nArray3[n]] = Column.convertObject(table2.getColumn(nArray3[n]).getDefaultString(), table2.getColumn(nArray3[n]).getType());
                    }
                    if (hashSet.add(constraint)) {
                        table2.checkCascadeUpdate(((Node)object2).getRow(), objectArray3, session, nArray3, null, bl, hashSet);
                        hashSet.remove(constraint);
                    }
                } else {
                    for (n = 0; n < ((Object)object).length; ++n) {
                        objectArray3[nArray3[n]] = objectArray[object[n]];
                    }
                    if (hashSet.add(constraint)) {
                        table2.checkCascadeUpdate(((Node)object2).getRow(), objectArray3, session, nArray2, this, bl, hashSet);
                        hashSet.remove(constraint);
                    }
                }
                if (bl) {
                    result.add(objectArray3);
                    table2.deleteNoRefCheck(((Node)object2).getData(), session);
                    if (table2 == this) {
                        node2 = constraint.findFkRef(row.getData(), false);
                    }
                }
                if (node2 == null) break;
                object2 = node2;
            }
            if (!bl) continue;
            object2 = result.rRoot;
            while (object2 != null) {
                table2.insertNoCheck(((Record)object2).data, session, true);
                object2 = ((Record)object2).next;
            }
        }
    }

    int delete(HsqlArrayList hsqlArrayList, Session session) throws HsqlException {
        Row row;
        int n;
        boolean bl = false;
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            row = (Row)hsqlArrayList.get(n);
            this.delete(row, session, false);
        }
        this.fireAll(4);
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            row = (Row)hsqlArrayList.get(n);
            this.delete(row, session, true);
        }
        this.fireAll(1);
        return hsqlArrayList.size();
    }

    private void delete(Row row, Session session, boolean bl) throws HsqlException {
        if (this.database.isReferentialIntegrity()) {
            this.constraintPath.clear();
            this.checkCascadeDelete(row, session, bl, this.constraintPath);
        }
        if (bl && !row.isDeleted()) {
            this.deleteNoRefCheck(row, session);
        }
    }

    private void deleteNoRefCheck(Object[] objectArray, Session session) throws HsqlException {
        this.fireAll(10, objectArray, null);
        this.deleteNoCheck(objectArray, session, true);
        this.fireAll(7, objectArray, null);
    }

    private void deleteNoRefCheck(Row row, Session session) throws HsqlException {
        Object[] objectArray = row.getData();
        this.fireAll(10, objectArray, null);
        this.deleteNoCheck(row, session, true);
        this.fireAll(7, objectArray, null);
    }

    private void deleteNoCheck(Row row, Session session, boolean bl) throws HsqlException {
        Object[] objectArray = row.getData();
        row = row.getUpdatedRow();
        for (int i = this.iIndexCount - 1; i >= 0; --i) {
            Node node = row.getNode(i);
            this.getIndex(i).delete(node);
        }
        row = row.getUpdatedRow();
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    void deleteNoCheck(Object[] objectArray, Session session, boolean bl) throws HsqlException {
        Node node = this.getIndex(0).search(objectArray);
        Row row = node.getRow();
        for (int i = this.iIndexCount - 1; i >= 0; --i) {
            node = row.getNode(i);
            this.getIndex(i).delete(node);
        }
        row = row.getUpdatedRow();
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    void deleteNoCheckRollback(Object[] objectArray, Session session, boolean bl) throws HsqlException {
        Node node = this.getIndex(0).search(objectArray);
        Row row = node.getRow();
        for (int i = this.iIndexCount - 1; i >= 0; --i) {
            node = row.getNode(i);
            this.getIndex(i).delete(node);
        }
        row = row.getUpdatedRow();
        row.delete();
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    int update(HsqlArrayList hsqlArrayList, Result result, int[] nArray, Session session) throws HsqlException {
        Object[] objectArray;
        int n;
        Record record = result.rRoot;
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            objectArray = (Object[])hsqlArrayList.get(n);
            this.enforceFieldValueLimits(record.data, nArray);
            this.enforceCheckConstraints(record.data);
            this.setIdentityColumn(record.data, null);
            if (this.database.isReferentialIntegrity()) {
                this.constraintPath.clear();
                this.checkCascadeUpdate((Row)objectArray, record.data, session, nArray, null, false, this.constraintPath);
            }
            record = record.next;
        }
        this.fireAll(5);
        record = result.rRoot;
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            objectArray = (Row)hsqlArrayList.get(n);
            hsqlArrayList.set(n, objectArray.getData());
            this.constraintPath.clear();
            this.checkCascadeUpdate((Row)objectArray, record.data, session, nArray, null, true, this.constraintPath);
            this.deleteNoCheck((Row)objectArray, session, true);
            record = record.next;
        }
        record = result.rRoot;
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            objectArray = (Object[])hsqlArrayList.get(n);
            this.fireAll(11, objectArray, record.data);
            this.insertNoCheck(record.data, session, true);
            this.fireAll(8, objectArray, record.data);
            record = record.next;
        }
        this.fireAll(2);
        return hsqlArrayList.size();
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    Index getIndex(String string) {
        for (int i = 0; i < this.iIndexCount; ++i) {
            Index index = this.getIndex(i);
            if (!string.equals(index.getName().name)) continue;
            return index;
        }
        return null;
    }

    int getConstraintIndex(String string) {
        int n = this.vConstraint.size();
        for (int i = 0; i < n; ++i) {
            Constraint constraint = (Constraint)this.vConstraint.get(i);
            if (!constraint.getName().name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        if (n >= 0) {
            return (Constraint)this.vConstraint.get(n);
        }
        return null;
    }

    Column getColumn(int n) {
        return (Column)this.vColumn.get(n);
    }

    void renameColumn(Column column, String string, boolean bl) throws HsqlException {
        int n = this.getColumnNr(column.columnName.name);
        this.vColumn.setKey(n, string);
        column.columnName.rename(string, bl);
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int n) {
        return (Index)this.vIndex.get(n);
    }

    CachedRow getRow(int n, Node node) throws HsqlException {
        if (this.isCached) {
            return this.cache.getRow(n, this);
        }
        return null;
    }

    void addRowToStore(Row row) throws HsqlException {
        if (this.isCached && this.cache != null) {
            this.cache.add((CachedRow)row);
        } else if (this.needsRowID) {
            row.getData()[this.iVisibleColumns] = ValuePool.getInt((int)this.rowIdSequence.getValue());
        }
    }

    void registerRow(CachedRow cachedRow) {
        if (this.needsRowID) {
            cachedRow.getData()[this.iVisibleColumns] = new Integer(cachedRow.iPos);
        }
    }

    void removeRow(CachedRow cachedRow) throws HsqlException {
        if (this.cache != null) {
            this.cache.free(cachedRow);
        }
    }

    void indexRow(Row row) throws HsqlException {
        int n;
        try {
            Node node = null;
            for (n = 0; n < this.iIndexCount; ++n) {
                node = row.getNextNode(node);
                this.getIndex(n).insert(node);
            }
        }
        catch (HsqlException hsqlException) {
            --n;
            while (n >= 0) {
                Node node = row.getNode(n);
                this.getIndex(n).delete(node);
                --n;
            }
            row.delete();
            throw hsqlException;
        }
    }

    void clearAllRows() {
        for (int i = 0; i < this.iIndexCount; ++i) {
            this.getIndex(i).setRoot(null);
        }
        this.identitySequence.reset();
    }

    void drop() throws HsqlException {
        if (this.cache != null && !this.isEmpty()) {
            this.cache.remove(this);
        }
    }

    boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.filesReadOnly || !this.isCached && !this.isText);
    }

    String getCatalogName() {
        if (this.database == null || this.database.getProperties().isPropertyTrue("hsqldb.catalogs")) {
            return null;
        }
        return this.database.getPath();
    }

    String getSchemaName() {
        if (this.database == null || this.database.getProperties().isPropertyTrue("hsqldb.schemas")) {
            return null;
        }
        if (this.tableType == 0) {
            return "DEFINITION_SCHEMA";
        }
        if (this.tableType == 7) {
            return "INFORMATION_SCHEMA";
        }
        if (this.isTemp) {
            Session session = this.database.sessionManager.getSession(this.ownerSessionId);
            return session != null && session.getId() == this.ownerSessionId ? session.getUsername() : null;
        }
        return "PUBLIC";
    }
}

