/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.GroupedResult;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;

class Select {
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    private HashSet groupColumnNames;
    TableFilter[] tFilter;
    Expression limitCondition;
    Expression queryCondition;
    Expression havingCondition;
    Expression[] exprColumns;
    int iResultLen;
    int iGroupLen;
    int iHavingIndex = -1;
    int iOrderLen;
    Select sUnion;
    HsqlNameManager.HsqlName sIntoTable;
    int intoType = 3;
    boolean isIntoTableQuoted;
    int iUnionType;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    private int limitStart;
    private int limitCount;
    Result.ResultMetaData resultMetaData;
    boolean isResolved = false;

    Select() {
    }

    HashMap getColumnAliases() {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.iResultLen; ++i) {
            String string = this.exprColumns[i].getAlias();
            if (string == null) continue;
            hashMap.put(string, this.exprColumns[i]);
        }
        return hashMap;
    }

    void resolve() throws HsqlException {
        this.resolveTables();
        this.resolveTypes();
        this.setFilterConditions();
    }

    void resolveTables() throws HsqlException {
        int n = this.tFilter.length;
        for (int i = 0; i < n; ++i) {
            this.resolveTables(this.tFilter[i]);
        }
    }

    void resolveTypes() throws HsqlException {
        int n = this.exprColumns.length;
        for (int i = 0; i < n; ++i) {
            this.exprColumns[i].resolveTypes();
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes();
        }
    }

    void resolveTables(TableFilter tableFilter) throws HsqlException {
        int n = this.exprColumns.length;
        for (int i = 0; i < n; ++i) {
            this.exprColumns[i].resolveTables(tableFilter);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTables(tableFilter);
        }
    }

    void setFilterConditions() throws HsqlException {
        if (this.queryCondition == null) {
            return;
        }
        for (int i = 0; i < this.tFilter.length; ++i) {
            this.tFilter[i].setConditions(this.queryCondition);
        }
    }

    boolean checkResolved(boolean bl) throws HsqlException {
        boolean bl2 = true;
        int n = this.exprColumns.length;
        for (int i = 0; i < n; ++i) {
            bl2 = bl2 && this.exprColumns[i].checkResolved(bl);
        }
        if (this.queryCondition != null) {
            bl2 = bl2 && this.queryCondition.checkResolved(bl);
        }
        return bl2;
    }

    Object getValue(int n) throws HsqlException {
        this.resolve();
        Result result = this.getResult(2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        if (n2 == 1 && n3 == 1) {
            Object object = result.rRoot.data[0];
            return result.metaData.colType[0] == n ? object : Column.convertObject(object, n);
        }
        HsqlException hsqlException = Trace.error(17);
        if (n2 == 0 && n3 == 1) {
            throw new HsqlInternalException(hsqlException);
        }
        throw hsqlException;
    }

    void prepareResult() throws HsqlException {
        int n;
        int n2;
        this.resolveAll(true);
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            for (n2 = this.iResultLen; n2 < this.iResultLen + this.iGroupLen; ++n2) {
                this.exprColumns[n2].collectColumnName(this.groupColumnNames);
            }
        }
        n2 = this.exprColumns.length;
        Result.ResultMetaData resultMetaData = this.resultMetaData = new Result.ResultMetaData(n2);
        int n3 = this.iResultLen;
        int n4 = n3 + this.iGroupLen;
        int n5 = this.iHavingIndex >= 0 ? this.iHavingIndex + 1 : n4;
        int n6 = n5 + this.iOrderLen;
        for (n = 0; n < n2; ++n) {
            Expression expression = this.exprColumns[n];
            resultMetaData.colType[n] = expression.getDataType();
            resultMetaData.colSize[n] = expression.getColumnSize();
            resultMetaData.colScale[n] = expression.getColumnScale();
            if (expression.isAggregate()) {
                this.isAggregated = true;
            }
            Trace.check(n < n3 || n >= n4 || this.exprColumns[n].canBeInGroupBy(), 68, this.exprColumns[n]);
            Trace.check(n != this.iHavingIndex || this.exprColumns[n].isConditional(), 69, this.exprColumns[n]);
            Trace.check(n < n5 || n >= n6 || this.exprColumns[n].canBeInOrderBy(), 70, this.exprColumns[n]);
            if (n >= this.iResultLen) continue;
            resultMetaData.sLabel[n] = expression.getAlias();
            resultMetaData.isLabelQuoted[n] = expression.isAliasQuoted();
            resultMetaData.sTable[n] = expression.getTableName();
            resultMetaData.sName[n] = expression.getColumnName();
            if (resultMetaData.isTableColumn(n)) {
                resultMetaData.nullability[n] = expression.nullability;
                resultMetaData.isIdentity[n] = expression.isIdentity;
                resultMetaData.isWritable[n] = expression.isWritable;
            }
            resultMetaData.sClassName[n] = expression.getValueClassName();
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        if (this.iHavingIndex >= 0) {
            this.checkAggregateOrGroupByColumns(this.iHavingIndex, this.iHavingIndex + 1);
        }
        this.checkAggregateOrGroupByColumns(n5, n6);
        if (this.isDistinctSelect) {
            for (n = n5; n < n6; ++n) {
                Trace.check(this.isSimilarIn(this.exprColumns[n], 0, this.iResultLen), 71, this.exprColumns[n]);
            }
        }
    }

    private int getLimitCount(int n) throws HsqlException {
        this.limitStart = this.limitCondition == null ? 0 : (Integer)this.limitCondition.getArg().getValue();
        int n2 = this.limitCount = this.limitCondition == null ? 0 : (Integer)this.limitCondition.getArg2().getValue();
        if (n == 0) {
            n = this.limitCount;
        } else if (this.limitCount == 0) {
            this.limitCount = n;
        } else {
            this.limitCount = n > this.limitCount ? this.limitCount : n;
            n = this.limitCount;
        }
        boolean bl = false;
        if (n != 0 && !this.isDistinctSelect && !this.isGrouped && this.sUnion == null && this.iOrderLen == 0) {
            bl = true;
        }
        return bl ? this.limitStart + n : Integer.MAX_VALUE;
    }

    Result getResult(int n) throws HsqlException {
        if (this.resultMetaData == null) {
            this.prepareResult();
        }
        Result result = this.buildResult(this.getLimitCount(n));
        if (this.isDistinctSelect) {
            result.removeDuplicates(this.iResultLen);
        }
        if (this.sUnion != null) {
            Result result2 = this.sUnion.getResult(0);
            switch (this.iUnionType) {
                case 1: {
                    result.append(result2);
                    result.removeDuplicates(this.iResultLen);
                    break;
                }
                case 2: {
                    result.append(result2);
                    break;
                }
                case 3: {
                    result.removeDifferent(result2, this.iResultLen);
                    break;
                }
                case 4: {
                    result.removeSecond(result2, this.iResultLen);
                }
            }
        }
        this.sortResult(result);
        result.setColumnCount(this.iResultLen);
        result.trimResult(this.limitStart, this.limitCount);
        return result;
    }

    private void sortResult(Result result) throws HsqlException {
        if (this.iOrderLen != 0) {
            int[] nArray = new int[this.iOrderLen];
            int[] nArray2 = new int[this.iOrderLen];
            int n = this.iResultLen + (this.isGrouped ? this.iGroupLen : 0);
            for (int i = 0; i < this.iOrderLen; ++i) {
                int n2 = n;
                if (this.exprColumns[n].orderColumnIndex != -1) {
                    n2 = this.exprColumns[n].orderColumnIndex;
                }
                nArray[i] = n2;
                nArray2[i] = this.exprColumns[n].isDescending() ? -1 : 1;
                ++n;
            }
            result.sortResult(nArray, nArray2);
        }
    }

    private void checkAggregateOrGroupByColumns(int n, int n2) throws HsqlException {
        if (n < n2) {
            int n3;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            for (n3 = n; n3 < n2; ++n3) {
                this.exprColumns[n3].collectInGroupByExpressions(hsqlArrayList);
            }
            int n4 = hsqlArrayList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                Expression expression = (Expression)hsqlArrayList.get(n3);
                Trace.check(this.inAggregateOrGroupByClause(expression), 67, expression);
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression expression) {
        if (!this.isAggregated || expression.canBeInAggregate()) {
            return true;
        }
        if (!this.isGrouped) {
            return false;
        }
        return this.isSimilarIn(expression, this.iResultLen, this.iResultLen + this.iGroupLen) || this.allColumnsAreDefinedIn(expression, this.groupColumnNames);
    }

    private boolean isSimilarIn(Expression expression, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!expression.similarTo(this.exprColumns[i])) continue;
            return true;
        }
        return false;
    }

    boolean allColumnsAreDefinedIn(Expression expression, HashSet hashSet) {
        HashSet hashSet2 = new HashSet();
        expression.collectAllColumnNames(hashSet2);
        if (hashSet2.size() > 0 && hashSet == null) {
            return false;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private Result buildResult(int n) throws HsqlException {
        int n2;
        int n3;
        Object[] objectArray;
        GroupedResult groupedResult = new GroupedResult(this, this.resultMetaData);
        int n4 = this.exprColumns.length;
        int n5 = this.tFilter.length;
        boolean[] blArray = new boolean[n5];
        boolean[] blArray2 = new boolean[n5];
        int n6 = 0;
        while (n6 >= 0) {
            objectArray = this.tFilter[n6];
            if (!blArray[n6]) {
                n3 = objectArray.findFirst();
                n2 = objectArray.isOuterJoin && n3 == 0 && !blArray2[n6] && !objectArray.nonJoinIsNull && objectArray.nextOuter() ? 1 : 0;
                blArray2[n6] = n2;
                blArray[n6] = n3;
            } else {
                n3 = objectArray.next();
                n2 = objectArray.isOuterJoin && n3 == 0 && !blArray[n6] && !blArray2[n6] && !objectArray.nonJoinIsNull && objectArray.nextOuter() ? 1 : 0;
                blArray2[n6] = n2;
                blArray[n6] = n3;
            }
            if (n3 == 0 && n2 == 0) {
                --n6;
                continue;
            }
            if (n6 < n5 - 1) {
                ++n6;
                continue;
            }
            while (blArray2[n6]) {
                blArray2[n6--] = false;
            }
            if (this.queryCondition != null && !this.queryCondition.test()) continue;
            try {
                int n7;
                Object[] objectArray2 = new Object[n4];
                for (n7 = groupedResult.groupBegin; n7 < groupedResult.groupEnd; ++n7) {
                    objectArray2[n7] = this.exprColumns[n7].getValue();
                }
                objectArray2 = groupedResult.getRow(objectArray2);
                for (n7 = 0; n7 < groupedResult.groupBegin; ++n7) {
                    objectArray2[n7] = this.isAggregated && this.exprColumns[n7].isAggregate() ? this.exprColumns[n7].updateAggregatingValue(objectArray2[n7]) : this.exprColumns[n7].getValue();
                }
                for (n7 = groupedResult.groupEnd; n7 < n4; ++n7) {
                    objectArray2[n7] = this.isAggregated && this.exprColumns[n7].isAggregate() ? this.exprColumns[n7].updateAggregatingValue(objectArray2[n7]) : this.exprColumns[n7].getValue();
                }
                groupedResult.addRow(objectArray2);
                if (groupedResult.size() < n) continue;
                break;
            }
            catch (HsqlInternalException hsqlInternalException) {
            }
        }
        if (this.isAggregated && !this.isGrouped && groupedResult.size() == 0) {
            objectArray = new Object[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray[n3] = this.exprColumns[n3].isAggregate() ? null : this.exprColumns[n3].getValue();
            }
            groupedResult.addRow(objectArray);
        }
        objectArray = groupedResult.iterator();
        while (objectArray.hasNext()) {
            Object[] objectArray3 = (Object[])objectArray.next();
            if (this.isAggregated) {
                for (n2 = 0; n2 < n4; ++n2) {
                    if (!this.exprColumns[n2].isAggregate()) continue;
                    objectArray3[n2] = this.exprColumns[n2].getAggregatedValue(objectArray3[n2]);
                }
            }
            if (this.iHavingIndex < 0 || ((Boolean)objectArray3[this.iHavingIndex]).booleanValue()) continue;
            objectArray.remove();
        }
        return groupedResult.getResult();
    }

    public StringBuffer getDDL() throws HsqlException {
        TableFilter tableFilter;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        for (n = 0; n < this.iResultLen; ++n) {
            stringBuffer.append(this.exprColumns[n].getDDL());
            if (n >= this.iResultLen - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append("FROM");
        for (n = 0; n < this.tFilter.length; ++n) {
            tableFilter = this.tFilter[n];
            if (n != 0 && tableFilter.isOuterJoin) {
                stringBuffer.append("FROM").append(' ');
                stringBuffer.append("JOIN").append(' ');
            }
            stringBuffer.append(',');
        }
        stringBuffer.append(' ').append("WHERE").append(' ');
        for (n = 0; n < this.tFilter.length; ++n) {
            tableFilter = this.tFilter[n];
        }
        stringBuffer.append(' ').append("GROUP").append(' ');
        for (n = this.iResultLen; n < this.iResultLen + this.iGroupLen; ++n) {
            stringBuffer.append(this.exprColumns[n].getDDL());
            if (n >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(' ').append("HAVING").append(' ');
        for (n = this.iHavingIndex; n < this.iHavingIndex + this.exprColumns.length; ++n) {
            stringBuffer.append(this.exprColumns[n].getDDL());
            if (n >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        if (this.sUnion != null) {
            switch (this.iUnionType) {
                case 4: {
                    stringBuffer.append(' ').append("EXCEPT").append(' ');
                    break;
                }
                case 3: {
                    stringBuffer.append(' ').append("INTERSECT").append(' ');
                    break;
                }
                case 1: {
                    stringBuffer.append(' ').append("UNION").append(' ');
                    break;
                }
                case 2: {
                    stringBuffer.append(' ').append("UNION").append(' ').append("ALL").append(' ');
                }
            }
        }
        n = this.iResultLen + this.iGroupLen;
        int n2 = this.iHavingIndex >= 0 ? this.iHavingIndex + 1 : n;
        int n3 = n2 + this.iOrderLen;
        stringBuffer.append(' ').append("ORDER").append("BY").append(' ');
        for (int i = n2; i < n3; ++i) {
            stringBuffer.append(this.exprColumns[i].getDDL());
            if (i >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer;
    }

    boolean resolveAll(boolean bl) throws HsqlException {
        boolean bl2 = true;
        if (this.isResolved) {
            return true;
        }
        this.resolve();
        boolean bl3 = bl2 = bl2 && this.checkResolved(bl);
        if (this.sUnion != null) {
            if (this.sUnion.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            this.sUnion.resolveAll(bl);
        }
        this.isResolved = bl2;
        return bl2;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String toString() {
        int n;
        this.preProcess();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            stringBuffer.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        if (this.limitCondition != null) {
            stringBuffer.append("start=[").append(this.limitCondition.getArg()).append("]\n");
            stringBuffer.append("limit=[").append(this.limitCondition.getArg2()).append("]\n");
        }
        stringBuffer.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuffer.append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuffer.append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuffer.append("columns=[");
        int n2 = this.exprColumns.length - this.iOrderLen;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.exprColumns[n]);
        }
        stringBuffer.append("\n]\n");
        stringBuffer.append("tableFilters=[\n");
        for (n = 0; n < this.tFilter.length; ++n) {
            stringBuffer.append("[\n");
            stringBuffer.append(this.tFilter[n]);
            stringBuffer.append("\n]");
        }
        stringBuffer.append("]\n");
        stringBuffer.append("eCondition=[").append(this.queryCondition).append("]\n");
        stringBuffer.append("havingCondition=[").append(this.havingCondition).append("]\n");
        stringBuffer.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.sUnion != null) {
            switch (this.iUnionType) {
                case 4: {
                    stringBuffer.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    stringBuffer.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    stringBuffer.append(" UNION ");
                    break;
                }
                case 2: {
                    stringBuffer.append(" UNION ALL ");
                    break;
                }
                default: {
                    stringBuffer.append(" UNKNOWN SET OPERATION ");
                }
            }
            stringBuffer.append("[\n").append(this.sUnion).append("]\n");
        }
        return stringBuffer.toString();
    }

    private void preProcess() {
        try {
            this.getResult(1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    Result describeResult() {
        Result result = new Result(3, this.iResultLen);
        Result.ResultMetaData resultMetaData = result.metaData;
        for (int i = 0; i < this.iResultLen; ++i) {
            Expression expression = this.exprColumns[i];
            resultMetaData.colType[i] = expression.getDataType();
            resultMetaData.colSize[i] = expression.getColumnSize();
            resultMetaData.colScale[i] = expression.getColumnScale();
            resultMetaData.sLabel[i] = expression.getAlias();
            resultMetaData.isLabelQuoted[i] = expression.isAliasQuoted();
            resultMetaData.sTable[i] = expression.getTableName();
            resultMetaData.sName[i] = expression.getColumnName();
            if (!resultMetaData.isTableColumn(i)) continue;
            resultMetaData.nullability[i] = expression.nullability;
            resultMetaData.isIdentity[i] = expression.isIdentity;
            resultMetaData.isWritable[i] = expression.isWritable;
        }
        return result;
    }
}

