/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Trace;

class NIOScaledRAFile
extends ScaledRAFile {
    MappedByteBuffer buffer;
    FileChannel channel;
    long fileLength;

    public NIOScaledRAFile(String string, boolean bl, int n) throws FileNotFoundException, IOException {
        super(string, bl, n);
        this.isNio = true;
        this.channel = this.file.getChannel();
        this.fileLength = 0L;
        Trace.printSystemOut("NIO file instance created. mode:  " + bl);
    }

    private long newBufferSize(long l) throws IOException {
        long l2;
        int n = 22;
        while (true) {
            if ((l2 = (long)(1 << n)) > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
                if (l2 >= l) break;
                throw new IOException(Trace.getMessage(29));
            }
            if (l2 >= l) break;
            ++n;
        }
        return l2;
    }

    private void enlargeBuffer(long l) throws IOException {
        int n = 0;
        if (this.buffer != null) {
            n = this.buffer.position();
            this.buffer.force();
        }
        this.fileLength = this.newBufferSize(l);
        Trace.printSystemOut("NIO next enlargeBuffer():  " + this.fileLength);
        try {
            this.buffer = this.channel.map(this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, this.fileLength);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
        this.buffer.position(n);
    }

    long length() throws IOException {
        return this.fileLength;
    }

    public void seek(long l) throws IOException {
        if (l >= this.fileLength) {
            this.enlargeBuffer(l);
        }
        this.buffer.position((int)l);
    }

    public long getFilePointer() throws IOException {
        return (this.buffer.position() + this.scale - 1) / this.scale;
    }

    public int read() throws IOException {
        return this.buffer.get();
    }

    public void read(byte[] byArray) throws IOException {
        this.read(byArray, 0, byArray.length);
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.buffer.get(byArray, n, n2);
    }

    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if ((long)this.buffer.position() + (long)n2 > this.fileLength) {
            this.enlargeBuffer((long)this.buffer.position() + (long)n2);
        }
        this.buffer.put(byArray, n, n2);
    }

    public void writeInt(int n) throws IOException {
        if ((long)this.buffer.position() + 4L > this.fileLength) {
            this.enlargeBuffer((long)this.buffer.position() + 4L);
        }
        this.buffer.putInt(n);
    }

    public void close() throws IOException {
        Trace.printSystemOut("NIO next close() - fileLength = " + this.fileLength);
        Trace.printSystemOut("NIO next buffer.force()");
        this.buffer.force();
        this.buffer = null;
        Trace.printSystemOut("NIO next channel.close()");
        this.channel.force(true);
        this.channel.close();
        this.channel = null;
        Trace.printSystemOut("NIO next file.close()");
        this.file.close();
    }
}

