/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.lib.StringUtil;

class Like {
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    Character escapeChar;
    boolean optimised;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;

    Like(Character c) {
        this.escapeChar = c;
    }

    void setParams(String string, boolean bl) {
        this.isIgnoreCase = bl;
        this.normalize(string, true);
        this.optimised = true;
    }

    void resetPattern(String string) {
        this.normalize(string, true);
    }

    private String getStartsWith() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.iLen && this.wildCardType[n] == 0; ++n) {
            stringBuffer.append(this.cLike[n]);
        }
        if (n == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    boolean compare(Object object) {
        if (object == null) {
            return this.iLen == 0;
        }
        String string = object.toString();
        if (this.isIgnoreCase) {
            string = string.toUpperCase();
        }
        return this.compareAt(string, 0, 0, string.length());
    }

    private boolean compareAt(String string, int n, int n2, int n3) {
        while (n < this.iLen) {
            switch (this.wildCardType[n]) {
                case 0: {
                    if (n2 < n3 && this.cLike[n] == string.charAt(n2++)) break;
                    return false;
                }
                case 1: {
                    if (n2++ < n3) break;
                    return false;
                }
                case 2: {
                    if (++n >= this.iLen) {
                        return true;
                    }
                    while (n2 < n3) {
                        if (this.cLike[n] == string.charAt(n2) && this.compareAt(string, n, n2, n3)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            }
            ++n;
        }
        return n2 == n3;
    }

    private void normalize(String string, boolean bl) {
        int n;
        boolean bl2 = this.isNull = string == null;
        if (!this.isNull && this.isIgnoreCase) {
            string = string.toUpperCase();
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        int n2 = string == null ? 0 : string.length();
        this.cLike = new char[n2];
        this.wildCardType = new int[n2];
        boolean bl3 = false;
        boolean bl4 = false;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (!bl3) {
                if (bl && this.escapeChar != null && this.escapeChar.charValue() == c) {
                    bl3 = true;
                    continue;
                }
                if (c == '_') {
                    this.wildCardType[this.iLen] = 1;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else if (c == '%') {
                    if (bl4) continue;
                    bl4 = true;
                    this.wildCardType[this.iLen] = 2;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else {
                    bl4 = false;
                }
            } else {
                bl4 = false;
                bl3 = false;
            }
            this.cLike[this.iLen++] = c;
        }
        for (n = 0; n < this.iLen - 1; ++n) {
            if (this.wildCardType[n] != 2 || this.wildCardType[n + 1] != 1) continue;
            this.wildCardType[n] = 1;
            this.wildCardType[n + 1] = 2;
        }
    }

    boolean hasWildcards() {
        return this.iFirstWildCard != -1;
    }

    boolean isEquivalentToFalsePredicate() {
        return this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isNull || !this.hasWildcards()) {
            return false;
        }
        for (int i = 0; i < this.wildCardType.length; ++i) {
            if (this.wildCardType[i] == 2) continue;
            return false;
        }
        return true;
    }

    boolean isEquivalentToBetweenPredicate() {
        return this.iFirstWildCard > 0 && this.iFirstWildCard == this.wildCardType.length - 1 && this.cLike[this.iFirstWildCard] == '%';
    }

    boolean isEquivalentToBetweenPredicateAugmentedWithLike() {
        return this.iFirstWildCard > 0 && this.cLike[this.iFirstWildCard] == '%';
    }

    String getRangeLow() {
        return this.getStartsWith();
    }

    String getRangeHigh() {
        String string = this.getStartsWith();
        return string == null ? null : string.concat("\uffff'");
    }

    public String toString() {
        return super.toString() + "[\n" + "bIgnoreCase=" + this.isIgnoreCase + '\n' + "iLen=" + this.iLen + '\n' + "cLike=" + StringUtil.arrayToString(this.cLike) + '\n' + "iType=" + StringUtil.arrayToString(this.wildCardType) + ']';
    }
}

