/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import org.hsqldb.HsqlSocketFactory;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;

public final class HsqlSocketFactorySecure
extends HsqlSocketFactory
implements HandshakeCompletedListener {
    protected Object socketFactory;
    protected Object serverSocketFactory;
    protected final Object socket_factory_mutex;
    protected final Object server_socket_factory_mutex;

    protected HsqlSocketFactorySecure() throws Exception {
        block3: {
            this.socket_factory_mutex = new Object();
            this.server_socket_factory_mutex = new Object();
            if (Security.getProvider("SunJSSE") == null) {
                try {
                    String string = "com.sun.net.ssl.internal.ssl.Provider";
                    Provider provider = (Provider)Class.forName(string).newInstance();
                    Security.addProvider(provider);
                }
                catch (Exception exception) {
                    if (!Trace.TRACE) break block3;
                    Trace.trace(exception.toString());
                }
            }
        }
    }

    public void configureSocket(Socket socket) {
        super.configureSocket(socket);
        SSLSocket sSLSocket = (SSLSocket)socket;
        sSLSocket.addHandshakeCompletedListener(this);
    }

    public ServerSocket createServerSocket(int n) throws Exception {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(n);
        if (Trace.TRACE) {
            Trace.trace("[" + this + "]: createServerSocket()");
            Trace.trace("capabilities for " + sSLServerSocket + ":");
            Trace.trace("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", sSLServerSocket.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", sSLServerSocket.getEnabledCipherSuites());
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, String string) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(string);
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(n, 128, inetAddress);
        if (Trace.TRACE) {
            Trace.trace("[" + this + "]: createServerSocket()");
            Trace.trace("capabilities for " + sSLServerSocket + ":");
            Trace.trace("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", sSLServerSocket.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", sSLServerSocket.getEnabledCipherSuites());
        }
        return sSLServerSocket;
    }

    private static final void dump(String string, String[] stringArray) {
        Trace.trace(string);
        Trace.trace("----------------------------");
        for (int i = 0; i < stringArray.length; ++i) {
            Trace.trace(String.valueOf(stringArray[i]));
        }
        Trace.trace("----------------------------");
    }

    public Socket createSocket(String string, int n) throws Exception {
        SSLSocket sSLSocket = (SSLSocket)this.getSocketFactoryImpl().createSocket(string, n);
        sSLSocket.addHandshakeCompletedListener(this);
        sSLSocket.startHandshake();
        this.verify(string, sSLSocket.getSession());
        return sSLSocket;
    }

    public boolean isSecure() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLServerSocketFactory getServerSocketFactoryImpl() throws Exception {
        Object object;
        Object object2 = this.server_socket_factory_mutex;
        synchronized (object2) {
            object = this.serverSocketFactory;
            if (object == null) {
                this.serverSocketFactory = object = SSLServerSocketFactory.getDefault();
            }
        }
        return (SSLServerSocketFactory)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketFactory getSocketFactoryImpl() throws Exception {
        Object object;
        Object object2 = this.socket_factory_mutex;
        synchronized (object2) {
            object = this.socketFactory;
            if (object == null) {
                this.socketFactory = object = SSLSocketFactory.getDefault();
            }
        }
        return (SSLSocketFactory)object;
    }

    protected void verify(String string, SSLSession sSLSession) throws Exception {
        String string2;
        X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
        X509Certificate x509Certificate = x509CertificateArray[0];
        Principal principal = x509Certificate.getSubjectDN();
        String string3 = String.valueOf(principal);
        int n = string3.indexOf("CN=");
        if (n < 0) {
            throw new UnknownHostException(Trace.getMessage(136));
        }
        int n2 = string3.indexOf(44, n += 3);
        if ((string2 = string3.substring(n, n2 > -1 ? n2 : string3.length())).length() < 1) {
            throw new UnknownHostException(Trace.getMessage(137));
        }
        if (!string2.equalsIgnoreCase(string)) {
            throw new UnknownHostException(Trace.getMessage(139, true, new Object[]{string2, string}));
        }
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        if (Trace.TRACE) {
            SSLSocket sSLSocket = handshakeCompletedEvent.getSocket();
            SSLSession sSLSession = handshakeCompletedEvent.getSession();
            Trace.trace("SSL handshake completed:");
            Trace.trace("------------------------------------------------");
            Trace.trace("socket:      : " + sSLSocket);
            Trace.trace("cipher suite : " + sSLSession.getCipherSuite());
            String string = StringConverter.byteToHex(sSLSession.getId());
            Trace.trace("session id   : " + string);
            Trace.trace("------------------------------------------------");
        }
    }
}

