/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseScript;
import org.hsqldb.Expression;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Logger;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Trigger;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterText;

class DatabaseCommandInterpreter {
    static final Result emptyResult = new Result(1);
    Tokenizer tokenizer = new Tokenizer();
    protected Database database;
    protected Session session;
    static final String oldLib = "org.hsql.Library.";
    static final int oldLibLen = "org.hsql.Library.".length();
    static final String newLib = "org.hsqldb.Library.";

    DatabaseCommandInterpreter(Session session) {
        this.session = session;
        this.database = session.getDatabase();
    }

    Result execute(String string) {
        DatabaseManager.gc();
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        Result result = null;
        int n = -1;
        Logger logger = this.database.logger;
        try {
            this.tokenizer.reset(string);
            Parser parser = new Parser(this.database, this.tokenizer, this.session);
            while (true) {
                this.tokenizer.setPartMarker();
                this.session.setScripting(false);
                String string2 = this.tokenizer.getString();
                if (string2.length() != 0) {
                    n = Token.get(string2);
                    if (n == 320) continue;
                    result = this.executePart(n, string2, parser);
                    if (result.iMode != 2) {
                        if (!this.session.getScripting()) continue;
                        logger.writeToLog(this.session, this.tokenizer.getLastPart());
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            result = new Result(throwable, this.tokenizer.getLastPart());
        }
        return result == null ? emptyResult : result;
    }

    private Result executePart(int n, String string, Parser parser) throws Throwable {
        Result result = emptyResult;
        switch (n) {
            case 193: {
                CompiledStatement compiledStatement = parser.compileSelectStatement(false);
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                if (compiledStatement.select.sIntoTable == null) {
                    result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement);
                    break;
                }
                result = this.processSelectInto(compiledStatement.select);
                this.database.setMetaDirty(false);
                break;
            }
            case 112: {
                CompiledStatement compiledStatement = parser.compileInsertStatement();
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement);
                break;
            }
            case 222: {
                CompiledStatement compiledStatement = parser.compileUpdateStatement();
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement);
                break;
            }
            case 62: {
                CompiledStatement compiledStatement = parser.compileDeleteStatement();
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement);
                break;
            }
            case 23: {
                CompiledStatement compiledStatement = parser.compileCallStatement();
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement);
                break;
            }
            case 196: {
                this.processSet();
                break;
            }
            case 35: {
                this.processCommit();
                break;
            }
            case 184: {
                this.processRollback();
                break;
            }
            case 188: {
                this.processSavepoint();
                break;
            }
            case 41: {
                this.processCreate();
                this.database.setMetaDirty(true);
                break;
            }
            case 4: {
                this.processAlter();
                this.database.setMetaDirty(true);
                break;
            }
            case 70: {
                this.processDrop();
                this.database.setMetaDirty(true);
                break;
            }
            case 96: {
                this.processGrantOrRevoke(true);
                this.database.setMetaDirty(false);
                break;
            }
            case 182: {
                this.processGrantOrRevoke(false);
                this.database.setMetaDirty(true);
                break;
            }
            case 37: {
                this.processConnect();
                this.database.setMetaDirty(false);
                this.session.setScripting(false);
                break;
            }
            case 66: {
                this.processDisconnect();
                this.session.setScripting(true);
                break;
            }
            case 318: {
                result = this.processScript();
                break;
            }
            case 322: {
                this.processShutdown();
                break;
            }
            case 303: {
                this.processCheckpoint();
                break;
            }
            case 304: {
                result = this.processExplainPlan();
                break;
            }
            case 176: {
                this.processReleaseSavepoint();
                break;
            }
            default: {
                throw Trace.error(11, string);
            }
        }
        return result;
    }

    private Result processScript() throws IOException, HsqlException {
        String string = this.tokenizer.getString();
        if (this.tokenizer.wasValue()) {
            string = (String)this.tokenizer.getAsValue();
            ScriptWriterText scriptWriterText = new ScriptWriterText(this.database, string, true, true);
            scriptWriterText.writeAll();
            scriptWriterText.close();
            return new Result(1);
        }
        this.tokenizer.back();
        this.session.checkAdmin();
        return DatabaseScript.getScript(this.database, false);
    }

    private void processCreate() throws HsqlException {
        boolean bl;
        String string;
        block18: {
            block17: {
                this.session.checkReadWrite();
                string = this.tokenizer.getString();
                bl = false;
                if (!string.equals("TEMP")) break block17;
                bl = true;
                string = this.tokenizer.getString();
                switch (Token.get(string)) {
                    case 325: {
                        this.session.checkAdmin();
                    }
                    case 213: 
                    case 309: {
                        this.session.setScripting(false);
                        break block18;
                    }
                    default: {
                        throw Trace.error(11, string);
                    }
                }
            }
            this.session.checkAdmin();
            this.session.checkDDLWrite();
            this.session.setScripting(true);
        }
        boolean bl2 = false;
        int n = 0;
        switch (Token.get(string)) {
            case 213: {
                n = bl ? 2 : 3;
                this.processCreateTable(n);
                break;
            }
            case 309: {
                this.tokenizer.getThis("TABLE");
                n = bl ? 2 : 3;
                this.processCreateTable(n);
                break;
            }
            case 302: {
                this.tokenizer.getThis("TABLE");
                this.processCreateTable(4);
                break;
            }
            case 325: {
                this.tokenizer.getThis("TABLE");
                n = bl ? 5 : 6;
                this.processCreateTable(n);
                break;
            }
            case 300: {
                this.processCreateAlias();
                break;
            }
            case 321: {
                this.processCreateSequence();
                break;
            }
            case 224: {
                this.processCreateTrigger();
                break;
            }
            case 223: {
                this.processCreateUser();
                break;
            }
            case 326: {
                this.processCreateView();
                break;
            }
            case 228: {
                bl2 = true;
                this.tokenizer.getThis("INDEX");
            }
            case 306: {
                this.processCreateIndex(bl2);
                break;
            }
            default: {
                throw Trace.error(11, string);
            }
        }
    }

    private int[] processColumnList(Table table) throws HsqlException {
        String string;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HashSet hashSet = new HashSet();
        this.tokenizer.getThis("(");
        do {
            string = this.tokenizer.getName();
            hsqlArrayList.add(string);
            hashSet.add(string);
            if (hsqlArrayList.size() == hashSet.size()) continue;
            throw Trace.error(27, 102, null);
        } while ((string = this.tokenizer.getString()).equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        int n = hsqlArrayList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = table.getColumnNr((String)hsqlArrayList.get(i));
        }
        return nArray;
    }

    private void addIndexOn(Table table, String string, boolean bl, boolean bl2) throws HsqlException {
        if (this.database.indexNameList.containsName(string)) {
            throw Trace.error(23);
        }
        HsqlNameManager.HsqlName hsqlName = this.newIndexHsqlName(string, bl);
        int[] nArray = this.processColumnList(table);
        this.session.commit();
        this.session.setScripting(!table.isTemp());
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.createIndex(nArray, hsqlName, bl2, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger() throws HsqlException {
        String string = this.tokenizer.getName();
        this.checkTriggerExists(string, false);
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        boolean bl2 = false;
        boolean bl3 = false;
        int n = TriggerDef.getDefaultQueueSize();
        String string2 = this.tokenizer.getString();
        String string3 = this.tokenizer.getString();
        this.tokenizer.getThis("ON");
        String string4 = this.tokenizer.getString();
        Table table = this.database.getTable(string4, this.session);
        this.checkIsReallyTable(table);
        this.session.setScripting(!table.isTemp());
        String string5 = this.tokenizer.getString();
        if (string5.equals("FOR")) {
            string5 = this.tokenizer.getString();
            if (!string5.equals("EACH")) throw Trace.error(12, string5);
            string5 = this.tokenizer.getString();
            if (!string5.equals("ROW")) throw Trace.error(12, string5);
            bl2 = true;
            string5 = this.tokenizer.getString();
        }
        if (string5.equals("NOWAIT")) {
            bl3 = true;
            string5 = this.tokenizer.getString();
        }
        if (string5.equals("QUEUE")) {
            n = this.tokenizer.getInt();
            string5 = this.tokenizer.getString();
        }
        if (!string5.equals("CALL")) {
            throw Trace.error(12, string5);
        }
        String string6 = this.tokenizer.getString();
        try {
            Class clazz = this.classForName(string6);
            Trigger trigger = (Trigger)clazz.newInstance();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl);
            TriggerDef triggerDef = new TriggerDef(hsqlName, string2, string3, bl2, table, trigger, "\"" + string6 + "\"", bl3, n);
            if (!triggerDef.isValid()) {
                throw Trace.error(11, 204);
            }
            table.addTrigger(triggerDef);
            triggerDef.start();
        }
        catch (Exception exception) {
            throw Trace.error(13, 205, exception.getMessage());
        }
        this.database.triggerNameList.addName(string, table.getName());
    }

    private Column processCreateColumn(Table table) throws HsqlException {
        int n;
        boolean bl = false;
        long l = this.database.firstIdentity;
        long l2 = 1L;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = true;
        String string = null;
        String string2 = this.tokenizer.getString();
        String string3 = string2;
        Trace.check(!string3.equals(""), 27, string3);
        boolean bl4 = this.tokenizer.wasQuotedIdentifier();
        String string4 = this.tokenizer.getString();
        int n4 = Types.getTypeNr(string4);
        if (string4.equals("IDENTITY")) {
            bl = true;
            bl2 = true;
        }
        if (n4 == 12 && this.database.isIgnoreCase()) {
            n4 = 100;
        }
        string2 = this.tokenizer.getString();
        if (n4 == 8 && string2.equals("PRECISION")) {
            string2 = this.tokenizer.getString();
        }
        String string5 = "";
        if (string2.equals("(")) {
            while (!(string2 = this.tokenizer.getString()).equals(")")) {
                string5 = string5 + string2;
            }
            string2 = this.tokenizer.getString();
        }
        if ((n = string5.indexOf(",")) != -1) {
            String string6 = string5.substring(n + 1, string5.length());
            string5 = string5.substring(0, n);
            Trace.check(Types.acceptsScaleCreateParam(n4), 11);
            try {
                n3 = Integer.parseInt(string6.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
        }
        if (!StringUtil.isEmpty(string5)) {
            Trace.check(Types.acceptsPrecisionCreateParam(n4), 11);
            try {
                n2 = Integer.parseInt(string5.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
        }
        if (string2.equals("DEFAULT")) {
            string = this.processCreateDefaultValue(n4, n2);
            string2 = this.tokenizer.getString();
        } else if (string2.equals("GENERATED")) {
            this.tokenizer.getThis("BY");
            this.tokenizer.getThis("DEFAULT");
            this.tokenizer.getThis("AS");
            this.tokenizer.getThis("IDENTITY");
            if (this.tokenizer.isGetThis("(")) {
                this.tokenizer.getThis("START");
                this.tokenizer.getThis("WITH");
                try {
                    l = this.tokenizer.getBigint();
                }
                catch (NumberFormatException numberFormatException) {
                    throw Trace.error(11, string5);
                }
                if (this.tokenizer.isGetThis(",")) {
                    this.tokenizer.getThis("INCREMENT");
                    this.tokenizer.getThis("BY");
                    l2 = this.tokenizer.getBigint();
                }
                this.tokenizer.getThis(")");
            }
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getString();
        }
        if (string2.equals("IDENTITY")) {
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getString();
        }
        if (string2.equals("NULL")) {
            string2 = this.tokenizer.getString();
        } else if (string2.equals("NOT")) {
            this.tokenizer.getThis("NULL");
            bl3 = false;
            string2 = this.tokenizer.getString();
        }
        if (string2.equals("IDENTITY")) {
            if (bl) {
                throw Trace.error(24, "IDENTITY");
            }
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getString();
        }
        if (string2.equals("PRIMARY")) {
            this.tokenizer.getThis("KEY");
            bl2 = true;
        } else {
            this.tokenizer.back();
        }
        return new Column(this.database.nameManager.newHsqlName(string3, bl4), bl3, n4, n2, n3, bl, l, l2, bl2, string);
    }

    private String processCreateDefaultValue(int n, int n2) throws HsqlException {
        String string;
        String string2;
        String string3 = this.tokenizer.getString();
        boolean bl = false;
        if (string3.equals("-") && this.tokenizer.getType() != 12) {
            bl = true;
            string3 = string3 + this.tokenizer.getString();
        }
        if (n == 1111 || !this.tokenizer.wasValue()) {
            throw Trace.error(46, string3);
        }
        Object object = this.tokenizer.getAsValue();
        if (bl) {
            object = Column.negate(object, n);
        }
        if (object == null) {
            return null;
        }
        try {
            Column.convertObject(object, n);
        }
        catch (Exception exception) {
            throw Trace.error(46, string3);
        }
        DatabaseCommandInterpreter.checkBooleanDefault(string3, n);
        if ((this.database.sqlEnforceSize || this.database.sqlEnforceSize) && !(string2 = Column.convertObject(object)).equals(string = (String)Table.enforceSize(string2, n, n2, false, false))) {
            throw Trace.error(46, string3);
        }
        return string3;
    }

    public static void checkBooleanDefault(String string, int n) throws HsqlException {
        if (n != 16 || string == null) {
            return;
        }
        if ((string = string.toUpperCase()).equals("TRUE") || string.equals("FALSE")) {
            return;
        }
        if (string.equals("0") || string.equals("1")) {
            return;
        }
        throw Trace.error(46, string);
    }

    private HsqlArrayList processCreateConstraints(Table table, boolean bl, int[] nArray) throws HsqlException {
        String string;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Constraint constraint = new Constraint(null, nArray, null, null, 1, 3, 3);
        HsqlNameManager.HsqlName hsqlName = null;
        hsqlArrayList.add(constraint);
        if (!bl) {
            return hsqlArrayList;
        }
        int n = 0;
        do {
            string = this.tokenizer.getString();
            HsqlNameManager.HsqlName hsqlName2 = null;
            ++n;
            if (string.equals("CONSTRAINT")) {
                hsqlName2 = this.database.nameManager.newHsqlName(this.tokenizer.getName(), this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            }
            switch (Token.get(string)) {
                case 167: {
                    this.tokenizer.getThis("KEY");
                    hsqlName = hsqlName2;
                    Object object = this.processColumnList(table);
                    Constraint constraint2 = (Constraint)hsqlArrayList.get(0);
                    if (constraint2.core.mainColArray != null && !ArrayUtil.areEqual(constraint2.core.mainColArray, object, ((int[])object).length, true)) {
                        throw Trace.error(24);
                    }
                    constraint2.core.mainColArray = object;
                    constraint2.constName = hsqlName;
                    break;
                }
                case 228: {
                    Object object = this.processColumnList(table);
                    if (hsqlName2 == null) {
                        hsqlName2 = this.database.nameManager.newAutoName("CT");
                    }
                    constraint = new Constraint(hsqlName2, (int[])object, null, null, 2, 3, 3);
                    hsqlArrayList.add(constraint);
                    break;
                }
                case 89: {
                    Object object;
                    this.tokenizer.getThis("KEY");
                    constraint = this.processCreateFK(table, hsqlName2);
                    if (constraint.core.refColArray == null) {
                        object = (Constraint)hsqlArrayList.get(0);
                        constraint.core.refColArray = object.core.mainColArray;
                        if (constraint.core.refColArray == null) {
                            throw Trace.error(26, 103, null);
                        }
                    }
                    this.checkFKColumnDefaults(table, constraint);
                    table.checkColumnsMatch(constraint.core.mainColArray, constraint.core.refTable, constraint.core.refColArray);
                    hsqlArrayList.add(constraint);
                    break;
                }
                case 30: {
                    if (hsqlName2 == null) {
                        hsqlName2 = this.database.nameManager.newAutoName("CT");
                    }
                    constraint = new Constraint(hsqlName2, null, null, null, 3, 0, 0);
                    constraint.core.check = this.processCreateCheckConstraintCondition(table);
                    hsqlArrayList.add(constraint);
                }
            }
        } while ((string = this.tokenizer.getString()).equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        return hsqlArrayList;
    }

    private Expression processCreateCheckConstraintCondition(Table table) throws HsqlException {
        this.tokenizer.getThis("(");
        Parser parser = new Parser(this.database, this.tokenizer, this.session);
        Expression expression = parser.parseExpression();
        this.tokenizer.getThis(")");
        return expression;
    }

    private void processCreateTable(int n) throws HsqlException {
        Object object;
        boolean bl;
        int[] nArray;
        Table table;
        block11: {
            String string = this.tokenizer.getName();
            this.checkTableExists(string, false);
            boolean bl2 = this.tokenizer.wasQuotedIdentifier();
            table = this.newTable(n, string, bl2);
            this.tokenizer.getThis("(");
            nArray = null;
            int n2 = 0;
            bl = false;
            while (true) {
                string = this.tokenizer.getString();
                bl2 = this.tokenizer.wasQuotedIdentifier();
                switch (Token.get(string)) {
                    case 30: 
                    case 38: 
                    case 89: 
                    case 167: 
                    case 228: {
                        bl = true;
                    }
                }
                this.tokenizer.back();
                if (bl) break block11;
                object = this.processCreateColumn(table);
                table.addColumn((Column)object);
                if (((Column)object).isPrimaryKey()) {
                    Trace.check(nArray == null, 24, ((Column)object).columnName.name);
                    nArray = new int[]{n2};
                }
                if (!(string = this.tokenizer.getString()).equals(",")) break;
                ++n2;
            }
            if (!string.equals(")")) {
                throw Trace.error(11, string);
            }
        }
        HsqlArrayList hsqlArrayList = this.processCreateConstraints(table, bl, nArray);
        try {
            this.session.commit();
            object = (Constraint)hsqlArrayList.get(0);
            table.createPrimaryKey(((Constraint)object).constName, ((Constraint)object).core.mainColArray, true);
            boolean bl3 = false;
            for (int i = 1; i < hsqlArrayList.size(); ++i) {
                TableWorks tableWorks;
                object = (Constraint)hsqlArrayList.get(i);
                if (((Constraint)object).constType == 2) {
                    tableWorks = new TableWorks(table);
                    tableWorks.createUniqueConstraint(((Constraint)object).core.mainColArray, ((Constraint)object).constName);
                    table = tableWorks.getTable();
                }
                if (((Constraint)object).constType == 0) {
                    tableWorks = new TableWorks(table);
                    tableWorks.createForeignKey(((Constraint)object).core.mainColArray, ((Constraint)object).core.refColArray, ((Constraint)object).constName, ((Constraint)object).core.refTable, ((Constraint)object).core.deleteAction, ((Constraint)object).core.updateAction);
                    table = tableWorks.getTable();
                }
                if (((Constraint)object).constType != 3) continue;
                tableWorks = new TableWorks(table);
                tableWorks.createCheckConstraint((Constraint)object, ((Constraint)object).constName);
                table = tableWorks.getTable();
            }
            this.database.linkTable(table);
        }
        catch (HsqlException hsqlException) {
            this.database.removeExportedKeys(table);
            throw hsqlException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Constraint processCreateFK(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray = this.processColumnList(table);
        this.tokenizer.getThis("REFERENCES");
        String string = this.tokenizer.getString();
        Table table2 = table.equals(string) ? table : this.database.getTable(string, this.session);
        int[] nArray2 = null;
        String string2 = this.tokenizer.getString();
        this.tokenizer.back();
        if (string2.equals("(")) {
            nArray2 = this.processColumnList(table2);
        } else {
            Index index = table2.getPrimaryIndex();
            if (index != null && (nArray2 = index.getColumns())[0] == table2.getColumnCount()) {
                throw Trace.error(26, 104, new Object[]{string});
            }
        }
        string2 = this.tokenizer.getString();
        int n = 3;
        int n2 = 3;
        while (string2.equals("ON")) {
            string2 = this.tokenizer.getString();
            if (n == 3 && string2.equals("DELETE")) {
                string2 = this.tokenizer.getString();
                if (string2.equals("SET")) {
                    string2 = this.tokenizer.getString();
                    if (string2.equals("DEFAULT")) {
                        n = 4;
                    } else {
                        if (!string2.equals("NULL")) throw Trace.error(11, string2);
                        n = 2;
                    }
                } else if (string2.equals("CASCADE")) {
                    n = 0;
                } else {
                    this.tokenizer.getCurrentThis("NO");
                    this.tokenizer.getThis("ACTION");
                }
            } else {
                if (n2 != 3 || !string2.equals("UPDATE")) throw Trace.error(11, string2);
                string2 = this.tokenizer.getString();
                if (string2.equals("SET")) {
                    string2 = this.tokenizer.getString();
                    if (string2.equals("DEFAULT")) {
                        n2 = 4;
                    } else {
                        if (!string2.equals("NULL")) throw Trace.error(11, string2);
                        n2 = 2;
                    }
                } else if (string2.equals("CASCADE")) {
                    n2 = 0;
                } else {
                    this.tokenizer.getCurrentThis("NO");
                    this.tokenizer.getThis("ACTION");
                }
            }
            string2 = this.tokenizer.getString();
        }
        this.tokenizer.back();
        if (hsqlName != null) return new Constraint(hsqlName, nArray, table2, nArray2, 0, n, n2);
        hsqlName = this.database.nameManager.newAutoName("FK");
        return new Constraint(hsqlName, nArray, table2, nArray2, 0, n, n2);
    }

    private void processCreateView() throws HsqlException {
        String string = this.tokenizer.getName();
        int n = this.tokenizer.getPartMarker();
        this.checkViewExists(string, false);
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
        HsqlArrayList hsqlArrayList = null;
        if (this.tokenizer.isGetThis("(")) {
            hsqlArrayList = Parser.getColumnNames(this.database, this.tokenizer, true);
        }
        this.tokenizer.getThis("AS");
        this.tokenizer.setPartMarker();
        this.tokenizer.getThis("SELECT");
        Parser parser = new Parser(this.database, this.tokenizer, this.session);
        Select select = parser.parseSelect(true);
        if (select.sIntoTable != null) {
            throw Trace.error(22);
        }
        select.prepareResult();
        View view = new View(this.database, hsqlName, this.tokenizer.getLastPart(), hsqlArrayList);
        this.session.commit();
        this.database.linkTable(view);
        this.tokenizer.setPartMarker(n);
    }

    private void processAlterTableRename(Table table) throws HsqlException {
        String string = table.getName().name;
        if (!table.equals(string, this.session)) {
            throw Trace.error(22);
        }
        this.tokenizer.getThis("TO");
        String string2 = this.tokenizer.getName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        this.checkTableExists(string2, false);
        this.session.commit();
        this.session.setScripting(!table.isTemp());
        table.setName(string2, bl);
    }

    private void processAlter() throws HsqlException {
        this.session.checkDDLWrite();
        this.session.checkAdmin();
        this.session.setScripting(true);
        String string = this.tokenizer.getString();
        switch (Token.get(string)) {
            default: {
                throw Trace.error(11, string);
            }
            case 306: {
                this.processAlterIndex();
                break;
            }
            case 321: {
                this.processAlterSequence();
                break;
            }
            case 213: {
                this.processAlterTable();
                break;
            }
            case 223: {
                this.processAlterUser();
            }
        }
    }

    private void processAlterTable() throws HsqlException {
        String string = this.tokenizer.getString();
        Table table = this.database.getUserTable(string, this.session);
        this.checkIsReallyTable(table);
        this.session.setScripting(!table.isTemp());
        String string2 = this.tokenizer.getString();
        switch (Token.get(string2)) {
            default: {
                throw Trace.error(11, string2);
            }
            case 317: {
                this.processAlterTableRename(table);
                return;
            }
            case 1: {
                string2 = this.tokenizer.getString();
                switch (Token.get(string2)) {
                    case 38: {
                        this.processAlterTableAddConstraint(table);
                        return;
                    }
                    case 89: {
                        this.tokenizer.getThis("KEY");
                        this.processAlterTableAddForeignKeyConstraint(table, null);
                        return;
                    }
                    case 228: {
                        this.processAlterTableAddUniqueConstraint(table, null);
                        return;
                    }
                    case 30: {
                        this.processAlterTableAddCheckConstraint(table, null);
                        return;
                    }
                    default: {
                        this.tokenizer.back();
                    }
                    case 34: 
                }
                this.processAlterTableAddColumn(table);
                return;
            }
            case 70: {
                string2 = this.tokenizer.getString();
                switch (Token.get(string2)) {
                    case 38: {
                        this.processAlterTableDropConstraint(table);
                        return;
                    }
                    default: {
                        this.tokenizer.back();
                    }
                    case 34: 
                }
                this.processAlterTableDropColumn(table);
                return;
            }
            case 4: 
        }
        this.tokenizer.getThis("COLUMN");
        this.processAlterColumn(table);
    }

    private void processAlterColumn(Table table) throws HsqlException {
        String string = this.tokenizer.getString();
        int n = table.getColumnNr(string);
        Column column = table.getColumn(n);
        String string2 = this.tokenizer.getString();
        switch (Token.get(string2)) {
            default: {
                throw Trace.error(11, string2);
            }
            case 317: {
                this.tokenizer.getThis("TO");
                this.processAlterColumnRename(table, column);
                return;
            }
            case 70: {
                this.tokenizer.getThis("DEFAULT");
                table.setDefaultString(n, null);
                return;
            }
            case 196: 
        }
        this.tokenizer.getThis("DEFAULT");
        int n2 = column.getType();
        int n3 = column.getSize();
        table.setDefaultString(n, this.processCreateDefaultValue(n2, n3));
    }

    private void processAlterColumnRename(Table table, Column column) throws HsqlException {
        String string = this.tokenizer.getName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        if (table.searchColumn(string) > -1) {
            throw Trace.error(27, string);
        }
        this.session.commit();
        this.session.setScripting(!table.isTemp());
        table.renameColumn(column, string, bl);
    }

    private void processAlterIndex() throws HsqlException {
        this.processAlterIndexRename();
    }

    private void processDrop() throws HsqlException {
        this.session.checkReadWrite();
        this.session.checkAdmin();
        this.session.setScripting(true);
        String string = this.tokenizer.getString();
        boolean bl = false;
        switch (Token.get(string)) {
            default: {
                throw Trace.error(11, string);
            }
            case 306: {
                this.processDropIndex();
                break;
            }
            case 321: {
                this.processDropSequence();
                break;
            }
            case 224: {
                this.processDropTrigger();
                break;
            }
            case 223: {
                this.processDropUser();
                break;
            }
            case 326: {
                bl = true;
            }
            case 213: {
                this.processDropTable(bl);
            }
        }
    }

    private void processGrantOrRevoke(boolean bl) throws HsqlException {
        Object object;
        String string;
        this.session.checkDDLWrite();
        this.session.checkAdmin();
        this.session.setScripting(true);
        int n = 0;
        do {
            string = this.tokenizer.getString();
            n |= UserManager.getRight(string);
        } while ((string = this.tokenizer.getString()).equals(","));
        if (!string.equals("ON")) {
            throw Trace.error(11, string);
        }
        Object object2 = null;
        string = this.tokenizer.getString();
        if (string.equals("CLASS")) {
            object2 = this.tokenizer.getString();
        } else {
            object = this.database.getTable(string, this.session);
            object2 = ((Table)object).getName();
            this.session.setScripting(!((Table)object).isTemp());
        }
        this.tokenizer.getThis("TO");
        string = this.tokenizer.getUserOrPassword();
        object = this.database.getUserManager();
        if (bl) {
            ((UserManager)object).grant(string, object2, n);
        } else {
            ((UserManager)object).revoke(string, object2, n);
        }
    }

    private void processConnect() throws HsqlException {
        this.tokenizer.getThis("USER");
        String string = this.tokenizer.getUserOrPassword();
        if (this.tokenizer.isGetThis("PASSWORD")) {
            String string2 = this.tokenizer.getUserOrPassword();
            User user = this.database.getUserManager().getUser(string, string2);
            this.session.commit();
            this.session.setUser(user);
            this.database.logger.logConnectUser(this.session);
        } else if (this.session.getUser().isSys()) {
            User user = this.database.getUserManager().get(string);
            this.session.commit();
            this.session.setUser(user);
            this.database.logger.logConnectUser(this.session);
        } else {
            this.tokenizer.getThis("PASSWORD");
        }
    }

    private void processSet() throws HsqlException {
        this.session.setScripting(true);
        String string = this.tokenizer.getString();
        block0 : switch (Token.get(string)) {
            default: {
                throw Trace.error(11, string);
            }
            case 314: {
                this.session.checkAdmin();
                string = this.tokenizer.getString().toLowerCase();
                if (!this.tokenizer.wasQuotedIdentifier()) {
                    throw Trace.error(125);
                }
                HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
                Trace.check(hsqlDatabaseProperties.isSetPropertyAllowed(string), 33, string);
                boolean bl = hsqlDatabaseProperties.isBoolean(string);
                boolean bl2 = hsqlDatabaseProperties.isIntegral(string);
                Trace.check(bl || bl2, 33, string);
                Object object = this.tokenizer.getInType(bl ? 16 : 4);
                hsqlDatabaseProperties.setProperty(string, object.toString().toLowerCase());
                string = this.tokenizer.getString();
                break;
            }
            case 312: {
                this.session.checkDDLWrite();
                this.session.setPassword(this.tokenizer.getUserOrPassword());
                break;
            }
            case 315: {
                this.session.commit();
                this.session.setReadOnly(this.processTrueOrFalse());
                break;
            }
            case 307: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                int n = this.tokenizer.getInt();
                this.database.logger.setLogSize(n);
                break;
            }
            case 319: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.session.setScripting(false);
                string = this.tokenizer.getString();
                int n = ArrayUtil.find(ScriptWriterBase.LIST_SCRIPT_FORMATS, string);
                if (n == 0 || n == 1 || n == 3) {
                    this.database.logger.setScriptType(n);
                    break;
                }
                throw Trace.error(11, string);
            }
            case 305: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.database.setIgnoreCase(this.processTrueOrFalse());
                break;
            }
            case 308: {
                this.session.setScripting(false);
                int n = this.tokenizer.getInt();
                this.session.setSQLMaxRows(n);
                break;
            }
            case 301: {
                this.session.setAutoCommit(this.processTrueOrFalse());
                break;
            }
            case 213: {
                this.session.checkDDLWrite();
                Table table = this.database.getTable(this.tokenizer.getString(), this.session);
                string = this.tokenizer.getString();
                this.session.setScripting(!table.isTemp());
                switch (Token.get(string)) {
                    default: {
                        throw Trace.error(11, string);
                    }
                    case 323: {
                        if (!table.isTemp()) {
                            this.session.checkAdmin();
                        }
                        string = this.tokenizer.getString();
                        if (!this.tokenizer.wasQuotedIdentifier()) {
                            throw Trace.error(75);
                        }
                        boolean bl = false;
                        if (this.tokenizer.getString().equals("DESC")) {
                            bl = true;
                        } else {
                            this.tokenizer.back();
                        }
                        table.setDataSource(string, bl, this.session, false);
                        break block0;
                    }
                    case 315: {
                        this.session.checkAdmin();
                        table.setDataReadOnly(this.processTrueOrFalse());
                        break block0;
                    }
                    case 306: 
                }
                this.session.checkAdmin();
                this.tokenizer.getString();
                table.setIndexRoots((String)this.tokenizer.getAsValue());
                break;
            }
            case 316: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.session.setScripting(false);
                this.database.setReferentialIntegrity(this.processTrueOrFalse());
                break;
            }
            case 327: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                int n = 0;
                String string2 = this.tokenizer.getString();
                if (string2.equals("TRUE")) {
                    n = 60;
                } else if (string2.equals("FALSE")) {
                    n = 0;
                } else {
                    this.tokenizer.back();
                    n = this.tokenizer.getInt();
                }
                this.database.logger.setWriteDelay(n);
            }
        }
    }

    private boolean processTrueOrFalse() throws HsqlException {
        String string = this.tokenizer.getString();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, string);
    }

    private void processCommit() throws HsqlException {
        if (!this.tokenizer.getString().equals("WORK")) {
            this.tokenizer.back();
        }
        this.session.commit();
    }

    private void processRollback() throws HsqlException {
        String string = this.tokenizer.getString();
        boolean bl = false;
        if (!string.equals("WORK")) {
            if (string.equals("TO")) {
                this.tokenizer.getThis("SAVEPOINT");
                string = this.tokenizer.getString();
                bl = true;
            } else {
                this.tokenizer.back();
            }
        }
        if (bl) {
            if (string.length() == 0) {
                throw Trace.error(11, 206);
            }
            this.session.rollbackToSavepoint(string);
        } else {
            this.session.rollback();
        }
    }

    private void processSavepoint() throws HsqlException {
        String string = this.tokenizer.getString();
        if (string.length() == 0) {
            throw Trace.error(11, 206);
        }
        this.session.savepoint(string);
    }

    private void processShutdown() throws HsqlException {
        if (!this.session.isClosed()) {
            this.session.checkAdmin();
        }
        int n = 0;
        String string = this.tokenizer.getString();
        if (string.equals("IMMEDIATELY")) {
            n = -1;
        } else if (string.equals("COMPACT")) {
            n = 1;
        } else if (string.equals("SCRIPT")) {
            n = 2;
        } else {
            this.tokenizer.back();
        }
        this.database.close(n);
    }

    private void processCheckpoint() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        boolean bl = false;
        String string = this.tokenizer.getString();
        if (string.equals("DEFRAG")) {
            bl = true;
        }
        this.database.logger.checkpoint(bl);
    }

    private HsqlNameManager.HsqlName newIndexHsqlName(String string, boolean bl) throws HsqlException {
        return HsqlNameManager.HsqlName.isReservedIndexName(string) ? this.database.nameManager.newAutoName("USER", string) : this.database.nameManager.newHsqlName(string, bl);
    }

    private Table newTable(int n, String string, boolean bl) throws HsqlException {
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl);
        int n2 = this.session.getId();
        switch (n) {
            case 5: 
            case 6: {
                return new TextTable(this.database, hsqlName, n, n2);
            }
        }
        return new Table(this.database, hsqlName, n, n2);
    }

    private void checkIndexExists(String string, boolean bl) throws HsqlException {
        boolean bl2;
        boolean bl3 = bl2 = this.database.findUserTableForIndex(string, this.session) != null;
        if (bl2 != bl) {
            int n = bl ? 26 : 23;
            throw Trace.error(n, string);
        }
    }

    private void checkTableExists(String string, boolean bl) throws HsqlException {
        boolean bl2 = this.database.dInfo.isSystemTable(string);
        if (!bl2) {
            boolean bl3 = bl2 = this.database.findUserTable(string, this.session) != null;
        }
        if (bl2 != bl) {
            int n = bl ? 22 : 21;
            throw Trace.error(n, string);
        }
    }

    private void checkViewExists(String string, boolean bl) throws HsqlException {
        boolean bl2;
        Table table = this.database.findUserTable(string, this.session);
        boolean bl3 = table != null;
        boolean bl4 = bl2 = bl3 && table.isView();
        if (!bl3) {
            bl3 = this.database.dInfo.isSystemTable(string);
        }
        if (bl3 != bl) {
            int n = bl3 ? (bl2 ? 52 : 21) : 53;
            throw Trace.error(n, string);
        }
    }

    private void checkIsReallyTable(Table table) throws HsqlException {
        if (table.isView() || table.tableType == 0) {
            throw Trace.error(55);
        }
    }

    private void checkTriggerExists(String string, boolean bl) throws HsqlException {
        boolean bl2 = this.database.triggerNameList.containsName(string);
        if (bl2 != bl) {
            int n = bl ? 43 : 164;
            throw Trace.error(n, string);
        }
    }

    private void checkAddColumn(Table table, Column column) throws HsqlException {
        boolean bl = true;
        if (column.isIdentity()) {
            bl = false;
        } else if (column.isPrimaryKey()) {
            bl = false;
        } else if (!table.isEmpty()) {
            boolean bl2 = bl = column.isNullable() || column.getDefaultString() != null;
        }
        if (!bl) {
            throw Trace.error(58);
        }
    }

    private void checkFKColumnDefaults(Table table, Constraint constraint) throws HsqlException {
        boolean bl = constraint.core.updateAction == 4;
        boolean bl2 = bl = bl || constraint.core.deleteAction == 4;
        if (bl) {
            int[] nArray = constraint.core.mainColArray;
            for (int i = 0; i < nArray.length; ++i) {
                Column column = table.getColumn(nArray[i]);
                String string = column.getDefaultString();
                if (string != null) continue;
                String string2 = column.columnName.name;
                throw Trace.error(57, 105, new Object[]{string2});
            }
        }
    }

    private void processAlterSequence() throws HsqlException {
        String string = this.tokenizer.getIdentifier();
        this.tokenizer.getThis("RESTART");
        this.tokenizer.getThis("WITH");
        long l = this.tokenizer.getBigint();
        NumberSequence numberSequence = this.database.sequenceManager.getSequence(string);
        Trace.check(numberSequence != null, 191);
        numberSequence.reset(l);
    }

    private void processAlterIndexRename() throws HsqlException {
        String string = this.tokenizer.getName();
        this.tokenizer.getThis("RENAME");
        this.tokenizer.getThis("TO");
        String string2 = this.tokenizer.getName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        Table table = this.database.findUserTableForIndex(string, this.session);
        if (table == null) {
            throw Trace.error(26, string);
        }
        this.checkIndexExists(string2, false);
        if (HsqlNameManager.HsqlName.isReservedIndexName(string)) {
            throw Trace.error(56, string);
        }
        if (HsqlNameManager.HsqlName.isReservedIndexName(string2)) {
            throw Trace.error(49, string2);
        }
        this.session.setScripting(!table.isTemp());
        this.session.commit();
        table.getIndex(string).setName(string2, bl);
        this.database.indexNameList.rename(string, string2);
    }

    private void processAlterTableAddColumn(Table table) throws HsqlException {
        int n = table.getColumnCount();
        Column column = this.processCreateColumn(table);
        this.checkAddColumn(table, column);
        String string = this.tokenizer.getString();
        if (string.equals("BEFORE")) {
            string = this.tokenizer.getName();
            n = table.getColumnNr(string);
        } else {
            this.tokenizer.back();
        }
        this.session.commit();
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.addOrDropColumn(column, n, 1);
    }

    private void processAlterTableAddConstraint(Table table) throws HsqlException {
        String string = this.tokenizer.getName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
        string = this.tokenizer.getString();
        switch (Token.get(string)) {
            default: {
                throw Trace.error(11, string);
            }
            case 89: {
                this.tokenizer.getThis("KEY");
                this.processAlterTableAddForeignKeyConstraint(table, hsqlName);
                return;
            }
            case 228: {
                this.processAlterTableAddUniqueConstraint(table, hsqlName);
                return;
            }
            case 30: 
        }
        this.processAlterTableAddCheckConstraint(table, hsqlName);
    }

    private void processAlterTableDropColumn(Table table) throws HsqlException {
        String string = this.tokenizer.getName();
        int n = table.getColumnNr(string);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.addOrDropColumn(null, n, -1);
    }

    private void processAlterTableDropConstraint(Table table) throws HsqlException {
        String string = this.tokenizer.getName();
        this.session.commit();
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.dropConstraint(string);
    }

    private void processCreateAlias() throws HsqlException {
        String string = this.tokenizer.getString();
        this.tokenizer.getThis("FOR");
        String string2 = DatabaseCommandInterpreter.upgradeMethodFQN(this.tokenizer.getString());
        this.database.getAlias().put(string, string2);
    }

    private void processCreateIndex(boolean bl) throws HsqlException {
        String string = this.tokenizer.getName();
        boolean bl2 = this.tokenizer.wasQuotedIdentifier();
        this.tokenizer.getThis("ON");
        Table table = this.database.getTable(this.tokenizer.getName(), this.session);
        this.addIndexOn(table, string, bl2, bl);
        String string2 = this.tokenizer.getString();
        if (!"DESC".equals(string2) && !"ASC".equals(string2)) {
            this.tokenizer.back();
        }
    }

    private void processCreateSequence() throws HsqlException {
        Object object;
        int n = 4;
        long l = 1L;
        long l2 = 0L;
        String string = this.tokenizer.getIdentifier();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        if (this.tokenizer.isGetThis("AS")) {
            object = this.tokenizer.getString();
            n = Types.getTypeNr((String)object);
            Trace.check(n == 4 || n == -5, 16);
        }
        if (this.tokenizer.isGetThis("START")) {
            this.tokenizer.getThis("WITH");
            l2 = this.tokenizer.getBigint();
        }
        if (this.tokenizer.isGetThis("INCREMENT")) {
            this.tokenizer.getThis("BY");
            l = this.tokenizer.getBigint();
        }
        object = this.database.nameManager.newHsqlName(string, bl);
        this.database.sequenceManager.createSequence((HsqlNameManager.HsqlName)object, l2, l, n);
    }

    private void processCreateUser() throws HsqlException {
        String string = this.tokenizer.getUserOrPassword();
        this.tokenizer.getThis("PASSWORD");
        String string2 = this.tokenizer.getUserOrPassword();
        boolean bl = this.tokenizer.getString().equals("ADMIN");
        if (!bl) {
            this.tokenizer.back();
        }
        this.database.getUserManager().createUser(string, string2, bl);
    }

    private void processDisconnect() throws HsqlException {
        this.database.sessionManager.processDisconnect(this.session);
    }

    private void processDropTable(boolean bl) throws HsqlException {
        String string;
        String string2 = string = this.tokenizer.getString();
        boolean bl2 = false;
        if (string.equals("IF")) {
            string = this.tokenizer.getString();
            if (string.equals("EXISTS")) {
                bl2 = true;
                string2 = this.tokenizer.getString();
            } else if (string.equals("IF")) {
                this.tokenizer.getThis("EXISTS");
                bl2 = true;
            } else {
                this.tokenizer.back();
            }
        } else {
            string = this.tokenizer.getString();
            if (string.equals("IF")) {
                this.tokenizer.getThis("EXISTS");
                bl2 = true;
            } else {
                this.tokenizer.back();
            }
        }
        Table table = this.database.findUserTable(string2, this.session);
        if (table != null && !table.isTemp()) {
            this.session.checkDDLWrite();
        }
        this.database.dropTable(string2, bl2, bl, this.session);
    }

    private void processDropUser() throws HsqlException {
        this.session.checkDDLWrite();
        this.database.getUserManager().dropUser(this.tokenizer.getUserOrPassword());
    }

    private void processDropSequence() throws HsqlException {
        this.session.checkDDLWrite();
        this.database.sequenceManager.dropSequence(this.tokenizer.getString());
    }

    private void processDropTrigger() throws HsqlException {
        this.session.checkDDLWrite();
        this.database.dropTrigger(this.tokenizer.getString(), this.session);
    }

    private void processDropIndex() throws HsqlException {
        String string = this.tokenizer.getString();
        String string2 = this.tokenizer.getString();
        boolean bl = false;
        if (string2.equals("IF")) {
            this.tokenizer.getThis("EXISTS");
            bl = true;
        } else {
            this.tokenizer.back();
        }
        this.session.checkDDLWrite();
        this.database.dropIndex(string, bl, this.session);
    }

    private Result processExplainPlan() throws IOException, HsqlException {
        String string;
        CompiledStatement compiledStatement;
        this.tokenizer.getThis("PLAN");
        this.tokenizer.getThis("FOR");
        Parser parser = new Parser(this.database, this.tokenizer, this.session);
        String string2 = this.tokenizer.getString();
        int n = Token.get(string2);
        Result result = Result.newSingleColumnResult("OPERATION", 12);
        switch (n) {
            case 193: {
                compiledStatement = parser.compileSelectStatement(false);
                break;
            }
            case 112: {
                compiledStatement = parser.compileInsertStatement();
                break;
            }
            case 222: {
                compiledStatement = parser.compileUpdateStatement();
                break;
            }
            case 62: {
                compiledStatement = parser.compileDeleteStatement();
                break;
            }
            case 23: {
                compiledStatement = parser.compileCallStatement();
                break;
            }
            default: {
                return result;
            }
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(compiledStatement.toString()));
        while (null != (string = lineNumberReader.readLine())) {
            result.add(new Object[]{string});
        }
        return result;
    }

    private static String upgradeMethodFQN(String string) {
        if (string.startsWith(oldLib)) {
            string = newLib + string.substring(oldLibLen);
        } else if (string.equals("java.lang.Math.abs")) {
            string = "org.hsqldb.Library.abs";
        }
        return string;
    }

    private Class classForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.database.classLoader;
        return classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
    }

    private Result processSelectInto(Select select) throws HsqlException {
        this.session.checkDDLWrite();
        Expression[] expressionArray = select.exprColumns;
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            if (expressionArray[i].getAlias().length() != 0) continue;
            throw Trace.error(45);
        }
        HsqlNameManager.HsqlName hsqlName = select.sIntoTable;
        String string = hsqlName.name;
        if (this.database.findUserTable(string, this.session) != null) {
            throw Trace.error(21, string);
        }
        Result result = select.getResult(0);
        int n2 = select.intoType;
        int n3 = this.session.getId();
        Table table = n2 == 6 ? new TextTable(this.database, hsqlName, n2, n3) : new Table(this.database, hsqlName, n2, n3);
        table.addColumns(result.metaData, result.getColumnCount());
        table.createPrimaryKey();
        this.database.linkTable(table);
        if (n2 == 6) {
            try {
                String string2 = StringUtil.toLowerSubset(string, '_') + ".csv";
                table.setDataSource(string2, false, this.session, true);
                this.logTableDDL(table);
                table.insertIntoTable(result, this.session);
            }
            catch (HsqlException hsqlException) {
                this.database.dropTable(string, false, false, this.session);
                throw hsqlException;
            }
        } else {
            this.logTableDDL(table);
            table.insertIntoTable(result, this.session);
        }
        Result result2 = new Result(1);
        result2.iUpdateCount = result.getSize();
        return result2;
    }

    private void logTableDDL(Table table) throws HsqlException {
        if (table.isTemp()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        DatabaseScript.getTableDDL(this.database, table, 0, null, null, stringBuffer);
        String string = DatabaseScript.getDataSource(table);
        this.database.logger.writeToLog(this.session, stringBuffer.toString());
        if (string != null) {
            this.database.logger.writeToLog(this.session, string);
        }
    }

    private void processAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray = this.processColumnList(table);
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT");
        }
        this.session.commit();
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.createUniqueConstraint(nArray, hsqlName);
    }

    private void processAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK");
        }
        Constraint constraint = this.processCreateFK(table, hsqlName);
        table.checkColumnsMatch(constraint.core.mainColArray, constraint.core.refTable, constraint.core.refColArray);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.createForeignKey(constraint.core.mainColArray, constraint.core.refColArray, constraint.constName, constraint.core.refTable, constraint.core.deleteAction, constraint.core.updateAction);
    }

    private void processAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT");
        }
        Constraint constraint = new Constraint(hsqlName, null, null, null, 3, 0, 0);
        constraint.core.check = this.processCreateCheckConstraintCondition(table);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.createCheckConstraint(constraint, hsqlName);
    }

    private void processReleaseSavepoint() throws HsqlException {
        this.tokenizer.getThis("SAVEPOINT");
        String string = this.tokenizer.getString();
        if (string.length() == 0) {
            throw Trace.error(11, 206);
        }
        this.session.releaseSavepoint(string);
    }

    private void processAlterUser() throws HsqlException {
        String string = this.tokenizer.getUserOrPassword();
        User user = (User)this.database.getUserManager().getUsers().get(string);
        Trace.check(user != null, 37, string);
        this.tokenizer.getThis("SET");
        this.tokenizer.getThis("PASSWORD");
        String string2 = this.tokenizer.getUserOrPassword();
        user.setPassword(string2);
        this.database.logger.writeToLog(this.session, user.getAlterUserDDL());
        this.session.setScripting(false);
    }
}

