/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.Types;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

public final class DITypeInfo {
    private int hnd_create_params = -1;
    private int hnd_local_names = -1;
    private int hnd_remarks = -1;
    private int type = 0;
    private int typeSub = 1;
    static /* synthetic */ Class class$org$hsqldb$resources$BundleHandler;

    public DITypeInfo() {
        this.setLocale(Locale.getDefault());
    }

    public Integer getCharOctLen() {
        return null;
    }

    public Long getCharOctLenAct() {
        switch (this.type) {
            case -1: 
            case 1: 
            case 12: {
                return ValuePool.getLong(0xFFFFFFFEL);
            }
            case 2005: {
                return ValuePool.getLong(Long.MAX_VALUE);
            }
        }
        return null;
    }

    public String getColStClsName() {
        switch (this.type) {
            case -5: {
                return "java.lang.Long";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 1111: {
                return "java.lang.Object";
            }
            case 16: {
                return "java.lang.Boolean";
            }
            case -1: 
            case 1: 
            case 12: 
            case 137: {
                return "java.lang.String";
            }
            case 70: {
                return "java.net.URL";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 6: 
            case 7: 
            case 8: {
                return "java.lang.Double";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return null;
    }

    public String getCreateParams() {
        String string;
        switch (this.type) {
            case 1: 
            case 12: {
                string = "LENGTH";
                break;
            }
            case 2: 
            case 3: {
                string = "PRECISION,SCALE";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public String getCstMapClsName() {
        switch (this.type) {
            case 2003: {
                return "org.hsqldb.jdbc.jdbcArray";
            }
            case 2004: {
                return "org.hsqldb.jdbc.jdbcBlob";
            }
            case 2005: {
                return "org.hsqldb.jdbc.jdbcClob";
            }
            case 2001: {
                return "org.hsqldb.jdbc.jdbcDistinct";
            }
            case 2006: {
                return "org.hsqldb.jdbc.jdbcRef";
            }
            case 2002: {
                return "org.hsqldb.jdbc.jdbcStruct";
            }
        }
        return null;
    }

    public int getMaxDisplaySize() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 137: 
            case 1111: {
                return Integer.MAX_VALUE;
            }
            case -5: {
                return 20;
            }
            case 16: {
                return 5;
            }
            case 70: {
                return 20004;
            }
            case 2: 
            case 3: {
                return 646456995;
            }
            case 91: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 6: 
            case 7: 
            case 8: {
                return 23;
            }
            case 92: {
                return 8;
            }
            case 5: {
                return 6;
            }
            case 93: {
                return 29;
            }
            case -6: {
                return 4;
            }
        }
        return 0;
    }

    public Integer getDataType() {
        return ValuePool.getInt(this.type);
    }

    Integer getDataTypeSub() {
        return ValuePool.getInt(this.typeSub);
    }

    public Integer getDefaultScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return ValuePool.getInt(0);
            }
        }
        return null;
    }

    public Integer getIntervalPrecision() {
        return null;
    }

    public String getLiteralPrefix() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return "'";
            }
            case 70: {
                return "'";
            }
            case 91: {
                return "'";
            }
            case 1111: {
                return "'";
            }
            case 92: {
                return "'";
            }
            case 93: {
                return "'";
            }
            case 137: {
                return "'";
            }
        }
        return null;
    }

    public String getLiteralSuffix() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return "'";
            }
            case 70: 
            case 91: 
            case 92: 
            case 93: 
            case 137: 
            case 1111: {
                return "'";
            }
        }
        return null;
    }

    public String getLocalName() {
        String string = this.getTypeName();
        return BundleHandler.getString(this.hnd_local_names, string);
    }

    public Integer getMaxScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 91: {
                return ValuePool.getInt(0);
            }
            case 2: 
            case 3: {
                return ValuePool.getInt(Short.MAX_VALUE);
            }
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(306);
            }
        }
        return null;
    }

    public Integer getMaxScaleAct() {
        switch (this.type) {
            case 2: 
            case 3: {
                return ValuePool.getInt(Integer.MAX_VALUE);
            }
        }
        return this.getMaxScale();
    }

    public Integer getMinScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 91: {
                return ValuePool.getInt(0);
            }
            case 2: 
            case 3: {
                return ValuePool.getInt(Short.MIN_VALUE);
            }
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(-324);
            }
        }
        return null;
    }

    public Integer getMinScaleAct() {
        switch (this.type) {
            case 2: 
            case 3: {
                return ValuePool.getInt(Integer.MIN_VALUE);
            }
        }
        return this.getMinScale();
    }

    public Integer getNullability() {
        return ValuePool.getInt(1);
    }

    public Integer getNumPrecRadix() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(10);
            }
        }
        return null;
    }

    public Integer getPrecision() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 137: 
            case 1111: {
                return ValuePool.getInt(Integer.MAX_VALUE);
            }
            case -5: {
                return ValuePool.getInt(19);
            }
            case 16: {
                return ValuePool.getInt(1);
            }
            case 70: {
                return ValuePool.getInt(20004);
            }
            case 2: 
            case 3: {
                return ValuePool.getInt(646456993);
            }
            case 4: 
            case 91: {
                return ValuePool.getInt(10);
            }
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(17);
            }
            case 92: {
                return ValuePool.getInt(8);
            }
            case 5: {
                return ValuePool.getInt(5);
            }
            case 93: {
                return ValuePool.getInt(29);
            }
            case -6: {
                return ValuePool.getInt(3);
            }
        }
        return null;
    }

    public Long getPrecisionAct() {
        Integer n = this.getPrecision();
        if (n == null) {
            return ValuePool.getLong(Long.MAX_VALUE);
        }
        return ValuePool.getLong(n.longValue());
    }

    public String getRemarks() {
        String string = this.getTypeName();
        return BundleHandler.getString(this.hnd_remarks, string);
    }

    public Integer getSearchability() {
        switch (this.type) {
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: {
                return ValuePool.getInt(0);
            }
            case 1111: {
                return ValuePool.getInt(1);
            }
        }
        return ValuePool.getInt(3);
    }

    public Integer getSqlDataType() {
        switch (this.type) {
            case 2003: {
                return ValuePool.getInt(50);
            }
            case -5: {
                return ValuePool.getInt(25);
            }
            case -2: {
                return ValuePool.getInt(30);
            }
            case 16: {
                return ValuePool.getInt(16);
            }
            case 2004: {
                return ValuePool.getInt(30);
            }
            case 1: {
                return ValuePool.getInt(1);
            }
            case 2005: {
                return ValuePool.getInt(40);
            }
            case 70: {
                return ValuePool.getInt(70);
            }
            case 91: {
                return ValuePool.getInt(9);
            }
            case 3: {
                return ValuePool.getInt(3);
            }
            case 2001: {
                return ValuePool.getInt(17);
            }
            case 8: {
                return ValuePool.getInt(8);
            }
            case 6: {
                return ValuePool.getInt(6);
            }
            case 4: {
                return ValuePool.getInt(4);
            }
            case 2000: {
                return ValuePool.getInt(2000);
            }
            case -4: {
                return ValuePool.getInt(30);
            }
            case -1: {
                return ValuePool.getInt(40);
            }
            case 0: {
                return ValuePool.getInt(0);
            }
            case 2: {
                return ValuePool.getInt(2);
            }
            case 1111: {
                return ValuePool.getInt(1111);
            }
            case 7: {
                return ValuePool.getInt(7);
            }
            case 2006: {
                return ValuePool.getInt(20);
            }
            case 5: {
                return ValuePool.getInt(5);
            }
            case 2002: {
                return ValuePool.getInt(17);
            }
            case 92: {
                return ValuePool.getInt(9);
            }
            case 93: {
                return ValuePool.getInt(9);
            }
            case -6: {
                return ValuePool.getInt(-6);
            }
            case -3: {
                return ValuePool.getInt(30);
            }
            case 12: {
                return ValuePool.getInt(12);
            }
            case 137: {
                return ValuePool.getInt(137);
            }
        }
        return null;
    }

    public Integer getSqlDateTimeSub() {
        switch (this.type) {
            case 91: {
                return ValuePool.getInt(1);
            }
            case 92: {
                return ValuePool.getInt(2);
            }
            case 93: {
                return ValuePool.getInt(3);
            }
        }
        return null;
    }

    public String getStdMapClsName() {
        switch (this.type) {
            case 2003: {
                return "java.sql.Array";
            }
            case -5: {
                return "long";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 16: {
                return "boolean";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 70: {
                return "java.net.URL";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 137: 
            case 1111: 
            case 2000: 
            case 2001: {
                return "java.lang.Object";
            }
            case 6: 
            case 7: 
            case 8: {
                return "double";
            }
            case 4: {
                return "int";
            }
            case 0: {
                return "null";
            }
            case 2006: {
                return "java.sql.Ref";
            }
            case 5: {
                return "short";
            }
            case 2002: {
                return "java.sql.Struct";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -6: {
                return "byte";
            }
        }
        return null;
    }

    public int getTypeCode() {
        return this.type;
    }

    public String getTypeName() {
        switch (this.type) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return this.typeSub == 4 ? "VARCHAR_IGNORECASE" : "VARCHAR";
            }
            case 137: {
                return "XML";
            }
        }
        return null;
    }

    public int getTypeSub() {
        return this.typeSub;
    }

    public Boolean isAutoIncrement() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Boolean isCaseSensitive() {
        switch (this.type) {
            case 0: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return null;
            }
            case -1: 
            case 1: 
            case 70: 
            case 137: 
            case 1111: {
                return Boolean.TRUE;
            }
            case 12: {
                return ValuePool.getBoolean(this.typeSub != 4);
            }
        }
        return Boolean.FALSE;
    }

    public Boolean isColStClsSupported() {
        return ValuePool.getBoolean(this.type == 0 ? true : this.getColStClsName() != null);
    }

    public Boolean isFixedPrecisionScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Boolean isStdMapClsSupported() {
        boolean bl = false;
        switch (this.type) {
            case 2003: {
                try {
                    Class.forName("java.sql.Array");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 2004: {
                try {
                    Class.forName("java.sql.Blob");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 2005: {
                try {
                    Class.forName("java.sql.Clob");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 2001: {
                bl = false;
                break;
            }
            case 2006: {
                try {
                    Class.forName("java.sql.Ref");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 2002: {
                try {
                    Class.forName("java.sql.Struct");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            default: {
                bl = this.getStdMapClsName() != null;
            }
        }
        return ValuePool.getBoolean(bl);
    }

    public Boolean isSupportedAsPCol() {
        switch (this.type) {
            case 0: 
            case 2000: 
            case 2003: {
                return Boolean.TRUE;
            }
        }
        return this.isSupportedAsTCol();
    }

    public Boolean isSupportedAsTCol() {
        if (this.type == 0) {
            return Boolean.FALSE;
        }
        String string = Types.getTypeString(this.type);
        return ValuePool.getBoolean(string != null);
    }

    public Boolean isUnsignedAttribute() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        Class clazz = class$org$hsqldb$resources$BundleHandler == null ? (class$org$hsqldb$resources$BundleHandler = DITypeInfo.class$("org.hsqldb.resources.BundleHandler")) : class$org$hsqldb$resources$BundleHandler;
        synchronized (clazz) {
            Locale locale2 = BundleHandler.getLocale();
            BundleHandler.setLocale(locale);
            this.hnd_create_params = BundleHandler.getBundleHandle("data-type-create-parameters", null);
            this.hnd_local_names = BundleHandler.getBundleHandle("data-type-names", null);
            this.hnd_remarks = BundleHandler.getBundleHandle("data-type-remarks", null);
            BundleHandler.setLocale(locale2);
        }
    }

    public void setTypeCode(int n) {
        this.type = n;
    }

    public void setTypeSub(int n) {
        this.typeSub = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

