/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ConstraintCore;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;

class Constraint {
    static final int CASCADE = 0;
    static final int SET_NULL = 2;
    static final int NO_ACTION = 3;
    static final int SET_DEFAULT = 4;
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    static final int CHECK = 3;
    ConstraintCore core;
    HsqlNameManager.HsqlName constName;
    int constType;

    Constraint(HsqlNameManager.HsqlName hsqlName, Table table, Index index) {
        this.core = new ConstraintCore();
        this.constName = hsqlName;
        this.constType = 2;
        this.core.mainTable = table;
        this.core.mainIndex = index;
        this.core.mainColArray = ArrayUtil.arraySlice(index.getColumns(), 0, index.getVisibleColumns());
        this.core.colLen = this.core.mainColArray.length;
    }

    Constraint(HsqlNameManager.HsqlName hsqlName, Constraint constraint) {
        this.constName = hsqlName;
        this.constType = 1;
        this.core = constraint.core;
    }

    Constraint(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2, Table table, Table table2, int[] nArray, int[] nArray2, Index index, Index index2, int n, int n2) throws HsqlException {
        this.core = new ConstraintCore();
        this.core.pkName = hsqlName;
        this.core.fkName = hsqlName2;
        this.constName = hsqlName2;
        this.constType = 0;
        this.core.mainTable = table;
        this.core.refTable = table2;
        this.core.mainColArray = nArray;
        this.core.colLen = this.core.mainColArray.length;
        this.core.refColArray = nArray2;
        this.core.mainIndex = index;
        this.core.refIndex = index2;
        this.core.deleteAction = n;
        this.core.updateAction = n2;
    }

    Constraint(HsqlNameManager.HsqlName hsqlName, int[] nArray, Table table, int[] nArray2, int n, int n2, int n3) {
        this.core = new ConstraintCore();
        this.constName = hsqlName;
        this.constType = n;
        this.core.mainColArray = nArray;
        this.core.refTable = table;
        this.core.refColArray = nArray2;
        this.core.deleteAction = n2;
        this.core.updateAction = n3;
    }

    private Constraint() {
    }

    HsqlNameManager.HsqlName getName() {
        return this.constName;
    }

    private void setName(String string, boolean bl) throws HsqlException {
        this.constName.rename(string, bl);
    }

    String getPkName() {
        return this.core.pkName == null ? null : this.core.pkName.name;
    }

    String getFkName() {
        return this.core.fkName == null ? null : this.core.fkName.name;
    }

    int getType() {
        return this.constType;
    }

    Table getMain() {
        return this.core.mainTable;
    }

    Index getMainIndex() {
        return this.core.mainIndex;
    }

    Table getRef() {
        return this.core.refTable;
    }

    Index getRefIndex() {
        return this.core.refIndex;
    }

    int getDeleteAction() {
        return this.core.deleteAction;
    }

    int getUpdateAction() {
        return this.core.updateAction;
    }

    int[] getMainColumns() {
        return this.core.mainColArray;
    }

    int[] getRefColumns() {
        return this.core.refColArray;
    }

    boolean isIndexFK(Index index) {
        return !(this.constType != 0 && this.constType != 1 || this.core.mainIndex != index && this.core.refIndex != index);
    }

    boolean isIndexUnique(Index index) {
        return this.constType == 2 && this.core.mainIndex == index;
    }

    boolean isEquivalent(int[] nArray, int n) {
        if (n != this.constType || this.constType != 2 || this.core.colLen != nArray.length) {
            return false;
        }
        return ArrayUtil.haveEqualSets(this.core.mainColArray, nArray, this.core.colLen);
    }

    boolean isEquivalent(Table table, int[] nArray, Table table2, int[] nArray2) {
        if (this.constType != 1 || this.constType != 0) {
            return false;
        }
        if (table != this.core.mainTable || table2 != this.core.refTable) {
            return false;
        }
        return ArrayUtil.areEqualSets(this.core.mainColArray, nArray) && ArrayUtil.areEqualSets(this.core.refColArray, nArray2);
    }

    void replaceTable(Table table, Table table2, int n, int n2) throws HsqlException {
        if (table == this.core.mainTable) {
            this.core.mainTable = table2;
            this.core.mainIndex = this.core.mainTable.getIndex(this.core.mainIndex.getName().name);
            this.core.mainColArray = ArrayUtil.toAdjustedColumnArray(this.core.mainColArray, n, n2);
            if (this.constType == 3) {
                // empty if block
            }
        }
        if (table == this.core.refTable) {
            this.core.refTable = table2;
            if (this.core.refIndex != null) {
                this.core.refIndex = this.core.refTable.getIndex(this.core.refIndex.getName().name);
                if (this.core.refIndex != this.core.mainIndex) {
                    this.core.refColArray = ArrayUtil.toAdjustedColumnArray(this.core.refColArray, n, n2);
                }
            }
        }
    }

    void replaceIndex(Index index, Index index2) {
        if (index == this.core.refIndex) {
            this.core.refIndex = index2;
        }
        if (index == this.core.mainIndex) {
            this.core.mainIndex = index2;
        }
    }

    void checkInsert(Object[] objectArray) throws HsqlException {
        int n;
        if (this.constType == 1 || this.constType == 2) {
            return;
        }
        if (this.constType == 3) {
            this.core.checkFilter.currentData = objectArray;
            if (!this.core.check.test()) {
                this.core.checkFilter.currentRow = null;
                throw Trace.error(157, 100, new Object[]{this.constName.name, this.core.mainTable.tableName.name});
            }
            this.core.checkFilter.currentData = null;
            return;
        }
        for (n = 0; n < this.core.colLen; ++n) {
            Object object = objectArray[this.core.refColArray[n]];
            if (object != null) continue;
            return;
        }
        if (this.core.mainIndex.find(objectArray, this.core.refColArray) == null) {
            if (this.core.mainTable == this.core.refTable) {
                n = 1;
                for (int i = 0; i < this.core.colLen; ++i) {
                    if (objectArray[this.core.refColArray[i]].equals(objectArray[this.core.mainColArray[i]])) continue;
                    n = 0;
                    break;
                }
                if (n != 0) {
                    return;
                }
            }
            throw Trace.error(177, 100, new Object[]{this.core.fkName.name, this.core.mainTable.getName().name});
        }
    }

    private void checkDelete(Object[] objectArray) throws HsqlException {
        for (int i = 0; i < this.core.colLen; ++i) {
            Object object = objectArray[this.core.mainColArray[i]];
            if (object != null) continue;
            return;
        }
        Node node = this.core.refIndex.find(objectArray, this.core.mainColArray);
        if (node != null) {
            throw Trace.error(8, 100, new Object[]{this.core.fkName.name, this.core.refTable.getName().name});
        }
    }

    Node findFkRef(Object[] objectArray, boolean bl) throws HsqlException {
        if (objectArray == null) {
            return null;
        }
        if (this.core.refIndex.isNull(objectArray, this.core.mainColArray)) {
            return null;
        }
        boolean bl2 = bl ? this.core.deleteAction != 3 : this.core.updateAction != 3;
        Node node = this.core.refIndex.findNotNull(objectArray, this.core.mainColArray, bl2);
        if (node != null && !bl2) {
            throw Trace.error(8, 100, new Object[]{this.core.fkName.name, this.core.refTable.getName().name});
        }
        return node;
    }

    Node findMainRef(Object[] objectArray) throws HsqlException {
        if (this.core.mainIndex.isNull(objectArray, this.core.refColArray)) {
            return null;
        }
        Node node = this.core.mainIndex.findNotNull(objectArray, this.core.refColArray, true);
        if (node == null) {
            throw Trace.error(177, 100, new Object[]{this.core.fkName.name, this.core.refTable.getName().name});
        }
        return node;
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws HsqlException {
        block9: {
            block8: {
                if (this.constType == 2) {
                    return;
                }
                if (this.constType == 3) {
                    Record record = result2.rRoot;
                    while (record != null) {
                        this.checkInsert(record.data);
                        record = record.next;
                    }
                    return;
                }
                if (this.constType != 1) break block8;
                if (!ArrayUtil.haveCommonElement(nArray, this.core.mainColArray, this.core.colLen)) {
                    return;
                }
                Record record = result.rRoot;
                while (record != null) {
                    if (this.core.mainIndex.find(record.data, this.core.mainColArray) == null) {
                        this.checkDelete(record.data);
                    }
                    record = record.next;
                }
                break block9;
            }
            if (this.constType != 0) break block9;
            if (!ArrayUtil.haveCommonElement(nArray, this.core.mainColArray, this.core.colLen)) {
                return;
            }
            Record record = result2.rRoot;
            while (record != null) {
                this.checkInsert(record.data);
                record = record.next;
            }
        }
    }

    static boolean hasReferencedRow(Object[] objectArray, int[] nArray, Index index) throws HsqlException {
        for (int i = 0; i < nArray.length; ++i) {
            Object object = objectArray[nArray[i]];
            if (object != null) continue;
            return true;
        }
        return index.find(objectArray, nArray) != null;
    }

    static void checkReferencedRows(Table table, int[] nArray, Index index) throws HsqlException {
        Index index2 = table.getPrimaryIndex();
        Node node = index2.first();
        while (node != null) {
            Object[] objectArray = node.getData();
            if (!Constraint.hasReferencedRow(objectArray, nArray, index)) {
                String string = "";
                for (int i = 0; i < nArray.length; ++i) {
                    Object object = objectArray[nArray[i]];
                    string = string + object;
                    string = string + ",";
                }
                throw Trace.error(177, 100, new Object[]{string, table.getName().name});
            }
            node = index2.next(node);
        }
    }
}

