/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

final class CompiledStatement {
    static final int UNKNOWN = 0;
    static final int INSERT_VALUES = 1;
    static final int INSERT_SELECT = 2;
    static final int UPDATE = 3;
    static final int DELETE = 4;
    static final int SELECT = 5;
    static final int CALL = 6;
    static final int DML = 7;
    static final int DQL = 8;
    static final int DDL = 9;
    Table targetTable;
    TableFilter tf;
    Expression condition;
    int[] columnMap;
    Expression[] columnValues;
    boolean[] checkColumns;
    Expression expression;
    Select select;
    Expression[] parameters;
    int[] paramTypes;
    SubQuery[] subqueries;
    int type;
    String sql;
    private static final Result updateCount = new Result(1);

    CompiledStatement() {
        this.parameters = new Expression[0];
        this.paramTypes = new int[0];
        this.subqueries = new SubQuery[0];
        this.type = 9;
    }

    void bind(Object[] objectArray) throws HsqlException {
        Trace.check(this.parameters != null, 5);
        int n = this.parameters.length;
        Trace.check(objectArray.length >= n, 5);
        for (int i = 0; i < n; ++i) {
            this.parameters[i].bind(objectArray[i]);
        }
    }

    CompiledStatement(Table table, Expression expression, Expression[] expressionArray) throws HsqlException {
        this.targetTable = table;
        this.tf = new TableFilter(table, null, false);
        if (expression != null) {
            this.condition = new Expression(expression);
            this.condition.resolveTables(this.tf);
            this.condition.resolveTypes();
            this.tf.setConditions(this.condition);
        }
        this.setParameters(expressionArray);
        this.type = 4;
    }

    CompiledStatement(Table table, String string, int[] nArray, Expression[] expressionArray, Expression expression, Expression[] expressionArray2) throws HsqlException {
        this.targetTable = table;
        this.columnMap = nArray;
        this.columnValues = expressionArray;
        this.tf = new TableFilter(table, string, false);
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression2 = expressionArray[i];
            if (expression2.isParam()) {
                expression2.setTableColumnAttributes(table, nArray[i]);
                continue;
            }
            expression2.resolveTables(this.tf);
            expression2.resolveTypes();
        }
        if (expression != null) {
            this.condition = new Expression(expression);
            this.condition.resolveTables(this.tf);
            this.condition.resolveTypes();
            this.tf.setConditions(this.condition);
        }
        this.setParameters(expressionArray2);
        this.type = 3;
    }

    CompiledStatement(Table table, int[] nArray, Expression[] expressionArray, boolean[] blArray, Expression[] expressionArray2) throws HsqlException {
        this.targetTable = table;
        this.columnMap = nArray;
        this.checkColumns = blArray;
        this.columnValues = expressionArray;
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            if (!expression.isParam()) continue;
            expression.setTableColumnAttributes(table, nArray[i]);
        }
        this.setParameters(expressionArray2);
        this.type = 1;
    }

    CompiledStatement(Table table, int[] nArray, boolean[] blArray, Select select, Expression[] expressionArray) throws HsqlException {
        this.targetTable = table;
        this.columnMap = nArray;
        this.checkColumns = blArray;
        this.select = select;
        select.prepareResult();
        this.setParameters(expressionArray);
        this.type = 2;
    }

    CompiledStatement(Select select, Expression[] expressionArray) throws HsqlException {
        this.select = select;
        select.prepareResult();
        this.setParameters(expressionArray);
        this.type = 5;
    }

    CompiledStatement(Expression expression, Expression[] expressionArray) throws HsqlException {
        this.expression = expression;
        expression.resolveTypes();
        expression.paramMode = 4;
        this.setParameters(expressionArray);
        this.type = 6;
    }

    private void setParameters(Expression[] expressionArray) {
        this.parameters = expressionArray;
        int[] nArray = new int[expressionArray.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            nArray[i] = expressionArray[i].getDataType();
        }
        this.paramTypes = nArray;
    }

    void materializeSubQueries() throws HsqlException {
        for (int i = 0; i < this.subqueries.length; ++i) {
            SubQuery subQuery = this.subqueries[i];
            if (subQuery.isMaterialised) continue;
            Table table = subQuery.table;
            Select select = subQuery.select;
            Result result = select.getResult(subQuery.isExistsPredicate ? 1 : 0);
            table.insertIntoTable(result, null);
            subQuery.isMaterialised = true;
        }
    }

    void dematerializeSubQueries() {
        for (int i = 0; i < this.subqueries.length; ++i) {
            this.subqueries[i].table.clearAllRows();
            this.subqueries[i].isMaterialised = false;
        }
    }

    Result describeResultSet() {
        switch (this.type) {
            case 6: {
                Expression expression = this.expression;
                Result result = Result.newSingleColumnResult("@0", expression.getDataType());
                result.metaData.sClassName[0] = expression.getValueClassName();
                return result;
            }
            case 5: {
                return this.select.describeResult();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return updateCount;
            }
        }
        return Trace.toResult(Trace.error(201));
    }

    Result describeParameters() {
        int n = this.parameters.length;
        int n2 = 0;
        Result result = Result.newParameterDescriptionResult(n);
        for (int i = 0; i < this.parameters.length; ++i) {
            Expression expression = this.parameters[i];
            int n3 = i + n2;
            result.metaData.sName[n3] = "@" + i + 1;
            result.metaData.sClassName[n3] = expression.getValueClassName();
            result.metaData.colType[n3] = expression.getDataType();
            result.metaData.colSize[n3] = expression.getColumnSize();
            result.metaData.colScale[n3] = expression.getColumnScale();
            result.metaData.nullability[n3] = expression.nullability;
            result.metaData.isIdentity[n3] = expression.isIdentity;
            result.metaData.paramMode[n3] = expression.paramMode;
        }
        return result;
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.toString();
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 5: {
                stringBuffer.append(this.select.toString());
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer);
                return stringBuffer.toString();
            }
            case 1: {
                stringBuffer.append("INSERT VALUES");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 2: {
                stringBuffer.append("INSERT SELECT");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                stringBuffer.append(this.select).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 3: {
                stringBuffer.append("UPDATE");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(stringBuffer);
                stringBuffer.append(this.tf).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 4: {
                stringBuffer.append("DELETE");
                stringBuffer.append('[').append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(stringBuffer);
                stringBuffer.append(this.tf).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 6: {
                stringBuffer.append("CALL");
                stringBuffer.append('[');
                stringBuffer.append(this.expression).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(StringBuffer stringBuffer) {
        stringBuffer.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            stringBuffer.append("\n[level=").append(this.subqueries[i].level).append('\n').append("hasParams=").append(this.subqueries[i].hasParams).append('\n').append("org.hsqldb.Select@").append(Integer.toHexString(this.subqueries[i].select.hashCode())).append("]");
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendTable(StringBuffer stringBuffer) {
        stringBuffer.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return stringBuffer;
    }

    private StringBuffer appendColumns(StringBuffer stringBuffer) {
        stringBuffer.append("COLUMNS=[");
        for (int i = 0; i < this.columnMap.length; ++i) {
            stringBuffer.append('\n').append(this.columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn((int)this.columnMap[i]).columnName.name).append('[').append(this.columnValues[i]).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendParms(StringBuffer stringBuffer) {
        stringBuffer.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            stringBuffer.append('\n').append('@').append(i).append('[').append(this.parameters[i]).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendCondition(StringBuffer stringBuffer) {
        return this.condition == null ? stringBuffer.append("CONDITION[]\n") : stringBuffer.append("CONDITION[").append(this.condition).append("]\n");
    }
}

